package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationimgtask.DesensitizationImgInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationimgtask.DesensitizationImgtaskDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationimgtask.DesensitizationImgInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationimgtask.DesensitizationImgtask;
import com.chenyang.nse.bussiness.entity.vo.dataproject.ImgTaskVO;
import com.chenyang.nse.bussiness.service.core.DesensitizationImgtaskService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional
public class DesensitizationImgtaskServiceImpl implements DesensitizationImgtaskService {
   @Autowired
   DesensitizationImgtaskDao desensitizationImgtaskDao;
   @Autowired
   DesensitizationImgInfoDao desensitizationImgInfoDao;

   public void saveDesensitizationImgtask(DesensitizationImgtask desensitizationImgtask) {
      this.desensitizationImgtaskDao.saveOrUpdate(desensitizationImgtask);
   }

   public void saveDesensitizationImgInfo(DesensitizationImgInfo desensitizationImgInfo) {
      this.desensitizationImgInfoDao.saveOrUpdate(desensitizationImgInfo);
   }

   public List<DesensitizationImgtask> queryImgtask(String projectid, PageInfo pageInfo) {
      List<DesensitizationImgtask> list = this.desensitizationImgtaskDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.eq("projectid", projectid)});
      return list;
   }

   public List<DesensitizationImgtask> queryImgtaskByid(String taskid) {
      List<DesensitizationImgtask> list = this.desensitizationImgtaskDao.queryAll(new Criterion[]{Restrictions.eq("id", taskid)});
      return list;
   }

   public List<DesensitizationImgInfo> queryImgInfo(String taskid) {
      List<DesensitizationImgInfo> list = this.desensitizationImgInfoDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
      return list;
   }

   public List<ImgTaskVO> queryImgByid(String taskid) {
      return this.desensitizationImgInfoDao.editInitQuery(taskid);
   }

   public void removeTask(String taskid) {
      this.desensitizationImgtaskDao.removeById(taskid);
   }

   public void removeInfoByTaskid(String taskid) {
      this.desensitizationImgInfoDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public DesensitizationImgtask queryTaskByName(String taskname, String projectid) {
      List<DesensitizationImgtask> desensitizationtasklist = this.desensitizationImgtaskDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskname", taskname), Restrictions.eq("projectid", projectid)});
      return desensitizationtasklist != null && desensitizationtasklist.size() > 0 ? (DesensitizationImgtask)desensitizationtasklist.get(0) : null;
   }
}
