package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreMaskingruleDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.vo.TmaskingRuleCustMapping;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ImportMaskingRuleServiceImpl implements ImportMaskingRuleService {
   @Autowired
   private TCoreMaskingruleDao tCoreMaskingruleDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;

   public InfoProperty queryEngineById(String engineid) {
      TCoreEngine engine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(engine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return info;
   }

   public List<TCoreMaskingRule> queryRule() {
      return this.tCoreMaskingruleDao.queryAll();
   }

   public List<TCoreEngine> queryMaskingEngine() {
      return this.tCoreEngineDao.queryAll();
   }

   public List<TCoreMaskingRule> queryRuleByEngineId(String engineid) {
      return this.tCoreMaskingruleDao.queryAll(new Criterion[]{Restrictions.eq("engineid", engineid)});
   }

   public void importMaskingRule(String engineid, List<TCoreMaskingRule> list) {
      List<TCoreMaskingRule> add = new ArrayList();
      List<TCoreMaskingRule> modify = new ArrayList();
      List<TCoreMaskingRule> remove = new ArrayList();
      this.queryRuleByEngineId(engineid);
      new ArrayList();
      new ArrayList();

      for(TCoreMaskingRule tmaskingRule : add) {
         this.tCoreMaskingruleDao.save(tmaskingRule);
      }

      for(TCoreMaskingRule tmaskingRule : modify) {
         this.tCoreMaskingruleDao.getSession().update(tmaskingRule);
      }

      for(TCoreMaskingRule tmaskingRule : remove) {
         this.tCoreMaskingruleDao.getSession().update(tmaskingRule);
      }

   }

   public List<TCoreMaskingRule> queryValidRule() {
      return this.tCoreMaskingruleDao.queryAll();
   }

   public void saveRule(List<TCoreMaskingRule> list) {
      for(TCoreMaskingRule var3 : list) {
         ;
      }

   }

   public List<TmaskingRuleCustMapping> queryRuleCustByEngineId(String engineid) {
      return this.tCoreMaskingruleDao.queryRuleCustByEngineId(engineid);
   }
}
