package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.service.core.PowerCenterFirstConnService;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PowerCenterFirstConnServiceImpl implements PowerCenterFirstConnService {
   @Autowired
   TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;

   public String getEngineid() {
      String engineid = ((TCoreEngine)this.tCoreEngineDao.queryAll().get(0)).getId();
      return engineid;
   }

   public InfoProperty getInfoProperty(String engineid) {
      TCoreEngine engine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(engine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return info;
   }
}
