package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSystemSettingDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSystemSetting;
import com.chenyang.nse.bussiness.service.core.TSystemSettingService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TSystemSettingServiceImpl implements TSystemSettingService {
   @Autowired
   private TConsoleSystemSettingDao tConsoleSystemSettingDao;

   public List<Map<String, Object>> querySystemSetting(PageInfo pageInfo) {
      long count = this.tConsoleSystemSettingDao.count();
      pageInfo.setCount(count);
      List<Map<String, Object>> list = this.tConsoleSystemSettingDao.querySystemSetting(pageInfo);
      return list;
   }

   public TConsoleSystemSetting updateSwitchState(String id, String value) {
      TConsoleSystemSetting tss = (TConsoleSystemSetting)this.tConsoleSystemSettingDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      tss.setValue(value);
      tss.setUpdatetime(DateTimeTool.getSysTimeDate(""));
      this.tConsoleSystemSettingDao.update(tss);
      return tss;
   }
}
