package com.chenyang.nse.bussiness.service.core.impl.encryption;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRoleDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.DesensitizationStrategyDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreDesensitizationStrategy;
import com.chenyang.nse.bussiness.service.core.encryption.DesensitizationStrategyService;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DesensitizationStrategyServiceImpl implements DesensitizationStrategyService {
   @Autowired
   DesensitizationStrategyDao desensitizationStrategyDao;
   @Autowired
   private TBaseRoleDao tBaseRoleDao;

   public void saveDesensitizationStrategy(List<String> parameter) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ParseException {
      String datasystemid = (String)parameter.get(0);
      String field = (String)parameter.get(1);
      String table = (String)parameter.get(2);
      String schema = (String)parameter.get(3);
      String state = (String)parameter.get(4);
      String projectId = (String)parameter.get(5);
      String username = (String)parameter.get(6);
      String dataareaid = (String)parameter.get(7);
      String dataareaname = (String)parameter.get(8);
      String ruleid = (String)parameter.get(9);
      String rulename = (String)parameter.get(10);
      String finalStrategyId = (String)parameter.get(11);
      String strategyName = (String)parameter.get(12);
      String roleGroup = (String)parameter.get(13);
      String remarks = (String)parameter.get(14);
      String createtimeString = (String)parameter.get(15);
      TCoreDesensitizationStrategy tCoreDesensitizationStrategy = new TCoreDesensitizationStrategy();
      List<TBaseRole> tBaseRoles = this.tBaseRoleDao.queryAll(new Criterion[]{Restrictions.ne("id", "1")});
      StringBuilder stringBuilder = new StringBuilder();

      for(int i = 0; i < tBaseRoles.size(); ++i) {
         if (i != 0) {
            stringBuilder.append(",").append(((TBaseRole)tBaseRoles.get(i)).getRolename());
         } else {
            stringBuilder.append(((TBaseRole)tBaseRoles.get(i)).getRolename());
         }
      }

      String roles = stringBuilder.toString();
      if (null != dataareaid && !dataareaid.equals("")) {
         this.desensitizationStrategyDao.remove(new Criterion[]{Restrictions.eq("strategyid", finalStrategyId), Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("table_field_id", field)});
         tCoreDesensitizationStrategy.setId(UUID.randomUUID().toString().replace("-", ""));
         tCoreDesensitizationStrategy.setDatasystem_id(datasystemid);
         tCoreDesensitizationStrategy.setTschemas(schema);
         tCoreDesensitizationStrategy.setTable_field_id(field);
         tCoreDesensitizationStrategy.setNames(table);
         tCoreDesensitizationStrategy.setProjectid(projectId);
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         Date finalCreatetime = sdf.parse(createtimeString);
         tCoreDesensitizationStrategy.setCreatetime(finalCreatetime);
         tCoreDesensitizationStrategy.setCreateuser(username);
         tCoreDesensitizationStrategy.setRemarks(remarks);
         tCoreDesensitizationStrategy.setDataareaid(dataareaid);
         tCoreDesensitizationStrategy.setDataareaname(dataareaname);
         tCoreDesensitizationStrategy.setState(state);
         tCoreDesensitizationStrategy.setRuleid(ruleid);
         tCoreDesensitizationStrategy.setRulename(rulename);
         tCoreDesensitizationStrategy.setStrategyid(finalStrategyId);
         tCoreDesensitizationStrategy.setStrategyname(strategyName);
         tCoreDesensitizationStrategy.setRolegroup(roles);
         this.desensitizationStrategyDao.save(tCoreDesensitizationStrategy);
      }

   }

   public void saveDesensitizationStrategyDel(List<String> parameter) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ParseException {
      String datasystemid = (String)parameter.get(0);
      String field = (String)parameter.get(1);
      String table = (String)parameter.get(2);
      String schema = (String)parameter.get(3);
      String state = (String)parameter.get(4);
      String projectId = (String)parameter.get(5);
      String username = (String)parameter.get(6);
      String dataareaid = (String)parameter.get(7);
      String dataareaname = (String)parameter.get(8);
      String ruleid = (String)parameter.get(9);
      String rulename = (String)parameter.get(10);
      String finalStrategyId = (String)parameter.get(11);
      String strategyName = (String)parameter.get(12);
      String roleGroup = (String)parameter.get(13);
      String remarks = (String)parameter.get(14);
      if (null != dataareaid && !dataareaid.equals("")) {
         String stragegy = null;
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
            stragegy = "strategyid";
         } else {
            stragegy = "strategyid";
         }

         this.desensitizationStrategyDao.remove(new Criterion[]{Restrictions.eq(stragegy, finalStrategyId), Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table)});
      }

   }

   public List<TCoreDesensitizationStrategy> queryDesenStrategylist(String projectId, String strategyName, String remarks, String roleGroup, String state) {
      List<TCoreDesensitizationStrategy> desenStrategylist = this.desensitizationStrategyDao.queryDesenStrategylist(projectId, strategyName, remarks, roleGroup, state);
      return desenStrategylist;
   }

   public List<TCoreDesensitizationStrategy> queryDesenStrategyDetails(String projectId, String strategyId) {
      List<TCoreDesensitizationStrategy> desenStrategylist = this.desensitizationStrategyDao.queryDesenStrategyDetails(projectId, strategyId);
      return desenStrategylist;
   }

   public void updateRoleGroup(List<TCoreDesensitizationStrategy> tcoreJiaMiDulist, String roleGroup) {
      int cpp = tcoreJiaMiDulist.size();

      for(int i = 0; i < cpp; ++i) {
         TCoreDesensitizationStrategy tCoreDesensitizationStrategy = (TCoreDesensitizationStrategy)tcoreJiaMiDulist.get(i);
         tCoreDesensitizationStrategy.setRolegroup(roleGroup);
         this.desensitizationStrategyDao.update(tCoreDesensitizationStrategy);
      }

   }

   public void remove(List<TCoreDesensitizationStrategy> tcoreJiaMiDulist) {
      int cpp = tcoreJiaMiDulist.size();

      for(int i = 0; i < cpp; ++i) {
         TCoreDesensitizationStrategy tCoreDesensitizationStrategy = (TCoreDesensitizationStrategy)tcoreJiaMiDulist.get(i);
         if (null != tCoreDesensitizationStrategy) {
            this.desensitizationStrategyDao.remove(tCoreDesensitizationStrategy);
         }
      }

   }

   public void disableOrEnable(List<TCoreDesensitizationStrategy> tcoreJiaMiDulist, String state) {
      int cpp = tcoreJiaMiDulist.size();

      for(int i = 0; i < cpp; ++i) {
         TCoreDesensitizationStrategy tCoreDesensitizationStrategy = (TCoreDesensitizationStrategy)tcoreJiaMiDulist.get(i);
         tCoreDesensitizationStrategy.setState(state);
         this.desensitizationStrategyDao.update(tCoreDesensitizationStrategy);
      }

   }

   public boolean checkStrategy(String ruleId) {
      List<TCoreDesensitizationStrategy> strategyList = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleId)});
      return !ObjectUtils.isEmpty(strategyList);
   }

   public int checkRepeatName(String strategyname, String id, String projectid) {
      new ArrayList();
      List list;
      if (StringUtils.isBlank(id)) {
         list = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("strategyname", strategyname), Restrictions.eq("projectid", projectid)});
      } else {
         list = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("strategyname", strategyname), Restrictions.eq("projectid", projectid), Restrictions.ne("id", id)});
      }

      return list.size();
   }
}
