package com.chenyang.nse.bussiness.service.core.impl.strategy;

import com.chenyang.nse.bussiness.dao.table.core.strategy.audit.app.AuditAppDataRuleDao;
import com.chenyang.nse.bussiness.dao.table.core.strategy.audit.conditions.AuditApplicationConditionsDao;
import com.chenyang.nse.bussiness.dao.table.core.strategy.audit.conditions.AuditDateConditionsDao;
import com.chenyang.nse.bussiness.dao.table.core.strategy.audit.conditions.AuditDbuserConditionsDao;
import com.chenyang.nse.bussiness.dao.table.core.strategy.audit.conditions.AuditIpConditionsDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.app.AuditAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditIpConditions;
import com.chenyang.nse.bussiness.entity.vo.strategy.StrategeVO;
import com.chenyang.nse.bussiness.service.core.strategy.AuditAppDataRuleService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditAppDataRuleServiceImpl implements AuditAppDataRuleService {
   @Autowired
   private AuditAppDataRuleDao auditAppDataRuleDao;
   @Autowired
   private AuditIpConditionsDao auditIpConditionsDao;
   @Autowired
   private AuditApplicationConditionsDao auditApplicationConditionsDao;
   @Autowired
   private AuditDbuserConditionsDao auditDbuserConditionsDao;
   @Autowired
   private AuditDateConditionsDao auditDateConditionsDao;

   public void saveAppRuleInfo(AuditAppDataRule appDataRule, String id) {
      if (StringUtil.isBlank(id)) {
         appDataRule.setCreateuser(CommonUtils.loginUsername());
         appDataRule.setCreatetime(new Date());
         this.auditAppDataRuleDao.save(appDataRule);
      } else {
         appDataRule.setUpdateuser(CommonUtils.loginUsername());
         appDataRule.setUpdatetime(new Date());
         this.auditAppDataRuleDao.saveOrUpdate(appDataRule);
      }

   }

   public void saveIpConditionsInfo(AuditIpConditions ipConditions) {
      this.auditIpConditionsDao.saveOrUpdate(ipConditions);
   }

   public void saveApplicationConditionsInfo(AuditApplicationConditions applicationConditions) {
      this.auditApplicationConditionsDao.saveOrUpdate(applicationConditions);
   }

   public void saveDbuserConditionsInfo(AuditDbuserConditions dbuserConditions) {
      this.auditDbuserConditionsDao.saveOrUpdate(dbuserConditions);
   }

   public void saveDateConditionsInfo(AuditDateConditions dateConditions) {
      this.auditDateConditionsDao.saveOrUpdate(dateConditions);
   }

   public List<AuditAppDataRule> getAppRuleInfoById(String id) {
      return this.auditAppDataRuleDao.queryAll(new Criterion[]{Restrictions.eq("id", id)});
   }

   public List<AuditIpConditions> getIpConditionsInfoByRuleId(String ruleid) {
      return this.auditIpConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<AuditApplicationConditions> getApplicationConditionsInfoByRuleId(String ruleid) {
      return this.auditApplicationConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<AuditDbuserConditions> getDbuserConditionsInfoByRuleId(String ruleid) {
      return this.auditDbuserConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<AuditDateConditions> getDateConditionsInfoByRuleId(String ruleid) {
      return this.auditDateConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delAppRuleInfoById(String id) {
      this.auditAppDataRuleDao.removeById(id);
   }

   public void delIpConditionsInfoByRuleId(String ruleid) {
      this.auditIpConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delApplicationConditionsInfoByRuleId(String ruleid) {
      this.auditApplicationConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delDbuserConditionsInfoByRuleId(String ruleid) {
      this.auditDbuserConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delDateConditionsInfoByRuleId(String ruleid) {
      this.auditDateConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<StrategeVO> queryAll() {
      return this.auditAppDataRuleDao.queryAllStrategy();
   }

   public List<AuditAppDataRule> getAuditInfoByDatasystemid(String datasystemid) {
      return this.auditAppDataRuleDao.queryAll(new Criterion[]{Restrictions.eq("datasourceid", datasystemid), Restrictions.eq("auditswitch", "1")});
   }
}
