package com.chenyang.nse.bussiness.tools.dataprocess;

import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EncTaskStateContainer {
   private int task;
   private String project;
   private String table;
   private String schema;
   Map<String, EncTaskState> states;

   public EncTaskStateContainer() {
      this.states = new HashMap();
   }

   public EncTaskStateContainer(int task) {
      this();
      this.task = task;
   }

   public EncTaskState add(String column) {
      EncTaskState state = new EncTaskState();
      state.setProject(this.project);
      state.setSchema(this.schema);
      state.setTable(this.table);
      state.setColumn(column);
      state.setId(String.format("%s-%s-%s-%s", this.project, this.schema, this.table, column));
      this.states.put(state.getId(), state);
      return state;
   }

   public EncTaskState get(String column) {
      String id = String.format("%s-%s-%s-%s", this.project, this.schema, this.table, column);
      return (EncTaskState)this.states.get(id);
   }

   public EncTaskState get(String project, String schema, String table, String column) {
      String id = String.format("%s-%s-%s-%s", project, schema, table, column);
      return (EncTaskState)this.states.get(id);
   }

   public void add(String project, String schema, String table, List<ColumnInfoVO> columns) {
      if (columns != null && columns.size() != 0) {
         this.project = project;
         this.schema = schema;
         this.table = table;

         for(ColumnInfoVO column : columns) {
            this.add(column.getColumnName());
         }

      }
   }

   public void over(String name) {
      EncTaskState encTaskState = this.get(name);
      encTaskState.over();
   }

   public void close(ColumnInfoVO column) {
   }

   public void dispose() {
      this.states.clear();
      this.states = null;
   }

   public int size() {
      return this.states.size();
   }

   public int getTask() {
      return this.task;
   }

   public void setTask(int task) {
      this.task = task;
   }

   public String getTable() {
      return this.table;
   }

   public void setTable(String table) {
      this.table = table;
   }

   public String getSchema() {
      return this.schema;
   }

   public void setSchema(String schema) {
      this.schema = schema;
   }
}
