package com.chenyang.nse.bussiness.tools.dataprocess;

import ch.qos.logback.classic.Logger;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.EncUtils;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class LoadingBatchTask implements Runnable {
   private String copySuffix = "";
   private String initialSuffix = "";
   private String isLike = "";
   protected static final String COMPLETE = "1";
   protected static final String RUNNING = "-1";
   protected static final String FAIL = "4";
   private int jiamiTasktotalCounts = 0;
   private int jiamiTaskFinishCounts = 0;
   private int failCount = 0;
   private boolean isKeepReadData = true;
   private int startRow = 0;
   private int maxPackageCount = 100000;
   private String dataSystemId;
   private String projectId;
   private String tableName;
   private String columnName;
   private String columnType;
   private String columnSize;
   private Connection connection;
   private TCoreDatasystem tCoreDatasystem;
   private String schema;
   private JdbcTemplate jdbcTemplate;
   private String[] primaryKeys;
   private List<ColumnInfoVO> columnInfoList;
   private List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList;
   List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList;
   HashSet<ColumnEncryption> columnSet = null;
   Properties props = new Properties();
   CountDownLatch countDownLatch;
   EncTaskStateContainer container;

   public LoadingBatchTask(String projectId, String dataSystemId, TCoreDatasystem tCoreDatasystem, String schema, String tableName, String[] primaryKeys, List<ColumnInfoVO> columnInfoList, CountDownLatch countDownLatch, List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList, List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList) {
      this.copySuffix = PropertyGhcaUtil.copySuffix;
      this.initialSuffix = PropertyGhcaUtil.initialSuffix;
      this.isLike = PropertyGhcaUtil.encryptionlikeopen;
      this.projectId = projectId;
      this.dataSystemId = dataSystemId;
      this.tCoreDatasystem = tCoreDatasystem;
      this.schema = schema;
      this.tableName = tableName;
      this.columnInfoList = columnInfoList;
      this.primaryKeys = primaryKeys;
      this.connection = JdbcTool.getConnection(tCoreDatasystem);
      this.columnPrimaryKeyInfoList = columnPrimaryKeyInfoList;
      this.countDownLatch = countDownLatch;
      this.allColumnList = allColumnList;

      try {
         this.props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      this.jdbcTemplate = (JdbcTemplate)ApplicationContextProvider.getBean(JdbcTemplate.class);
      this.container = EncTaskTracker.instance().container();
      this.container.add(projectId, schema, tableName, columnInfoList);
      EncTaskTracker.instance().register(this.container);
   }

   public void run() {
      try {
         this.runTask();
      } finally {
         EncTaskTracker.instance().over(this.container.getTask());
      }

   }

   public void runTask() {
      this.countDownLatch.countDown();
      List<ColumnInfoVO> rollbackCols = new ArrayList();
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + this.projectId + File.separator + this.dataSystemId;
      Logger encryptionlogger = (new LoggerBuilder()).getLogger(loggerPath, this.schema + "." + this.tableName);
      Thread.currentThread().setName("pool-" + this.tableName + "-thread");
      encryptionlogger.info("执行批量加密任务开始start>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
      encryptionlogger.info("执行批量加密任务开始start↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓");
      encryptionlogger.info("启动执行线程！！");
      TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao = (TCoreJiaMiJieMiJinDuDao)ApplicationContextProvider.getBean(TCoreJiaMiJieMiJinDuDao.class);
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);
      MaksingAppDataRuleService maksingAppDataRuleService = (MaksingAppDataRuleService)ApplicationContextProvider.getBean(MaksingAppDataRuleService.class);
      new HashMap();
      Boolean doresult = true;
      String copySuffix1 = this.copySuffix;
      String selectSQL = "";
      List<String> selectSqlList = new ArrayList();
      String updateSQL = "";
      List<String> updateSqlList = new ArrayList();
      StringBuilder selectStrBuilder = new StringBuilder();
      Boolean isOracle = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         isOracle = false;
      }

      Boolean isPostgres = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
         isPostgres = false;
      }

      Boolean isGreenplum = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         isGreenplum = false;
      }

      Boolean isMssqlserver = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         isMssqlserver = false;
      }

      Boolean isDM = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         isDM = false;
      }

      Boolean isKingbase = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         isKingbase = false;
      }

      Boolean isDB2 = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
         isDB2 = false;
      }

      Boolean isGBASE8S = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.GBASE8S.toString())) {
         isGBASE8S = false;
      }

      Boolean isOCEANBASE = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString())) {
         isOCEANBASE = false;
      }

      Boolean isMysql = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
         isMysql = false;
      }

      Boolean isHive = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
         isHive = false;
      }

      Boolean isHivetdh = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         isHivetdh = false;
      }

      if (this.primaryKeys.length > 0) {
         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (isOracle) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
            } else if (isPostgres) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
            } else if (isGreenplum) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
            } else if (!isMssqlserver && !isHive && !isHivetdh) {
               if (isDM) {
                  selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
               } else {
                  selectStrBuilder.append(this.primaryKeys[i]);
               }
            } else {
               selectStrBuilder.append(this.primaryKeys[i]);
            }

            if (i != this.primaryKeys.length - 1) {
               selectStrBuilder.append(",");
            }
         }
      }

      if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         String substring = selectStrBuilder.toString();
         String[] arr = substring.split(",");
         List list = new ArrayList();

         for(int i = 0; i < arr.length; ++i) {
            String s = arr[i].trim();
            if (!list.contains(s)) {
               list.add(s);
            }
         }

         substring = StringUtils.strip(list.toString(), "[]");
         selectStrBuilder.setLength(0);
         selectStrBuilder.append(substring);
      }

      StringBuilder updateStrBuilder = new StringBuilder();
      int count = 0;
      if (this.primaryKeys.length > 0) {
         updateSQL = updateSQL + " WHERE ";

         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (isOracle) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (isPostgres) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (isGreenplum) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (!isMssqlserver && !isHive && !isHivetdh) {
               if (isDM) {
                  updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               } else {
                  updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               }
            } else {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
            }

            ++count;
            if (count < this.primaryKeys.length) {
               updateSQL = updateSQL + " AND ";
            }
         }
      }

      String updateSql1 = updateSQL;
      StringBuilder addColumnStrings = new StringBuilder();
      List<StringBuilder> addCopy = new ArrayList();
      List<String> sqlColumnList = new ArrayList();
      Set<String> columnMap = JdbcTool.getColumnMap(this.connection, this.schema, this.tableName);

      for(int i = 0; i < this.columnInfoList.size(); ++i) {
         this.columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
         this.columnType = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType();
         this.columnSize = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnSize();
         tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "-1");
         String columNamecopy = this.columnName + this.copySuffix;
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         String primaryKeyFlag = "0";
         String primary_key_columns = "";
         String primary_key_col = "";

         for(com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO : maksingAppDataRuleService.queryColumnInfo(this.dataSystemId, this.schema, this.tableName)) {
            if (columnInfoVO.getPrimarykey().equals("1")) {
               primary_key_columns = primary_key_columns + columnInfoVO.getColumnname() + ",";
               if ("DM".equals(this.tCoreDatasystem.getDbtype())) {
                  primary_key_col = primary_key_columns + columnInfoVO.getColumnname();
               } else {
                  primary_key_col = "\"" + primary_key_columns + columnInfoVO.getColumnname() + "\",";
               }
            }
         }

         if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
            primary_key_col.substring(0, primary_key_col.length() - 1);
         }

         if (!"".equals(primary_key_columns)) {
            if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
               primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
            }

            String[] fileds = primary_key_columns.split(",");
            if (fileds.length > 0) {
               for(String filed11 : fileds) {
                  if (this.columnName.equals(filed11)) {
                     primaryKeyFlag = "1";
                  }
               }
            }
         }

         this.columnSize = EncUtils.strColumnSize(this.tCoreDatasystem.getDbtype(), this.columnType, this.columnSize, ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike(), primaryKeyFlag, ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType());
         String columnSizestr = "";
         if ("VARCHAR2".equalsIgnoreCase(this.columnType) || "varchar".equalsIgnoreCase(this.columnType) || "char".equalsIgnoreCase(this.columnType)) {
            columnSizestr = "(" + this.columnSize + ")";
         }

         StringBuilder addColumnString = new StringBuilder();
         String copyColumn = this.columnName + this.copySuffix;
         if (!columnMap.contains(copyColumn) && !columnMap.contains(columNamecopy)) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               addColumnString.append("alter table \"").append(this.schema).append("\".\"").append(this.tableName).append("\" ");
            } else {
               addColumnString.append("alter table ").append(this.schema).append(".").append(this.tableName);
            }

            if (isOracle) {
               addColumnStrings.append(columNamecopy).append(" ");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
            } else if (isDM) {
               addColumnStrings.append(columNamecopy).append(" ");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
            } else if (!isPostgres && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               if (isGreenplum) {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               } else if (isMssqlserver) {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               } else {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               }
            } else {
               addColumnStrings.append(columNamecopy).append(",");
               if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(";");
               } else {
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               }
            }
         }

         addCopy.add(addColumnString);
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            String substring = selectStrBuilder.toString() + ",\"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\"";
            String[] arr1 = substring.split(",");
            List list = new ArrayList();

            for(int n = 0; n < arr1.length; ++n) {
               String s = arr1[n].trim();
               if (!list.contains(s)) {
                  list.add(s);
               }
            }

            substring = StringUtils.strip(list.toString(), "[]");
            sqlColumnList.add(substring);
         } else {
            sqlColumnList.add(selectStrBuilder.toString() + "," + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
         }

         if (isOracle) {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\" where 1=1 ");
         } else if (isPostgres) {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" FROM \"" + this.schema + "\".\"" + this.tableName + "\" where 1=1 ");
         } else if (isGreenplum) {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" FROM \"" + this.schema + "\".\"" + this.tableName + "\" where 1=1 ");
         } else if (isMssqlserver) {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + "." + this.tableName + " where 1=1 ");
         } else if (!isHive && !isHivetdh) {
            if (isDM) {
               String substring = selectStrBuilder.toString() + ",\"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\"";
               String[] arr1 = substring.split(",");
               List list = new ArrayList();

               for(int n = 0; n < arr1.length; ++n) {
                  String s = arr1[n].trim();
                  if (!list.contains(s)) {
                     list.add(s);
                  }
               }

               substring = StringUtils.strip(list.toString(), "[]");
               selectSqlList.add("SELECT " + substring + " FROM \"" + this.schema + "\".\"" + this.tableName + "\" where 1=1 ");
            } else if (isDB2) {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\" where 1=1 ");
            } else if (isOCEANBASE) {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\" where 1=1 ");
            } else if (isGBASE8S) {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + ":" + this.tableName + " where 1=1 ");
            } else {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + "." + this.tableName + " where 1=1 ");
            }
         } else {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + "." + this.tableName + " where 1=1 ");
         }

         updateStrBuilder.append(columNamecopy).append("=?,");
         if (isOracle) {
            updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" =? " + updateSql1);
         } else if (isPostgres) {
            updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" =? " + updateSql1);
         } else if (isGreenplum) {
            updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" =? " + updateSql1);
         } else if (isMssqlserver) {
            updateSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + " =? " + updateSql1);
         } else if (!isHive && !isHivetdh) {
            if (isDM) {
               updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" =? " + updateSql1);
            } else {
               updateSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + " =? " + updateSql1);
            }
         } else {
            updateSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + " =? " + updateSql1);
         }
      }

      List<TCoreJiaMiJieMiJinDu> tCoreJiaList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
      int cpppppp = tCoreJiaList.size();
      if (cpppppp == 0) {
         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag("0");
         tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
      }

      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
      if (null != tCoreJiaMiJieMiJinList && tCoreJiaMiJieMiJinList.size() > 0) {
         for(int npp = 0; npp < tCoreJiaMiJieMiJinList.size(); ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      if (null != tCoreJiaMiJieMiJin) {
         tCoreJiaMiJieMiJin.setTotalcounts(this.jiamiTasktotalCounts);
         tCoreJiaMiJieMiJin.setStarttime(new Date());
         tCoreJiaMiJieMiJin.setFlag("0");
         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
      }

      Statement commStmt = null;
      ResultSet rs = null;
      ResultSet rsCount = null;
      PreparedStatement updataCopyPstmt = null;
      Connection selcon = null;
      int bacthMaxCount = 10000;
      int curBacthCount = 0;

      try {
         this.connection.setAutoCommit(false);
         Statement stmtCount = null;

         try {
            stmtCount = this.connection.createStatement();
            String selectCountTable = "";
            if (isOracle) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isPostgres) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isGreenplum) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isMssqlserver) {
               selectCountTable = "select count(1) as table_rows from " + this.schema + "." + this.tableName;
            } else if (!isHive && !isHivetdh) {
               if (isDM) {
                  selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
               } else {
                  selectCountTable = "select count(1) as table_rows from " + this.schema + "." + this.tableName;
               }
            } else {
               selectCountTable = "select count(1) as table_rows from " + this.schema + "." + this.tableName;
            }

            for(rsCount = stmtCount.executeQuery(selectCountTable); rsCount.next(); this.jiamiTasktotalCounts = rsCount.getInt("table_rows")) {
            }

            if (null != tCoreJiaMiJieMiJin) {
               tCoreJiaMiJieMiJin.setTotalcounts(this.jiamiTasktotalCounts);
               tCoreJiaMiJieMiJin.setStarttime(new Date());
               tCoreJiaMiJieMiJin.setFlag("0");
               tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
            }
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (rsCount != null) {
               try {
                  stmtCount.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            if (stmtCount != null) {
               try {
                  stmtCount.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            stmtCount.close();
         }

         for(int i = 0; i < this.columnInfoList.size(); ++i) {
            ColumnInfoVO colInfo = (ColumnInfoVO)this.columnInfoList.get(i);

            try {
               this.isKeepReadData = true;
               this.startRow = 0;
               this.columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
               tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "-1");
               boolean isupk = false;
               if (this.columnPrimaryKeyInfoList != null && this.columnPrimaryKeyInfoList.size() > 0 && "1".equals(((ColumnPrimaryKeyInfo)this.columnPrimaryKeyInfoList.get(0)).getFlag())) {
                  List pklist = Arrays.asList(this.primaryKeys);
                  if (pklist.contains(this.columnName)) {
                     isupk = true;
                  }
               }

               try {
                  if (isOracle) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isPostgres) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isGreenplum) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isMssqlserver) {
                     this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, false, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isHivetdh) {
                     this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, false, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isDM) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else {
                     this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  }
               } catch (SQLException e) {
                  this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "4");
                  encryptionlogger.error(e.getMessage());
                  continue;
               }

               Boolean bh = false;
               Map<String, String> mt = new HashMap();
               encryptionlogger.info("正常信息获取表字段信息");

               try {
                  commStmt = this.connection.createStatement();
                  rs = JdbcTool.getColumns(this.connection, this.schema, this.tableName);
                  ResultSetMetaData rsMetadata = rs.getMetaData();
                  int countMT = rsMetadata.getColumnCount();

                  for(int i1 = 1; i1 < countMT + 1; ++i1) {
                     String columnNameCol = rsMetadata.getColumnLabel(i1);
                     String columnTypeCol = rsMetadata.getColumnTypeName(i1);
                     if (!mt.containsKey(columnNameCol)) {
                        mt.put(columnNameCol, columnTypeCol);
                     }
                  }

                  if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
                     bh = true;
                  }

                  updataCopyPstmt = this.connection.prepareStatement((String)updateSqlList.get(i));
               } catch (Exception w) {
                  encryptionlogger.info("异常信息" + w.getMessage());
                  continue;
               }

               encryptionlogger.info("正常信息开始查询加密数据");

               label9839:
               while(this.isKeepReadData) {
                  ResultSet rs1 = null;
                  PreparedStatement tableDataStatement = null;

                  try {
                     String sql1 = (String)sqlColumnList.get(i);
                     String sql2 = (String)selectSqlList.get(i);
                     String sqlPaging = null;
                     if (isDB2) {
                        sqlPaging = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + this.startRow + " AND RN <= " + (this.startRow + this.maxPackageCount);
                     } else if (!isOracle && !isDM) {
                        if (!isPostgres && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                           if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                              sqlPaging = sql2 + " limit " + this.maxPackageCount + " OFFSET " + this.startRow;
                           } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                              if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                                 sqlPaging = sql2 + " ORDER BY " + sql1 + " OFFSET " + this.startRow + " ROWS FETCH NEXT " + this.maxPackageCount + " ROWS ONLY";
                              }
                           } else {
                              sqlPaging = sql2 + " limit " + this.startRow + "," + this.maxPackageCount;
                           }
                        } else {
                           sqlPaging = sql2 + " offset " + this.startRow + " limit " + this.maxPackageCount;
                        }
                     } else {
                        sqlPaging = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + this.startRow + " AND RN <= " + (this.startRow + this.maxPackageCount);
                     }

                     this.startRow += this.maxPackageCount;
                     System.out.println("-------- 读取数据SQL：" + sqlPaging);
                     tableDataStatement = this.connection.prepareStatement(sqlPaging, 1004, 1007);
                     tableDataStatement.setFetchSize(10000);
                     rs1 = tableDataStatement.executeQuery();
                     if (!this.isCanKeepRead(rs1)) {
                        this.isKeepReadData = false;
                        break;
                     }

                     if ("HIVE".equals(this.tCoreDatasystem.getDbtype()) || "HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
                        if (!rs1.next()) {
                           break;
                        }

                        try {
                           String secretkeyId = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKeyId();
                           String encryptionType = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType();
                           String secretKey = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKey();
                           String isLike = ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike();
                           String value = rs1.getString(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
                           String keepfirst = ((ColumnInfoVO)this.columnInfoList.get(i)).getKeepfirst();
                           String encdigit = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncdigit();
                           String twoindex = ((ColumnInfoVO)this.columnInfoList.get(i)).getTwoindex();
                           value = this.doEncryptionMethod(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
                           updataCopyPstmt.setString(1, value);

                           for(int j = 0; j < this.primaryKeys.length; ++j) {
                              if (bh) {
                                 String cname = this.primaryKeys[j];
                                 com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                                 if (columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int")) {
                                    updataCopyPstmt.setInt(j + 2, Integer.parseInt(rs1.getString(this.primaryKeys[j])));
                                 } else {
                                    updataCopyPstmt.setString(j + 2, rs1.getString(this.primaryKeys[j]));
                                 }
                              } else {
                                 updataCopyPstmt.setString(j + 2, rs1.getString(this.primaryKeys[j]));
                              }
                           }

                           updataCopyPstmt.addBatch();
                           ++this.jiamiTaskFinishCounts;
                           ++curBacthCount;
                        } catch (Exception q) {
                           this.isKeepReadData = false;
                           encryptionlogger.info("异常信息" + q.getMessage());
                           curBacthCount = 0;
                           continue;
                        }

                        if (curBacthCount == bacthMaxCount) {
                           try {
                              updataCopyPstmt.executeBatch();
                              this.connection.commit();
                           } catch (Exception t) {
                              this.isKeepReadData = false;
                              encryptionlogger.error(t.getMessage());
                              encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
                              encryptionlogger.warn("{}行加密数据提交失败!", curBacthCount);
                              if (null != tCoreJiaMiJieMiJin) {
                                 tCoreJiaMiJieMiJin.setExceptionstring(t.toString());
                                 tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                              }

                              doresult = false;
                              TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
                              List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
                              int cpplll = tCoreJiaMiJieList.size();
                              if (cpplll > 0) {
                                 for(int npplll = 0; npplll < cpplll; ++npplll) {
                                    tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
                                 }
                              }

                              tCoreJiaMiJie.setState("-1");
                              this.jiamiTaskFinishCounts -= curBacthCount;
                              tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                              this.failCount += curBacthCount;
                              tCoreJiaMiJieMiJin.setFailcounts(this.failCount);
                              tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
                              curBacthCount = 0;
                              TCoreJiaMiJieMiJinDu var570 = null;
                              continue;
                           }

                           curBacthCount = 0;
                           if (null != tCoreJiaMiJieMiJin && doresult) {
                              tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                              tCoreJiaMiJieMiJin.setState("0");
                              tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                           }

                           encryptionlogger.info("表名：" + this.tableName + "，字段：" + this.columnName + " 加密完成行数为：" + this.jiamiTaskFinishCounts);
                        }
                     }

                     while(true) {
                        while(true) {
                           while(true) {
                              if (!rs1.next()) {
                                 continue label9839;
                              }

                              try {
                                 String secretkeyId = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKeyId();
                                 String encryptionType = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType();
                                 String secretKey = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKey();
                                 String isLike = ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike();
                                 String value = rs1.getString(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
                                 String keepfirst = ((ColumnInfoVO)this.columnInfoList.get(i)).getKeepfirst();
                                 String encdigit = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncdigit();
                                 String twoindex = ((ColumnInfoVO)this.columnInfoList.get(i)).getTwoindex();
                                 value = this.doEncryptionMethod(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
                                 updataCopyPstmt.setString(1, value);

                                 for(int j = 0; j < this.primaryKeys.length; ++j) {
                                    if (bh) {
                                       String cname = this.primaryKeys[j];
                                       com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                                       if (columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int")) {
                                          updataCopyPstmt.setInt(j + 2, Integer.parseInt(rs1.getString(this.primaryKeys[j])));
                                       } else {
                                          updataCopyPstmt.setString(j + 2, rs1.getString(this.primaryKeys[j]));
                                       }
                                    } else {
                                       updataCopyPstmt.setString(j + 2, rs1.getString(this.primaryKeys[j]));
                                    }
                                 }

                                 updataCopyPstmt.addBatch();
                                 ++this.jiamiTaskFinishCounts;
                                 ++curBacthCount;
                                 break;
                              } catch (Exception q) {
                                 this.isKeepReadData = false;
                                 encryptionlogger.info("异常信息" + q.getMessage());
                                 curBacthCount = 0;
                              }
                           }

                           if (curBacthCount == bacthMaxCount) {
                              try {
                                 updataCopyPstmt.executeBatch();
                                 this.connection.commit();
                                 break;
                              } catch (Exception t) {
                                 this.isKeepReadData = false;
                                 encryptionlogger.error(t.getMessage());
                                 encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
                                 encryptionlogger.warn("{}行加密数据提交失败!", curBacthCount);
                                 if (null != tCoreJiaMiJieMiJin) {
                                    tCoreJiaMiJieMiJin.setExceptionstring(t.toString());
                                    tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                                 }

                                 doresult = false;
                                 TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
                                 List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
                                 int cpplll = tCoreJiaMiJieList.size();
                                 if (cpplll > 0) {
                                    for(int npplll = 0; npplll < cpplll; ++npplll) {
                                       tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
                                    }
                                 }

                                 tCoreJiaMiJie.setState("-1");
                                 this.jiamiTaskFinishCounts -= curBacthCount;
                                 tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                                 this.failCount += curBacthCount;
                                 tCoreJiaMiJieMiJin.setFailcounts(this.failCount);
                                 tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
                                 curBacthCount = 0;
                                 TCoreJiaMiJieMiJinDu var573 = null;
                              }
                           }
                        }

                        curBacthCount = 0;
                        if (null != tCoreJiaMiJieMiJin && doresult) {
                           tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                           tCoreJiaMiJieMiJin.setState("0");
                           tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                        }

                        encryptionlogger.info("表名：" + this.tableName + "，字段：" + this.columnName + " 加密完成行数为：" + this.jiamiTaskFinishCounts);
                     }
                  } catch (Exception q) {
                     this.isKeepReadData = false;
                     encryptionlogger.info("异常信息" + q.getMessage());
                  } finally {
                     if (rs1 != null) {
                        try {
                           rs1.close();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                     if (tableDataStatement != null) {
                        try {
                           tableDataStatement.close();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                  }
               }

               if (curBacthCount > 0) {
                  try {
                     updataCopyPstmt.executeBatch();
                     this.connection.commit();
                  } catch (Exception e) {
                     encryptionlogger.error(e.getMessage());
                     encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
                     encryptionlogger.warn("{}行加密数据提交失败!", curBacthCount);
                     if (null != tCoreJiaMiJieMiJin) {
                        tCoreJiaMiJieMiJin.setExceptionstring(e.toString());
                        tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                     }

                     doresult = false;
                     TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
                     List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
                     int cpplll = tCoreJiaMiJieList.size();
                     if (cpplll > 0) {
                        for(int npplll = 0; npplll < cpplll; ++npplll) {
                           tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
                        }
                     }

                     tCoreJiaMiJie.setState("-1");
                     this.jiamiTaskFinishCounts -= curBacthCount;
                     tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                     tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
                     continue;
                  }
               } else {
                  this.connection.commit();
               }

               String flag = doresult ? "1" : "4";
               encryptionlogger.info("字段" + this.columnName + "加密完成！");
               encryptionlogger.info("字段" + this.columnName + "加密完成总行数：" + this.jiamiTaskFinishCounts);
               tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, flag);
               if (null != tCoreJiaMiJieMiJin && doresult) {
                  tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                  tCoreJiaMiJieMiJin.setState("1");
                  tCoreJiaMiJieMiJin.setEndtime(new Date());
                  tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
               }

               String check = this.checkEncryption(this.tCoreDatasystem, (ColumnInfoVO)this.columnInfoList.get(i), encryptionlogger);
               if (!"ok".equals(check)) {
                  this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "12");
                  encryptionlogger.error("正常信息：字段" + this.columnName + "加密校验失败");
               } else {
                  encryptionlogger.info("正常信息：字段" + this.columnName + "加密校验成功");
                  String columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
                  tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, flag);
                  if (null != tCoreJiaMiJieMiJin && doresult) {
                     tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                     tCoreJiaMiJieMiJin.setState("1");
                     tCoreJiaMiJieMiJin.setEndtime(new Date());
                     tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                  }

                  String primaryKeyFlag = "0";
                  String primary_key_columns = "";
                  String primary_key_col = "";
                  List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumns = maksingAppDataRuleService.queryColumnInfo(this.dataSystemId, this.schema, this.tableName);
                  encryptionlogger.info("正常信息：字段" + columnName + "加载替换开始");
                  if (this.primaryKeys.length != 0) {
                     for(int ip = 0; ip < this.primaryKeys.length; ++ip) {
                        primary_key_columns = primary_key_columns + this.primaryKeys[ip] + ",";
                        primary_key_col = "\"" + primary_key_columns + this.primaryKeys[ip] + "\",";
                     }
                  }

                  if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
                     primary_key_col = primary_key_col.substring(0, primary_key_col.length() - 1);
                  }

                  if (!"".equals(primary_key_columns)) {
                     if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
                        primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                     }

                     String[] fileds = primary_key_columns.split(",");
                     if (fileds.length > 0) {
                        for(String filed11 : fileds) {
                           if (((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName().equals(filed11)) {
                              primaryKeyFlag = "1";
                           }
                        }
                     }
                  }

                  encryptionlogger.info("字段" + columnName + " 获取原字段长度");
                  String columnSizeInitialStr = "";

                  try {
                     String alterColumnToInitialSql = "";

                     try {
                        this.columnSize = colInfo.getColumnSize();
                        columnSizeInitialStr = "(" + this.columnSize + ")";
                        if (null != this.columnType && this.columnType.toLowerCase().contains("text")) {
                           columnSizeInitialStr = "";
                        }

                        encryptionlogger.info("字段" + columnName + " 获取原字段长度:" + this.columnSize);
                        encryptionlogger.info("字段" + columnName + " 修改字段名为:" + columnName + this.initialSuffix);
                        if (isOracle) {
                           alterColumnToInitialSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                        } else if (!isPostgres && !EdbType.GAUSS.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                           if (isGreenplum) {
                              alterColumnToInitialSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                           } else if (isMssqlserver) {
                              alterColumnToInitialSql = "EXEC sp_rename '[" + this.schema + "].[" + this.tableName + "].[" + columnName + "]', '" + columnName + this.initialSuffix + "', 'COLUMN'";
                           } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                              alterColumnToInitialSql = "ALTER TABLE " + this.schema + "." + this.tableName + "  change " + columnName + " " + columnName + this.initialSuffix + " " + this.columnType + columnSizeInitialStr;
                           } else if (isDM) {
                              alterColumnToInitialSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  alter column \"" + columnName + "\" rename to \"" + columnName + this.initialSuffix + "\"";
                           } else if (isKingbase) {
                              alterColumnToInitialSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                           } else {
                              alterColumnToInitialSql = this.alterColumnToInitialSqlProject(this.schema, this.tableName, columnName, this.columnType, columnSizeInitialStr, this.initialSuffix, isupk);
                           }
                        } else {
                           alterColumnToInitialSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                        }

                        commStmt.executeUpdate(alterColumnToInitialSql);
                        if (isMssqlserver || isGreenplum || isPostgres) {
                           this.connection.commit();
                        }

                        encryptionlogger.info("正常信息：字段" + columnName + " 修改字段名为:" + columnName + this.initialSuffix + " 成功");
                     } catch (Exception e) {
                        encryptionlogger.info("字段" + columnName + "加载替换失败:字段" + columnName + " 修改字段名为:" + columnName + this.initialSuffix + " 失败");
                        encryptionlogger.error(e.getMessage());
                        encryptionlogger.error("异常信息" + e.getMessage());
                        encryptionlogger.info("字段" + columnName + "加载替换失败： 失败， sql语句：" + alterColumnToInitialSql);
                        this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "9");
                        encryptionlogger.info("正常信息：copy字段回滚开始");
                        encryptionlogger.info("正常信息：copy字段回滚结束");
                        this.jiamiTaskFinishCounts = 0;
                        e.printStackTrace();
                        continue;
                     }

                     boolean ispk = false;
                     if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                        String primaryKeysqlIndex = "";
                        String primaryKeysql = "";
                        String primaryKeysql1 = "";
                        if (isOracle) {
                           primaryKeysql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  drop primary key";
                        } else if (isPostgres) {
                           primaryKeysql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  DROP CONSTRAINT \"" + this.tableName + "_pkey\"";
                        } else if (isGreenplum) {
                           primaryKeysql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  DROP CONSTRAINT \"" + this.tableName + "_pkey\"";
                        } else if (isMssqlserver) {
                           List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(this.connection, this.schema, this.tableName);
                           StringBuilder primaryKeysqlBuilder = new StringBuilder();
                           if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                              for(int i3 = 0; i3 < primarykeyInfo.size(); ++i3) {
                                 primaryKeysql = "ALTER TABLE " + this.schema + "." + this.tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i3)).getPkname() + " ";
                                 primaryKeysqlBuilder.append(primaryKeysql);
                              }

                              primaryKeysql = primaryKeysqlBuilder.toString();
                           }
                        } else if (isDM) {
                           List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(this.connection, this.schema, this.tableName);
                           if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                              for(int i4 = 0; i4 < primarykeyInfo.size(); ++i4) {
                                 primaryKeysqlIndex = "create CLUSTER index \"" + this.schema + "_" + this.tableName + "_" + columnName + "_index\" on \"" + this.schema + "\".\"" + this.tableName + "\"(\"" + columnName + this.copySuffix + "\") ";
                                 primaryKeysql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i4)).getPkname() + "\"";
                                 primaryKeysql1 = "drop index \"" + this.schema + "\".\"" + this.schema + "_" + this.tableName + "_" + columnName + "_index\"";
                                 PreparedStatement preStatementKeyIndex = this.connection.prepareStatement(primaryKeysqlIndex);
                                 preStatementKeyIndex.executeUpdate();
                                 preStatementKeyIndex.close();

                                 try {
                                    PreparedStatement preStatementKey = this.connection.prepareStatement(primaryKeysql);
                                    preStatementKey.executeUpdate();
                                    preStatementKey.close();
                                 } catch (Exception var484) {
                                 }

                                 PreparedStatement preStatementKey1 = this.connection.prepareStatement(primaryKeysql1);
                                 preStatementKey1.executeUpdate();
                                 preStatementKey1.close();
                              }
                           }
                        } else if (!isKingbase) {
                           primaryKeysql = "alter table " + this.schema + "." + this.tableName + "  drop primary key";
                        } else {
                           List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(this.connection, this.schema, this.tableName);
                           StringBuilder primaryKeysqlBuilder = new StringBuilder();
                           if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                              for(int i5 = 0; i5 < primarykeyInfo.size(); ++i5) {
                                 primaryKeysql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i5)).getPkname() + "\" ";
                                 primaryKeysqlBuilder.append(primaryKeysql);
                              }

                              primaryKeysql = primaryKeysqlBuilder.toString();
                           }
                        }

                        if (isDM) {
                           try {
                              PreparedStatement preStatementKey = this.connection.prepareStatement(primaryKeysql);
                              preStatementKey.executeUpdate();
                              preStatementKey.close();
                           } catch (Exception var483) {
                           }
                        } else {
                           PreparedStatement preStatementKey = this.connection.prepareStatement(primaryKeysql);
                           preStatementKey.executeUpdate();
                           preStatementKey.close();
                        }
                     }

                     String columnSizestr = "";
                     String alterCopyToColumnSql = "";

                     try {
                        this.columnSize = EncUtils.strColumnSize(this.tCoreDatasystem.getDbtype(), this.columnType, this.columnSize, ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike(), primaryKeyFlag, ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType());
                        columnSizestr = "(" + this.columnSize + ")";
                        String s2 = "";
                        if (isOracle) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                        } else if (!isPostgres && !EdbType.GAUSS.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                           if (isGreenplum) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           } else if (isMssqlserver) {
                              alterCopyToColumnSql = "EXEC sp_rename '[" + this.schema + "].[" + this.tableName + "].[" + columnName + this.copySuffix + "]', '" + columnName + "', 'COLUMN'";
                           } else if (isHivetdh) {
                              alterCopyToColumnSql = "ALTER TABLE " + this.schema + "." + this.tableName + "  change " + columnName + this.copySuffix + " " + columnName + " " + this.columnType + columnSizestr;
                           } else if (isDM) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  alter column \"" + columnName + this.copySuffix + "\" rename to \"" + columnName + "\"";
                           } else if (isMysql) {
                              alterCopyToColumnSql = this.alterCopyToColumnSqlProject(this.schema, this.tableName, columnName, this.columnType, columnSizestr, this.copySuffix, isupk);
                           } else if (isKingbase) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           } else {
                              alterCopyToColumnSql = this.alterCopyToColumnSqlProject(this.schema, this.tableName, columnName, this.columnType, columnSizestr, this.copySuffix, isupk);
                           }
                        } else {
                           alterCopyToColumnSql = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                        }

                        commStmt.executeUpdate(alterCopyToColumnSql);
                        if (EdbType.GAUSS.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) || isKingbase || isMssqlserver || isGreenplum || isPostgres) {
                           this.connection.commit();
                        }
                     } catch (Exception e) {
                        rollbackCols.add(this.columnInfoList.get(i));
                        encryptionlogger.info("字段" + columnName + "加载替换失败:字段" + columnName + this.copySuffix + " 修改字段名为:" + columnName + " 失败");
                        encryptionlogger.error(e.getMessage());
                        encryptionlogger.error("异常信息" + e.getMessage());
                        encryptionlogger.info("字段" + columnName + "加载替换失败： 失败， sql语句：" + alterCopyToColumnSql);
                        this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "9");
                        encryptionlogger.info("正常信息：copy字段回滚开始");
                        this.updateInitalColumn((ColumnInfoVO)this.columnInfoList.get(i), this.initialSuffix, commStmt, encryptionlogger);
                        encryptionlogger.info("正常信息：Initial字段回滚结束");
                        this.jiamiTaskFinishCounts = 0;
                        e.printStackTrace();
                        continue;
                     }

                     if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                        String[] fileds = primary_key_columns.split(",");
                        if (fileds.length > 1) {
                           String primaryKeysql111 = "";
                           StringBuilder primaryKeysql333 = new StringBuilder();
                           if (isOracle) {
                              if (!"".equals(primary_key_col)) {
                                 primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (" + primary_key_col + ")";
                              }
                           } else if (isPostgres) {
                              if (!"".equals(primary_key_col)) {
                                 primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (" + primary_key_col + ")";
                              }
                           } else if (isGreenplum) {
                              if (!"".equals(primary_key_col)) {
                                 primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (" + primary_key_col + ")";
                              }
                           } else if (isMssqlserver) {
                              for(com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO allColumn : allColumns) {
                                 String substring = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                                 String[] split = substring.split(",");

                                 for(String col : split) {
                                    if (col.equals(allColumn.getColumnname())) {
                                       primaryKeysql333.append("ALTER TABLE [" + this.schema + "].[" + this.tableName + "]  ALTER COLUMN [" + col + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                    }
                                 }
                              }

                              primaryKeysql111 = "alter table " + this.schema + "." + this.tableName + "  add primary key (" + primary_key_columns + ")";
                           } else if (!isDM) {
                              primaryKeysql111 = "alter table " + this.schema + "." + this.tableName + "  add primary key (" + primary_key_columns + ")";
                           } else if (!"".equals(primary_key_columns)) {
                              String[] arr1 = primary_key_columns.split(",");
                              List list = new ArrayList();

                              for(int n = 0; n < arr1.length; ++n) {
                                 String s = arr1[n].trim();
                                 if (!list.contains(s)) {
                                    list.add(s);
                                 }
                              }

                              primary_key_columns = StringUtils.strip(list.toString(), "[]");
                              primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (" + primary_key_columns + ")";
                           }

                           if (primaryKeysql333.length() > 0) {
                              PreparedStatement preStatementKey333 = this.connection.prepareStatement(primaryKeysql333.toString());
                              preStatementKey333.executeUpdate();
                              preStatementKey333.close();
                           }

                           PreparedStatement preStatementKey111 = this.connection.prepareStatement(primaryKeysql111);
                           preStatementKey111.executeUpdate();
                           preStatementKey111.close();
                        } else {
                           String primaryKeysql111 = "";
                           StringBuilder primaryKeysql333 = new StringBuilder();
                           if (isOracle) {
                              primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (\"" + columnName + "\")";
                           } else if (isPostgres) {
                              primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (\"" + columnName + "\")";
                           } else if (isGreenplum) {
                              primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (\"" + columnName + "\")";
                           } else if (!isMssqlserver) {
                              if (isDM) {
                                 primaryKeysql111 = "alter table \"" + this.schema + "\".\"" + this.tableName + "\"  add primary key (\"" + columnName + "\")";
                              } else {
                                 primaryKeysql111 = "alter table " + this.schema + "." + this.tableName + "  add primary key (" + columnName + ")";
                              }
                           } else {
                              for(com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO allColumn : allColumns) {
                                 if (columnName.equals(allColumn.getColumnname())) {
                                    primaryKeysql333.append("ALTER TABLE [" + this.schema + "].[" + this.tableName + "]  ALTER COLUMN [" + columnName + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                 }
                              }

                              primaryKeysql111 = "alter table " + this.schema + "." + this.tableName + "  add primary key (" + columnName + ")";
                           }

                           if (null != primaryKeysql333) {
                              PreparedStatement preStatementKey333 = this.connection.prepareStatement(primaryKeysql333.toString());
                              preStatementKey333.executeUpdate();
                              preStatementKey333.close();
                           }

                           PreparedStatement preStatementKey111 = this.connection.prepareStatement(primaryKeysql111);
                           preStatementKey111.executeUpdate();
                           preStatementKey111.close();
                        }
                     }

                     this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "5");
                     this.jiamiTaskFinishCounts = 0;
                     encryptionlogger.info("字段" + columnName + "加载替换完成");
                     encryptionlogger.info("执行批量加密任务结束--------------------------");
                     encryptionlogger.info("--------------------------------------------");
                  } catch (Exception e) {
                     encryptionlogger.info("字段" + columnName + "加载替换失败");
                     encryptionlogger.error(e.getMessage());
                     encryptionlogger.error("异常信息" + e.getMessage());
                     this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "9");
                     this.jiamiTaskFinishCounts = 0;
                     e.printStackTrace();
                  } finally {
                     if (rs != null) {
                        try {
                           rs.close();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                     if (commStmt != null) {
                        try {
                           commStmt.close();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                     if (updataCopyPstmt != null) {
                        try {
                           updataCopyPstmt.close();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                     System.gc();
                  }
               }
            } finally {
               this.container.over(colInfo.getColumnName());
            }
         }
      } catch (Exception e) {
         encryptionlogger.error(e.getMessage(), e);
         encryptionlogger.info("加载替换失败");
         encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
         tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "4");

         try {
            this.connection.rollback();
         } catch (SQLException ex) {
            ex.printStackTrace();
         }

         TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
         List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
         int cpplll = tCoreJiaMiJieList.size();
         if (cpplll > 0) {
            for(int npplll = 0; npplll < cpplll; ++npplll) {
               tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
            }
         }

         tCoreJiaMiJie.setState("-1");
         this.failCount += curBacthCount;
         tCoreJiaMiJie.setFailcounts(this.failCount);
         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
      } finally {
         if (this.connection != null) {
            try {
               this.connection.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (selcon != null) {
            try {
               selcon.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (commStmt != null) {
            try {
               commStmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (rsCount != null) {
            try {
               rsCount.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (updataCopyPstmt != null) {
            try {
               updataCopyPstmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      if (rollbackCols.size() > 0) {
         try {
            Connection rollbackConn = JdbcTool.getConnection(this.tCoreDatasystem);
            Throwable var545 = null;

            try {
               this.rollbackColumns(rollbackConn, rollbackCols, this.copySuffix, (List)null, (List)null, (List)null, this.tCoreDatasystem);
            } catch (Throwable var474) {
               var545 = var474;
               throw var474;
            } finally {
               if (rollbackConn != null) {
                  if (var545 != null) {
                     try {
                        rollbackConn.close();
                     } catch (Throwable var473) {
                        var545.addSuppressed(var473);
                     }
                  } else {
                     rollbackConn.close();
                  }
               }

            }
         } catch (Exception e) {
            encryptionlogger.error("加密替换回滚失败:" + e.getMessage());
         }
      }

   }

   private String doEncryptionMethod(String encryptionType, String secretKey, String value, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      if (null != encryptionType && !"".equals(encryptionType)) {
         value = EncProvider.encryptEcb(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
      }

      return value;
   }

   private String checkEncryption(TCoreDatasystem tCoreDatasystem, ColumnInfoVO columnInfoVO, Logger encryptionlogger) {
      encryptionlogger.info("正常信息：开始校验");
      ResultSet rsCount = null;
      int checkNum = Integer.valueOf(this.props.getProperty("checkNum"));
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var9 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var11 = null;

            try {
               encryptionlogger.info("正常信息：校验连接创建成功");
               Boolean bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isgreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isgreenplum = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               encryptionlogger.info("正常信息：加密非空校验开始");
               int iCLimitCount = 0;
               ResultSet rsC = null;

               String columnNameN;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + this.columnName + "\" IS NOT NULL AND \"" + this.columnName + this.copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + this.columnName + "\" IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isgreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + this.columnName + "\" IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isHivetdh) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + this.schema + "." + this.tableName + " WHERE " + this.columnName + " IS NOT NULL AND " + this.columnName + this.copySuffix + " IS NULL  limit " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + this.columnName + "\" IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE " + this.columnName + " IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + this.columnName + "\" IS NOT NULL AND \"" + this.columnName + this.copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE " + this.columnName + " IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(this.schema);
                     mg.append("表：");
                     mg.append(this.tableName);
                     mg.append("列：");
                     mg.append(this.columnName);
                     mg.append("加密后的数据为空，加密失败，准备回滚。");
                     encryptionlogger.info("异常信息：加密非空校验：加密后的数据为空，加密失败，准备回滚。");
                     columnNameN = mg.toString();
                     return columnNameN;
                  }

                  encryptionlogger.info("正常信息：加密非空校验通过");
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               encryptionlogger.info("正常信息：解密校验开始");
               ResultSet rs1 = null;

               try {
                  if (bb) {
                     rs1 = stmt.executeQuery("select nn.\"" + this.columnName + "\",nn.\"" + this.columnName + this.copySuffix + "\" from (select t.\"" + this.columnName + "\",t.\"" + this.columnName + this.copySuffix + "\",rownum rn from \"" + this.schema + "\".\"" + this.tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                  } else if (bbb) {
                     rs1 = stmt.executeQuery("select \"" + this.columnName + "\",\"" + this.columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (isgreenplum) {
                     rs1 = stmt.executeQuery("select \"" + this.columnName + "\",\"" + this.columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (isHivetdh) {
                     rs1 = stmt.executeQuery("select " + this.columnName + "," + this.columnName + this.copySuffix + " from " + this.schema + "." + this.tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rs1 = stmt.executeQuery("select \"" + this.columnName + "\",\"" + this.columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (SQBoolean) {
                     rs1 = stmt.executeQuery("SELECT " + this.columnName + "," + this.columnName + this.copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + this.schema + "." + this.tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                  } else if (DMBoolean) {
                     rs1 = stmt.executeQuery("select \"" + this.columnName + "\",\"" + this.columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else {
                     rs1 = stmt.executeQuery(this.checkColumn(this.schema, this.tableName, this.columnName, this.columnName + this.copySuffix, iCLimitCount, checkNum));
                  }

                  while(rs1.next()) {
                     String copy = rs1.getString(this.columnName + this.copySuffix);
                     if (null != copy) {
                        columnNameN = rs1.getString(this.columnName);
                        String secretKeyId = columnInfoVO.getSecretKeyId();
                        Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                        if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                           Boolean isEq = EncUtils.compareStringEq(columnNameN, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, columnInfoVO.getIsLike(), columnInfoVO.getKeepfirst(), columnInfoVO.getEncdigit(), columnInfoVO.getTwoindex()));
                           if (!isEq) {
                              StringBuilder mg111 = new StringBuilder();
                              mg111.append("数据源：");
                              mg111.append(this.schema);
                              mg111.append("表：");
                              mg111.append(this.tableName);
                              mg111.append("列：");
                              mg111.append(this.columnName);
                              mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                              encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                              String var27 = mg111.toString();
                              return var27;
                           }
                        }
                     }
                  }

                  encryptionlogger.info("正常信息：解密校验通过");
               } catch (Exception e) {
                  e.printStackTrace();
                  encryptionlogger.info("结束校验");
                  columnNameN = "e1";
                  return columnNameN;
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var128) {
               var11 = var128;
               throw var128;
            } finally {
               if (stmt != null) {
                  if (var11 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var121) {
                        var11.addSuppressed(var121);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var130) {
            var9 = var130;
            throw var130;
         } finally {
            if (conn != null) {
               if (var9 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var120) {
                     var9.addSuppressed(var120);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         encryptionlogger.info("正常信息：校验结束");
         return "e2";
      }

      encryptionlogger.info("正常信息：校验结束");
      return "ok";
   }

   private String checkCopy(String schema, String tableName, String columnName, String checkColumnName) {
      String sql = String.format("SELECT COUNT(1) AS num FROM %s.%s WHERE %s <> NULL AND (%s = NULL or %s = '')", schema, tableName, columnName, checkColumnName, checkColumnName);
      return sql;
   }

   private String checkColumn(String schema, String tableName, String columnName, String checkColumnName, int iCLimitCount, int limitCount) {
      String sql = String.format("SELECT %s,%s FROM %s.%s limit %s,%s", columnName, checkColumnName, schema, tableName, iCLimitCount, limitCount);
      return sql;
   }

   private String delCopyColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      return sql;
   }

   private String columnSizeSql(String schema, String tableName, String columnName) {
      String sql = String.format("SELECT %s FROM %s.%s WHERE 1=2", columnName, schema, tableName);
      return sql;
   }

   private String alterColumnToInitialSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize, String initialSuffix, boolean isupk) {
      String sql = "";
      if (isupk) {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s not null", schema, tableName, columnName, columnName + initialSuffix, columnType, columnSize);
      } else {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName, columnName + initialSuffix, columnType, columnSize);
      }

      return sql;
   }

   private String alterInitialToColumnSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize, String initialSuffix) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName + initialSuffix, columnName, columnType, columnSize);
      return sql;
   }

   private String alterCopyToColumnSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize, String copySuffix, boolean isupk) {
      String sql = "";
      if (isupk) {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s not null", schema, tableName, columnName + copySuffix, columnName, columnType, columnSize);
      } else {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName + copySuffix, columnName, columnType, columnSize);
      }

      return sql;
   }

   private int updateFieldFlag(String id, String flag) {
      int num = this.jdbcTemplate.update("UPDATE t_core_encryption_field SET flag = ? WHERE id = ?", new Object[]{flag, id});
      return num;
   }

   private void addTableField(Connection con, String schema, String tableName, StringBuilder addColumnStrings, StringBuilder addColumnString, Logger encryptionlogger, boolean isupk, ColumnInfoVO columnInfoVO) throws SQLException {
      if (null != addColumnString && addColumnStrings.length() > 0) {
         if ("HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
            Set<String> columnMap = JdbcTool.getColumnMap(this.connection, schema, tableName);
            String cinitial = columnInfoVO.getColumnName() + PropertyGhcaUtil.initialSuffix;
            String sql = "";
            int max = 0;

            try {
               Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
               String property = properties.getProperty("encryption.field.max");
               if (property != null && property.length() > 0) {
                  max = Integer.valueOf(property.trim());
               }
            } catch (Exception e) {
               e.printStackTrace();
            }

            String hiveColumnSize = columnInfoVO.getColumnSize();
            if (max > 0 && Integer.parseInt(hiveColumnSize) >= max) {
               hiveColumnSize = String.valueOf(max);
            } else {
               hiveColumnSize = EncUtils.strColumnSize(this.tCoreDatasystem.getDbtype(), columnInfoVO.getColumnType(), columnInfoVO.getColumnSize(), columnInfoVO.getIsLike(), "0", columnInfoVO.getEncryptionType());
            }

            hiveColumnSize = "(" + hiveColumnSize + ")";
            if (columnMap.contains(cinitial)) {
               sql = "ALTER TABLE " + schema + "." + tableName + "  change " + columnInfoVO.getColumnName() + PropertyGhcaUtil.initialSuffix + " " + columnInfoVO.getColumnName() + PropertyGhcaUtil.copySuffix + " " + columnInfoVO.getColumnType() + hiveColumnSize;
            } else {
               sql = "alter table " + schema + "." + tableName + "  add columns(" + columnInfoVO.getColumnName() + PropertyGhcaUtil.copySuffix + " " + columnInfoVO.getColumnType() + hiveColumnSize + ")";
            }

            if (null != addColumnStrings) {
               encryptionlogger.info("新增加密列：" + addColumnStrings + "  sql语句：" + sql);
            }

            PreparedStatement preStatement = con.prepareStatement(sql);
            preStatement.executeUpdate();
            preStatement.close();
         } else {
            String sql = addColumnString.toString();
            if (isupk) {
               sql = sql + " not null";
            }

            if (null != addColumnStrings) {
               encryptionlogger.info("新增加密列：" + addColumnStrings + "  sql语句：" + sql);
            }

            PreparedStatement preStatement = con.prepareStatement(sql);
            preStatement.executeUpdate();
            preStatement.close();
         }
      }

   }

   public void deleteCopyColumn(ColumnInfoVO columnInfoVo, String copySuffix, Statement stmt, Logger encryptionlogger) {
      this.updateFieldFlag(columnInfoVo.getTcoreencryptionfieldId(), "4");
      String rollback;
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP (\"" + this.columnName + copySuffix + "\")";
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP COLUMN \"" + this.columnName + copySuffix + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
            rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
         } else {
            rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
         }
      } else {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP COLUMN \"" + this.columnName + copySuffix + "\"";
      }

      encryptionlogger.info("加密出错，删除加密列：" + columnInfoVo.getColumnName() + copySuffix);

      try {
         stmt.executeUpdate(rollback);
      } catch (SQLException var7) {
         encryptionlogger.info("删除加密列：" + columnInfoVo.getColumnName() + copySuffix + " 失败， sql语句：" + rollback);
      }

   }

   public void updateInitalColumn(ColumnInfoVO columnInfoVo, String initialSuffix, Statement stmt, Logger encryptionlogger) {
      String columnSizestr = "";
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
         columnSizestr = "(" + columnInfoVo.getColumnSize() + ")";
      }

      this.updateFieldFlag(columnInfoVo.getTcoreencryptionfieldId(), "4");
      String rollback;
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + this.columnName + initialSuffix + "\" TO \"" + this.columnName + "\"";
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            rollback = "EXEC sp_rename '[" + this.schema + "].[" + this.tableName + "].[" + this.columnName + initialSuffix + "]', '" + this.columnName + "', 'COLUMN'";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  alter column \"" + this.columnName + initialSuffix + "\" rename to \"" + this.columnName + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
            rollback = this.alterInitialToColumnSqlProject(this.schema, this.tableName, this.columnName, this.columnType, columnSizestr, initialSuffix);
         } else {
            rollback = this.alterInitialToColumnSqlProject(this.schema, this.tableName, this.columnName, this.columnType, columnSizestr, initialSuffix);
         }
      } else {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + this.columnName + initialSuffix + "\" TO \"" + this.columnName + "\"";
      }

      encryptionlogger.info("加密替换出错，initial列回滚：" + columnInfoVo.getColumnName());

      try {
         stmt.executeUpdate(rollback);
      } catch (SQLException throwables) {
         throwables.printStackTrace();
         encryptionlogger.info("initial列回滚：" + columnInfoVo.getColumnName() + " 失败， sql语句：" + rollback);
         encryptionlogger.info("initial列回滚失败错误：" + throwables.getMessage());
      }

   }

   private boolean isCanKeepRead(ResultSet rs) throws SQLException {
      try {
         boolean isCan = true;
         if (!"HIVE".equals(this.tCoreDatasystem.getDbtype()) && !"HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
            rs.last();
            if (rs.getRow() <= 0) {
               isCan = false;
            }

            rs.beforeFirst();
            System.out.println("isCanKeepRead方法:" + isCan);
            return isCan;
         } else {
            return true;
         }
      } catch (Exception e) {
         System.out.println("isCanKeepRead方法" + e.getMessage());
         throw new SQLException(e);
      }
   }

   public String getSqlPaging(String sql1, String sql2) {
      String sqlPaging111 = null;
      if (EdbType.DB2.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      } else if (!EdbType.ORACLE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         if (!EdbType.POSTGRESQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
            if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " limit " + 1 + " OFFSET " + 10;
            } else if (EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) || EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) || EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " limit " + 1 + "," + 10;
            }
         } else {
            sqlPaging111 = sql2 + " offset " + 1 + " limit " + 10;
         }
      } else {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      }

      return sqlPaging111;
   }

   private void rollbackColumns(Connection conn, List<ColumnInfoVO> allColumns, String suffix, List<String> colSizes, List<String> pkFlags, List<String> pkCols, TCoreDatasystem tCoreDatasystem) {
      if (allColumns != null && allColumns.size() != 0) {
         Set<String> colSet = JdbcTool.getColumnMap(conn, this.schema, this.tableName);

         for(int i = 0; i < allColumns.size(); ++i) {
            try {
               ColumnInfoVO column = (ColumnInfoVO)allColumns.get(i);
               JdbcTool.rollbackReplaceColumn(conn, colSet, this.schema, this.tableName, column.getColumnName(), column.getColumnName() + suffix, column.getColumnType(), colSizes == null ? null : (String)colSizes.get(i), pkFlags == null ? null : (String)pkFlags.get(i), pkCols == null ? null : (String)pkCols.get(i), column.getColumnName(), tCoreDatasystem);
            } catch (Exception ex) {
               ex.printStackTrace();
            }
         }

      }
   }
}
