package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DB2LoadTableTool {
   public static void executeLoadTable(Map<String, String> map) {
      System.out.println("--------------DB2WriteLoadTable Start---------------");

      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String pipeFilePath = File.separator + "data" + File.separator + "infa_db2" + File.separator + "target" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".pipe";
         String shFilePath = File.separator + "data" + File.separator + "infa_db2" + File.separator + "target" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".sh";
         String rmPipeFileCmd = "rm -f " + pipeFilePath;
         String mkrPipeFileCmd = "mkfifo " + pipeFilePath;
         CommandTool.command(rmPipeFileCmd);
         CommandTool.command(mkrPipeFileCmd);
         String linkName = (String)map.get("linkname");
         String dataBase = (String)map.get("database");
         if (linkName.length() > 8) {
            linkName = "a" + linkName.substring(linkName.length() - 7, linkName.length());
         }

         StringBuffer str = new StringBuffer();
         str.append("#!/bin/sh \n");
         str.append("db2 connect to " + dataBase + " user " + (String)map.get("user") + " using " + (String)map.get("pwd") + " \n");
         str.append("db2 load client from " + pipeFilePath + " of del MODIFIED BY Timestampformat=\\\"\\\"YYYY-MM-DD HH:MM:SS\\\"\\\" COLDEL\\|  replace into " + (String)map.get("dbschema") + ".\\\"" + (String)map.get("tablename") + "\\\" nonrecoverable; \n");
         str.append("db2 terminate \n");
         FileTool.clearFileContent(shFilePath);
         FileTool.writeContentToFile(shFilePath, str.toString());
         CommandTool.command("chmod 777 -R " + File.separator + "data" + File.separator + "infa_db2" + File.separator + "target" + File.separator + (String)map.get("taskname"));
         System.out.println("---------------DB2WriteLoadTable End----------------");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static List<String> getLoalhostIP() {
      List<String> ls = new ArrayList();

      try {
         Enumeration<?> enumeration = NetworkInterface.getNetworkInterfaces();
         InetAddress ip = null;

         while(enumeration.hasMoreElements()) {
            NetworkInterface netInterface = (NetworkInterface)enumeration.nextElement();
            Enumeration<?> addresses = netInterface.getInetAddresses();

            while(addresses.hasMoreElements()) {
               ip = (InetAddress)addresses.nextElement();
               ls.add(ip.getHostName());
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return ls;
   }
}
