package com.chenyang.nse.bussiness.webtools.json;

public enum ErrCode {
   UNAUTHORIZED("9401", "未经授权"),
   FORBIDDEN("9403", "无操作权限"),
   DATA_NOT_FOUND("9404", "数据未找到"),
   SERVER_EXCEPTION("9501", "服务端异常"),
   BIND_ERROR("9601", "数据绑定错误"),
   DATA_IS_EXIST("9602", "同类数据已存在"),
   DATA_NOT_EDITABLE("9603", "数据不可编辑"),
   DATA_EHECK_FAILURE("9603", "数据检查失败"),
   DATA_IS_RELATION("9604", "数据被引用"),
   DATA_PARSE_FAILURE("9605", "数据解析失败"),
   DATA_ENCODE_FAILURE("9607", "数据编码失败"),
   DATA_DECODE_FAILURE("9608", "数据解码失败"),
   BUSINESS_ERROR("9701", "业务逻辑错误"),
   REQ_PARAM_ERROR("9801", "请求的参数错误"),
   TOKEN_INVALID("9802", "令牌无效"),
   REMOTE_CALL_ERROR("9901", "远程调用失败"),
   NEVER_USED_CODE("9999", "无解了"),
   DATASOURCE_USE_CODE("9981", "该数据源已被受控资产库使用"),
   PASSWORD_ERROR_CODE("9982", "新密码与原密码相同"),
   UNSURED_ERROR_CODE("9983", "当前没有确认的字段"),
   ADD_ERROR_CODE("8881", "添加失败"),
   UPDATE_ERROR_CODE("8882", "更新失败"),
   DELETE_ERROR_CODE("8883", "删除失败"),
   LOGIN_ERROR_CODE("8884", "登录失败"),
   LOGINOUT_ERROR_CODE("8885", "退出失败");

   private String code;
   private String desc;

   private ErrCode(String code, String desc) {
      this.code = code;
      this.desc = desc;
   }

   public String getCode() {
      return this.code;
   }

   public String getDesc() {
      return this.desc;
   }
}
