package com.chenyang.nse.bussiness.webtools.tools.jdbc;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.webtools.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.webtools.entity.db.DbInfo;
import com.chenyang.nse.bussiness.webtools.entity.db.TypeInfo;
import com.chenyang.nse.bussiness.webtools.entity.vo.DatasystemVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.MviewVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.ProcedureParam;
import com.chenyang.nse.bussiness.webtools.entity.vo.ProcedureVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.SequenceVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.SynonymsVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.ViewVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.webtools.enumeration.EdbType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class JdbcTool {
   private static ColumnInfo columnInfo;
   private static List<String> noSizeList = new ArrayList();

   public static boolean hasColumnSize(String columnType) {
      return !noSizeList.contains(columnType) && !columnType.startsWith("TIMESTAMP");
   }

   public static Connection getConnection(DatasystemVO datasystem) {
      String url = "";
      if (datasystem.getDbtype().equals(EdbType.INFORMIX.toString())) {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername(), datasystem.getServername());
      } else if (!datasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !datasystem.getDbtype().equals(EdbType.MARIADB.toString()) && !datasystem.getDbtype().equals(EdbType.TERADATA.toString())) {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername());
      } else {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername(), datasystem.getServername(), datasystem.getPagecode());
         url = url + "&useSSL=false&rewriteBatchedStatements=true&serverTimezone=UTC";
      }

      String driver = EdbType.getEdbTypeByDbcode(datasystem.getDbtype()).getDbdriver();
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = com.chenyang.nse.bussiness.tools.jdbc.JdbcTool.getKerberosConn(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
         return conn;
      } else {
         Connection connection = null;

         try {
            connection = getConnection(driver, url, datasystem.getUsername(), datasystem.getPassword());
         } catch (Exception e) {
            e.printStackTrace();
         }

         return connection;
      }
   }

   public static List<String> getTableName(Connection cnn, String schema, String tableNamePattern) {
      List<String> tables = new ArrayList();
      DatabaseMetaData dbMetaData = null;
      String[] types = new String[]{"TABLE"};
      ResultSet rs = null;

      try {
         dbMetaData = cnn.getMetaData();
         if (null != tableNamePattern) {
            tableNamePattern = "%" + tableNamePattern + "%";
         }

         rs = dbMetaData.getTables(cnn.getCatalog(), schema, tableNamePattern, types);

         while(rs.next()) {
            tables.add(rs.getObject("TABLE_NAME").toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               Statement s = rs.getStatement();
               rs.close();
               if (s != null) {
                  s.close();
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return tables;
   }

   public static List<String> getAllTableNameForMySql(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("use " + database);
         ps.execute();
         ps = conn.prepareStatement("select table_name from information_schema.tables where table_schema='" + database + "' and table_type='base table';");
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForInformix(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select tabname from systables where tabtype = 'T'");
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString("tabname"));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForOracle(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select TABLE_NAME from all_tab_comments where TABLE_TYPE='TABLE' and OWNER='" + database + "'");
         rs = ps.executeQuery();

         while(rs.next()) {
            if (rs.getString("TABLE_NAME").indexOf("$") == -1) {
               list.add(rs.getString("TABLE_NAME"));
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForMySqlLike(Connection conn, String database, String tableNamePattern) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("use " + database);
         ps.execute();
         if (tableNamePattern == null || tableNamePattern.equals("null")) {
            tableNamePattern = "";
         }

         ps = conn.prepareStatement("SHOW TABLES LIKE '%" + tableNamePattern + "%'");
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForOracle(Connection conn, String database, String tableNamePattern) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = "select TABLE_NAME from all_tab_comments where TABLE_TYPE='TABLE' and OWNER='" + database + "'";
         if (tableNamePattern != null && !tableNamePattern.equals("")) {
            sql = sql + " and TABLE_NAME LIKE '%" + tableNamePattern + "%'";
         }

         sql = sql + "order by TABLE_NAME";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString("TABLE_NAME"));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> querySequences(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.ORACLE.getDbcode())) {
         return null;
      } else {
         List<String> list = new ArrayList();
         PreparedStatement ps = null;
         ResultSet rs = null;

         try {
            String sql = " select SEQUENCE_OWNER sequenceOwner,SEQUENCE_NAME sequenceName from dba_sequences where sequence_owner= ? ";
            ps = cnn.prepareStatement(sql);
            ps.setString(1, schema);
            rs = ps.executeQuery();

            while(rs.next()) {
               list.add(rs.getString(2));
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               rs.close();
            } catch (SQLException e1) {
               e1.printStackTrace();
            }

            try {
               ps.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return list;
      }
   }

   public static List<SequenceVO> querySequenceAttr(Connection cnn, String sequenceName, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<SequenceVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " select sequence_name,min_value,max_value,increment_by,last_number,cache_size,CYCLE_FLAG,ORDER_FLAG from all_sequences where upper (sequence_name)=? AND sequence_owner=? ";
         ps = cnn.prepareStatement(sql);
         ps.setString(1, sequenceName);
         ps.setString(2, schema);
         rs = ps.executeQuery();

         while(rs.next()) {
            SequenceVO seq = new SequenceVO();
            seq.setSequenceName(rs.getString(1));
            seq.setMinValue(rs.getLong(2));
            seq.setMaxValue(rs.getLong(3));
            seq.setIncrementBy(rs.getLong(4));
            seq.setLastNumber(rs.getLong(5));
            seq.setCacheSize(rs.getLong(6));
            seq.setCycleFlag(rs.getString(7));
            seq.setOrderFlag(rs.getString(8));
            list.add(seq);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<SynonymsVO> querySynonymAttr(Connection cnn, String sequenceName, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<SynonymsVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT  synonym_name synonymname, owner ,table_owner tableowner,table_name tablename, db_link dblink FROM SYS.ALL_SYNONYMS WHERE SYNONYM_NAME= ? AND OWNER= ? ";
         ps = cnn.prepareStatement(sql);
         ps.setString(1, sequenceName);
         ps.setString(2, schema);
         rs = ps.executeQuery();

         while(rs.next()) {
            SynonymsVO syn = new SynonymsVO();
            syn.setSynonymsname(rs.getString(1));
            syn.setType("table");
            syn.setOwner(rs.getString(2));
            syn.setObject(rs.getString(3) + "." + rs.getString(4));
            syn.setDblink(rs.getString(5) == null ? "" : rs.getString(5));
            list.add(syn);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<String> getDbSchemas(Connection cnn) {
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         if (cnn.toString().indexOf(EdbType.OCEANBASE.getDbcode().toLowerCase()) >= 0) {
            return getDataBaseForOB(cnn);
         } else {
            DatabaseMetaData dbMetaData = null;
            List<String> list = new ArrayList();
            ResultSet rs = null;

            try {
               dbMetaData = cnn.getMetaData();
               rs = dbMetaData.getSchemas();

               while(rs.next()) {
                  list.add(rs.getObject("TABLE_SCHEM").toString());
               }
            } catch (SQLException e) {
               e.printStackTrace();
            } finally {
               try {
                  if (rs != null) {
                     Statement s = rs.getStatement();
                     rs.close();
                     if (s != null) {
                        s.close();
                     }
                  }
               } catch (SQLException e) {
                  e.printStackTrace();
               }

            }

            List<String> nullArr = new ArrayList();
            nullArr.add(null);
            list.removeAll(nullArr);
            return list;
         }
      } else {
         return getDataBaseForMySql(cnn);
      }
   }

   public static String getDataBaseType(Connection conn) {
      EdbType dbtype = DbInfo.getEdbTypeByConnection(conn);
      return dbtype != null ? dbtype.getDbcode() : null;
   }

   public static List<String> getDataBaseForMySql(Connection cnn) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " show databases ";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<String> getDataBaseForOB(Connection cnn) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " select username from sys.dba_users ";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static Connection getKerberosConn(String url, String drivername, String loginprincipal, String xmlpath) {
      Configuration conf = new Configuration();
      Connection conn = null;
      conf.set("hadoop.security.authentication", "Kerberos");

      try {
         UserGroupInformation.setConfiguration(conf);
         loginprincipal = "hive/quickstart.cloudera@CLOUDERA";
         xmlpath = "/data";
         UserGroupInformation.loginUserFromKeytab(loginprincipal, xmlpath + "/hive.keytab");
         Class.forName(drivername);
         conn = DriverManager.getConnection(url);
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return conn;
   }

   public static Connection getConnection(String driver, String url, String username, String password) {
      Connection conn = null;

      try {
         Class.forName(driver);
         String DBname = url.substring(url.indexOf(":") + 1);
         int ss = DBname.indexOf(":");
         String typename = DBname.substring(0, ss);
         if (typename.equals("mysql")) {
            if (DBname.substring(ss + 3).contains("/")) {
               conn = DriverManager.getConnection(url, username, password);
            } else {
               conn = DriverManager.getConnection(url, username, (String)null);
            }
         } else {
            conn = DriverManager.getConnection(url, username, password);
         }

         return conn;
      } catch (SQLException e) {
         e.printStackTrace();
         return conn;
      } catch (Exception e) {
         e.printStackTrace();
         return conn;
      } finally {
         ;
      }
   }

   public static List<String> getAllTableName(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         if (dbtype.equals(EdbType.INFORMIX.getDbcode())) {
            return getAllTableNameForInformix(cnn, schema);
         } else if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllTableNameForOracle(cnn, schema);
         } else {
            List<String> tables = getTableName(cnn, schema, (String)null);
            return tables;
         }
      } else {
         return getAllTableNameForMySql(cnn, schema);
      }
   }

   public static void closeConnection(Connection conn) {
      try {
         if (conn != null) {
            conn.close();
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public static ColumnInfo getColumnInfoInstance() {
      if (columnInfo == null) {
         columnInfo = new ColumnInfo();
      }

      return columnInfo;
   }

   public static List<String> getAllViewName(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<String> Views = new ArrayList();

      try {
         if (dbtype.equals(EdbType.MYSQL.getDbcode()) || dbtype.equals(EdbType.RAPIDSDB.getDbcode()) || dbtype.equals(EdbType.POSTGRESQL.getDbcode())) {
            return getAllViewNameForMySql(cnn, schema);
         }

         if (dbtype.equals(EdbType.HIVE.getDbcode())) {
            return getAllViewNameForHive(cnn, schema);
         }

         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllViewNameForOracle(cnn, schema);
         }

         Views = getViewName(cnn, schema, null);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return Views;
   }

   private static List<String> getViewName(Connection cnn, String schema, Object o) throws SQLException {
      List<String> views = new ArrayList();
      String[] types = new String[]{"VIEW"};
      DatabaseMetaData dbMetaData = cnn.getMetaData();
      ResultSet rs = dbMetaData.getTables(cnn.getCatalog(), schema, (String)null, types);

      while(rs.next()) {
         views.add(rs.getObject("TABLE_NAME").toString());
      }

      return views;
   }

   public static List<String> getAllSynonymName(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);

      try {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllSynonymNameForOracle(cnn, schema);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return new ArrayList();
   }

   private static List<String> getAllSynonymNameForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> synonyms = new ArrayList();
      String sql = "SELECT SYNONYM_NAME , TABLE_NAME FROM DBA_SYNONYMS WHERE TABLE_OWNER = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String SYNONYM_NAME = resultSet.getString("SYNONYM_NAME");
         synonyms.add(SYNONYM_NAME);
      }

      return synonyms;
   }

   private static List<String> getAllViewNameForMySql(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> views = new ArrayList();
      String sql = "select TABLE_NAME,VIEW_DEFINITION from information_schema.VIEWS where TABLE_SCHEMA = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String table_name = resultSet.getString("TABLE_NAME");
         views.add(table_name);
      }

      return views;
   }

   private static List<String> getAllViewNameForHive(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> tables = new ArrayList();
      String sql = "show tables";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String tableName = resultSet.getString("TAB_NAME");
         String result = "";
         sql = "desc formatted " + tableName;
         ResultSet rs = statement.executeQuery(sql);

         while(rs.next()) {
            String col_name = rs.getString("COL_NAME").trim();
            if (col_name.equalsIgnoreCase("Table Type:")) {
               result = rs.getString("DATA_TYPE").trim();
               break;
            }
         }

         if ("VIRTUAL_VIEW".equalsIgnoreCase(result)) {
            tables.add(tableName);
         }
      }

      return tables;
   }

   private static List<String> getAllViewNameForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> views = new ArrayList();
      String sql = "select VIEW_NAME ,TEXT from DBA_VIEWS where OWNER = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String table_name = resultSet.getString("VIEW_NAME");
         views.add(table_name);
      }

      return views;
   }

   public static List<ColumnInfo> getAllColumnInfo(Connection cnn, String schema, String tablename) {
      getColumnInfoInstance();
      List<ColumnInfo> list = ColumnInfo.getColumnInfoByConnection(cnn, schema, tablename, (String)null);
      return list;
   }

   public static ResultVO testConnect(String url, String driver, String username, String password) {
      boolean result = false;
      ResultVO resultvo = new ResultVO();
      Connection conn = null;

      ResultVO ss;
      try {
         Class.forName(driver);
         String DBname = url.substring(url.indexOf(":") + 1);
         int ss1 = DBname.indexOf(":");
         String typename = DBname.substring(0, ss1);
         if (typename.equals("mysql")) {
            if (DBname.substring(ss1 + 11).contains("/")) {
               conn = DriverManager.getConnection(url, username, password);
            } else {
               conn = DriverManager.getConnection(url, username, (String)null);
            }
         } else {
            conn = DriverManager.getConnection(url, username, password);
         }

         if (conn != null) {
            result = true;
         }

         return resultvo;
      } catch (Exception e) {
         e.printStackTrace();
         resultvo.setMessage(getExceptionSrintStackTrace(e));
         ss = resultvo;
      } finally {
         resultvo.setResult(result);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (Exception e) {
            e.printStackTrace();
            resultvo.setMessage(getExceptionSrintStackTrace(e));
            resultvo.setResult(false);
         }

      }

      return ss;
   }

   private static void checkDbVersion(String url, ResultVO resultvo, String productVersion) {
      if (StringUtils.isNotBlank(productVersion)) {
         if (productVersion.startsWith("Oracle Database")) {
            resultvo.setVersion(productVersion.substring(16, 19));
            System.out.println(productVersion.substring(16, 19));
         } else {
            resultvo.setVersion(productVersion.substring(0, 3));
            System.out.println(productVersion.substring(0, 3));
         }
      }

      if (url.indexOf("jdbc:oracle") >= 0) {
         resultvo.setVersion(productVersion.substring(16, 19));
      } else if (url.indexOf("jdbc:mysql") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 3));
      } else if (url.indexOf("jdbc:sqlserver") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 2));
      } else if (url.indexOf("jdbc:db2") >= 0) {
         resultvo.setVersion(productVersion.substring(5, 9));
      } else if (url.indexOf("jdbc:hive2") >= 0) {
         resultvo.setVersion(productVersion.split("-")[0]);
      } else if (url.indexOf("jdbc:postgresql") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 2));
      } else if (url.indexOf("jdbc:dm") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 3));
      }

   }

   public static String getExceptionSrintStackTrace(Exception e) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      return sw.toString();
   }

   public static Throwable getExceptionType(Exception e) {
      return e;
   }

   public static String getExceptionMessage(Exception e) {
      return e.getMessage();
   }

   public static List<TypeInfo> getTypeInfoListByConnection(Connection conn) {
      List<TypeInfo> list = null;
      if (conn == null) {
         return null;
      } else {
         DatabaseMetaData dbmd = null;
         ResultSet rs = null;

         try {
            dbmd = conn.getMetaData();

            TypeInfo typeinfo;
            for(rs = dbmd.getTypeInfo(); rs.next(); list.add(typeinfo)) {
               String typename = rs.getString("TYPE_NAME");
               Integer datatype = rs.getInt("DATA_TYPE");
               Integer precision = rs.getInt("PRECISION");
               String literalprefix = rs.getString("LITERAL_PREFIX");
               String literalsuffix = rs.getString("LITERAL_SUFFIX");
               String createparams = rs.getString("CREATE_PARAMS");
               Short nullable = rs.getShort("NULLABLE");
               Boolean casesensitive = rs.getBoolean("CASE_SENSITIVE");
               Short searchable = rs.getShort("SEARCHABLE");
               Boolean unsignedattribute = rs.getBoolean("UNSIGNED_ATTRIBUTE");
               Boolean fixedprecscale = rs.getBoolean("FIXED_PREC_SCALE");
               Boolean autoincrement = rs.getBoolean("AUTO_INCREMENT");
               String localtypename = rs.getString("LOCAL_TYPE_NAME");
               Short minimumscale = rs.getShort("MINIMUM_SCALE");
               Short maximunscale = rs.getShort("MAXIMUM_SCALE");
               Integer sqldatatype = rs.getInt("SQL_DATA_TYPE");
               Integer sqldatatimesub = rs.getInt("SQL_DATETIME_SUB");
               Integer numprecradix = rs.getInt("NUM_PREC_RADIX");
               typeinfo = new TypeInfo(typename, datatype, precision, literalprefix, literalsuffix, createparams, nullable, casesensitive, searchable, unsignedattribute, fixedprecscale, autoincrement, localtypename, minimumscale, maximunscale, sqldatatype, sqldatatimesub, numprecradix);
               if (list == null) {
                  list = new ArrayList();
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               if (rs != null) {
                  rs.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return list;
      }
   }

   public static List<String> getFK(Connection conn, String dbname, String schema, String tableName) {
      List<String> list = new ArrayList();
      ResultSet rs = null;

      try {
         DatabaseMetaData databaseMetaData = conn.getMetaData();
         rs = databaseMetaData.getImportedKeys(dbname, schema, tableName);

         while(rs.next()) {
            list.add(rs.getString("FKCOLUMN_NAME"));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static List<String> getPK(Connection conn, String dbname, String schema, String tableName) {
      List<String> list = new ArrayList();
      ResultSet rs = null;

      try {
         DatabaseMetaData databaseMetaData = conn.getMetaData();
         rs = databaseMetaData.getPrimaryKeys(dbname, schema, tableName);

         while(rs.next()) {
            list.add(rs.getString("COLUMN_NAME"));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static ResultSet getOceanBaseColumns(Connection conn, String tableName) {
      ResultSet rs = null;
      PreparedStatement ps = null;

      try {
         try {
            String sql = "select * from user_tab_columns WHERE TABLE_NAME = '" + tableName + "'";
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return rs;
      } finally {
         ;
      }
   }

   public static List<String> getOceanBasePK(Connection conn, String dbname, String schema, String tableName) {
      List<String> list = new ArrayList();
      ResultSet rs = null;
      PreparedStatement ps = null;

      try {
         String sql = "select   *   from   user_cons_columns  where owner ='" + schema + "' and table_name='" + tableName + "'";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString("COLUMN_NAME"));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
               ps.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static List<ColumnInfoVO> getColumnInfoVO(Connection conn, String schemaPattern, String tableNamePattern) {
      List<ColumnInfoVO> columnList = new ArrayList();
      if (conn == null) {
         return columnList;
      } else {
         String dbtype = com.chenyang.nse.bussiness.tools.jdbc.JdbcTool.getDataBaseType(conn);
         DatabaseMetaData dbmd = null;
         ResultSet rs = null;

         try {
            Properties props = new Properties();

            try {
               props = PropertiesLoaderUtils.loadAllProperties("config.properties");
            } catch (IOException e) {
               e.printStackTrace();
            }

            Object varchar_size_extendedObj = props.getProperty("varchar_size_extended");
            float varchar_size_extended = 1.0F;
            if (null != varchar_size_extendedObj) {
               varchar_size_extended = new Float(props.getProperty("varchar_size_extended"));
            }

            new ArrayList();
            List<String> fkList = new ArrayList();
            dbmd = conn.getMetaData();
            List pkList;
            if (EdbType.MYSQL.getDbname().equals(dbtype)) {
               pkList = getPK(conn, schemaPattern, (String)null, tableNamePattern);
               fkList = getFK(conn, schemaPattern, (String)null, tableNamePattern);
               rs = dbmd.getColumns(schemaPattern, (String)null, tableNamePattern, (String)null);
            } else if (conn.toString().toLowerCase().indexOf("oceanbase") != -1) {
               pkList = getOceanBasePK(conn, (String)null, schemaPattern, tableNamePattern);
               rs = getOceanBaseColumns(conn, tableNamePattern);
            } else {
               pkList = getPK(conn, (String)null, schemaPattern, tableNamePattern);
               if (!dbtype.equals("RAPIDSDB")) {
                  fkList = getFK(conn, (String)null, schemaPattern, tableNamePattern);
               }

               rs = dbmd.getColumns((String)null, schemaPattern, tableNamePattern, (String)null);
            }

            ColumnInfoVO cv;
            if (conn.toString().toLowerCase().indexOf("oceanbase") == -1) {
               while(rs.next()) {
                  cv = new ColumnInfoVO();
                  cv.setTablecat(rs.getString("TABLE_CAT"));
                  cv.setTableschem(rs.getString("TABLE_SCHEM"));
                  cv.setTablename(rs.getString("TABLE_NAME"));
                  cv.setColumnname(rs.getString("COLUMN_NAME"));
                  cv.setDatatype(rs.getString("DATA_TYPE"));
                  if (EdbType.DB2.getDbname().equals(dbtype) && "VARCHAR () FOR BIT DATA".equals(rs.getString("TYPE_NAME"))) {
                     cv.setTypename("VARBINARY");
                  } else if (EdbType.INFORMIX.getDbname().equals(dbtype) && "interval".equals(rs.getString("TYPE_NAME")) && "1538".equals(rs.getString("COLUMN_SIZE"))) {
                     cv.setTypename("interval year to month");
                  } else if (EdbType.INFORMIX.getDbname().equals(dbtype) && "interval".equals(rs.getString("TYPE_NAME")) && "2122".equals(rs.getString("COLUMN_SIZE"))) {
                     cv.setTypename("interval day to SECOND");
                  } else if (EdbType.INFORMIX.getDbname().equals(dbtype) && "datetime".equals(rs.getString("TYPE_NAME"))) {
                     cv.setTypename("datetime year to fraction");
                  } else {
                     cv.setTypename(rs.getString("TYPE_NAME"));
                  }

                  String columnsize = rs.getString("COLUMN_SIZE");
                  if (columnsize == null) {
                     columnsize = columnsize == null ? "" : columnsize;
                  }

                  if ((EdbType.MYSQL.getDbname().equals(dbtype) || EdbType.RAPIDSDB.getDbname().equals(dbtype)) && "year".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                     columnsize = "4";
                  }

                  if ((EdbType.MYSQL.getDbname().equals(dbtype) || EdbType.RAPIDSDB.getDbname().equals(dbtype) || EdbType.GREENPLUM.getDbname().equals(dbtype) || EdbType.MSSQLSERVER.getDbname().equals(dbtype)) && ("VARCHAR".equalsIgnoreCase(rs.getString("TYPE_NAME")) || "CHAR".equalsIgnoreCase(rs.getString("TYPE_NAME"))) && StringUtils.isNotBlank(columnsize) && 1.0F != varchar_size_extended) {
                     int columnsizeInt = Integer.valueOf(columnsize);
                     columnsizeInt = (int)((float)columnsizeInt * varchar_size_extended);
                     columnsize = String.valueOf(columnsizeInt);
                  }

                  if (EdbType.HIVE.getDbname().equals(dbtype) && "boolean".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                     columnsize = "1";
                  }

                  if (EdbType.ORACLE.getDbname().equals(dbtype) && "INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                     columnsize = "6";
                  }

                  if (EdbType.ORACLE.getDbname().equals(dbtype) && "DATE".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                     columnsize = "19";
                  }

                  if (EdbType.ORACLE.getDbname().equals(dbtype) && "ROWID".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                     columnsize = "255";
                  }

                  cv.setColumnsize(columnsize);
                  cv.setBufferlength(rs.getString("BUFFER_LENGTH"));
                  String decimaldigits = rs.getString("DECIMAL_DIGITS");
                  if (decimaldigits == null) {
                     decimaldigits = decimaldigits == null ? "" : decimaldigits;
                  }

                  cv.setDecimaldigits(decimaldigits);
                  cv.setNumprecpadix(rs.getString("NUM_PREC_RADIX"));
                  cv.setNullable(rs.getString("NULLABLE"));
                  String remarks = rs.getString("REMARKS");
                  if (remarks == null || remarks.equals("")) {
                     remarks = "";
                  }

                  cv.setRemarks(remarks);
                  cv.setColumndef(rs.getString("COLUMN_DEF"));
                  cv.setSqldatatype(rs.getString("SQL_DATA_TYPE"));
                  cv.setSqldatetimesub(rs.getString("SQL_DATETIME_SUB"));
                  cv.setCharoctetlength(rs.getString("CHAR_OCTET_LENGTH"));
                  cv.setOrdinalposition(rs.getString("ORDINAL_POSITION"));
                  cv.setIsnullable(rs.getString("IS_NULLABLE"));
                  cv.setPrimarykey("0");
                  cv.setForeignkey("0");
                  cv.setMaskingruleid("");
                  cv.setMaskingrulename("");
                  cv.setRegextype("");
                  if (pkList.contains(cv.getColumnname())) {
                     cv.setPrimarykey("1");
                  }

                  if (fkList.contains(cv.getColumnname())) {
                     cv.setForeignkey("1");
                  }

                  if (columnsize.equals("2147483647") && !EdbType.MYSQL.getDbname().equals(dbtype)) {
                     cv.setColumnsize("255");
                  }

                  if (cv.getDecimaldigits().equals("-127") && cv.getColumnsize().equals("0")) {
                     cv.setColumnsize("");
                     cv.setDecimaldigits("");
                  }

                  if (EdbType.INFORMIX.getDbname().equals(dbtype) && "decimal".equalsIgnoreCase(cv.getTypename()) && "255".equals(cv.getDecimaldigits())) {
                     cv.setDecimaldigits("0");
                  }

                  if (EdbType.GREENPLUM.getDbname().equals(dbtype)) {
                     if ("timetz".equalsIgnoreCase(cv.getTypename())) {
                        cv.setDecimaldigits("0");
                     }

                     if ("numeric".equalsIgnoreCase(cv.getTypename())) {
                        cv.setColumnsize("1023");
                     }
                  } else if (EdbType.DB2.getDbname().equals(dbtype)) {
                     if ("vargraphic".equalsIgnoreCase(cv.getTypename())) {
                        cv.setColumnsize(Integer.parseInt(cv.getColumnsize()) / 2 + "");
                     }

                     if ("graphic".equalsIgnoreCase(cv.getTypename())) {
                        cv.setColumnsize(Integer.parseInt(cv.getColumnsize()) / 2 + "");
                     }

                     if ("xml".equalsIgnoreCase(cv.getTypename())) {
                        cv.setColumnsize("8000");
                     }
                  } else if (EdbType.ORACLE.getDbname().equals(dbtype)) {
                     if (cv.getTypename().contains("INTERVAL DAY") || cv.getTypename().contains("interval day")) {
                        cv.setColumnsize("30");
                        cv.setDecimaldigits("0");
                     }

                     if (cv.getTypename().equalsIgnoreCase("LONG")) {
                        cv.setColumnsize("4000");
                     }

                     if (cv.getTypename().equalsIgnoreCase("JTF_PF_PARAMS_TABLE") || cv.getTypename().equalsIgnoreCase("JTF_PF_COOKIES_TABLE") || cv.getTypename().equalsIgnoreCase("OZF_OFFER_HEADER") || cv.getTypename().equalsIgnoreCase("WF_EVENT_T") || cv.getTypename().equalsIgnoreCase("SDO_ORDINATE_ARRAY") || cv.getTypename().equalsIgnoreCase("WF_PARAMETER_LIST_T") || cv.getTypename().equalsIgnoreCase("JTF_PF_PAGE_OBJECT") || cv.getTypename().equalsIgnoreCase("SDO_ELEM_INFO_ARRAY") || cv.getTypename().equalsIgnoreCase("JTF_PF_PRODPARAMS_TABLE") || cv.getTypename().equalsIgnoreCase("IH_BULK_TYPE") || cv.getTypename().equalsIgnoreCase("OZF_ACCOUNT_HEADER") || cv.getTypename().equalsIgnoreCase("AQ$_SIG_PROP") || cv.getTypename().equalsIgnoreCase("OZF_QUOTA_HEADER") || cv.getTypename().equalsIgnoreCase("XNP_MESSAGE_TYPE")) {
                        cv.setTypename("VARCHAR2");
                        cv.setDatatype("12");
                     }
                  }

                  cv.setCharoctetlength(cv.getColumnsize());
                  columnList.add(cv);
               }
            } else {
               for(; rs.next(); columnList.add(cv)) {
                  cv = new ColumnInfoVO();
                  cv.setColumnname(rs.getString("COLUMN_NAME"));
                  cv.setTablename(rs.getString("TABLE_NAME"));
                  cv.setTypename(rs.getString("DATA_TYPE"));
                  cv.setRemarks("");
                  if ("NUMBER".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     if (null == rs.getString("DATA_PRECISION")) {
                        cv.setColumnsize("");
                     } else {
                        cv.setColumnsize(rs.getString("DATA_PRECISION"));
                     }
                  } else if ("FLOAT".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     cv.setColumnsize(rs.getString("DATA_PRECISION"));
                  } else if ("0".equals(rs.getString("DATA_LENGTH")) && null == rs.getString("DATA_PRECISION") && null != rs.getString("DATA_SCALE")) {
                     cv.setColumnsize(rs.getString("DATA_SCALE"));
                  } else {
                     cv.setColumnsize(rs.getString("DATA_LENGTH"));
                  }

                  if (null == rs.getString("DATA_PRECISION")) {
                     cv.setDecimaldigits("");
                  } else if ("NUMBER".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     cv.setDecimaldigits(rs.getString("DATA_LENGTH"));
                  } else if ("FLOAT".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     cv.setDecimaldigits("");
                  } else {
                     cv.setDecimaldigits(rs.getString("DATA_PRECISION"));
                  }

                  if (pkList.contains(cv.getColumnname())) {
                     cv.setPrimarykey("1");
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (rs != null) {
               try {
                  rs.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }

         return columnList;
      }
   }

   public static String executeQuerySql(Connection conn) {
      String version = "";
      String sql = "SELECT service_level, fixpack_num FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO";
      PreparedStatement pstmt = null;
      ResultSet r = null;

      try {
         pstmt = conn.prepareStatement(sql);

         for(r = pstmt.executeQuery(); r.next(); version = r.getString("SERVICE_LEVEL")) {
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (r != null) {
               r.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }

            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return version;
   }

   public static List<ViewVO> queryViewDeclare(Connection cnn, String viewName, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<ViewVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " select owner,view_name viewname ,DBMS_METADATA.get_ddl('VIEW',view_name,owner) AS text from all_views where view_name = ? AND OWNER= ? ";
         ps = cnn.prepareStatement(sql);
         ps.setString(1, viewName);
         ps.setString(2, schema);
         rs = ps.executeQuery();

         while(rs.next()) {
            ViewVO syn = new ViewVO();
            syn.setOwner(rs.getString(1));
            syn.setViewname(rs.getString(2));
            syn.setText(rs.getString(3));
            list.add(syn);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<MviewVO> queryMViewDeclare(Connection cnn, String viewname, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<MviewVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT DBMS_METADATA.GET_DDL('MATERIALIZED_VIEW', '" + viewname + "','" + schema + "') text FROM DUAL ";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            MviewVO syn = new MviewVO();
            syn.setOwner(schema);
            syn.setViewname(viewname);
            syn.setText(rs.getString(1));
            list.add(syn);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<MviewVO> queryMViewAttr(Connection cnn, String viewName, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<MviewVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT mview_name, container_name container, refresh_method refreshMethod, last_refresh_date refreshDate        FROM dba_mview_analysis         WHERE owner='" + schema + "' and mview_name='" + viewName + "'";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            MviewVO syn = new MviewVO();
            syn.setOwner(schema);
            syn.setViewname(viewName);
            syn.setContainer(rs.getString(2));
            syn.setRefreshMethod(rs.getString(3));
            syn.setRefreshDate(rs.getString(4));
            list.add(syn);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static String queryTableComments(Connection conn, String viewName, String schema) {
      String result = "";
      String dbtype = getDataBaseType(conn);
      new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "";
      if (!dbtype.equals("ORACLE")) {
         return "";
      } else {
         try {
            sql = " select comments          FROM ALL_tab_comments         WHERE owner='" + schema + "' and Table_Name='" + viewName + "'";
            ps = conn.prepareStatement(sql);

            for(rs = ps.executeQuery(); rs.next(); result = rs.getString(1)) {
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               rs.close();
            } catch (SQLException e1) {
               e1.printStackTrace();
            }

            try {
               ps.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return result;
      }
   }

   public static String queryTableSpace(Connection conn, String viewName, String schema) {
      String result = "";
      String dbtype = getDataBaseType(conn);
      new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      if (!dbtype.equals("ORACLE")) {
         return "";
      } else {
         try {
            String sql = " select tablespace_name          FROM all_tables         WHERE owner='" + schema + "' and Table_Name='" + viewName + "'";
            ps = conn.prepareStatement(sql);

            for(rs = ps.executeQuery(); rs.next(); result = rs.getString(1)) {
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               rs.close();
            } catch (SQLException e1) {
               e1.printStackTrace();
            }

            try {
               ps.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return result;
      }
   }

   public static String queryViewComments(Connection conn, String viewName, String schema) {
      String result = "";
      String dbtype = getDataBaseType(conn);
      new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      if (!dbtype.equals("ORACLE")) {
         return "";
      } else {
         try {
            String sql = " select comments          FROM ALL_tab_comments         WHERE table_type = 'VIEW' and owner='" + schema + "' and Table_Name like '%" + viewName + "%'";
            ps = conn.prepareStatement(sql);

            for(rs = ps.executeQuery(); rs.next(); result = rs.getString(1)) {
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               rs.close();
            } catch (SQLException e1) {
               e1.printStackTrace();
            }

            try {
               ps.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return result;
      }
   }

   public static List<String> queryProcedures(Connection conn, String schema) {
      String dbtype = getDataBaseType(conn);

      try {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllProcedureForOracle(conn, schema);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return new ArrayList();
   }

   private static List<String> getAllProcedureForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> procedures = new ArrayList();
      String sql = "SELECT OBJECT_NAME FROM DBA_PROCEDURES WHERE OWNER = '" + schema + "' AND OBJECT_TYPE='PROCEDURE'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String OBJECT_NAME = resultSet.getString("OBJECT_NAME");
         procedures.add(OBJECT_NAME);
      }

      return procedures;
   }

   public static List<String> queryFunctions(Connection conn, String schema) {
      String dbtype = getDataBaseType(conn);

      try {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllFunctionForOracle(conn, schema);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return new ArrayList();
   }

   private static List<String> getAllFunctionForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> procedures = new ArrayList();
      String sql = "SELECT OBJECT_NAME FROM DBA_PROCEDURES WHERE OWNER = '" + schema + "' AND OBJECT_TYPE='FUNCTION'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String OBJECT_NAME = resultSet.getString("OBJECT_NAME");
         procedures.add(OBJECT_NAME);
      }

      return procedures;
   }

   public static List<String> queryMviewList(Connection conn, String schema) {
      String dbtype = getDataBaseType(conn);

      try {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllMviewForOracle(conn, schema);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return new ArrayList();
   }

   private static List<String> getAllMviewForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> mviews = new ArrayList();
      String sql = "SELECT MVIEW_NAME FROM dba_mview_analysis WHERE OWNER = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String OBJECT_NAME = resultSet.getString("MVIEW_NAME");
         mviews.add(OBJECT_NAME);
      }

      return mviews;
   }

   public static ProcedureVO queryProcedureParam(Connection conn, String proceName, String schema) {
      List<ProcedureParam> params = new ArrayList();
      String dbtype = getDataBaseType(conn);
      ProcedureVO procedureVO = new ProcedureVO();
      procedureVO.setOwner(schema);
      procedureVO.setProceName(proceName);
      procedureVO.setValid(true);
      procedureVO.setType("PROCEDURE");
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT ua.OBJECT_NAME,ua.argument_name,ua.\"POSITION\",ua.DATA_TYPE ,ua.IN_OUT ,ua.DATA_LENGTH ,ua.DATA_PRECISION ,ua.DATA_SCALE,up.object_type        FROM dba_arguments ua,dba_procedures up         WHERE ua.object_id = up.object_id AND ua.OBJECT_NAME ='" + proceName + "' and up.object_type='PROCEDURE' AND up.OWNER ='" + schema + "'";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            ProcedureParam param = new ProcedureParam();
            param.setParamName(rs.getString(2));
            param.setPosition(rs.getInt(3));
            param.setType(rs.getString(4));
            param.setInout(rs.getString(5));
            param.setColumnsize(rs.getInt(6));
            param.setStandsize(rs.getInt(7));
            param.setDecimaldigits(rs.getInt(8));
            params.add(param);
         }

         procedureVO.setParam(params);
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return procedureVO;
   }

   public static List<ProcedureVO> queryProcedureDeclare(Connection conn, String procedureName, String schema) {
      String dbtype = getDataBaseType(conn);
      List<ProcedureVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT DBMS_METADATA.GET_DDL('PROCEDURE','" + procedureName + "','" + schema + "') FROM DUAL ";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            ProcedureVO syn = new ProcedureVO();
            syn.setOwner(schema);
            syn.setText(rs.getString(1));
            list.add(syn);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static ProcedureVO queryFunctionParam(Connection conn, String proceName, String schema) {
      List<ProcedureParam> params = new ArrayList();
      String dbtype = getDataBaseType(conn);
      ProcedureVO procedureVO = new ProcedureVO();
      procedureVO.setOwner(schema);
      procedureVO.setProceName(proceName);
      procedureVO.setValid(true);
      procedureVO.setType("FUNCTION");
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT ua.OBJECT_NAME,ua.argument_name,ua.\"POSITION\",ua.DATA_TYPE ,ua.IN_OUT ,ua.DATA_LENGTH ,ua.DATA_PRECISION ,ua.DATA_SCALE,up.object_type        FROM dba_arguments ua,dba_procedures up         WHERE ua.object_id = up.object_id AND ua.OBJECT_NAME ='" + proceName + "' and up.object_type='FUNCTION' AND up.OWNER ='" + schema + "'";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            ProcedureParam param = new ProcedureParam();
            param.setParamName(rs.getString(2));
            param.setPosition(rs.getInt(3));
            param.setType(rs.getString(4));
            param.setInout(rs.getString(5));
            param.setColumnsize(rs.getInt(6));
            param.setStandsize(rs.getInt(7));
            param.setDecimaldigits(rs.getInt(8));
            params.add(param);
         }

         procedureVO.setParam(params);
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return procedureVO;
   }

   public static List<ProcedureVO> queryFunctionDeclare(Connection conn, String procedureName, String schema) {
      String dbtype = getDataBaseType(conn);
      List<ProcedureVO> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " SELECT DBMS_METADATA.GET_DDL('FUNCTION','" + procedureName + "','" + schema + "') FROM DUAL ";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            ProcedureVO syn = new ProcedureVO();
            syn.setOwner(schema);
            syn.setText(rs.getString(1));
            list.add(syn);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public void putimg() {
      Statement stmt = null;
      PreparedStatement pstmt = null;
      Connection conn = null;
      String sql = "";

      try {
         File file = new File("D:\\storestylepics\\wallpaper4_small.png");
         InputStream photoStream = new FileInputStream(file);
         Class.forName("org.gjt.mm.mysql.Driver").newInstance();
         String url = "jdbc:mysql://192.168.2.131:3306/mysql?zeroDateTimeBehavior=convertToNull&useUnicode=true&characterEncoding=null&useSSL=false&rewriteBatchedStatements=true&serverTimezone=UTC";
         conn = DriverManager.getConnection(url);
         stmt = conn.createStatement();
         sql = "INSERT INTO am_blob_container(bigobject) VALUES (?)";
         pstmt = conn.prepareStatement(sql);
         pstmt.setBinaryStream(1, photoStream, (int)file.length());
         pstmt.executeUpdate();
         System.out.println("putimg()========end");
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            if (stmt != null) {
               stmt.close();
               Statement var26 = null;
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         try {
            if (pstmt != null) {
               pstmt.close();
               PreparedStatement var27 = null;
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         try {
            if (conn != null) {
               conn.close();
               Connection var28 = null;
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

   }

   static {
      noSizeList.add("BLOB");
      noSizeList.add("CLOB");
      noSizeList.add("DATE");
      noSizeList.add("DATETIME");
      noSizeList.add("LONGBLOB");
      noSizeList.add("LONGTEXT");
      noSizeList.add("IMAGE");
      noSizeList.add("TEXT");
      noSizeList.add("INTEGER");
      noSizeList.add("TIME");
   }
}
