package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuDao;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseButton;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.vo.MenuRtVO;
import com.chenyang.nse.bussiness.entity.vo.MenuVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridVO;
import com.chenyang.nse.bussiness.service.console.ButtonService;
import com.chenyang.nse.bussiness.service.console.MenuService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.RoleService;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/menu"})
public class MenuController {
   @Autowired
   private MenuService menuService;
   @Autowired
   private ButtonService buttonService;
   @Autowired
   private RoleService roleService;
   @Autowired
   private TBaseMenuDao tBaseMenuDao;
   @Autowired
   private OperationService operationService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TBaseMenu> menulist = this.menuService.queryMenuByParentId((String)null, "0");
      model.addAttribute("menulist", menulist);
      return "core/menu";
   }

   @ResponseBody
   @RequestMapping({"/querymenu"})
   public List<TBaseMenu> querymenu(String flag, String parentid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TBaseMenu> menulist = this.menuService.queryMenuByParentId(parentid, flag);
      return menulist;
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public List<TreeGridVO> query(String id, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TBaseMenu> list = this.menuService.queryMenuByParentId1(id, flag);
      List<TBaseButton> buttonlist = this.buttonService.queryButtonByParentId(id);
      List<String> menuidlist = this.buttonService.queryDistinctMenuId();

      for(TBaseButton tBaseButton : buttonlist) {
         TBaseMenu tBaseMenu = new TBaseMenu();
         tBaseMenu.setId(tBaseButton.getId());
         tBaseMenu.setMenuname(tBaseButton.getButtonname());
         tBaseMenu.setCreatetime(tBaseButton.getCreatetime());
         tBaseMenu.setParentid(tBaseButton.getMenuid());
         tBaseMenu.setUrl(tBaseButton.getOperatename());
         tBaseMenu.setFlag("button");
         tBaseMenu.setNote(tBaseButton.getNote());
         list.add(tBaseMenu);
      }

      List<TreeGridVO> tg = new ArrayList();

      try {
         tg = ObjectTool.listConvert(list, TreeGridVO.class);
         boolean spreadout = false;
         if (menuidlist != null) {
            for(TreeGridVO treeGridVO : tg) {
               for(int j = 0; j < menuidlist.size(); ++j) {
                  if (treeGridVO.getId().equals(menuidlist.get(j))) {
                     treeGridVO.setState("closed");
                  }
               }
            }
         }

         if (null == id) {
            for(TreeGridVO treeGridVO : tg) {
               treeGridVO.setState("closed");
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tg;
   }

   @RequestMapping({"/remove"})
   public void remove(@RequestParam("idlist[]") List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.menuService.remove(idlist);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("菜单管理");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setLogmessage("删除菜单");
      this.operationService.add(record);
   }

   @RequestMapping({"/removerow"})
   public void removerow(@RequestParam("id") String id, @RequestParam("menuname") String menuname, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.menuService.removerow(id);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("菜单管理");
      record.setLogmessage("删除菜单");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setOperationObject(menuname);
      this.operationService.add(record);
   }

   @RequestMapping({"/add"})
   @ResponseBody
   public int add(@RequestBody MenuVO menuVO, HttpServletRequest request, HttpServletResponse response, Model model) {
      int add = 0;
      List<TBaseMenu> subMenu = null;
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();

      try {
         subMenu = ObjectTool.listConvert(menuVO.getMenus(), TBaseMenu.class);
         if (null == menuVO.getId()) {
            TBaseMenu menu = new TBaseMenu();
            ObjectTool.fieldCoty(menuVO, menu);
            add = this.menuService.add(menu, subMenu, username);
            return add;
         }

         add = this.menuService.add(menuVO.getId(), menuVO.getNote(), subMenu);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return add;
   }

   @GetMapping({"/queryAll"})
   @ResponseBody
   public Response<List<MenuRtVO>> getAllMenu(HttpServletRequest request, HttpServletResponse response, Model model) {
      return RespHelper.<List<MenuRtVO>>successResp(this.menuService.queryMenuAll());
   }

   @ResponseBody
   @RequestMapping({"/testmenunameexist"})
   public Map<String, Object> testmenunameexist(String menuname, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, Object> map = new HashMap();
      map.put("result", this.menuService.isMenunameExist(menuname));
      return map;
   }

   @ResponseBody
   @RequestMapping({"/querymenubyid"})
   public TBaseMenu querymenubyid(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      TBaseMenu tBaseMenu = this.menuService.queryMenueByid(id);
      tBaseMenu.getMenuname();
      tBaseMenu.getParentid();
      return tBaseMenu;
   }

   @ResponseBody
   @RequestMapping({"/modifymenu"})
   public void modifymenu(TBaseMenu menu, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      this.menuService.modifyMenu(menu, username);
   }

   @ResponseBody
   @RequestMapping({"/sortmenu"})
   public void sortmenu(@RequestBody List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.menuService.sortMenu(idlist);
   }
}
