package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationAlgorithm;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationAlgorithmType;
import com.chenyang.nse.bussiness.service.core.DesensitizationAlgorithmService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/desensitizationAlgorithm"})
public class DesensitizationAlgorithmController {
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   @Autowired
   private DesensitizationAlgorithmService desensitizationAlgorithmService;

   @GetMapping({"/querytype"})
   @ResponseBody
   public Response getType() {
      List<DesensitizationAlgorithmType> desensitizationAlgorithmTypes = this.desensitizationAlgorithmService.queryTypeAll();
      return RespHelper.successResp(desensitizationAlgorithmTypes);
   }

   @GetMapping({"/queryinfo"})
   @ResponseBody
   public Response getAlgorithmTypeInfo(@RequestParam("typeid") String typeid) {
      List<DesensitizationAlgorithm> desensitizationAlgorithms = this.desensitizationAlgorithmService.queryInfoById(typeid);
      return RespHelper.successResp(desensitizationAlgorithms);
   }

   @GetMapping({"/queryFunctionList"})
   @ResponseBody
   public Response queryFunction() {
      List<DesensitizationAlgorithm> desensitizationAlgorithms = this.desensitizationAlgorithmService.queryAll();
      return RespHelper.successResp(desensitizationAlgorithms);
   }

   @GetMapping({"/queryFunctionInfo"})
   @ResponseBody
   public Response queryFunctionInfo(String name) {
      DesensitizationAlgorithm desensitizationAlgorithm = this.desensitizationAlgorithmService.queryInfoByName(name);
      return RespHelper.successResp(desensitizationAlgorithm);
   }
}
