package com.chenyang.nse.bussiness.dao;

import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleHelpDocument;
import com.chenyang.nse.bussiness.entity.vo.HelpDocumentVO;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TConsoleHelpDocumentDao extends BaseDao<Object, String> {
   public void editHelpDocument(String id, String content, String menu_name) {
      String sql = "UPDATE t_console_help_document set menu_name = :menu_name,content = :content WHERE id = :id ";
      this.getSession().createNativeQuery(sql).setParameter("menu_name", menu_name).setParameter("content", content).setParameter("id", id).executeUpdate();
   }

   public void delHelpById(String id) {
      String sql = "delete from t_console_help_document  WHERE id = :id ";
      this.getSession().createNativeQuery(sql).setParameter("id", id).executeUpdate();
   }

   public void delHelpByFa_id(String id) {
      String sql = "delete from t_console_help_document  WHERE fa_id = :id ";
      this.getSession().createNativeQuery(sql).setParameter("id", id).executeUpdate();
   }

   public TConsoleHelpDocument queryHelpDocument(String id) {
      String sql = "select id as id ,fa_id,menu_name,content,anchor from t_console_help_document WHERE id =:id";
      return (TConsoleHelpDocument)this.getSession().createNativeQuery(sql).setParameter("id", id).setResultTransformer(Transformers.aliasToBean(TConsoleHelpDocument.class)).uniqueResult();
   }

   public List<HelpDocumentVO> queryAllList() {
      String sql = "select id as id ,fa_id,menu_name,content,anchor from t_console_help_document ORDER BY createtime ";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(HelpDocumentVO.class)).getResultList();
   }
}
