package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreFirstPageData;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.UserJoinFieldInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreFirstPageDataDao extends BaseDao<TCoreFirstPageData, String> {
   public static String PEIZHIKUDBTYPE = null;
   private static Properties properties = null;

   public List<Map<String, Object>> query(String projectid) {
      String sql = "        SELECT                                                                                                               a.projectid,                                                                                         a.projectname,                                                                                       ifnull(a.tablecount, 0) as table_num,                                                                 ifnull(a.sensitivetable, 0) as masking_table_num,                                                     ifnull(a.sensitivefield, 0) as masking_field_num,                                                     ifnull(a.fieldcount, 0) as field_num,                                                                 ifnull(b.scope_table_num, 0) as scope_table_num,                                                      ifnull(b.scope_field_num, 0) as scope_field_num,                                                      ifnull(c.sensitive_table_num, 0) as sensitive_table_num,                                              ifnull(d.auth_user_num, 0) as auth_user_num,                                                          ifnull(e.scope_num, 0) as scope_num,                                                                  ifnull(f.sensitive_field_num, 0) as sensitive_field_num                                      FROM                                                                                                         (                                                                                                            SELECT                                                                                               c.projectid,                                                                                         sum(c.tablecount) AS tablecount,                                                                     sum(c.sensitivetable) AS sensitivetable,                                                             sum(c.fieldcount) AS fieldcount,                                                                     sum(c.sensitivefield) AS sensitivefield,                                                             (                                                                                                        SELECT                                                                                                  project                                                                                           FROM                                                                                                    t_core_data_project a1                                                                            WHERE                                                                                                    a1.id = c.projectid                                                                             LIMIT 1                                                                                           ) AS projectname                                                                                     FROM       (                                                                                                        SELECT                                                                                               b1.*, (                                                                                                      SELECT                                                                                       projectid                                                                                            FROM                                                                                                 t_core_discovery_task a1                                                                             WHERE                                                                                                a1.id = b1.taskid                                                                                   LIMIT 1                                                                                      ) AS projectid                                                                               FROM                                                                                                         (                                                                                                            SELECT                                                                                                       *                                                                                                    FROM                                                                                         T_CORE_DISCOVERY_DATA_RESULT t1                                                                      WHERE                                                                                                createtime = (                                                                                               SELECT                                                                                       max(createtime)                                                                                      FROM                                                                                                 T_CORE_DISCOVERY_DATA_RESULT t2                                                                      WHERE                                                                                                t1.taskid = t2.taskid                                                                        )                                                                                    ) b1                                                                                 \t\t\t) c                                                                                               GROUP BY                                                                                             c.projectid                                                                                  ) a                                                                                                          LEFT JOIN (                                                                                                  SELECT                                                                                       projectid,                                                                                                   COUNT(DISTINCT NAMES) AS scope_table_num,                                                    COUNT(DISTINCT tablefield_id) AS scope_field_num                                                     FROM                                                                                                         T_CORE_SCOPE_FIELD                                                                           GROUP BY                                                                                             projectid                                                                                    ) b ON a.projectid = b.projectid                                                                             LEFT JOIN (                                                                                                  SELECT                                                                                       projectid,                                                                                                   COUNT(NAMES) AS sensitive_table_num                                                 FROM                                                                                                         T_CORE_FIELD_SENSITIVE                                                                       GROUP BY                                                                                             projectid                                                                                    ) c ON a.projectid = c.projectid                                                                             LEFT JOIN (                                                                                                  SELECT                                                                                       a.projectid,                                                                                                 count(b.joinid) AS auth_user_num                                                             FROM                                                                                                 t_console_dutytableinfo a                                                                            LEFT JOIN t_console_dutyjoininfo b ON a.id = b.dutytableid                                          GROUP BY                                                                                             a.projectid                                                                                  ) d ON a.projectid = d.projectid                                                                             LEFT JOIN (                                                                                                  SELECT                                                                                       tcsf.projectid,                                                                                              count(DISTINCT tcsf.scope_id) AS scope_num                                                   FROM                                                                                                 T_CORE_SCOPE_FIELD tcsf                                                                              GROUP BY                                                                                             tcsf.projectid                                                                               ) e ON a.projectid = e.projectid                                                                             LEFT JOIN (                                                                                                  SELECT                                                                                       projectid,                                                                                                   sensitive_field_num                                                                          FROM ( SELECT c.projectid, c.open_level, count(1) AS sensitive_field_num FROM ( SELECT b.sensitive_name AS sensitive_name, b.open_level,        a.tablefield_id, a.projectid FROM t_core_field_sensitive a INNER JOIN t_core_sensitive_level b ON a.scope_id = b.id ) c GROUP BY c.projectid,         c.open_level ORDER BY UPPER(c.open_level)) d WHERE d.open_level = ( SELECT min(UPPER(open_level)) FROM ( SELECT c.projectid, c.open_level, count(1) AS sensitive_field_num         FROM ( SELECT b.sensitive_name AS sensitive_name, b.open_level, a.tablefield_id, a.projectid FROM t_core_field_sensitive a          INNER JOIN t_core_sensitive_level b ON a.scope_id = b.id ) c GROUP BY c.projectid, c.open_level ORDER BY UPPER(c.open_level)) e          WHERE d.projectid = e.projectid )  ) f ON a.projectid = f.projectid   where a.projectid = '" + projectid + "'                                                                  ";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, Object>> queryByProjectId(String project_id) {
      String sql = "select * from  T_CORE_FIRST_PAGE_DATA where project_id= :project_id";
      return this.getSession().createNativeQuery(sql).setParameter("project_id", project_id).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryDutyByType(String project_id, String duty_scope) {
      String sql = "select duty_name from  t_duty_person p inner join t_core_project_datasource pd on p.projectid=pd.project_id where pd.project_id= :project_id  and duty_scope= :duty_scope";
      return this.getSession().createNativeQuery(sql).setParameter("project_id", project_id).setParameter("duty_scope", duty_scope).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryAuthUser(String project_id, String datasystemid, String schemaname, String tablename) {
      String sql = "SELECT a.tablename, count(b.joinid) as authnum FROM ( SELECT * FROM t_console_dutytableinfo WHERE projectid = :project_id AND datasystemid = :datasystemid AND schemaname = :schemaname AND tablename = :tablename ) a LEFT JOIN t_console_dutyjoininfo b ON a.id = b.dutytableid GROUP BY a.tablename";
      return this.getSession().createNativeQuery(sql).setParameter("project_id", project_id).setParameter("datasystemid", datasystemid).setParameter("schemaname", schemaname).setParameter("tablename", tablename).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryDutyByTypeOfTable(String projectid, String duty_scope) {
      String sql = "select duty_name from  t_duty_person p inner join t_core_project_datasource pd on p.projectid=pd.project_id where p.projectid= :projectid  and duty_scope= :duty_scope";
      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setParameter("duty_scope", duty_scope).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryScope(String project_id, String datasystemid, String schemaname, String tablename) {
      String sql = "SELECT tcsf.names,count(DISTINCT tcsf.scope_id) as num from T_CORE_SCOPE_FIELD tcsf where projectid = :project_id AND datasystem_id = :datasystemid AND tschemas = :schemaname AND names = :tablename ";
      return this.getSession().createNativeQuery(sql).setParameter("project_id", project_id).setParameter("datasystemid", datasystemid).setParameter("schemaname", schemaname).setParameter("tablename", tablename).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> querySensitive(String datasystemid, String schemaname, String tablename) {
      String sql = "SELECT b.sensitive_name AS sensitive_name FROM t_core_field_sensitive a INNER JOIN t_core_sensitive_level b on a.scope_id = b.id where datasystem_id = :datasystemid AND tschemas = :schemaname AND NAMES = :tablename ORDER BY UPPER(b.open_level)";
      return this.getSession().createNativeQuery(sql).setParameter("datasystemid", datasystemid).setParameter("schemaname", schemaname).setParameter("tablename", tablename).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryDutyByUser(String duty_id, String duty_scope) {
      String sql = "select distinct (select project from t_core_data_project a where a.id = projectid) as project from t_console_dutyjoininfo b inner join t_duty_person c ON b.joinid = c.duty_id INNER JOIN t_console_dutytableinfo a on b.dutytableid = a.id  where c.duty_id= :duty_id and c.duty_scope= :duty_scope";
      return this.getSession().createNativeQuery(sql).setParameter("duty_id", duty_id).setParameter("duty_scope", duty_scope).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryAuthSystemByUser(String duty_id) {
      String sql = "select count(DISTINCT pd.project_id) as authnum from  t_duty_person p inner join t_core_project_datasource pd on p.datasystemid=pd.systemsource_id where p.duty_id= :duty_id ";
      return this.getSession().createNativeQuery(sql).setParameter("duty_id", duty_id).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryAuthTableByUser(String duty_id) {
      String sql = "select count(DISTINCT pd.dutytableid) as authnum from  t_duty_person p inner join t_console_dutyjoininfo  pd on pd.joinid= p.duty_id  where p.duty_id= :duty_id ";
      return this.getSession().createNativeQuery(sql).setParameter("duty_id", duty_id).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryByUserGroup(String group_id) {
      String sql = "SELECT a.projectid, ifnull(b.scope_num,0) as scope_num, c.sensitive_name, ( SELECT project FROM t_core_data_project a1 WHERE a1.id = a.projectid LIMIT 1 ) AS projectname    FROM ( SELECT DISTINCT pd.project_id AS projectid FROM t_duty_person p INNER JOIN t_core_project_datasource pd ON p.datasystemid = pd.systemsource_id    INNER JOIN t_base_usergroup ug ON p.duty_id = ug.userid inner join t_console_dutyjoininfo d on p.duty_id = d.joinid and d.jointype='2' WHERE ug.groupid = :group_id ) a LEFT JOIN ( SELECT tcsf.projectid, count(DISTINCT tcsf.scope_id) AS scope_num     FROM T_CORE_SCOPE_FIELD tcsf GROUP BY tcsf.projectid ) b ON a.projectid = b.projectid LEFT JOIN ( SELECT projectid, sensitive_name, open_level     FROM ( SELECT a.projectid, b.sensitive_name AS sensitive_name, b.open_level FROM t_core_field_sensitive a INNER JOIN t_core_sensitive_level b ON a.scope_id = b.id     GROUP BY a.projectid, b.open_level ORDER BY a.projectid, UPPER(b.open_level)) a WHERE a.open_level = ( SELECT min(UPPER(open_level))    FROM ( SELECT a.projectid, b.sensitive_name AS sensitive_name, b.open_level FROM t_core_field_sensitive a    INNER JOIN t_core_sensitive_level b ON a.scope_id = b.id GROUP BY a.projectid, b.open_level ORDER BY a.projectid, UPPER(b.open_level)) b    WHERE a.projectid = b.projectid )) c ON a.projectid = c.projectid";
      return this.getSession().createNativeQuery(sql).setParameter("group_id", group_id).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryDatasourceDuty(String project_id, String duty_scope, String datasourceid) {
      String sql = "select duty_name from  t_duty_person p inner join t_core_project_datasource pd on p.projectid=pd.project_id where pd.project_id= :project_id  and duty_scope= :duty_scope and pd.systemsource_id = :datasourceid";
      return this.getSession().createNativeQuery(sql).setParameter("project_id", project_id).setParameter("duty_scope", duty_scope).setParameter("datasourceid", datasourceid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<TCoreDatasourceSchema> querySchemasByProjectId(String projectid, String datasystemid) {
      String sql = "select dbtype,schemaname,osdsid,projectid from t_core_datasource_schema where projectid = :projectid";
      if (!StringUtil.isBlank(datasystemid)) {
         sql = sql + " and osdsid = '" + datasystemid + "'";
      }

      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(TCoreDatasourceSchema.class)).getResultList();
   }

   public List<TCoreDatasourceSchema> getDataSourceIds(String projectid) {
      String sql = "SELECT osdsid,schemaname from t_core_datasource_schema WHERE projectid = :projectid GROUP BY osdsid";
      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(TCoreDatasourceSchema.class)).getResultList();
   }

   public List<TCoreDatasystem> getDataSourceDetail(String osdsid) {
      String sql = "SELECT dbip,dbport,dbservername,dbtype,username,password,flag,pagecode FROM t_core_datasystem WHERE id = :osdsid";
      return this.getSession().createNativeQuery(sql).setParameter("osdsid", osdsid).setResultTransformer(Transformers.aliasToBean(TCoreDatasystem.class)).getResultList();
   }

   public List<TCoreFieldSensitive> querySensitiveFiledList(String projectid, String datasystemid) {
      String sql = "SELECT fs.tablefield_id,datasystem_id,names,tschemas,projectid\r\nFROM t_core_sensitive_level sl LEFT JOIN t_core_field_sensitive fs ON fs.scope_id = sl.id\r\nWHERE sl.open_level = 'A' AND fs.projectid = :projectid";
      if (!StringUtil.isBlank(datasystemid)) {
         sql = sql + " and fs.datasystem_id = '" + datasystemid + "'";
      }

      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(TCoreFieldSensitive.class)).getResultList();
   }

   public List<TCoreDataScope> queryScopeList(String projectid) {
      String sql = "SELECT s.id as id,scope_name,s.edition_id FROM t_core_data_project p LEFT JOIN t_core_data_scope s ON p.edition_id = s.edition_id WHERE p.id = :projectid";
      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(TCoreDataScope.class)).getResultList();
   }

   public List<UserJoinFieldInfo> queryDutyInfoList(String projectid, String datasystemid, String schemaname, String tablename) {
      String sql = "SELECT df.joinid,df.jointype,df.dutytableid\r\nFROM t_console_dutyjoininfo df LEFT JOIN t_console_dutytableinfo dt ON df.dutytableid = dt.id WHERE projectid = :projectid";
      if (!StringUtil.isBlank(datasystemid)) {
         sql = sql + " And datasystemid ='" + datasystemid + "'";
      }

      if (!StringUtil.isBlank(tablename)) {
         sql = sql + " And schemaname ='" + schemaname + "' And tablename ='" + tablename + "'";
      }

      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(UserJoinFieldInfo.class)).getResultList();
   }

   public List<TBaseUserrole> queryUserListInRole(String roleid) {
      String sql = "SELECT userid,roleid from t_base_userrole WHERE roleid = :roleid";
      return this.getSession().createNativeQuery(sql).setParameter("roleid", roleid).setResultTransformer(Transformers.aliasToBean(TBaseUserrole.class)).getResultList();
   }

   static {
      try {
         properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
         PEIZHIKUDBTYPE = properties.get("peizhikudbtype").toString();
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
