package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreServerInfoStatus;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreServerInfoVO;
import com.chenyang.nse.bussiness.entity.vo.TCoreServerInfoStatusVo;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreServerInfoStatusDao extends BaseDao<TCoreServerInfoStatus, String> {
   public List<TCoreServerInfoStatus> queryPrimaryServer() {
      String sql = XmlTool.getSql("serverInfoStatus", "queryPrimaryServer");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreServerInfoStatus.class)).getResultList();
   }

   public List<TCoreServerInfoStatus> queryNextPrimaryServer(String prePtid) {
      String sql = XmlTool.getSql("serverInfoStatus", "queryNextPrimaryServer");
      return this.getSession().createNativeQuery(sql).setParameter("prePtid", prePtid).setResultTransformer(Transformers.aliasToBean(TCoreServerInfoStatus.class)).getResultList();
   }

   public List<TCoreServerInfoStatus> queryAllNoPrimaryServer() {
      String sql = XmlTool.getSql("serverInfoStatus", "queryAllNoPrimaryServer");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreServerInfoStatus.class)).getResultList();
   }

   public List<TCoreServerInfoStatus> queryServerByCondition(TCoreServerInfoStatusVo cond) {
      List<TCoreServerInfoStatus> reList = new ArrayList();
      if (StringUtils.isNotBlank(cond.getIp()) && StringUtils.isNotBlank(cond.getPort())) {
         String sql = XmlTool.getSql("serverInfoStatus", "queryServerByCondition");
         reList = this.getSession().createNativeQuery(sql).setParameter("ip", cond.getIp()).setParameter("port", cond.getPort()).setResultTransformer(Transformers.aliasToBean(TCoreServerInfoStatus.class)).getResultList();
      }

      return reList;
   }

   public List<TCoreServerInfoVO> queryAllServer() {
      String sql = XmlTool.getSql("serverinfolist", "queryAllServerInfoList");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreServerInfoVO.class)).getResultList();
   }
}
