package com.chenyang.nse.bussiness.dao.table.core.datamap;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTablerelation;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDatamapTablerelationDao extends BaseDao<TCoreDatamapTablerelation, String> {
   public boolean isRelationExist(String datamapid, String sourcetableid, String targettableid) {
      TCoreDatamapTablerelation relation = this.queryTableRelation(datamapid, sourcetableid, targettableid);
      if (relation != null) {
         return true;
      } else {
         relation = this.queryTableRelation(datamapid, targettableid, sourcetableid);
         return relation != null;
      }
   }

   public TCoreDatamapTablerelation queryTableRelation(String datamapid, String sourcetableid, String targettableid) {
      TCoreDatamapTablerelation relation = (TCoreDatamapTablerelation)this.queryUnique(new Criterion[]{Restrictions.eq("datamapid", datamapid), Restrictions.eq("sourcetableid", sourcetableid), Restrictions.eq("targettableid", targettableid)});
      return relation;
   }
}
