package com.chenyang.nse.bussiness.dao.table.core.desensitizationtask;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

@Repository
public class DesensitizationtaskDao extends BaseDao<Desensitizationtask, String> {
   static final String CACHE_NAME = "desensitizationtask";

   public long getExeTaskNum() {
      String sql = "select  count(*) from desensitization_table as a,desensitizationtask as b  where a.taskid = b.id and taskstatus = 1";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public long getTableNum(String taskid) {
      String sql = "select count(*) as count from desensitization_table    where taskid = '" + taskid + "'";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public long getTableNumByAll(String sqls) {
      String sql = "select count(*) as count from desensitization_table    where taskid  in (" + sqls + ")";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   @Cacheable(
      cacheNames = {"desensitizationtask"},
      key = "'DESENSITIZATIONTASK_' + #taskid",
      unless = "#result == null"
   )
   public Desensitizationtask getById(String taskid) {
      Desensitizationtask desensitizationtask = (Desensitizationtask)this.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
      return desensitizationtask;
   }

   public List<Map<String, Object>> selectMaskingCount(String id) {
      String sql = "SELECT count(1) as s FROM desensitizationtask where projectid ='" + id + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Desensitizationtask> queryTaskAll() {
      String sql = XmlTool.getSql("getalltask", "selectTaskAllList");
      List<Desensitizationtask> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(Desensitizationtask.class)).getResultList();
      return vo;
   }

   public List<Desensitizationtask> queryTaskAllbyprojectid(String projectid) {
      String sql = XmlTool.getSql("getalltask", "selectTaskAllListByProjectid");
      List<Desensitizationtask> vo = this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(Desensitizationtask.class)).getResultList();
      return vo;
   }
}
