package com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;

public class DateUtil {
   public static int returnCurrentYear() {
      try {
         Date date = new Date();
         Calendar ca = Calendar.getInstance();
         ca.setTime(date);
         return ca.get(1);
      } catch (Exception var2) {
         return 0;
      }
   }

   public static String getYear(String inputDate, String patten) {
      Date date = convertStringToDate(inputDate, patten);
      String year = convertDateToString(date, "yyyy");
      return year;
   }

   public static String getLastYear(String inputDate, String patten) {
      String year = returnCurrentUtilDateString("yyyy");
      int lastyear = Integer.parseInt(year) - 1;
      return String.valueOf(lastyear);
   }

   public static String getNextYear(String inputDate, String patten) {
      int num = getMonthDaysNum(inputDate, patten);
      String newDate = getYear(inputDate, patten) + "-" + getMonth(inputDate, patten) + "-" + num;
      System.out.println("nnewDate =" + newDate);
      Date date = AddTime(convertStringToDate(newDate, "yyyy-MM-dd"), 3, 1);
      System.out.println("date =" + date);
      String nextYear = getYear(convertDateToString(date, patten), patten);
      System.out.println("next year =" + nextYear);
      return nextYear;
   }

   public static int returnCurrentMonth() {
      try {
         Date date = new Date();
         Calendar ca = Calendar.getInstance();
         ca.setTime(date);
         return ca.get(2) + 1;
      } catch (Exception var2) {
         return 0;
      }
   }

   public static String getMonthNumber(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(2) + 1;
      return i < 10 ? "0" + i : "" + i;
   }

   public static String getMonth(String inputDate, String patten) {
      Date date = convertStringToDate(inputDate, patten);
      String month = convertDateToString(date, "MM");
      return month;
   }

   public static String getLastMonthNumber(String inputDate, String patten) {
      Date date = AddTime(convertStringToDate(inputDate, patten), 3, -getMonthDaysNum(inputDate, patten));
      String lastMonth = getMonthNumber(convertDateToString(date, patten), patten);
      return lastMonth;
   }

   public static String getNextMonthNumber(String inputDate, String patten) {
      int num = getMonthDaysNum(inputDate, patten);
      String newDate = getYear(inputDate, patten) + "-" + getMonth(inputDate, patten) + "-" + num;
      Date date = AddTime(convertStringToDate(newDate, "yyyy-MM-dd"), 3, 1);
      String nextMonth = getMonthNumber(convertDateToString(date, patten), patten);
      return nextMonth;
   }

   public static String getCurrentYearMonth(int months) {
      Calendar cal = Calendar.getInstance();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");
      cal.set(2, months);
      String yearmonth = formatter.format(cal.getTime());
      return yearmonth;
   }

   public static String getQuarterMinMonth(String quarter) {
      if ("1".equals(quarter)) {
         return "01";
      } else if ("2".equals(quarter)) {
         return "04";
      } else if ("3".equals(quarter)) {
         return "07";
      } else {
         return "4".equals(quarter) ? "10" : "01";
      }
   }

   public static String getQuarterMaxMonth(String quarter) {
      if ("1".equals(quarter)) {
         return "03";
      } else if ("2".equals(quarter)) {
         return "06";
      } else if ("3".equals(quarter)) {
         return "09";
      } else {
         return "4".equals(quarter) ? "12" : "01";
      }
   }

   public static Timestamp returnCurrentSqlDateTime() {
      return new Timestamp(System.currentTimeMillis());
   }

   public static java.sql.Date returnCurrentSqlDate(String datePatten) {
      java.sql.Date sqlDate = java.sql.Date.valueOf(returnCurrentUtilDateString(datePatten));
      return sqlDate;
   }

   public static int returnCurrentDayOfMonth() {
      try {
         Date date = new Date();
         Calendar ca = Calendar.getInstance();
         ca.setTime(date);
         return ca.get(5);
      } catch (Exception var2) {
         return 0;
      }
   }

   public static Date returnCurrentUtilDate(String dataPatten) {
      try {
         SimpleDateFormat sdf = new SimpleDateFormat(dataPatten);
         return sdf.parse(DateFormat.getDateInstance().format(new Date()));
      } catch (Exception var2) {
         return null;
      }
   }

   public static String returnCurrentUtilDateString() {
      try {
         Date Now = new Date();
         return Now.toString();
      } catch (Exception var1) {
         return null;
      }
   }

   public static String returnCurrentUtilDateString(String dataPatten) {
      try {
         Date now = new Date();
         SimpleDateFormat sdf = new SimpleDateFormat(dataPatten);
         return sdf.format(now);
      } catch (Exception var3) {
         return null;
      }
   }

   public static Date convertStringToDate(String inputDate, String dataPatten) {
      SimpleDateFormat sdf = new SimpleDateFormat(dataPatten);
      if (inputDate == null || inputDate.equals("") || inputDate.equals("null")) {
         inputDate = "1899-12-31";
      }

      Date date = null;

      try {
         date = sdf.parse(inputDate);
      } catch (ParseException e) {
         e.printStackTrace();
      }

      return date;
   }

   public static String ConvertDateStrFormat(String inputDate, String oldDatePatten, String newDatePatten) {
      String str = convertDateToString(convertStringToDate(inputDate, oldDatePatten), newDatePatten);
      return str;
   }

   public static String convertDateToString(Date inputDate, String dataPatten) {
      SimpleDateFormat sdf = new SimpleDateFormat(dataPatten);
      return sdf.format(inputDate);
   }

   public static int subtractDate(Date sourceDate, Date subDate) {
      int result = 0;
      long value = sourceDate.getTime() - subDate.getTime();
      value /= 86400000L;
      result = (int)value;
      return result;
   }

   public static boolean isWeekend(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(7) - 1;
      return i == 6 || i == 0;
   }

   public static String getWeek(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(7) - 1;
      if (i == 0) {
         return "星期日";
      } else if (i == 1) {
         return "星期一";
      } else if (i == 2) {
         return "星期二";
      } else if (i == 3) {
         return "星期三";
      } else if (i == 4) {
         return "星期四";
      } else if (i == 5) {
         return "星期五";
      } else {
         return i == 6 ? "星期六" : "";
      }
   }

   public static String getWeekStartDate(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(7) - 1;
      return i == 0 ? addToDate(inputDate, datePatten, -6) : addToDate(inputDate, datePatten, 1 - i);
   }

   public static String getWeekEndDate(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(7) - 1;
      return i == 0 ? inputDate : addToDate(inputDate, datePatten, 7 - i);
   }

   public static String getMonthName(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(2) + 1;
      if (i == 1) {
         return "1月";
      } else if (i == 2) {
         return "2月";
      } else if (i == 3) {
         return "3月";
      } else if (i == 4) {
         return "4月";
      } else if (i == 5) {
         return "5月";
      } else if (i == 6) {
         return "6月";
      } else if (i == 7) {
         return "7月";
      } else if (i == 8) {
         return "8月";
      } else if (i == 9) {
         return "9月";
      } else if (i == 10) {
         return "10月";
      } else if (i == 11) {
         return "11月";
      } else {
         return i == 12 ? "12月" : "";
      }
   }

   public static int getWeekInt(String inputDate, String datePatten) {
      Date date = convertStringToDate(inputDate, datePatten);
      Calendar calendar = GregorianCalendar.getInstance();
      calendar.setTime(date);
      int i = calendar.get(7) - 1;
      return i;
   }

   public static Date AddTime(Date paraDate, int offset, int operand) {
      try {
         long Addcount = 1L;
         Date RetDate = null;
         switch (offset) {
            case 0:
               Addcount = 1000L;
               break;
            case 1:
               Addcount = 60000L;
               break;
            case 2:
               Addcount = 3600000L;
               break;
            case 3:
               Addcount = 86400000L;
         }

         long rettime = paraDate.getTime() + Addcount * (long)operand;
         RetDate = new Date(rettime);
         return RetDate;
      } catch (Exception var9) {
         Date date = null;
         return date;
      }
   }

   public static String addToDate(String inputDate, String datePatten, int num) {
      String value = "";

      try {
         SimpleDateFormat sdf = new SimpleDateFormat(datePatten);
         Date date = sdf.parse(inputDate);
         Calendar xCalendar = GregorianCalendar.getInstance();
         xCalendar.setTime(date);
         xCalendar.add(5, num);
         value = sdf.format(xCalendar.getTime());
      } catch (Exception e) {
         e.printStackTrace();
      }

      return value;
   }

   public static String[] returnCurrentMonthBetween(String radomdate, String datepatten) {
      Date inputDate = convertStringToDate(radomdate, datepatten);
      Calendar cal = Calendar.getInstance();
      SimpleDateFormat formatter = new SimpleDateFormat(datepatten);
      cal.setTime(inputDate);
      int year = cal.get(1);
      int month = cal.get(2) + 1;
      int maxDateNum = cal.getActualMaximum(5);
      String monthstr = "";
      if (month < 10) {
         monthstr = "0" + month;
      } else {
         monthstr = "" + month;
      }

      String startMonthDay = year + "-" + monthstr + "-01";
      Calendar enddate = new GregorianCalendar(year, month - 1, maxDateNum);
      String endMonthDay = formatter.format(enddate.getTime());
      startMonthDay = convertDateToString(convertStringToDate(startMonthDay, "yyyy-MM-dd"), datepatten);
      String[] xx = new String[0];
      xx = new String[]{"" + startMonthDay, "" + endMonthDay};
      return xx;
   }

   public static String returnCurrentMonthEndDate(String patten) {
      String currentDate = returnCurrentUtilDateString(patten);
      int maxDateNum = getMonthDaysNum(currentDate, patten);
      String newDate = getYear(currentDate, patten) + "-" + getMonth(currentDate, patten) + "-" + maxDateNum;
      newDate = ConvertDateStrFormat(newDate, "yyyy-MM-dd", patten);
      return newDate;
   }

   public static String[] returnCurrentWeekBetween(String radomdate, String datepatten) {
      String[] weekday = new String[0];
      int dayofweek = 0;

      try {
         Calendar cal = Calendar.getInstance();
         SimpleDateFormat formatter = new SimpleDateFormat(datepatten);
         cal.setTime(formatter.parse(radomdate));
         dayofweek = cal.get(7) - 1;
         String startdayofweek = "";
         String enddayofweek = "";
         if (dayofweek == 0) {
            startdayofweek = addToDate(radomdate, datepatten, -dayofweek + 1 - 7);
            enddayofweek = addToDate(radomdate, datepatten, dayofweek);
         } else {
            startdayofweek = addToDate(radomdate, datepatten, -dayofweek + 1);
            enddayofweek = addToDate(radomdate, datepatten, 7 - dayofweek);
         }

         weekday = new String[]{"" + startdayofweek, "" + enddayofweek};
      } catch (Exception e) {
         e.printStackTrace();
      }

      return weekday;
   }

   public static LinkedHashMap generateDayAndWeek(String year, String monthRegex) {
      String[] monthArry = monthRegex.split(",");
      Calendar calendar = GregorianCalendar.getInstance();
      LinkedHashMap map = new LinkedHashMap();

      for(int i = 0; i < monthArry.length; ++i) {
         LinkedHashMap monthmap = new LinkedHashMap();
         String month = "";
         if (monthArry[i].length() == 1) {
            month = "0" + monthArry[i];
         } else {
            month = monthArry[i];
         }

         Date date = convertStringToDate(year + month + "01", "yyyyMMdd");
         calendar.setTime(date);
         int maxdays = calendar.getActualMaximum(5);
         if (maxdays > 0) {
            for(int k = 1; k < maxdays + 1; ++k) {
               String k_date_str = "";
               if (k < 10) {
                  k_date_str = year + month + "0" + k;
               } else {
                  k_date_str = year + month + k;
               }

               String week = getWeek(k_date_str, "yyyyMMdd");
               monthmap.put(k_date_str, week);
            }
         }

         map.put(monthArry[i], monthmap);
      }

      return map;
   }

   public static int getMonthDaysNum(String inputDate, String patten) {
      Calendar calendar = GregorianCalendar.getInstance();
      Date date = convertStringToDate(inputDate, patten);
      calendar.setTime(date);
      int maxdays = calendar.getActualMaximum(5);
      return maxdays;
   }

   public static String getAllMonthWeekendNumbers(String inputDate, String patten, char c) {
      int maxNum = getMonthDaysNum(inputDate, patten);
      String str = "";
      if (maxNum > 0) {
         for(int i = 1; i <= maxNum; ++i) {
            String subDate = ConvertDateStrFormat(inputDate, patten, "yyyy-MM");
            String date = subDate + "-" + getMonthNumber(String.valueOf(i), "MM");
            if (isWeekend(date, "yyyy-MM-dd")) {
               str = str + c + getMonthNumber(String.valueOf(i), "MM") + ",";
            }
         }

         str = str.substring(0, str.length() - 1);
      }

      return str;
   }

   public static String getAddMonth(String inputDate, int monthNum) {
      String resultDate = "";

      try {
         try {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            calendar.setTime(sdf.parse(inputDate));
            calendar.add(2, monthNum);
            Date date = calendar.getTime();
            resultDate = sdf.format(date);
         } catch (Exception var9) {
         }

         return resultDate;
      } finally {
         ;
      }
   }

   public static String CoverValue(String DateTime) {
      String dayValue = "";
      String monthValue = "";
      String timeValue = "";
      String coverDate = "";
      if (DateTime.length() > 6 && DateTime.length() == 12) {
         timeValue = DateTime.substring(7);
      }

      dayValue = DateTime.substring(0, 2);
      monthValue = DateTime.substring(3, 6);
      String month = "";
      if (monthValue.toLowerCase().equals("jan")) {
         month = "01";
      } else if (monthValue.toLowerCase().equals("feb")) {
         month = "02";
      } else if (monthValue.toLowerCase().equals("mar")) {
         month = "03";
      } else if (monthValue.toLowerCase().equals("apr")) {
         month = "04";
      } else if (monthValue.toLowerCase().equals("may")) {
         month = "05";
      } else if (monthValue.toLowerCase().equals("jun")) {
         month = "06";
      } else if (monthValue.toLowerCase().equals("jul")) {
         month = "07";
      } else if (monthValue.toLowerCase().equals("aug")) {
         month = "08";
      } else if (monthValue.toLowerCase().equals("sep")) {
         month = "09";
      } else if (monthValue.toLowerCase().equals("oct")) {
         month = "10";
      } else if (monthValue.toLowerCase().equals("nov")) {
         month = "11";
      } else if (monthValue.toLowerCase().equals("dec")) {
         month = "12";
      } else {
         month = monthValue;
      }

      if (DateTime.length() > 6) {
         coverDate = month + dayValue + "-" + timeValue;
      } else {
         coverDate = month + dayValue;
      }

      return coverDate;
   }

   public static String getDefaultLogDate() {
      return getCurrentFormate_Date();
   }

   public static String getDefaultCurrentDate() {
      Date date = new Date();
      int lengthDay = 2;
      if (date.getDay() != 1 && date.getDay() != 2) {
         if (date.getDay() == 0) {
            lengthDay = 3;
         }
      } else {
         lengthDay = 4;
      }

      return getCalCurrentDate(lengthDay);
   }

   public static String getCalCurrentDate(int timeRecord) {
      Date d = new Date();
      SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
      return df.format(new Date(d.getTime() - (long)(timeRecord * 24 * 60 * 60 * 1000)));
   }

   public static String returnCurrentDateMode24() {
      try {
         Date now = new Date();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         return sdf.format(now);
      } catch (Exception var2) {
         return null;
      }
   }

   public static String returnCurrentDateMode24_No_style() {
      try {
         Date now = new Date();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
         return sdf.format(now);
      } catch (Exception var2) {
         return null;
      }
   }

   public static String getCurrentFormate_Date() {
      String date = returnCurrentDateMode12().substring(0, 8);
      String date_formate = "";
      date_formate = date.substring(0, 4).concat("-") + date.substring(4, 6).concat("-") + date.substring(6, 8);
      return date_formate;
   }

   public static String returnCurrentDateMode12() {
      try {
         Date now = new Date();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
         return sdf.format(now);
      } catch (Exception var2) {
         return null;
      }
   }

   public static String getWeeklyStartDay() {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
      Calendar cal = Calendar.getInstance();
      Date toDay = cal.getTime();
      int day_of_week = cal.get(7) - 2;
      cal.add(5, -day_of_week);
      Date weekFirst = cal.getTime();
      return formatter.format(weekFirst);
   }

   public static String getWeeklyEndDay() {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
      Calendar cal = Calendar.getInstance();
      Date toDay = cal.getTime();
      int day_of_week = cal.get(7) - 2;
      cal.add(5, -day_of_week);
      Date weekFirst = cal.getTime();
      formatter.format(weekFirst);
      cal.add(5, 6);
      Date weekLast = cal.getTime();
      return formatter.format(weekLast);
   }

   public static String getMonthStartDay() {
      return getCurrentFormate_Date().substring(0, 8) + "01";
   }

   public static String getSpecifiedDayBefore(String specifiedDay) {
      Calendar c = Calendar.getInstance();
      Date date = null;

      try {
         date = (new SimpleDateFormat("yy-MM-dd")).parse(specifiedDay);
      } catch (ParseException e) {
         e.printStackTrace();
      }

      c.setTime(date);
      int day = c.get(5);
      c.set(5, day - 1);
      String dayBefore = (new SimpleDateFormat("yyyy-MM-dd")).format(c.getTime());
      return dayBefore;
   }

   public static String getMonthEndDay() {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = Calendar.getInstance();
      c.add(2, 1);
      c.set(5, 1);
      return getSpecifiedDayBefore(dateFormat.format(c.getTime()));
   }

   public static String getMonthFirstDay() {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = Calendar.getInstance();
      c.set(5, 1);
      return dateFormat.format(c.getTime());
   }

   public static String getPreMonthFirstDay() {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = Calendar.getInstance();
      c.add(2, -1);
      c.set(5, 1);
      return dateFormat.format(c.getTime());
   }

   public static Calendar getFirstDayOfNextMonth() {
      Calendar c = Calendar.getInstance();
      c.add(2, 1);
      c.set(5, 1);
      c.set(11, 0);
      c.set(12, 0);
      c.set(13, 0);
      c.set(14, 0);
      return c;
   }

   public static String getPreMonthEndDay() {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = Calendar.getInstance();
      c.set(5, 1);
      return getSpecifiedDayBefore(dateFormat.format(c.getTime()));
   }

   public static String getBeforeThereMonthBegin() {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = Calendar.getInstance();
      c.add(2, -3);
      c.set(5, 1);
      return dateFormat.format(c.getTime());
   }

   public static String getBeforeSixMonthBegin() {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = Calendar.getInstance();
      c.add(2, -6);
      c.set(5, 1);
      return dateFormat.format(c.getTime());
   }

   public static Date getDateFromString(String stringDate) throws Exception {
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      return dateFormat.parse(stringDate);
   }

   public static Calendar getCalendarFromString(String stringDate) throws Exception {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(getDateFromString(stringDate));
      return calendar;
   }

   public static Calendar getCalendarFromString(String stringDate, String patten) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(convertStringToDate(stringDate, patten));
      return calendar;
   }

   public static Calendar getCalendarFromDate(Date date) throws Exception {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(date);
      return calendar;
   }

   public static Calendar getYesterday(String date) throws Exception {
      Calendar calendar = getCalendarFromString(date);
      calendar.add(5, -1);
      return calendar;
   }

   public static List<Calendar> getWeekdaysCalendar(int weekDay) throws Exception {
      Calendar firstDay = getCalendarFromString(getMonthFirstDay());
      List<Calendar> mondays = new ArrayList();
      if (weekDay < firstDay.get(7)) {
         firstDay.add(5, 7);
         firstDay.set(7, weekDay);
      } else if (weekDay >= firstDay.get(7)) {
         firstDay.set(7, weekDay);
      }

      Calendar nextMonday = Calendar.getInstance();
      nextMonday.set(5, firstDay.get(5));

      while(nextMonday.get(2) == firstDay.get(2)) {
         Calendar day = Calendar.getInstance();
         day.set(5, nextMonday.get(5));
         mondays.add(day);
         nextMonday.add(5, 7);
      }

      return mondays;
   }

   public static Calendar getLastWeekMonday(Calendar calendar) {
      Calendar lastMonday = Calendar.getInstance();
      lastMonday.set(4, calendar.get(4) - 1);
      lastMonday.set(7, 2);
      lastMonday.get(5);
      return lastMonday;
   }

   public static Calendar getLastWeekSunday(Calendar calendar) {
      Calendar lastMonday = Calendar.getInstance();
      lastMonday.set(5, calendar.get(5));
      if (lastMonday.get(7) == 1) {
         lastMonday.add(4, -1);
      }

      lastMonday.set(7, 1);
      return lastMonday;
   }

   public static Calendar getDayOfThisWeekByInteger(Calendar calendar, int num) {
      Calendar result = Calendar.getInstance();
      result.set(5, calendar.get(5));
      if (1 == result.get(7)) {
         result.add(4, -1);
      }

      if (7 == num) {
         result.add(4, 1);
      }

      int value = 0;
      switch (num) {
         case 1:
            value = 2;
            break;
         case 2:
            value = 3;
            break;
         case 3:
            value = 4;
            break;
         case 4:
            value = 5;
            break;
         case 5:
            value = 6;
            break;
         case 6:
            value = 7;
            break;
         case 7:
            value = 1;
      }

      result.set(7, value);
      return result;
   }

   public static Calendar getDayOfNextWeekByInteger(Calendar calendar, int num) {
      Calendar result = Calendar.getInstance();
      result.set(5, calendar.get(5));
      result.add(4, 1);
      return getDayOfThisWeekByInteger(result, num);
   }

   public static Calendar getDayOfLastWeekByInteger(Calendar calendar, int num) {
      Calendar result = Calendar.getInstance();
      result.set(5, calendar.get(5));
      result.add(4, -1);
      return getDayOfThisWeekByInteger(result, num);
   }

   public static Calendar getDayWeekByInteger(Calendar calendar, int weekOrder, int num) {
      Calendar result = Calendar.getInstance();
      if (weekOrder == 0) {
         result.set(4, calendar.get(5) - 1);
         result.add(4, -(1 - weekOrder));
      } else {
         result.set(5, calendar.get(5));
         result.add(4, -(1 - weekOrder));
      }

      return getDayOfThisWeekByInteger(result, num);
   }

   public static Calendar getDayOfLastMonthByInteger(int num) {
      Calendar result = Calendar.getInstance();
      result.add(2, -1);
      result.set(5, num);
      return result;
   }

   public static Calendar getDayOfThisMonthByInteger(int num) {
      Calendar result = Calendar.getInstance();
      result.set(5, num);
      return result;
   }

   public static Calendar getDayOfNextMonthByInteger(int num) {
      Calendar result = Calendar.getInstance();
      result.add(2, 1);
      result.set(5, num);
      return result;
   }

   public static String getRightNowForSimple() {
      Date now = new Date();
      SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
      return sdf.format(now);
   }

   public static String getCurrentDateForDBFormate() {
      Date now = new Date();
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      return sdf.format(now);
   }

   public static Date simpleDate(Date date) throws ParseException {
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
      String dateStr = sdf.format(date);
      return sdf.parse(dateStr);
   }

   public static String getStringFormDate(Date date) throws Exception {
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
      return sdf.format(date);
   }

   public static String getStringDateByPattern(Date date, String pattern) throws Exception {
      SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
      return dateFormat.format(date);
   }

   public static String getDateByCalBeforeAfterNum(String inputDate, String pattern, int num) {
      try {
         SimpleDateFormat sdf = new SimpleDateFormat(pattern);
         Calendar rightNow = Calendar.getInstance();
         rightNow.setTime(sdf.parse(inputDate));
         rightNow.add(5, num);
         return sdf.format(rightNow.getTime());
      } catch (Exception ex) {
         ex.printStackTrace();
         return null;
      }
   }

   public static String getSingleMonthEndDay(String dayStr, int mount) throws Exception {
      if (dayStr.split("-").length == 2) {
         dayStr = dayStr + "-01";
      }

      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
      Calendar c = getCalendarFromString(dayStr);
      c.add(2, mount);
      c.set(5, 1);
      return getSpecifiedDayBefore(dateFormat.format(c.getTime()));
   }

   public static void main(String[] args) throws Exception {
      String str = getCurrentDateForDBFormate();
      System.out.println(str);
   }

   public static String processMonthDate(String currDateStr, String monDayFormate) throws Exception {
      String beforeMonthStr = getSingleMonthEndDay(currDateStr, 0).substring(0, 7);
      String[] tmpMonFormate = monDayFormate.split("_");
      if (tmpMonFormate[1].equals("0")) {
         return tmpMonFormate[2].equals("END") ? getSingleMonthEndDay(currDateStr, 0) : beforeMonthStr + "-" + (tmpMonFormate[2].length() > 1 ? tmpMonFormate[2] : "0" + tmpMonFormate[2]);
      } else {
         return tmpMonFormate[2].equals("END") ? getSingleMonthEndDay(currDateStr, 1) : currDateStr.substring(0, 7) + "-" + (tmpMonFormate[2].length() > 1 ? tmpMonFormate[2] : "0" + tmpMonFormate[2]);
      }
   }

   public static void processDate() throws Exception {
      System.out.println(returnCurrentDateMode12());
      String startDateCurr = "W_0_1";
      String endDateCurr = "W_1_7";
      String sDateCurr = "W_1_7";
      String[] strl = returnCurrentWeekBetween("2015-07-01", "yyyy-MM-dd");

      for(int i = 0; i < strl.length; ++i) {
         System.out.println("--- $$ " + strl[i]);
      }

      System.out.println(getDateByCalBeforeAfterNum(strl[0], "yyyy-MM-dd", 6));
      System.out.println(getDateByCalBeforeAfterNum(strl[0], "yyyy-MM-dd", -7));
      String[] strl2 = returnCurrentWeekBetween("2015-07-03", "yyyy-MM-dd");

      for(int i = 0; i < strl2.length; ++i) {
         System.out.println("---- " + strl2[i]);
      }

      System.out.println(getDateByCalBeforeAfterNum("2015-07-01", "yyyy-mm-dd", 10));
   }

   public static String processWeeklyDate(String beginDate, String dateFormate) throws Exception {
      String[] strl = returnCurrentWeekBetween(beginDate, "yyyy-MM-dd");
      String[] splitArray = dateFormate.split("_");
      return splitArray[1].equals("0") ? getDateByCalBeforeAfterNum(strl[0], "yyyy-MM-dd", -(8 - Integer.parseInt(splitArray[2]))) : getDateByCalBeforeAfterNum(strl[0], "yyyy-MM-dd", Integer.parseInt(splitArray[2]) - 1);
   }

   public static String getRightNowForSimpleFormate() {
      Date now = new Date();
      SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
      return sdf.format(now);
   }

   public interface TimeUnit {
      int SECOND = 0;
      int MINUTE = 1;
      int HOUR = 2;
      int DAY = 3;
   }
}
