package com.chenyang.nse.bussiness.entity;

import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.db.TypeInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDbfieldtype;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreTablestructure;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.console.DBFieldTypesService;
import com.chenyang.nse.bussiness.tools.jdbc.BeanFactory;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class Table extends TCoreTablestructure {
   private List<TCoreTablestructure> columns;

   public Table() {
   }

   public Table(List<TCoreTablestructure> columns) {
      this.columns = columns;
   }

   public List<TCoreTablestructure> getColumns() {
      return this.columns;
   }

   public void setColumns(List<TCoreTablestructure> columns) {
      this.columns = columns;
   }

   public String generateCreateDLL() {
      List<String> primarykey = new ArrayList();
      StringBuffer create = new StringBuffer();
      create.append("CREATE TABLE " + this.getTableorcolumnname() + " \n (");

      for(int i = 0; i < this.columns.size(); ++i) {
         TCoreTablestructure column = (TCoreTablestructure)this.columns.get(i);
         create.append(column.getTableorcolumnname() + " ");
         create.append(column.getJavacolumntype() + " ");
         if (column.getColumnlength() != null) {
            create.append("(" + column.getColumnlength() + ") ");
         }

         if (column.getIsprimarykey() != null && column.getIsprimarykey().equals("1")) {
            create.append(" NOT NULL ");
            primarykey.add(column.getTableorcolumnname());
         }

         if (i < this.columns.size() - 1 || primarykey.size() > 0) {
            create.append(" ,");
         }

         if (i == this.columns.size() - 1 && primarykey.size() > 0) {
            create.append(" PRIMARY KEY (");

            for(int j = 0; j < primarykey.size(); ++j) {
               create.append((String)primarykey.get(j));
               if (j < primarykey.size() - 1) {
                  create.append(",");
               }
            }

            create.append(")");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }

   public String generateCreateDLL(String dbtype) {
      DBFieldTypesService dbFieldTypesService = (DBFieldTypesService)BeanFactory.getBean(DBFieldTypesService.class);
      List<String> primarykey = new ArrayList();
      StringBuffer create = new StringBuffer();
      create.append("CREATE TABLE " + this.getTableorcolumnname() + " \n (");

      for(int i = 0; i < this.columns.size(); ++i) {
         TCoreTablestructure column = (TCoreTablestructure)this.columns.get(i);
         create.append(column.getTableorcolumnname() + " ");
         String columntype = dbFieldTypesService.getColumnTypeByJavaType(dbtype, column.getJavacolumntype());
         create.append(columntype + " ");
         if (column.getColumnlength() != null && JdbcTool.hasColumnSize(columntype)) {
            create.append("(" + column.getColumnlength() + ") ");
         }

         if (column.getIsprimarykey() != null && column.getIsprimarykey().equals("1")) {
            create.append(" NOT NULL ");
            primarykey.add(column.getTableorcolumnname());
         }

         if (i < this.columns.size() - 1 || primarykey.size() > 0) {
            create.append(" ,");
         }

         if (i == this.columns.size() - 1 && primarykey.size() > 0) {
            create.append(" PRIMARY KEY (");

            for(int j = 0; j < primarykey.size(); ++j) {
               create.append((String)primarykey.get(j));
               if (j < primarykey.size() - 1) {
                  create.append(",");
               }
            }

            create.append(")");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }

   public String generateCreateDLL(String dbtype, String targetSchema) {
      DBFieldTypesService dbFieldTypesService = (DBFieldTypesService)BeanFactory.getBean(DBFieldTypesService.class);
      List<String> primarykey = new ArrayList();
      StringBuffer create = new StringBuffer();
      if (targetSchema != null) {
         if (EdbType.ORACLE.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + this.getTableorcolumnname() + " \n (");
         } else if (EdbType.DB2.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + this.getTableorcolumnname() + " \n (");
         } else {
            create.append("CREATE TABLE " + this.getTableorcolumnname() + " \n (");
         }
      } else {
         create.append("CREATE TABLE " + this.getTableorcolumnname() + " \n (");
      }

      for(int i = 0; i < this.columns.size(); ++i) {
         TCoreTablestructure column = (TCoreTablestructure)this.columns.get(i);
         create.append(column.getTableorcolumnname() + " ");
         String columntype = dbFieldTypesService.getColumnTypeByJavaType(dbtype, column.getJavacolumntype());
         create.append(columntype + " ");
         if (column.getColumnlength() != null && JdbcTool.hasColumnSize(columntype)) {
            create.append("(" + column.getColumnlength() + ") ");
         }

         if (column.getIsprimarykey() != null && column.getIsprimarykey().equals("1")) {
            create.append(" NOT NULL ");
            primarykey.add(column.getTableorcolumnname());
         }

         if (i < this.columns.size() - 1 || primarykey.size() > 0) {
            create.append(" ,");
         }

         if (i == this.columns.size() - 1 && primarykey.size() > 0) {
            create.append(" PRIMARY KEY (");

            for(int j = 0; j < primarykey.size(); ++j) {
               create.append((String)primarykey.get(j));
               if (j < primarykey.size() - 1) {
                  create.append(",");
               }
            }

            create.append(")");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }

   public String generateCreateDLL(String dbtype, String targetSchema, String targetTableName) {
      DBFieldTypesService dbFieldTypesService = (DBFieldTypesService)BeanFactory.getBean(DBFieldTypesService.class);
      List<String> primarykey = new ArrayList();
      StringBuffer create = new StringBuffer();
      if (targetSchema != null) {
         if (EdbType.ORACLE.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
         } else if (EdbType.DB2.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
         } else {
            create.append("CREATE TABLE " + targetTableName + " \n (");
         }
      } else {
         create.append("CREATE TABLE " + targetTableName + " \n (");
      }

      for(int i = 0; i < this.columns.size(); ++i) {
         TCoreTablestructure column = (TCoreTablestructure)this.columns.get(i);
         create.append(column.getTableorcolumnname() + " ");
         String columntype = dbFieldTypesService.getColumnTypeByJavaType(dbtype, column.getJavacolumntype());
         create.append(columntype + " ");
         if (column.getColumnlength() != null && JdbcTool.hasColumnSize(columntype)) {
            create.append("(" + column.getColumnlength() + ") ");
         }

         if (column.getIsprimarykey() != null && column.getIsprimarykey().equals("1")) {
            create.append(" NOT NULL ");
            primarykey.add(column.getTableorcolumnname());
         }

         if (i < this.columns.size() - 1 || primarykey.size() > 0) {
            create.append(" ,");
         }

         if (i == this.columns.size() - 1 && primarykey.size() > 0) {
            create.append(" PRIMARY KEY (");

            for(int j = 0; j < primarykey.size(); ++j) {
               create.append((String)primarykey.get(j));
               if (j < primarykey.size() - 1) {
                  create.append(",");
               }
            }

            create.append(")");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }

   public static void main(String[] args) {
      String driverClass_oracle = "oracle.jdbc.driver.OracleDriver";
      String url_oracle = "jdbc:oracle:thin:@192.168.1.100:1521:orcl";
      String username_oracle = "c##ghca";
      String password_oracle = "ghca";
      String driverClass_mysql = "com.mysql.jdbc.Driver";
      String url_mysql = "jdbc:mysql://192.168.1.100:3306/mysql";
      String username_mysql = "root";
      String password_mysql = "123";
      Connection conn_oracle = null;
      Connection conn_mysql = null;
      String tableName = "T_SYSUSER";

      try {
         conn_oracle = JdbcTool.getConnection(driverClass_oracle, url_oracle, username_oracle, password_oracle);
         JdbcTool.getConnection(driverClass_mysql, url_mysql, username_mysql, password_mysql);
         List<Column> columns = JdbcTool.getAllColumn(conn_oracle, username_oracle.toUpperCase(), tableName);
         List<TCoreTablestructure> columnList = new ArrayList();

         for(Column column : columns) {
            TCoreTablestructure t = new TCoreTablestructure();
            t.setTableorcolumnname(column.getName());
            t.setColumntype(column.getType());
            t.setColumnlength(column.getLength());
            columnList.add(t);
         }

         Table table = new Table();
         table.setColumns(columnList);
         table.setTableorcolumnname(tableName);
         String sql = table.generateCreateDLL();
         System.out.println(sql);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public String generateCreateDLL(String dbtype, String targetSchema, String targetTableName, List<String> notnull) {
      DBFieldTypesService dbFieldTypesService = (DBFieldTypesService)BeanFactory.getBean(DBFieldTypesService.class);
      List<String> primarykey = new ArrayList();
      StringBuffer create = new StringBuffer();
      if (targetSchema != null) {
         if (EdbType.ORACLE.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
         } else if (EdbType.DB2.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
         } else {
            create.append("CREATE TABLE " + targetTableName + " \n (");
         }
      } else {
         create.append("CREATE TABLE " + targetTableName + " \n (");
      }

      for(int i = 0; i < this.columns.size(); ++i) {
         TCoreTablestructure column = (TCoreTablestructure)this.columns.get(i);
         create.append(column.getTableorcolumnname() + " ");
         String columntype = dbFieldTypesService.getColumnTypeByJavaType(dbtype, column.getJavacolumntype());
         create.append(columntype + " ");
         if (column.getColumnlength() != null && JdbcTool.hasColumnSize(columntype) && Integer.valueOf(column.getColumnlength()) > 0 && !columntype.equalsIgnoreCase("smallint")) {
            create.append("(" + column.getColumnlength() + ") ");
         }

         if (column.getIsprimarykey() != null && column.getIsprimarykey().equals("1") && notnull.contains(column.getTableorcolumnname())) {
            create.append(" NOT NULL ");
            primarykey.add(column.getTableorcolumnname());
         }

         if (i < this.columns.size() - 1) {
            create.append(" ,");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }

   public String generateCreateDLL(String dbtype, String targetSchema, String targetTableName, List<String> notnull, List<TypeInfo> targettype) {
      DBFieldTypesService dbFieldTypesService = (DBFieldTypesService)BeanFactory.getBean(DBFieldTypesService.class);
      List<String> primarykey = new ArrayList();
      StringBuffer create = new StringBuffer();
      if (targetSchema != null) {
         if (EdbType.ORACLE.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
         } else if (EdbType.DB2.getDbcode().equals(dbtype)) {
            create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
         } else {
            create.append("CREATE TABLE " + targetTableName + " \n (");
         }
      } else {
         create.append("CREATE TABLE " + targetTableName + " \n (");
      }

      for(int i = 0; i < this.columns.size(); ++i) {
         TCoreTablestructure column = (TCoreTablestructure)this.columns.get(i);
         create.append(column.getTableorcolumnname() + " ");
         String columntype = dbFieldTypesService.getColumnTypeByJavaType(dbtype, column.getJavacolumntype());
         create.append(columntype + " ");
         if (column.getColumnlength() != null && JdbcTool.hasColumnSize(columntype) && !columntype.equalsIgnoreCase("smallint")) {
            String clength = column.getColumnlength().split(",")[0];
            int maxlength = 0;

            for(TypeInfo info : targettype) {
               if (info.getTypename().equalsIgnoreCase(columntype)) {
                  maxlength = info.getMaximunscale() == 0 ? 0 : info.getMaximunscale();
                  break;
               }
            }

            if (maxlength == 0) {
               continue;
            }

            if (Integer.valueOf(clength) > 0 && maxlength >= Integer.valueOf(clength)) {
               create.append("(" + column.getColumnlength() + ") ");
            } else {
               create.append("(" + maxlength + ") ");
            }
         }

         if (column.getIsprimarykey() != null && column.getIsprimarykey().equals("1") && notnull.contains(column.getTableorcolumnname())) {
            create.append(" NOT NULL ");
            primarykey.add(column.getTableorcolumnname());
         }

         if (i < this.columns.size() - 1) {
            create.append(" ,");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }

   public String generateCreateDLL(List<ColumnInfo> source_column, String sourcedbtype, String targetdbtype, String targetSchema, String targetTableName, List<String> notnull, List<TypeInfo> targettype) {
      DBFieldTypesService dbFieldTypesService = (DBFieldTypesService)BeanFactory.getBean(DBFieldTypesService.class);
      new ArrayList();
      StringBuffer create = new StringBuffer();
      if (targetSchema != null) {
         create.append("CREATE TABLE " + targetSchema + "." + targetTableName + " \n (");
      } else {
         create.append("CREATE TABLE " + targetTableName + " \n (");
      }

      for(int i = 0; i < source_column.size(); ++i) {
         ColumnInfo column = (ColumnInfo)source_column.get(i);
         System.out.println(column);
         TConsoleDbfieldtype cs = dbFieldTypesService.queryColumn(sourcedbtype, column.getTypename(), column.getDatatype());
         TConsoleDbfieldtype ts = dbFieldTypesService.getColumnTypeByJavaType(targetdbtype, cs.getJavatype(), cs.getEnginecolumntype());
         create.append(column.getColumnname() + " " + ts.getColumntype() + " ");
         if (ts.getLength() != null && !"".equals(ts.getLength().trim())) {
            if ("0".equals(ts.getLength())) {
               create.append("(" + column.getColumnsize());
            } else {
               create.append("(" + ts.getLength());
            }

            if (column.getDatatype() == null || Integer.valueOf(column.getDatatype()) != 3 && Integer.valueOf(column.getDatatype()) != 2) {
               create.append(") ");
            } else {
               create.append("," + column.getDecimaldigits() + ") ");
            }
         }

         if (i < source_column.size() - 1) {
            create.append(" ,");
         }

         create.append("\n");
      }

      create.append(")");
      return create.toString();
   }
}
