package com.chenyang.nse.bussiness.entity.webApi;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class Msg {
   @JsonIgnore
   private ApiCode apiCode;
   private boolean success;
   private String code;
   private String text;
   private Object data;

   public static Msg error(ApiCode code) {
      Msg msg = new Msg();
      msg.code = code.getCode();
      msg.text = code.getText();
      msg.success = false;
      return msg;
   }

   public static Msg error(ApiCode code, String desc) {
      Msg msg = new Msg();
      msg.code = code.getCode();
      msg.text = String.format(code.getText(), desc);
      msg.apiCode = code;
      msg.success = false;
      return msg;
   }

   public static Msg succed(Object data) {
      Msg msg = new Msg();
      msg.data = data;
      msg.apiCode = ApiCode.ok;
      msg.code = ApiCode.ok.getCode();
      msg.success = true;
      return msg;
   }

   public String getCode() {
      return this.code;
   }

   public void setCode(String code) {
      this.code = code;
   }

   public String getText() {
      return this.text;
   }

   public void setText(String text) {
      this.text = text;
   }

   public Object getData() {
      return this.data;
   }

   public void setData(Object data) {
      this.data = data;
   }

   public boolean isSuccess() {
      return this.success;
   }

   public void setSuccess(boolean success) {
      this.success = success;
   }

   @JsonIgnore
   public ApiCode getApiCode() {
      return this.apiCode;
   }
}
