package com.chenyang.nse.bussiness.incencryption.controller;

import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.incencryption.service.IncEncryptionService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"encryption"})
public class IncEncryptionController {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected IncEncryptionService incEncryptionService;

   @RequestMapping({"incencryption"})
   public Response<String> incencryption(@RequestBody Map<String, String> map) {
      this.logger.info(map != null ? map.toString() : "");
      String projectId = (String)map.get("projectId");
      if (!StringUtils.hasText(projectId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "projectId is required");
      } else {
         String dataSystemId = (String)map.get("dataSystemId");
         if (!StringUtils.hasText(dataSystemId)) {
            return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "dataSystemId is required");
         } else {
            String schema = (String)map.get("schema");
            if (!StringUtils.hasText(schema)) {
               return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "schema is required");
            } else {
               String tableName = (String)map.get("tableName");
               if (!StringUtils.hasText(tableName)) {
                  return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "tableName is required");
               } else {
                  try {
                     this.incEncryptionService.incEncrypt(projectId, dataSystemId, schema, tableName);
                     return RespHelper.<String>successResp();
                  } catch (IncEncryptionService.IncEncryptionMaxThreadsReachedException e) {
                     this.logger.info(e.getMessage());
                     return RespHelper.<String>createResp(ErrCode.BUSINESS_ERROR.getCode(), e.getMessage());
                  } catch (IncEncryptionService.IncEncryptionTaskRunningException var8) {
                     this.logger.info("IncEncryptionTaskRunning");
                     return RespHelper.<String>createResp(ErrCode.BUSINESS_ERROR.getCode(), "IncEncryptionTaskRunning");
                  } catch (Exception e) {
                     this.logger.error(e.getMessage(), e);
                     return RespHelper.<String>createResp(ErrCode.BUSINESS_ERROR.getCode(), String.format("[%s]%s", e.getClass().getName(), e.getMessage()));
                  }
               }
            }
         }
      }
   }
}
