package com.chenyang.nse.bussiness.interfaces;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveRMI implements IHiveRMI {
   public HiveRMI() throws RemoteException {
   }

   public List<HashMap<String, String>> getHdfsList(String kerberosPath, String user, String hdfsPath) throws RemoteException, IOException {
      String path1 = kerberosPath + "core-site.xml";
      String path2 = kerberosPath + "hdfs-site.xml";
      String path3 = kerberosPath + "hive-site.xml";
      String path4 = kerberosPath + "mapred-site.xml";
      Configuration conf = new Configuration();
      conf.addResource(new Path(path1));
      conf.addResource(new Path(path2));
      conf.addResource(new Path(path3));
      conf.addResource(new Path(path4));
      conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
      UserGroupInformation.setConfiguration(conf);
      FileSystem fs = FileSystem.get(conf);
      FileStatus[] files = fs.listStatus(new Path(hdfsPath));
      HashMap<String, String> maps = new HashMap();
      List<HashMap<String, String>> listmap = new ArrayList();
      maps.put("path", "");
      maps.put("name", "..");
      maps.put("length", "");
      maps.put("replication", "");
      maps.put("blocksize", "");
      maps.put("owner", "");
      maps.put("modification_time", "");
      maps.put("access_time", "");
      maps.put("group", "");
      maps.put("permission", "");
      maps.put("isDirectory", "true");
      listmap.add(maps);

      for(FileStatus file1 : files) {
         HashMap<String, String> map = new HashMap();
         map.put("path", file1.getPath().toString());
         map.put("name", file1.getPath().getName());
         map.put("length", String.valueOf(file1.getLen()));
         map.put("replication", Integer.toString(file1.getReplication()));
         map.put("blocksize", String.valueOf(file1.getBlockSize()));
         map.put("owner", file1.getOwner());
         Date date = new Date(file1.getModificationTime());
         String modification_time = DateFormatUtils.format(date, "yyyy-MM-dd HH:mm:ss");
         map.put("modification_time", modification_time);
         Date date1 = new Date(file1.getAccessTime());
         String access_time = DateFormatUtils.format(date1, "yyyy-MM-dd HH:mm:ss");
         map.put("access_time", access_time);
         map.put("group", file1.getGroup());
         map.put("permission", file1.getPermission().toString());
         map.put("isDirectory", file1.isDirectory() + "");
         map.put("user", user);
         listmap.add(map);
      }

      if (fs != null) {
         fs.close();
      }

      return listmap;
   }

   public void readHdfsToPipe(List<String> hdfs_filepathlist, String kerberosPath, String user, String hdfsPath, String charset) throws IOException {
      String path1 = kerberosPath + "core-site.xml";
      String path2 = kerberosPath + "hdfs-site.xml";
      String path3 = kerberosPath + "hive-site.xml";
      String path4 = kerberosPath + "mapred-site.xml";
      Configuration conf = new Configuration();
      conf.addResource(new Path(path1));
      conf.addResource(new Path(path2));
      conf.addResource(new Path(path3));
      conf.addResource(new Path(path4));
      conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
      UserGroupInformation.setConfiguration(conf);
      FileSystem fs = null;
      FileOutputStream fos = null;
      FSDataInputStream in = null;

      try {
         fs = FileSystem.get(conf);
         File file = new File(hdfsPath);
         fos = new FileOutputStream(file);

         for(String hdfs_filepath : hdfs_filepathlist) {
            in = fs.open(new Path(hdfs_filepath));
            IOUtils.copyBytes(in, fos, conf, false);
         }
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         if (in != null) {
            IOUtils.closeStream(in);
         }

         if (fos != null) {
            IOUtils.closeStream(fos);
         }

         if (fs != null) {
            fs.close();
         }

      }

   }

   public void delHdfs(String kerberosPath, String user, String hdfsPath) throws RemoteException, IOException {
      String path1 = kerberosPath + "core-site.xml";
      String path2 = kerberosPath + "hdfs-site.xml";
      String path3 = kerberosPath + "hive-site.xml";
      String path4 = kerberosPath + "mapred-site.xml";
      String keytab_path = kerberosPath + "hive.keytab";
      String krb5_path = kerberosPath + "krb5.conf";
      Configuration conf = new Configuration();
      conf.addResource(new Path(path1));
      conf.addResource(new Path(path2));
      conf.addResource(new Path(path3));
      conf.addResource(new Path(path4));
      conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
      System.setProperty("java.security.krb5.conf", krb5_path);
      UserGroupInformation.setConfiguration(conf);
      UserGroupInformation.loginUserFromKeytab(user, keytab_path);
      FileSystem fs = FileSystem.get(conf);
      fs.delete(new Path(hdfsPath), true);
      if (fs != null) {
         fs.close();
      }

   }

   public void addHdfs(String kerberosPath, String user, String hdfsPath) throws RemoteException, IOException {
      String path1 = kerberosPath + "core-site.xml";
      String path2 = kerberosPath + "hdfs-site.xml";
      String path3 = kerberosPath + "hive-site.xml";
      String path4 = kerberosPath + "mapred-site.xml";
      String keytab_path = kerberosPath + "hive.keytab";
      String krb5_path = kerberosPath + "krb5.conf";
      Configuration conf = new Configuration();
      conf.addResource(new Path(path1));
      conf.addResource(new Path(path2));
      conf.addResource(new Path(path3));
      conf.addResource(new Path(path4));
      conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
      System.setProperty("java.security.krb5.conf", krb5_path);
      UserGroupInformation.setConfiguration(conf);
      UserGroupInformation.loginUserFromKeytab(user, keytab_path);
      FileSystem fs = FileSystem.get(conf);
      Path path = new Path(hdfsPath);
      fs.mkdirs(path);
      if (fs != null) {
         fs.close();
      }

   }

   public String test() throws RemoteException, IOException {
      return "this is a test";
   }

   public void writeHdfsToPipe(String kerberosPath, String user, String filePath, String hdfsFile, String charset) {
      String path1 = kerberosPath + "core-site.xml";
      String path2 = kerberosPath + "hdfs-site.xml";
      String path3 = kerberosPath + "hive-site.xml";
      String path4 = kerberosPath + "mapred-site.xml";
      String keytab_path = kerberosPath + "hive.keytab";
      String krb5_path = kerberosPath + "krb5.conf";
      Configuration conf = new Configuration();
      conf.addResource(new Path(path1));
      conf.addResource(new Path(path2));
      conf.addResource(new Path(path3));
      conf.addResource(new Path(path4));
      conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
      System.setProperty("java.security.krb5.conf", krb5_path);
      FileInputStream in = null;
      FileSystem fs = null;
      FSDataOutputStream fsDataOutputStream = null;

      try {
         in = new FileInputStream(new File(filePath));
         UserGroupInformation.setConfiguration(conf);
         UserGroupInformation.loginUserFromKeytab(user, keytab_path);
         fs = FileSystem.get(conf);
         fsDataOutputStream = fs.create(new Path(hdfsFile), true);
         IOUtils.copyBytes(in, fsDataOutputStream, conf);
      } catch (Exception e) {
         e.printStackTrace();
         if (in != null) {
            IOUtils.closeStream(in);
         }

         if (fsDataOutputStream != null) {
            IOUtils.closeStream(fsDataOutputStream);
         }

         if (fs != null) {
            try {
               fs.close();
            } catch (IOException e1) {
               e1.printStackTrace();
            }
         }
      }

   }

   public static void main(String[] args) throws IOException {
      HiveRMI h = new HiveRMI();
      h.getHdfsList("D:\\tdh_kerberos\\146\\", "hive", "hdfs://nameservice1/tmp/");
   }
}
