package com.chenyang.nse.bussiness.rulesupply.controller;

import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.annot.PullRegister;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.jar.db.TCoreClientInfo;
import com.chenyang.nse.bussiness.jar.db.TCoreClientInfoDao;
import com.chenyang.nse.bussiness.jar.db.TCoreClientRuleChangeLog;
import com.chenyang.nse.bussiness.jar.db.TCoreClientRuleChangeLogDao;
import com.chenyang.nse.bussiness.jar.util.JarClientUtil;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.tools.strategy.StrategyData;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"core"})
public class EncryptionStrategyController {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected StrategyData strategyData;
   @Autowired
   private TCoreClientInfoDao clientInfoDao;
   @Autowired
   private TCoreClientRuleChangeLogDao ruleChangeLogDao;
   @Autowired
   private TdataProjectService tdataProjectService;

   @PassToken
   @RequestMapping({"/encryptionrule"})
   @PullRegister
   public String encryptionrule(@RequestParam(required = false) String projectid, HttpServletRequest request, HttpServletResponse response) throws IOException {
      this.logger.info("projectid={}", projectid);
      Map<String, String> params = JarClientUtil.getRequestParamsMap(request);
      String projectId = (String)params.get("projectId");
      String remoteHost = (String)params.get("remoteHost");
      String remotePort = (String)params.get("remotePort");
      Properties props = null;

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String isQueryEnc = props.getProperty("is_encrypted");
         JarClientUtil.log(remoteHost, Integer.parseInt(remotePort), "开始同步加密策略...");
         String strategyjson = "";
         if ("0".equals(isQueryEnc)) {
            strategyjson = this.strategyData.getEncryptionData(projectId, "0", "5", "44");
         } else {
            strategyjson = this.strategyData.getEncryptionData(projectId, "5", "44");
         }

         JarClientUtil.log(remoteHost, Integer.parseInt(remotePort), "加密策略同步完成!同步内容为：" + strategyjson);
         TCoreClientInfo clientInfo = this.clientInfoDao.queryJarClients(remoteHost, Integer.parseInt(remotePort), projectId);
         if (clientInfo != null) {
            TCoreClientRuleChangeLog log = new TCoreClientRuleChangeLog();
            log.setRule_str(strategyjson);
            log.setT_client_id(clientInfo.getId());
            log.setCreate_time((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(new Date()));
            this.ruleChangeLogDao.save(log);
         }

         return strategyjson;
      } catch (Exception e) {
         e.printStackTrace();
         return "";
      }
   }

   @PassToken
   @RequestMapping({"/pullAllEncryptionRules"})
   public String encryptionrule() throws IOException {
      try {
         String strategyjson = this.strategyData.getEncryptionData("", "5", "44");
         return strategyjson;
      } catch (Exception e) {
         e.printStackTrace();
         return "";
      }
   }

   @PassToken
   @RequestMapping({"/digestrule"})
   @PullRegister
   public String digestrule(@RequestParam(required = false) String projectid, HttpServletRequest request, HttpServletResponse response) throws IOException {
      this.logger.info("projectid={}", projectid);
      Map<String, String> params = JarClientUtil.getRequestParamsMap(request);
      String projectId = (String)params.get("projectId");
      String remoteHost = (String)params.get("remoteHost");
      String remotePort = (String)params.get("remotePort");

      try {
         JarClientUtil.log(remoteHost, Integer.parseInt(remotePort), "开始同步数据完整性校验策略...");
         String strategyjson = this.strategyData.getDigestData(projectId);
         JarClientUtil.log(remoteHost, Integer.parseInt(remotePort), "数据完整性校验策略同步完成!同步内容为：" + strategyjson);
         return strategyjson;
      } catch (Exception e) {
         e.printStackTrace();
         return "";
      }
   }
}
