package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoveryVersrionDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryVersrion;
import com.chenyang.nse.bussiness.service.core.DiscoveryVersrionService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiscoveryVersrionServiceImpl implements DiscoveryVersrionService {
   @Autowired
   private TcoreDiscoveryVersrionDao tcoreDiscoveryVersrionDao;

   public List<TcoreDiscoveryVersrion> queryTcoreDiscoveryVersriont(PageInfo pageInfo, String taskid) {
      List<TcoreDiscoveryVersrion> list = this.tcoreDiscoveryVersrionDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      return list;
   }

   public List<TcoreDiscoveryVersrion> queryTcoreDiscoveryVersriont(String taskid, String version) {
      List<TcoreDiscoveryVersrion> list = this.tcoreDiscoveryVersrionDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("taskversion", version)});
      return list;
   }

   public void save(TcoreDiscoveryVersrion tcoreDiscoveryVersrion) {
      this.tcoreDiscoveryVersrionDao.save(tcoreDiscoveryVersrion);
   }
}
