package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.bean.DataBase;
import com.chenyang.nse.bussiness.bean.DataCache;
import com.chenyang.nse.bussiness.bean.Schema;
import com.chenyang.nse.bussiness.bean.Table;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreDigestMainDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDigestMain;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionConfigVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.TCoreDigestMainService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.jdbc.QueryBloodTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.number.IntegerTool;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.utils.GHCAUtils;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TCoreDigestMainServiceImpl implements TCoreDigestMainService {
   private static final Logger logger = LoggerFactory.getLogger(TCoreDigestMainServiceImpl.class);
   public static CopyOnWriteArrayList<String> tasktables = new CopyOnWriteArrayList();
   private int maxPackageCount = 100000;
   @Autowired
   private TCoreDigestMainDao tCoreDigestMainDao;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   DataSystemService dataSystemService;
   @Autowired
   MaksingAppDataRuleService maksingAppDataRuleService;
   @Autowired
   EncryptionConfigService encryptionConfigService;

   public void save(TCoreDigestMain tCoreDigestMain) {
      String datasystemid = tCoreDigestMain.getDatasystemid();
      String projectid = tCoreDigestMain.getProjectid();
      String schema = tCoreDigestMain.getSchemaname();
      String table = tCoreDigestMain.getTablename();
      String digestfield = tCoreDigestMain.getDigestfield();
      TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectid), Restrictions.eq("datasystemid", datasystemid), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", table)});
      digestMain.setDigestfield(digestfield);
      digestMain.setUpdatetime(new Date());
      digestMain.setUpdateuser(CommonUtils.loginUsername());
      this.tCoreDigestMainDao.update(digestMain);
   }

   public TCoreDigestMain query(String datasystemid, String projectid, String schema, String table) {
      TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectid), Restrictions.eq("datasystemid", datasystemid), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", table)});
      if (digestMain == null) {
         TCoreDigestMain tCoreDigestMain1 = new TCoreDigestMain();
         tCoreDigestMain1.setDatasystemid(datasystemid);
         tCoreDigestMain1.setProjectid(projectid);
         tCoreDigestMain1.setSchemaname(schema);
         tCoreDigestMain1.setTablename(table);
         tCoreDigestMain1.setFlag("0");
         tCoreDigestMain1.setId(StringTool.getTablePrimaryKey());
         tCoreDigestMain1.setCreatetime(new Date());
         tCoreDigestMain1.setCreateuser(CommonUtils.loginUsername());
         tCoreDigestMain1.setDigestfield("");
         this.tCoreDigestMainDao.save(tCoreDigestMain1);
         return tCoreDigestMain1;
      } else {
         return digestMain;
      }
   }

   public Map<String, Object> queryDatasystemInfo(String projectId, String dataSystemId) {
      Map<String, Object> result = new HashMap();
      TCoreDataProject tCoreDataProject = (TCoreDataProject)this.tCoreDataProjectDao.get(projectId);
      result.put("projectName", tCoreDataProject.getProject());
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      result.put("datasystemName", datasystem.getSysname());
      result.put("dbType", datasystem.getDbtype());
      result.put("ip", datasystem.getDbip());
      result.put("port", datasystem.getDbport());
      List<TCoreDatasourceSchema> schemas = this.dataSystemService.querySchemas(projectId, dataSystemId);
      StringBuilder bb = new StringBuilder();
      if (null != schemas) {
         for(TCoreDatasourceSchema schema : schemas) {
            if (null != schema.getSchemaname()) {
               bb.append(schema.getSchemaname());
               bb.append(",");
            }
         }
      }

      if (null != bb) {
         result.put("schema", bb.toString().substring(0, bb.toString().lastIndexOf(44)));
      } else {
         result.put("schema", "");
      }

      int totalTableCount = 0;
      int digesttablecount = 0;
      int digestcolumncount = 0;
      List<TCoreDatasourceSchema> schemaList = this.dataSystemService.querySchemas(projectId, dataSystemId);
      Connection connection = JdbcTool.getConnection(datasystem);

      for(TCoreDatasourceSchema schema : schemaList) {
         totalTableCount = (int)((double)totalTableCount + QueryBloodTool.getTabelNum(datasystem, connection, schema.getSchemaname(), datasystem.getDbtype()));
         digesttablecount += this.getdigesttablecount(dataSystemId, schema.getSchemaname(), projectId);
         List<TCoreDigestMain> tCoreDigestMains = this.tCoreDigestMainDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystemid", dataSystemId), Restrictions.eq("schemaname", schema.getSchemaname())});
         if (tCoreDigestMains != null && tCoreDigestMains.size() != 0) {
            for(TCoreDigestMain digestMain : tCoreDigestMains) {
               if (StringUtils.isNotBlank(digestMain.getDigestfield())) {
                  String[] dig = digestMain.getDigestfield().split("#");
                  digestcolumncount += dig.length;
               }
            }
         }
      }

      result.put("digesttablecount", digesttablecount);
      result.put("undigesttablecount", totalTableCount - digesttablecount);
      result.put("digestcolumncount", digestcolumncount);
      return result;
   }

   public Map<String, Object> querytableInfo(String dataSystemId, String projectId, String schema, String tableName) {
      List<ColumnInfoVO> columnInfoVOS = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableName);
      Map<String, Object> result = new HashMap();
      result.put("totalColumnCount", columnInfoVOS.size());
      TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystemid", dataSystemId), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", tableName)});
      int digestColumnCount = 0;
      int jiamiTasktotalCounts = 0;
      String operator = "";
      Date operationTime = null;
      if (digestMain != null) {
         String digestfield = digestMain.getDigestfield();
         if (StringUtils.isNotBlank(digestfield)) {
            digestColumnCount = digestfield.split("#").length;
         }

         if (StringUtils.isNotBlank(digestMain.getUpdateuser())) {
            operator = digestMain.getUpdateuser();
         } else {
            operator = digestMain.getCreateuser();
         }

         if (digestMain.getUpdatetime() != null) {
            operationTime = digestMain.getUpdatetime();
         } else {
            operationTime = digestMain.getCreatetime();
         }
      }

      result.put("digestColumnCount", digestColumnCount);
      result.put("operator", operator);
      result.put("operationTime", operationTime);
      return result;
   }

   public void generatedigest(String dataSystemId, String projectId, String schema, String tableName) {
      TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystemid", dataSystemId), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", tableName)});
      digestMain.setFlag("1");
      this.tCoreDigestMainDao.update(digestMain);
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId);
      Connection connection = JdbcTool.getConnection(tCoreDatasystem);
      boolean isKeepReadData = true;
      String tableString = projectId + "_" + dataSystemId + "_" + schema + "_" + tableName;
      String digestfields = digestMain.getDigestfield();
      String[] digests = digestfields.split("#");
      if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
         try {
            MongoClient connect = MongodbTool.connect(tCoreDatasystem.getDbservername(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"), tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), true);
            MongoDatabase db = connect.getDatabase(schema);
            MongoCollection<Document> collection = db.getCollection(tableName);
            Bson sort = Filters.eq("_id", 1);
            int count = 0;
            int max = 100000;

            while(true) {
               FindIterable<Document> find = collection.find().sort(sort).skip(count).limit(max);
               MongoCursor<Document> cursor = find.iterator();
               List<Document> results = new ArrayList();

               while(cursor.hasNext()) {
                  results.add(cursor.next());
               }

               if (results.size() == 0) {
                  return;
               }

               for(Document document : results) {
                  String pk = MongodbTool.getDocumentValue("_id", document);
                  Bson eq = Filters.eq("_id", pk);

                  for(int i = 0; i < digests.length; ++i) {
                     String value = MongodbTool.getDocumentValue(digests[i], document);
                     String value1 = SM3Utils.encrypt(value);
                     collection.updateMany(eq, new Document("$set", new Document(digests[i] + PropertyGhcaUtil.digestSuffix, value1)));
                  }
               }

               count += max;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
         try {
            EsUtil esUtil = new EsUtil();
            ClientInterface connect = GHCAUtils.getInstance().connectToES(tCoreDatasystem.getDbip(), tCoreDatasystem.getDbport(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"));

            for(int i = 0; i < digests.length; ++i) {
               boolean updateFlag = true;

               while(updateFlag) {
                  try {
                     updateFlag = false;
                     esUtil.addColumnCopy(connect, schema, tableName, digests[i], PropertyGhcaUtil.digestSuffix);
                     Thread.sleep(200L);
                  } catch (Exception var45) {
                     updateFlag = true;
                  }
               }
            }

            int count = 0;
            int max = 100000;

            while(true) {
               List<MetaMap> esDatas = esUtil.queryAllColumn(connect, schema, tableName, count, max);
               if (esDatas.size() == 0) {
                  return;
               }

               count += max;

               for(MetaMap data : esDatas) {
                  String id = data.getId();

                  for(int i = 0; i < digests.length; ++i) {
                     String value = EsUtil.getDocumentValue(digests[i], data);
                     String newValue = SM3Utils.encrypt(value);
                     data = EsUtil.putDocumentValue(digests[i] + PropertyGhcaUtil.digestSuffix, newValue, data);
                  }

                  connect.updateDocument(schema, tableName, id, data, "refresh=wait_for");
               }

               count += max;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         try {
            if (tasktables != null) {
               tasktables.add(tableString);
            }

            connection.setAutoCommit(false);
            if ("ORACLE".equals(tCoreDatasystem.getDbtype())) {
               addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
            } else if (!"POSTGRESQL".equals(tCoreDatasystem.getDbtype()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
               if ("GREENPLUM".equals(tCoreDatasystem.getDbtype())) {
                  addTableField(connection, schema, tableName, digests);
               } else if ("GAUSS".equals(tCoreDatasystem.getDbtype())) {
                  addTableField(connection, schema, tableName, digests);
               } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  addhivetdhTableField(connection, schema, tableName, digests);
               } else if ("MSSQLSERVER".equals(tCoreDatasystem.getDbtype())) {
                  addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
               } else if ("DM".equals(tCoreDatasystem.getDbtype())) {
                  addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
               } else if ("KINGBASE".equals(tCoreDatasystem.getDbtype())) {
                  addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
               } else if ("DB2".equals(tCoreDatasystem.getDbtype())) {
                  addDB2TableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
               } else {
                  addTableField(connection, schema, tableName, digests);
               }
            } else {
               addTableField(connection, schema, tableName, digests);
            }

            List<String> digestilist = Arrays.asList(digests);
            StringBuilder selectStrBuilder = new StringBuilder();
            StringBuilder updateStrBuilder = new StringBuilder();
            String selectSQL = "";
            String updateSQL = "";

            for(int i = 0; i < digests.length; ++i) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     selectStrBuilder.append("" + digests[i] + "").append(",");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                     selectStrBuilder.append(digests[i]).append(",");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
                  } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString())) {
                     selectStrBuilder.append(digests[i]).append(",");
                  } else if (IntegerTool.isNumeric(digests[i])) {
                     selectStrBuilder.append("`" + digests[i] + "`").append(",");
                  } else {
                     selectStrBuilder.append(digests[i]).append(",");
                  }
               } else {
                  selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
               }
            }

            EncryptionConfigVO proEncryptionConfigVO = new EncryptionConfigVO();
            proEncryptionConfigVO.setDatasystem_id(dataSystemId);
            proEncryptionConfigVO.setSchema(schema);
            proEncryptionConfigVO.setTable_name(tableName);
            proEncryptionConfigVO.setProjectId(projectId);
            List<ColumnInfoVO> proColumnInfoVOList = this.encryptionConfigService.queryOriginalList(proEncryptionConfigVO);
            String[] primaryKeys = new String[0];
            String primaryKeyColumns = "";
            int pt = proColumnInfoVOList.size();

            for(int y = 0; y < pt; ++y) {
               String proKey = ((ColumnInfoVO)proColumnInfoVOList.get(y)).getPrimarykey();
               if (proKey.equals("1")) {
                  primaryKeyColumns = primaryKeyColumns + "," + ((ColumnInfoVO)proColumnInfoVOList.get(y)).getColumnname();
               }
            }

            if (!primaryKeyColumns.equals("")) {
               primaryKeyColumns = primaryKeyColumns.substring(1, primaryKeyColumns.length());
               primaryKeys = primaryKeyColumns.split(",");
            }

            StringBuilder orderById = new StringBuilder();
            if (primaryKeys.length > 0) {
               for(int i = 0; i < primaryKeys.length; ++i) {
                  if (!digestilist.contains(primaryKeys[i])) {
                     if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                        selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                     } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                        if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                           selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                        } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                           selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                        } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                           selectStrBuilder.append("" + primaryKeys[i] + "").append(",");
                        } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                           selectStrBuilder.append(primaryKeys[i]).append(",");
                        } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                           selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                        } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                           selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                        } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                           selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                        } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString())) {
                           selectStrBuilder.append(primaryKeys[i]).append(",");
                        } else if (IntegerTool.isNumeric(primaryKeys[i])) {
                           selectStrBuilder.append("`" + primaryKeys[i] + "`").append(",");
                        } else {
                           selectStrBuilder.append(primaryKeys[i]).append(",");
                        }
                     } else {
                        selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                     }

                     orderById.append(primaryKeys[i]).append(",");
                  }
               }
            }

            selectStrBuilder.deleteCharAt(selectStrBuilder.length() - 1);
            orderById.deleteCharAt(orderById.length() - 1);
            if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\" ORDER BY " + orderById.toString();
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName + "";
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
               } else {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
               }
            } else {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
            }

            if (digests.length > 0) {
               for(int i = 0; i < digests.length; ++i) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                     updateStrBuilder.append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix.toUpperCase(Locale.ROOT) + "\"").append(" =? ").append(",");
                  } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                     if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                        updateStrBuilder.append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(" =? ").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                        updateStrBuilder.append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(" =? ").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                        updateStrBuilder.append("" + digests[i] + PropertyGhcaUtil.digestSuffix + "").append(" =? ").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                        updateStrBuilder.append(digests[i] + PropertyGhcaUtil.digestSuffix).append(" =? ").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                        updateStrBuilder.append(digests[i] + PropertyGhcaUtil.digestSuffix).append(" =? ").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                        updateStrBuilder.append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(" =? ").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                        updateStrBuilder.append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(" =? ").append(",");
                     } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString())) {
                        updateStrBuilder.append(digests[i] + PropertyGhcaUtil.digestSuffix).append(" =? ").append(",");
                     } else {
                        updateStrBuilder.append(digests[i] + PropertyGhcaUtil.digestSuffix).append(" =? ").append(",");
                     }
                  } else {
                     updateStrBuilder.append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(" =? ").append(",");
                  }
               }
            }

            updateStrBuilder.deleteCharAt(updateStrBuilder.length() - 1);
            if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
               } else {
                  updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
               }
            } else {
               updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
            }

            int count = 0;
            if (primaryKeys.length > 0) {
               updateSQL = updateSQL + " WHERE ";

               for(int i = 0; i < primaryKeys.length; ++i) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                     updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                  } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                     if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                        updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                        updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                        updateSQL = updateSQL + primaryKeys[i] + "=? ";
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                        updateSQL = updateSQL + primaryKeys[i] + "=? ";
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                        updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                        updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                        updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                     } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString())) {
                        updateSQL = updateSQL + primaryKeys[i] + "=? ";
                     } else if (IntegerTool.isNumeric(primaryKeys[i])) {
                        updateSQL = updateSQL + "`" + primaryKeys[i] + "`=? ";
                     } else {
                        updateSQL = updateSQL + primaryKeys[i] + "=? ";
                     }
                  } else {
                     updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                  }

                  ++count;
                  if (count < primaryKeys.length) {
                     updateSQL = updateSQL + " AND ";
                  }
               }
            }

            PreparedStatement stmt = null;
            ResultSet rs = null;
            ResultSet rsCount = null;
            PreparedStatement pstmt = null;
            Connection selcon = null;
            int bacthMaxCount = 10000;
            int curBacthCount = 0;
            isKeepReadData = true;
            int startRow = 0;
            selcon = JdbcTool.getConnection(tCoreDatasystem);
            selcon.setAutoCommit(false);
            String sqlp = this.getSqlPaging(selectStrBuilder.toString(), selectSQL, tCoreDatasystem);
            stmt = selcon.prepareStatement(sqlp, 1003, 1007);
            stmt.setFetchSize(10);
            rs = stmt.executeQuery();
            Map<String, String> mt = new HashMap();
            ResultSetMetaData rsMetadata = rs.getMetaData();
            int countMT = rsMetadata.getColumnCount();

            for(int i = 1; i < countMT + 1; ++i) {
               String columnNameCol = rsMetadata.getColumnLabel(i);
               String columnTypeCol = rsMetadata.getColumnTypeName(i);
               if (!mt.containsKey(columnNameCol)) {
                  mt.put(columnNameCol, columnTypeCol);
               }
            }

            if (!"DB2".equals(tCoreDatasystem.getDbtype())) {
               rs.close();
               stmt.close();
               selcon.close();
            }

            Statement stmtCount = null;
            stmtCount = connection.createStatement();
            String selectCountTable = "";
            if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
               } else {
                  selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
               }
            } else {
               selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
            }

            rsCount = stmtCount.executeQuery(selectCountTable);
            if (rsCount != null) {
               try {
                  rsCount.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            while(isKeepReadData) {
               PreparedStatement tableDataStatement = null;
               String sql1 = selectStrBuilder.toString();
               String sqlPaging = null;
               if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  sqlPaging = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + selectSQL + " ) TT ) where RN>" + startRow + " AND RN <= " + (startRow + this.maxPackageCount);
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                     if (EdbType.GREENPLUM.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                        sqlPaging = selectSQL + " limit " + this.maxPackageCount + " OFFSET " + startRow;
                     } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.OCEANBASE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                        if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                           sqlPaging = selectSQL + " ORDER BY " + sql1 + " OFFSET " + startRow + " ROWS FETCH NEXT " + this.maxPackageCount + " ROWS ONLY";
                        }
                     } else {
                        sqlPaging = selectSQL + " limit " + startRow + "," + this.maxPackageCount;
                     }
                  } else {
                     sqlPaging = selectSQL + " offset " + startRow + " limit " + this.maxPackageCount;
                  }
               } else {
                  sqlPaging = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + selectSQL + " ) TT ) where RN>" + startRow + " AND RN <= " + (startRow + this.maxPackageCount);
               }

               startRow += this.maxPackageCount;
               System.out.println("-------- 读取数据SQL：" + sqlPaging);
               if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                  tableDataStatement = connection.prepareStatement(sqlPaging, 1004, 1007);
               } else {
                  tableDataStatement = connection.prepareStatement(sqlPaging, 1004, 1008);
               }

               tableDataStatement.setFetchSize(100000);
               ResultSet rs1 = tableDataStatement.executeQuery();
               if (!this.isCanKeepRead(rs1, tCoreDatasystem)) {
                  break;
               }

               pstmt = connection.prepareStatement(updateSQL);
               if ("HIVE".equals(tCoreDatasystem.getDbtype()) || "HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                  if (!rs1.next()) {
                     break;
                  }

                  String value = "";

                  for(int i = 0; i < digests.length; ++i) {
                     value = rs1.getString(digests[i]);
                     if (null != value) {
                        value = SM3Utils.encrypt(value);
                     }

                     pstmt.setString(1 + i, value);
                  }

                  for(int i = 0; i < primaryKeys.length; ++i) {
                     if (("POSTGRESQL".equals(tCoreDatasystem.getDbtype()) || tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) && ((String)mt.get(primaryKeys[i])).toLowerCase().contains("int") && ((String)mt.get(primaryKeys[i])).toLowerCase().contains("serial")) {
                        pstmt.setInt(digests.length + i + 1, Integer.parseInt(rs1.getString(primaryKeys[i])));
                     } else {
                        pstmt.setString(digests.length + i + 1, rs1.getString(primaryKeys[i]));
                     }
                  }

                  pstmt.addBatch();
                  ++curBacthCount;
                  if (curBacthCount == bacthMaxCount) {
                     try {
                        pstmt.executeBatch();
                        connection.commit();
                     } catch (Exception var51) {
                        curBacthCount = 0;
                        continue;
                     }

                     curBacthCount = 0;
                  }
               }

               while(rs1.next()) {
                  for(int i = 0; i < digests.length; ++i) {
                     String value = rs1.getString(digests[i]);
                     if (null != value) {
                        value = SM3Utils.encrypt(value);
                     }

                     pstmt.setString(i + 1, value);
                  }

                  for(int i = 0; i < primaryKeys.length; ++i) {
                     if (!"POSTGRESQL".equals(tCoreDatasystem.getDbtype()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString()) || !((String)mt.get(primaryKeys[i])).toLowerCase().contains("int") && !((String)mt.get(primaryKeys[i])).toLowerCase().contains("serial")) {
                        pstmt.setString(digests.length + i + 1, rs1.getString(primaryKeys[i]));
                     } else {
                        pstmt.setInt(digests.length + i + 1, Integer.parseInt(rs1.getString(primaryKeys[i])));
                     }
                  }

                  pstmt.addBatch();
                  ++curBacthCount;
                  if (curBacthCount == bacthMaxCount) {
                     try {
                        pstmt.executeBatch();
                        connection.commit();
                     } catch (Exception var52) {
                        curBacthCount = 0;
                        continue;
                     }

                     curBacthCount = 0;
                  }
               }

               try {
                  rs1.close();
                  if (curBacthCount == 0) {
                     tableDataStatement.close();
                     pstmt.close();
                  }
               } catch (Exception e) {
                  logger.error(e.getMessage());
               }
            }

            if (curBacthCount > 0) {
               try {
                  pstmt.executeBatch();
                  connection.commit();
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else {
               connection.commit();
            }
         } catch (Exception throwables) {
            if (tasktables != null) {
               tasktables.remove(tableString);
            }

            throwables.printStackTrace();
         }

         if (tasktables != null) {
            tasktables.remove(tableString);
         }

      }
   }

   private boolean isCanKeepRead(ResultSet rs, TCoreDatasystem tCoreDatasystem) throws SQLException {
      if (!"HIVE_TDH".equals(tCoreDatasystem.getDbtype()) && !"HIVE".equals(tCoreDatasystem.getDbtype())) {
         try {
            boolean isCan = true;
            rs.last();
            if (rs.getRow() <= 0) {
               isCan = false;
            }

            rs.beforeFirst();
            System.out.println("isCanKeepRead方法:" + isCan);
            return isCan;
         } catch (Exception e) {
            System.out.println("isCanKeepRead方法" + e.getMessage());
            throw new SQLException(e);
         }
      } else {
         return true;
      }
   }

   public String getSqlPaging(String sql1, String sql2, TCoreDatasystem tCoreDatasystem) {
      String sqlPaging111 = null;
      if (EdbType.DB2.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      } else if (!EdbType.ORACLE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
         if (!EdbType.POSTGRESQL.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !tCoreDatasystem.getDbtype().equalsIgnoreCase(EdbType.GAUSSDB.toString())) {
            if (EdbType.GREENPLUM.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " limit " + 1 + " OFFSET " + 10;
            } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.OCEANBASE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                  sqlPaging111 = sql2 + " ORDER BY " + sql1 + " OFFSET " + 1 + " ROWS FETCH NEXT " + 10 + " ROWS ONLY";
               }
            } else {
               sqlPaging111 = sql2 + " limit " + 1 + "," + 10;
            }
         } else {
            sqlPaging111 = sql2 + " offset " + 1 + " limit " + 10;
         }
      } else {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      }

      return sqlPaging111;
   }

   private static void addTableField(Connection con, String schema, String tableName, String[] digests) throws SQLException {
      String driverName = con.getMetaData().getDriverName();
      if (driverName.toLowerCase(Locale.ROOT).contains("oracle")) {
         driverName = "oracle";
      }

      for(int i = 0; i < digests.length; ++i) {
         String sql = "alter table " + schema + "." + tableName + " add " + digests[i] + PropertyGhcaUtil.digestSuffix;
         if (!EdbType.ORACLE.toString().equalsIgnoreCase(driverName)) {
            sql = sql + " text";
         } else {
            sql = sql + " varchar(1000)";
         }

         PreparedStatement preStatement = con.prepareStatement(sql);

         try {
            preStatement.executeUpdate();
         } catch (SQLException s) {
            s.printStackTrace();
         }

         preStatement.close();
         con.commit();
      }

   }

   private static void addDB2TableField(Connection con, String schema, String tableName, String[] digests) throws SQLException {
      for(int i = 0; i < digests.length; ++i) {
         String sql = "alter table " + schema + "." + tableName + " add column \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\" long varchar";
         PreparedStatement preStatement = con.prepareStatement(sql);

         try {
            preStatement.executeUpdate();
         } catch (SQLException s) {
            s.printStackTrace();
         }

         preStatement.close();
         con.commit();
         CallableStatement cs = con.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
         cs.execute();
         cs.close();
      }

   }

   private static void addhivetdhTableField(Connection con, String schema, String tableName, String[] digests) throws SQLException {
      Set<String> columnMap = JdbcTool.getColumnMap(con, schema, tableName);

      for(int i = 0; i < digests.length; ++i) {
         if (!columnMap.contains(digests[i] + PropertyGhcaUtil.digestSuffix)) {
            String sql = "alter table " + schema + "." + tableName + " add columns(" + digests[i] + PropertyGhcaUtil.digestSuffix + " String)";
            PreparedStatement preStatement = con.prepareStatement(sql);

            try {
               preStatement.executeUpdate();
            } catch (SQLException s) {
               s.printStackTrace();
            }

            preStatement.close();
            con.commit();
         }
      }

   }

   public void deletedigest(String dataSystemId, String projectId, String schema, String tableName) {
      TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystemid", dataSystemId), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", tableName)});
      digestMain.setFlag("0");
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId);
      String tableString = projectId + "_" + dataSystemId + "_" + schema + "_" + tableName;
      if (!"HIVE_TDH".equals(tCoreDatasystem.getDbtype()) && !"ES".equals(tCoreDatasystem.getDbtype())) {
         String digestfields = digestMain.getDigestfield();
         String[] digests = digestfields.split("#");
         if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
            MongoClient connect = null;

            try {
               connect = MongodbTool.connect(tCoreDatasystem.getDbservername(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"), tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), true);
               MongoDatabase db = connect.getDatabase(schema);
               MongoCollection<Document> collection = db.getCollection(tableName);
               FindIterable<Document> find = collection.find();
               MongoCursor<Document> cursor = find.iterator();
               List<Document> results = new ArrayList();

               while(cursor.hasNext()) {
                  results.add(cursor.next());
               }

               for(Document document : results) {
                  String pk = MongodbTool.getDocumentValue("_id", document);
                  Bson eq = Filters.eq("_id", pk);

                  for(int i = 0; i < digests.length; ++i) {
                     collection.updateMany(eq, new Document("$unset", new Document(digests[i] + PropertyGhcaUtil.digestSuffix, "")), (new UpdateOptions()).upsert(true));
                  }
               }

            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            try {
               if (tasktables != null) {
                  tasktables.add(tableString);
               }

               for(int i = 0; i < digests.length; ++i) {
                  Statement stmtInitail = null;
                  String alterColumnToInitialSql = "";
                  Connection conn = JdbcTool.getConnection(tCoreDatasystem);
                  stmtInitail = conn.createStatement();
                  if ("ORACLE".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix.toUpperCase(Locale.ROOT) + "\"";
                  } else if ("POSTGRES".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"";
                  } else if ("GREENPLUM".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"";
                  } else if ("GAUSS".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"";
                  } else if ("MSSQLSERVER".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = this.delColumn(schema, tableName, digests[i] + PropertyGhcaUtil.digestSuffix);
                  } else if ("DM".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"";
                  } else if ("KINGBASE".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"";
                  } else if ("DB2".equals(tCoreDatasystem.getDbtype())) {
                     alterColumnToInitialSql = "ALTER TABLE " + schema + "." + tableName + " DROP COLUMN \"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"";
                  } else {
                     alterColumnToInitialSql = this.delColumn(schema, tableName, digests[i] + PropertyGhcaUtil.digestSuffix);
                  }

                  stmtInitail.executeUpdate(alterColumnToInitialSql);
                  if ("DB2".equals(tCoreDatasystem.getDbtype())) {
                     CallableStatement cs = conn.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
                     cs.execute();
                     cs.close();
                  }
               }
            } catch (SQLException throwables) {
               if (tasktables != null) {
                  tasktables.remove(tableString);
               }

               throwables.printStackTrace();
            }

            if (tasktables != null) {
               tasktables.remove(tableString);
            }

            this.tCoreDigestMainDao.removeById(digestMain.getId());
         }
      }
   }

   private String delColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      return sql;
   }

   public boolean checkdigest(String dataSystemId, String projectId, String schema, String tableName) {
      TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystemid", dataSystemId), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", tableName)});
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId);
      boolean check = true;
      String digestfields = digestMain.getDigestfield();
      String[] digests = digestfields.split("#");
      if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
         try {
            MongoClient connect = MongodbTool.connect(tCoreDatasystem.getDbservername(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"), tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), true);
            MongoDatabase db = connect.getDatabase(schema);
            MongoCollection<Document> collection = db.getCollection(tableName);
            Bson sort = Filters.eq("_id", 1);
            int count = 0;
            int max = 100000;

            while(true) {
               FindIterable<Document> find = collection.find().sort(sort).skip(count).limit(max);
               MongoCursor<Document> cursor = find.iterator();
               List<Document> results = new ArrayList();

               while(cursor.hasNext()) {
                  results.add(cursor.next());
               }

               if (results.size() == 0) {
                  break;
               }

               for(Document document : results) {
                  for(int i = 0; i < digests.length; ++i) {
                     String value = MongodbTool.getDocumentValue(digests[i], document);
                     String value1 = MongodbTool.getDocumentValue(digests[i] + PropertyGhcaUtil.digestSuffix, document);
                     if (value1 != null && !value1.equals(SM3Utils.encrypt(value))) {
                        return false;
                     }
                  }
               }

               count += max;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return check;
      } else if ("ES".equals(tCoreDatasystem.getDbtype())) {
         try {
            EsUtil esUtil = new EsUtil();
            ClientInterface connect = GHCAUtils.getInstance().connectToES(tCoreDatasystem.getDbip(), tCoreDatasystem.getDbport(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"));
            int count = 0;
            int max = 100000;

            while(true) {
               List<MetaMap> esDatas = esUtil.queryAllColumn(connect, schema, tableName, count, max);
               if (esDatas.size() == 0) {
                  break;
               }

               count += max;

               for(MetaMap data : esDatas) {
                  for(int i = 0; i < digests.length; ++i) {
                     String value = EsUtil.getDocumentValue(digests[i], data);
                     String newValue = EsUtil.getDocumentValue(digests[i] + PropertyGhcaUtil.digestSuffix, data);
                     if (newValue != null && !newValue.equals(SM3Utils.encrypt(value))) {
                        return false;
                     }
                  }
               }

               count += max;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return check;
      } else {
         try {
            Connection conn = JdbcTool.getConnection(tCoreDatasystem);
            Throwable connect = null;

            try {
               StringBuilder selectStrBuilder = new StringBuilder();
               StringBuilder sqlserverorder = new StringBuilder();
               String selectSQL = "";
               String updateSQL = "";

               for(int i = 0; i < digests.length; ++i) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",").append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix.toUpperCase(Locale.ROOT) + "\"").append(",");
                  } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                     if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                        selectStrBuilder.append("\"" + digests[i] + "\"").append(",").append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                        selectStrBuilder.append("\"" + digests[i] + "\"").append(",").append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                        selectStrBuilder.append(digests[i]).append(",").append(digests[i] + PropertyGhcaUtil.digestSuffix).append(",");
                        sqlserverorder.append(digests[i]).append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                        selectStrBuilder.append(digests[i]).append(",").append(digests[i] + PropertyGhcaUtil.digestSuffix).append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                        selectStrBuilder.append(digests[i]).append(",").append(digests[i] + PropertyGhcaUtil.digestSuffix).append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                        selectStrBuilder.append("\"" + digests[i] + "\"").append(",").append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                        selectStrBuilder.append("\"" + digests[i] + "\"").append(",").append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(",");
                     } else if (!tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.MARIADB.toString())) {
                        selectStrBuilder.append(digests[i]).append(",").append(digests[i] + PropertyGhcaUtil.digestSuffix).append(",");
                     } else {
                        if (IntegerTool.isNumeric(digests[i])) {
                           selectStrBuilder.append("`" + digests[i] + "`").append(",");
                        } else {
                           selectStrBuilder.append(digests[i]).append(",");
                        }

                        selectStrBuilder.append(digests[i] + PropertyGhcaUtil.digestSuffix).append(",");
                     }
                  } else {
                     selectStrBuilder.append("\"" + digests[i] + "\"").append(",").append("\"" + digests[i] + PropertyGhcaUtil.digestSuffix + "\"").append(",");
                  }
               }

               selectStrBuilder.deleteCharAt(selectStrBuilder.length() - 1);
               if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  sqlserverorder.deleteCharAt(sqlserverorder.length() - 1);
               }

               if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
                  } else {
                     selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
                  }
               } else {
                  selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
               }

               boolean isKeepReadData = true;
               int startRow = 0;
               Connection selcon = JdbcTool.getConnection(tCoreDatasystem);
               String sqlp = this.getSqlPaging(selectStrBuilder.toString(), selectSQL, tCoreDatasystem);
               Statement s1 = selcon.prepareStatement(sqlp, 1003, 1007);
               s1.setFetchSize(10);
               ResultSet rsCount = null;
               if (rsCount != null) {
                  try {
                     rsCount.close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }
               }

               Connection connection = JdbcTool.getConnection(tCoreDatasystem);

               while(isKeepReadData && check) {
                  PreparedStatement tableDataStatement = null;
                  String sql1 = selectStrBuilder.toString();
                  String sql3 = sqlserverorder.toString();
                  String sqlPaging = null;
                  if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                     sqlPaging = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + selectSQL + " ) TT ) where RN>" + startRow + " AND RN <= " + (startRow + this.maxPackageCount);
                  } else if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                        if (EdbType.GREENPLUM.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                           sqlPaging = selectSQL + " limit " + this.maxPackageCount + " OFFSET " + startRow;
                        } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                           if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                              sqlPaging = selectSQL + " ORDER BY " + sql3 + " OFFSET " + startRow + " ROWS FETCH NEXT " + this.maxPackageCount + " ROWS ONLY";
                           }
                        } else {
                           sqlPaging = selectSQL + " limit " + startRow + "," + this.maxPackageCount;
                        }
                     } else {
                        sqlPaging = selectSQL + " offset " + startRow + " limit " + this.maxPackageCount;
                     }
                  } else {
                     sqlPaging = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + selectSQL + " ) TT ) where RN>" + startRow + " AND RN <= " + (startRow + this.maxPackageCount);
                  }

                  startRow += this.maxPackageCount;
                  System.out.println("-------- 读取数据SQL：" + sqlPaging);
                  if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                     tableDataStatement = connection.prepareStatement(sqlPaging, 1004, 1007);
                  } else {
                     tableDataStatement = connection.prepareStatement(sqlPaging, 1004, 1008);
                  }

                  tableDataStatement.setFetchSize(100000);
                  ResultSet rs1 = tableDataStatement.executeQuery();
                  if (!this.isCanKeepRead(rs1, tCoreDatasystem)) {
                     isKeepReadData = false;
                     return check;
                  }

                  if ("HIVE".equals(tCoreDatasystem.getDbtype()) || "HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
                     if (!rs1.next()) {
                        return check;
                     }

                     for(int i = 0; i < digests.length; ++i) {
                        String value = rs1.getString(digests[i]);
                        String value1 = rs1.getString(digests[i] + PropertyGhcaUtil.digestSuffix);
                        if (value1 != null && !value1.equals(SM3Utils.encrypt(value))) {
                           boolean var32 = false;
                           return var32;
                        }
                     }
                  }

                  while(rs1.next()) {
                     for(int i = 0; i < digests.length; ++i) {
                        String value = rs1.getString(digests[i]);
                        String value1 = rs1.getString(digests[i] + PropertyGhcaUtil.digestSuffix);
                        if (value1 != null && !value1.equals(SM3Utils.encrypt(value))) {
                           boolean var85 = false;
                           return var85;
                        }
                     }
                  }
               }

               return check;
            } catch (Throwable var50) {
               connect = var50;
               throw var50;
            } finally {
               if (conn != null) {
                  if (connect != null) {
                     try {
                        conn.close();
                     } catch (Throwable var46) {
                        connect.addSuppressed(var46);
                     }
                  } else {
                     conn.close();
                  }
               }

            }
         } catch (Exception e) {
            e.printStackTrace();
            return check;
         }
      }
   }

   public void taskgeneratedigest(TCoreDigestMain digestMain) {
      String dataSystemId = digestMain.getDatasystemid();
      String schema = digestMain.getSchemaname();
      String tableName = digestMain.getTablename();
      String projectId = digestMain.getProjectid();
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId);
      String tableString = projectId + "_" + dataSystemId + "_" + schema + "_" + tableName;
      if (tasktables != null) {
         tasktables.add(tableString);
      }

      String digestfields = digestMain.getDigestfield();
      String[] digests = digestfields.split("#");
      Connection connection = JdbcTool.getConnection(tCoreDatasystem);
      boolean isKeepReadData = true;
      int maxPackageCount = 100000;

      try {
         connection.setAutoCommit(false);
         if ("ORACLE".equals(tCoreDatasystem.getDbtype())) {
            addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
         } else if ("POSTGRES".equals(tCoreDatasystem.getDbtype())) {
            addTableField(connection, schema, tableName, digests);
         } else if ("GREENPLUM".equals(tCoreDatasystem.getDbtype())) {
            addTableField(connection, schema, tableName, digests);
         } else if ("GAUSS".equals(tCoreDatasystem.getDbtype())) {
            addTableField(connection, schema, tableName, digests);
         } else if ("MSSQLSERVER".equals(tCoreDatasystem.getDbtype())) {
            addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
         } else if ("HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
            addhivetdhTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
         } else if ("DM".equals(tCoreDatasystem.getDbtype())) {
            addTableField(connection, "\"" + schema + "\"", "\"" + tableName + "\"", digests);
         } else {
            addTableField(connection, schema, tableName, digests);
         }

         connection.commit();
         List<String> digestilist = Arrays.asList(digests);
         StringBuilder selectStrBuilder = new StringBuilder();
         StringBuilder updateStrBuilder = new StringBuilder();
         String selectSQL = "";
         String updateSQL = "";

         for(int i = 0; i < digests.length; ++i) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  selectStrBuilder.append(digests[i]).append(",");
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  selectStrBuilder.append(digests[i]).append(",");
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
               } else if (tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
                  if (IntegerTool.isNumeric(digests[i])) {
                     selectStrBuilder.append("`" + digests[i] + "`").append(",");
                  } else {
                     selectStrBuilder.append(digests[i]).append(",");
                  }
               } else {
                  selectStrBuilder.append(digests[i]).append(",");
               }
            } else {
               selectStrBuilder.append("\"" + digests[i] + "\"").append(",");
            }
         }

         EncryptionConfigVO proEncryptionConfigVO = new EncryptionConfigVO();
         proEncryptionConfigVO.setDatasystem_id(dataSystemId);
         proEncryptionConfigVO.setSchema(schema);
         proEncryptionConfigVO.setTable_name(tableName);
         proEncryptionConfigVO.setProjectId(projectId);
         List<ColumnInfoVO> proColumnInfoVOList = this.encryptionConfigService.queryOriginalList(proEncryptionConfigVO);
         String[] primaryKeys = new String[0];
         String primaryKeyColumns = "";
         int pt = proColumnInfoVOList.size();

         for(int y = 0; y < pt; ++y) {
            String proKey = ((ColumnInfoVO)proColumnInfoVOList.get(y)).getPrimarykey();
            if (proKey.equals("1")) {
               primaryKeyColumns = primaryKeyColumns + "," + ((ColumnInfoVO)proColumnInfoVOList.get(y)).getColumnname();
            }
         }

         if (!primaryKeyColumns.equals("") && primaryKeyColumns != null) {
            primaryKeyColumns = primaryKeyColumns.substring(1, primaryKeyColumns.length());
            primaryKeys = primaryKeyColumns.split(",");
         }

         if (primaryKeys.length > 0) {
            for(int i = 0; i < primaryKeys.length; ++i) {
               if (!digestilist.contains(primaryKeys[i])) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                     selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                  } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                     if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                        selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                        selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                        selectStrBuilder.append(primaryKeys[i]).append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                        selectStrBuilder.append(primaryKeys[i]).append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                        selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                        selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                     } else if (tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
                        if (IntegerTool.isNumeric(primaryKeys[i])) {
                           selectStrBuilder.append("`" + primaryKeys[i] + "`").append(",");
                        } else {
                           selectStrBuilder.append(primaryKeys[i]).append(",");
                        }
                     } else {
                        selectStrBuilder.append(primaryKeys[i]).append(",");
                     }
                  } else {
                     selectStrBuilder.append("\"" + primaryKeys[i] + "\"").append(",");
                  }
               }
            }
         }

         selectStrBuilder.deleteCharAt(selectStrBuilder.length() - 1);
         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
            } else {
               selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + schema + "." + tableName;
            }
         } else {
            selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + schema + "\".\"" + tableName + "\"";
         }

         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
            } else {
               updateSQL = "UPDATE " + schema + "." + tableName + " SET " + updateStrBuilder.toString();
            }
         } else {
            updateSQL = "UPDATE \"" + schema + "\".\"" + tableName + "\" SET " + updateStrBuilder.toString();
         }

         updateSQL = updateSQL.substring(0, updateSQL.length() - 1);
         int count = 0;
         if (primaryKeys.length > 0) {
            updateSQL = updateSQL + " WHERE ";

            for(int i = 0; i < primaryKeys.length; ++i) {
               if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
               } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                  if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                     updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                     updateSQL = updateSQL + primaryKeys[i] + "=? ";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     updateSQL = updateSQL + primaryKeys[i] + "=? ";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                     updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                     updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
                     if (IntegerTool.isNumeric(primaryKeys[i])) {
                        updateSQL = updateSQL + "`" + primaryKeys[i] + "`=? ";
                     } else {
                        updateSQL = updateSQL + primaryKeys[i] + "=? ";
                     }
                  } else {
                     updateSQL = updateSQL + primaryKeys[i] + "=? ";
                  }
               } else {
                  updateSQL = updateSQL + "\"" + primaryKeys[i] + "\"=? ";
               }

               ++count;
               if (count < primaryKeys.length) {
                  updateSQL = updateSQL + " AND ";
               }
            }
         }

         PreparedStatement stmt = null;
         ResultSet rs = null;
         ResultSet rsCount = null;
         PreparedStatement pstmt = null;
         Connection selcon = null;
         int bacthMaxCount = 10000;
         int curBacthCount = 0;
         int jiamiTaskFinishCounts = 0;
         isKeepReadData = true;
         int startRow = 0;
         selcon = JdbcTool.getConnection(tCoreDatasystem);
         selcon.setAutoCommit(false);
         String sqlp = this.getSqlPaging(selectStrBuilder.toString(), selectSQL, tCoreDatasystem);
         stmt = selcon.prepareStatement(sqlp, 1003, 1007);
         stmt.setFetchSize(10);
         rs = stmt.executeQuery();
         Map<String, String> mt = new HashMap();
         ResultSetMetaData rsMetadata = rs.getMetaData();
         int countMT = rsMetadata.getColumnCount();

         for(int i = 1; i < countMT + 1; ++i) {
            String columnNameCol = rsMetadata.getColumnLabel(i);
            String columnTypeCol = rsMetadata.getColumnTypeName(i);
            if (!mt.containsKey(columnNameCol)) {
               mt.put(columnNameCol, columnTypeCol);
            }
         }

         Statement stmtCount = null;
         stmtCount = connection.createStatement();
         String selectCountTable = "";
         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
            } else {
               selectCountTable = "select count(*) as table_rows from " + schema + "." + tableName;
            }
         } else {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + schema + "\".\"" + tableName + "\"";
         }

         stmtCount.executeQuery(selectCountTable);
         pstmt = connection.prepareStatement(updateSQL);

         while(isKeepReadData) {
            PreparedStatement tableDataStatement = null;
            String sql1 = selectStrBuilder.toString();
            String sqlPaging = null;
            if (tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               sqlPaging = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + selectSQL + " ) TT ) where digest_value is not null and RN>" + startRow + " AND RN <= " + (startRow + this.maxPackageCount);
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                  if (EdbType.GREENPLUM.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                     sqlPaging = selectSQL + " where digest_value is not null limit " + this.maxPackageCount + " OFFSET " + startRow;
                  } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                     if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
                        sqlPaging = selectSQL + " where digest_value is not null  ORDER BY " + sql1 + " OFFSET " + startRow + " ROWS FETCH NEXT " + this.maxPackageCount + " ROWS ONLY";
                     }
                  } else {
                     sqlPaging = selectSQL + " limit " + startRow + "," + this.maxPackageCount;
                  }
               } else {
                  sqlPaging = selectSQL + " where digest_value is not null  offset " + startRow + " limit " + this.maxPackageCount;
               }
            } else {
               sqlPaging = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + selectSQL + " ) TT ) where digest_value is not null and RN>" + startRow + " AND RN <= " + (startRow + this.maxPackageCount);
            }

            startRow += this.maxPackageCount;
            System.out.println("-------- 读取数据SQL：" + sqlPaging);
            if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               tableDataStatement = connection.prepareStatement(sqlPaging, 1004, 1007);
            } else {
               tableDataStatement = connection.prepareStatement(sqlPaging, 1004, 1008);
            }

            tableDataStatement.setFetchSize(100000);
            ResultSet rs1 = tableDataStatement.executeQuery();
            if (!this.isCanKeepRead(rs1, tCoreDatasystem)) {
               isKeepReadData = false;
               break;
            }

            if ("HIVE".equals(tCoreDatasystem.getDbtype()) || "HIVE_TDH".equals(tCoreDatasystem.getDbtype())) {
               if (!rs1.next()) {
                  break;
               }

               String value = "";
               String secretKey = "ghca";

               for(int i = 0; i < digests.length; ++i) {
                  value = value + rs1.getString(digests[i]);
               }

               value = SM3Utils.encrypt(value);
               pstmt.setString(1, value);

               for(int i = 0; i < primaryKeys.length; ++i) {
                  if ("POSTGRES".equals(tCoreDatasystem.getDbtype()) && ((String)mt.get(primaryKeys[i])).toLowerCase().contains("int")) {
                     pstmt.setInt(1 + i + 1, Integer.parseInt(rs1.getString(primaryKeys[i])));
                  } else {
                     pstmt.setString(1 + i + 1, rs1.getString(primaryKeys[i]));
                  }
               }

               pstmt.addBatch();
               ++jiamiTaskFinishCounts;
               ++curBacthCount;
               if (curBacthCount == bacthMaxCount) {
                  try {
                     pstmt.executeBatch();
                     connection.commit();
                  } catch (Exception var48) {
                     curBacthCount = 0;
                     continue;
                  }

                  curBacthCount = 0;
               }
            }

            while(rs1.next()) {
               String value = "";
               String secretKey = "ghca";

               for(int i = 0; i < digests.length; ++i) {
                  value = value + rs1.getString(digests[i]);
               }

               value = SM3Utils.encrypt(value);
               pstmt.setString(1, value);

               for(int i = 0; i < primaryKeys.length; ++i) {
                  if ("POSTGRES".equals(tCoreDatasystem.getDbtype()) && ((String)mt.get(primaryKeys[i])).toLowerCase().contains("int")) {
                     pstmt.setInt(1 + i + 1, Integer.parseInt(rs1.getString(primaryKeys[i])));
                  } else {
                     pstmt.setString(1 + i + 1, rs1.getString(primaryKeys[i]));
                  }
               }

               pstmt.addBatch();
               ++jiamiTaskFinishCounts;
               ++curBacthCount;
               if (curBacthCount == bacthMaxCount) {
                  try {
                     pstmt.executeBatch();
                     connection.commit();
                  } catch (Exception var49) {
                     curBacthCount = 0;
                     continue;
                  }

                  curBacthCount = 0;
               }
            }
         }

         if (curBacthCount > 0) {
            try {
               pstmt.executeBatch();
               connection.commit();
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            connection.commit();
         }
      } catch (Exception e) {
         if (tasktables != null) {
            tasktables.remove(tableString);
         }

         e.printStackTrace();
      }

      if (tasktables != null) {
         tasktables.remove(tableString);
      }

   }

   public Integer getdigesttablecount(String dataSystemId, String schema, String projectid) {
      Integer count = 0;
      List<DataBase> dataBaseList = DataCache.dataList;
      DataBase dataBase = null;
      Optional<DataBase> dataBaseOptional = dataBaseList.stream().filter((d) -> d.getDatasystemid().equals(dataSystemId)).findFirst();
      if (dataBaseOptional.isPresent()) {
         dataBase = (DataBase)dataBaseOptional.get();
         List<Schema> schemas = dataBase.getSchemaList();
         Schema schema1 = null;
         if (schemas != null) {
            Optional<Schema> schemaOptional = schemas.stream().filter((s) -> s.getName().equals(schema)).findFirst();
            if (schemaOptional.isPresent()) {
               schema1 = (Schema)schemaOptional.get();
               List<Table> tableList = schema1.getTableList();
               if (tableList != null || tableList.size() != 0) {
                  for(Table t : tableList) {
                     TCoreDigestMain digestMain = (TCoreDigestMain)this.tCoreDigestMainDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", dataSystemId), Restrictions.eq("projectid", projectid), Restrictions.eq("schemaname", schema), Restrictions.eq("tablename", t.getName())});
                     if (digestMain != null && StringUtils.isNotBlank(digestMain.getDigestfield())) {
                        count = count + 1;
                     }
                  }
               }
            }
         }
      }

      return count;
   }

   @Transactional
   public void digesttask() {
      TCoreDigestMainDao tCoreDigestMainDao = (TCoreDigestMainDao)ApplicationContextProvider.getBean(TCoreDigestMainDao.class);

      for(TCoreDigestMain digestMain : tCoreDigestMainDao.queryAll()) {
         if (!StringUtils.isBlank(digestMain.getDigestfield())) {
            EncryptionConfigVO proEncryptionConfigVO = new EncryptionConfigVO();
            proEncryptionConfigVO.setDatasystem_id(digestMain.getDatasystemid());
            proEncryptionConfigVO.setSchema(digestMain.getSchemaname());
            proEncryptionConfigVO.setTable_name(digestMain.getTablename());
            proEncryptionConfigVO.setProjectId(digestMain.getProjectid());
            List<ColumnInfoVO> proColumnInfoVOList = this.encryptionConfigService.queryOriginalList(proEncryptionConfigVO);
            if (proColumnInfoVOList != null && proColumnInfoVOList.size() != 0) {
               String tableString = digestMain.getProjectid() + "_" + digestMain.getDatasystemid() + "_" + digestMain.getSchemaname() + "_" + digestMain.getTablename();
               if (tasktables == null || !tasktables.contains(tableString)) {
                  this.taskgeneratedigest(digestMain);
               }
            }
         }
      }

   }
}
