package com.chenyang.nse.bussiness.service.webApi.business;

import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class KeyLoader {
   private static final Logger LOGGER = LoggerFactory.getLogger(KeyLoader.class);
   @Autowired
   private TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   @Qualifier("TCoreEncryptionContext")
   private TCoreEncryptionService service;
   @Autowired
   protected TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;

   public MulKey load() {
      MulKey map = new MulKey();

      try {
         List<TCoreEncryptionTypeField> fieldCfgs = this.tCoreEncryptionTypeFieldDao.queryAll();
         if (fieldCfgs != null && fieldCfgs.size() != 0) {
            for(TCoreEncryptionTypeField fieldCfg : fieldCfgs) {
               String encSecId = fieldCfg.getEncryption_secretkey_id();
               if (encSecId != null && !encSecId.isEmpty()) {
                  Map<String, String> secMap = this.service.queryEncryptionInfo(encSecId);
                  if (secMap != null) {
                     String key = (String)secMap.get("secretkey");
                     String id = String.format("%s#$#%s#$#%s#$#%s", fieldCfg.getTschemas(), fieldCfg.getNames(), fieldCfg.getTable_field_id(), fieldCfg.getProjectid());
                     TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.queryUnique(new Criterion[]{Restrictions.eq("id", fieldCfg.getEncryption_secretkey_id())});
                     TCoreEncryption tCoreEncryp = new TCoreEncryption();
                     if (null != tCoreSecretkey) {
                        tCoreEncryp = (TCoreEncryption)this.tCoreEncryptionDao.queryUnique(new Criterion[]{Restrictions.eq("id", tCoreSecretkey.getId())});
                     }

                     String type = "";
                     if (null != tCoreEncryp && null != tCoreEncryp.getEncryption_type() && !"".equals(tCoreEncryp.getEncryption_type())) {
                        type = tCoreEncryp.getEncryption_type();
                     }

                     if (type == null || type.length() == 0) {
                        type = "SM4";
                     }

                     String tkey = "";
                     tkey = key + ":" + type + ":" + fieldCfg.getIslike() + ":" + (StringUtils.isEmpty(fieldCfg.getKeepfirst()) ? "0" : fieldCfg.getKeepfirst()) + ":" + (StringUtils.isEmpty(fieldCfg.getEncdigit()) ? "0" : fieldCfg.getEncdigit()) + ":" + (StringUtils.isEmpty(fieldCfg.getTwoindex()) ? "0" : fieldCfg.getTwoindex());
                     String pid = fieldCfg.getProjectid() + ":" + fieldCfg.getId();
                     map.bKeys.put(id, tkey);
                     map.pKeys.put(pid, key);
                  }
               }
            }

            return map;
         } else {
            return map;
         }
      } catch (Exception e) {
         LOGGER.error(e.getMessage(), e);
         MulKey var3 = new MulKey();
         return var3;
      } finally {
         ;
      }
   }

   static class MulKey {
      public Map<String, String> bKeys = new HashMap();
      public Map<String, String> pKeys = new HashMap();
   }
}
