package com.chenyang.nse.bussiness.tools.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class JacksonUtils {
   private static ObjectMapper objectMapper = new ObjectMapper();
   private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

   public static <T> T fromJson(String jsonStr, Class<T> valueType) {
      try {
         return (T)objectMapper.readValue(jsonStr, valueType);
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public static <T> T readValue(String jsonStr, TypeReference<T> valueTypeRef) {
      try {
         return (T)objectMapper.readValue(jsonStr, valueTypeRef);
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public static String toJSon(Object object) {
      try {
         return objectMapper.writeValueAsString(object);
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public static Map<String, String> convert(String[] paramNames, String json) {
      if (paramNames != null && paramNames.length != 0) {
         Map<String, String> result = new HashMap(paramNames.length);
         Map<String, String> map = null;

         try {
            map = (Map)objectMapper.readValue(json, new TypeReference<Map<String, String>>() {
            });
         } catch (Exception e) {
            e.printStackTrace();
         }

         for(String name : paramNames) {
            result.put(name, map.get(name));
         }

         return result.isEmpty() ? null : result;
      } else {
         return null;
      }
   }

   public static boolean isIntact(Map<String, String> map, String[] canNullKeys) {
      Set<String> keys = map.keySet();

      for(String name : canNullKeys) {
         keys.remove(name);
      }

      if (keys.isEmpty()) {
         return true;
      } else {
         for(String key : keys) {
            String value = (String)map.get(key);
            if (value == null || "".equals(value.trim())) {
               return false;
            }
         }

         return true;
      }
   }

   public static Map<String, Object> parseJsonToMap(String jsonStr) {
      try {
         return (Map)objectMapper.readValue(jsonStr, Map.class);
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public static String toIntactJson(Object obj) {
      String allJsonParams = toJSon(obj);
      Map<String, Object> allMap = parseJsonToMap(allJsonParams);
      if (allMap != null) {
      }

      Set<String> keys = allMap.keySet();
      Map<String, Object> intactMap = new HashMap();

      for(String theKey : keys) {
         if (allMap.get(theKey) != null && !"errorCodeList".equals(theKey) && !"secureKey".equals(theKey)) {
            intactMap.put(theKey, allMap.get(theKey));
         }
      }

      return toJSon(intactMap);
   }

   static {
      objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
   }
}
