package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.TCoreConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemoracleDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationsourceDao;
import com.chenyang.nse.bussiness.entity.Column;
import com.chenyang.nse.bussiness.entity.Table;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.db.DbInfo;
import com.chenyang.nse.bussiness.entity.db.ForeignKeyInfo;
import com.chenyang.nse.bussiness.entity.db.IndexInfo;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.db.TableInfo;
import com.chenyang.nse.bussiness.entity.db.TypeInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemoracle;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreTablestructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TableJoinsInfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.dataproject.TableJoinsInfoService;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import com.chenyang.nse.bussiness.tools.net.NetTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.springframework.beans.factory.annotation.Autowired;

public class JdbcTool {
   private static TableInfo tableInfo;
   private static ColumnInfo columnInfo;
   private static PrimaryKeyInfo primaryKeyInfo;
   @Autowired
   private static DesensitizationsourceDao desensitizationsourceDao;
   @Autowired
   private static TCoreConfigDao tCoreConfigDao;
   @Autowired
   private static TableJoinsInfoService tableJoinsInfoService;
   private static List<String> noSizeList = new ArrayList();

   public static boolean hasColumnSize(String columnType) {
      return !noSizeList.contains(columnType) && !columnType.startsWith("TIMESTAMP");
   }

   public static TableInfo getTableInfoInstance() {
      if (tableInfo == null) {
         tableInfo = new TableInfo();
      }

      return tableInfo;
   }

   public static ColumnInfo getColumnInfoInstance() {
      if (columnInfo == null) {
         columnInfo = new ColumnInfo();
      }

      return columnInfo;
   }

   public static PrimaryKeyInfo getPrimaryKeyInfoInstance() {
      if (primaryKeyInfo == null) {
         primaryKeyInfo = new PrimaryKeyInfo();
      }

      return primaryKeyInfo;
   }

   public static boolean testConnection(String ip, String port, String driver, String url, String username, String password) {
      new ResultVO();
      boolean result = NetTool.checkConnect(ip);
      if (!result) {
         return false;
      } else {
         ResultVO resultVO = NetTool.isHostConnectable(ip, Integer.parseInt(port));
         result = resultVO.getResult();
         if (!result) {
            return false;
         } else {
            Connection conn = getConnection(driver, url, username, password);
            if (conn == null) {
               return false;
            } else {
               closeConnection(conn);
               return true;
            }
         }
      }
   }

   public static Connection getConnection(String driver, String url, String username, String password) {
      Connection conn = null;

      try {
         Class.forName(driver);
         Properties props = new Properties();
         props.put("remarksReporting", "true");
         props.put("user", username);
         String DBname = url.substring(url.indexOf(":") + 1);
         int ss = DBname.indexOf(":");
         String typename = DBname.substring(0, ss);
         if (typename.equals("mysql")) {
            if (DBname.substring(ss + 3).contains("/")) {
               props.put("password", password);
            } else {
               props.put("password", "");
            }
         } else {
            props.put("password", password);
         }

         conn = DriverManager.getConnection(url, props);
         return conn;
      } catch (Exception e) {
         e.printStackTrace();
         return conn;
      } finally {
         ;
      }
   }

   public static Connection getconnection(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException {
      Connection conn = null;

      try {
         Class.forName(driver);
         Properties props = new Properties();
         props.put("remarksReporting", "true");
         props.put("user", username);
         String DBname = url.substring(url.indexOf(":") + 1);
         int ss = DBname.indexOf(":");
         String typename = DBname.substring(0, ss);
         if (typename.equals("mysql")) {
            if (DBname.substring(ss + 3).contains("/")) {
               props.put("password", password);
            } else {
               props.put("password", "");
            }
         } else {
            props.put("password", password);
         }

         conn = DriverManager.getConnection(url, props);
         return conn;
      } catch (Exception e) {
         e.printStackTrace();
         return conn;
      } finally {
         ;
      }
   }

   public static Connection getConnectionlog(String driver, String url, String username, String password) throws SQLException, ClassNotFoundException {
      Connection conn = null;
      Class.forName(driver);
      Properties props = new Properties();
      props.put("remarksReporting", "true");
      props.put("user", username);
      String DBname = url.substring(url.indexOf(":") + 1);
      int ss = DBname.indexOf(":");
      String typename = DBname.substring(0, ss);
      if (typename.equals("mysql")) {
         if (DBname.substring(ss + 3).contains("/")) {
            props.put("password", password);
         } else {
            props.put("password", "");
         }
      } else {
         props.put("password", password);
      }

      conn = DriverManager.getConnection(url, props);
      return conn;
   }

   public static Connection getConnection(TCoreDatasystem datasystem) {
      String url = "";
      if (datasystem.getDbtype().equals(EdbType.INFORMIX.toString())) {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername(), datasystem.getServername());
      } else if (!datasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !datasystem.getDbtype().equals(EdbType.MARIADB.toString()) && !datasystem.getDbtype().equals(EdbType.TERADATA.toString())) {
         if ("ES".equals(datasystem.getDbtype())) {
            return null;
         }

         if ("ORACLE".equals(datasystem.getDbtype())) {
            String oracleisins = datasystem.getOracleisins();
            String dbCode = datasystem.getDbtype();
            String dbIp = datasystem.getDbip();
            String dbPort = datasystem.getDbport();
            String dbServerName = datasystem.getDbservername();
            if ("1".equals(oracleisins)) {
               dbCode = "ORACLEINS";
               TCoreDatasystemoracleDao bean = (TCoreDatasystemoracleDao)ApplicationContextProvider.getBean(TCoreDatasystemoracleDao.class);
               List<TCoreDatasystemoracle> tCoreDatasystemoracles = bean.queryInsByDatasnystemId(datasystem.getId());
               dbIp = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsip();
               dbPort = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsport();
               dbServerName = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsname();
            }

            url = EdbType.getUrlByEdbcode(dbCode, dbIp, dbPort, dbServerName);
         } else if (StringUtils.isNotBlank(datasystem.getDbip()) && !datasystem.getDbtype().equals(EdbType.GAUSSDB.getDbcode())) {
            url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername());
         } else {
            String[] ips = datasystem.getDbip().split(",");
            String[] ports = datasystem.getDbport().split(",");
            List<Map<String, String>> ipports = new ArrayList();

            for(int i = 0; i < ips.length; ++i) {
               Map<String, String> map = new HashMap();
               map.put("ip", ips[i]);
               map.put("port", ports[i]);
               ipports.add(map);
            }

            url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), ipports, datasystem.getDbservername(), datasystem.getDbservername());
         }
      } else {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername(), datasystem.getServername(), datasystem.getPagecode());
         url = url + "&useSSL=false&rewriteBatchedStatements=true&serverTimezone=UTC";
      }

      String driver = EdbType.getEdbTypeByDbcode(datasystem.getDbtype()).getDbdriver();
      if ("TDH".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = getKerberosConnOfTDH(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem);
         return conn;
      } else if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = getKerberosConn(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
         return conn;
      } else {
         Connection connection = getConnection(driver, url, datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
         return connection;
      }
   }

   public static Connection getConnectionlog(TCoreDatasystem datasystem) throws ClassNotFoundException, SQLException, IOException {
      String url = "";
      if (datasystem.getDbtype().equals(EdbType.INFORMIX.toString())) {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername(), datasystem.getServername());
      } else if (!datasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !datasystem.getDbtype().equals(EdbType.MARIADB.toString()) && !datasystem.getDbtype().equals(EdbType.TERADATA.toString())) {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername());
      } else {
         url = EdbType.getUrlByEdbcode(datasystem.getDbtype(), datasystem.getDbip(), datasystem.getDbport(), datasystem.getDbservername(), datasystem.getServername(), datasystem.getPagecode());
      }

      String driver = EdbType.getEdbTypeByDbcode(datasystem.getDbtype()).getDbdriver();
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = getKerberosConnlog(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
         return conn;
      } else {
         Connection connection = getConnectionlog(driver, url, datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
         return connection;
      }
   }

   public static void closeConnection(Connection conn) {
      try {
         if (conn != null) {
            conn.close();
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public static Connection getConnection(String url, String username, String password) {
      Connection connection = null;

      try {
         connection = DriverManager.getConnection(url, username, password);
      } catch (Exception throwables) {
         throwables.printStackTrace();
      }

      return connection;
   }

   public static List<TableInfo> getTableInfoByConnection(Connection conn, String schemaPattern, String tableNamePattern) {
      List<TableInfo> list = getTableInfoInstance().getTableInfoByConnection(conn, schemaPattern, tableNamePattern);
      return list;
   }

   public static TableInfo getTableInfo(Connection conn, String schemaPattern, String tableNamePattern) {
      List<TableInfo> list = getTableInfoInstance().getTableInfoByConnection(conn, schemaPattern, tableNamePattern);
      closeConnection(conn);
      return list != null && list.size() > 0 ? (TableInfo)list.get(0) : null;
   }

   /** @deprecated */
   @Deprecated
   public static boolean copyTable(Connection sourceConnection, String sourceSchema, String sourceTableName, Connection targetConnection, String targetSchema, String targetTableName) {
      if (sourceConnection != null && targetConnection != null) {
         EdbType source = DbInfo.getEdbTypeByConnection(sourceConnection);
         EdbType target = DbInfo.getEdbTypeByConnection(targetConnection);
         if (!source.getDbcode().equals(target.getDbcode())) {
            return copyTable(sourceSchema, sourceTableName, sourceConnection, target.getDbcode(), targetSchema, targetTableName, targetConnection);
         } else if (source.getDbcode().equals(EdbType.MYSQL.getDbcode())) {
            copyTableForMySql(sourceConnection, sourceSchema, sourceTableName, targetConnection, targetSchema, targetTableName);
            return true;
         } else if (source.getDbcode().equals(EdbType.ORACLE.getDbcode())) {
            copyTableForOracle(sourceConnection, sourceSchema, sourceTableName, targetConnection, targetSchema, targetTableName);
            return true;
         } else {
            return copyTable(sourceSchema, sourceTableName, sourceConnection, target.getDbcode(), targetSchema, targetTableName, targetConnection);
         }
      } else {
         return false;
      }
   }

   /** @deprecated */
   @Deprecated
   public static void copyTableForOracle(Connection sourceConnection, String sourceSchema, String sourceTableName, Connection targetConnection, String targetSchema, String targetTableName) {
      String sql = getCreateTableSqlForOracle(sourceConnection, sourceSchema, sourceTableName);
      String[] sql_line = sql.split("\\r?\\n");
      List<ColumnInfo> columns = getAllColumnInfo(sourceConnection, sourceSchema, sourceTableName);
      StringBuffer sql_target = new StringBuffer();
      sql_target.append("CREATE TABLE " + targetSchema + "." + targetTableName + "");

      for(int i = 2; i < 2 + columns.size(); ++i) {
         String temp = sql_line[i].trim();
         if (i == columns.size() + 1 && temp.endsWith(",")) {
            temp = temp.substring(0, temp.length() - 1);
         }

         sql_target.append(temp);
      }

      sql_target.append(")");
      executeSql(targetConnection, sql_target.toString());
   }

   /** @deprecated */
   @Deprecated
   public static void copyTableForMySql(Connection sourceConnection, String sourceSchema, String sourceTableName, Connection targetConnection, String targetSchema, String targetTableName) {
      String sql = getCreateTableSqlForMySql(sourceConnection, sourceSchema, sourceTableName);
      String[] sql_line = sql.split("\\r?\\n");
      List<ColumnInfo> columns = getAllColumnInfo(sourceConnection, sourceSchema, sourceTableName);
      StringBuffer sql_target = new StringBuffer();
      sql_target.append("CREATE TABLE `" + targetSchema + "`.`" + targetTableName + "` (");

      for(int i = 1; i < 1 + columns.size(); ++i) {
         String temp = sql_line[i].trim();
         if (i == columns.size() && temp.endsWith(",")) {
            temp = temp.substring(0, temp.length() - 1);
         }

         sql_target.append(temp);
      }

      sql_target.append(")");
      executeSql(targetConnection, sql_target.toString());
   }

   public static String getViewDDL(Connection connection, String schema, String viewName) {
      EdbType dbtype = DbInfo.getEdbTypeByConnection(connection);
      if (dbtype == null) {
         return null;
      } else if (dbtype.getDbcode().equals(EdbType.ORACLE.getDbcode())) {
         return getViewDDLForOracle(connection, schema, viewName);
      } else if (dbtype.getDbcode().equals(EdbType.DB2.getDbcode())) {
         return getViewDDLForDb2(connection, schema, viewName);
      } else if (dbtype.getDbcode().equals(EdbType.MYSQL.getDbcode())) {
         return getViewDDLForMysql(connection, schema, viewName);
      } else if (dbtype.getDbcode().equals(EdbType.MSSQLSERVER.getDbcode())) {
         return getViewDDLForMssqlserver(connection, schema, viewName);
      } else {
         return dbtype.getDbcode().equals(EdbType.SYBASE.getDbcode()) ? getViewDDLForSybase(connection, schema, viewName) : null;
      }
   }

   public static List<String> getAllColumnNameList(Connection cnn, String schema, String tablename) {
      List<String> columnList = new ArrayList();
      DatabaseMetaData dbMetaData = null;
      ResultSet columns = null;

      try {
         dbMetaData = cnn.getMetaData();
         if (schema != null) {
            schema = schema.toUpperCase();
         }

         columns = dbMetaData.getColumns(cnn.getCatalog(), schema, tablename, (String)null);

         while(columns.next()) {
            String col = columns.getObject("COLUMN_NAME").toString();
            columnList.add(col);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (columns != null) {
               columns.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return columnList;
   }

   public static String getViewDDLForDb2(Connection connection, String schema, String viewName) {
      String ddl = "create view " + viewName + " as ";
      String sql = "select * from syscat.views t where t.VIEWNAME=? and t.VIEWSCHEMA=?";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = connection.prepareStatement(sql);
         ps.setString(1, viewName.toUpperCase());
         ps.setString(2, schema.toUpperCase());
         rs = ps.executeQuery();
         if (rs.next()) {
            ddl = rs.getString("TEXT");
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      if (ddl != null) {
         ddl = ddl.toUpperCase();
      }

      return ddl;
   }

   public static String getViewDDLForMysql(Connection connection, String schema, String viewName) {
      String ddl = "create view " + viewName + " as ";
      String sql = "select * from information_schema.views t where t.TABLE_NAME=?";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = connection.prepareStatement(sql);
         ps.setString(1, viewName.toUpperCase());
         rs = ps.executeQuery();
         if (rs.next()) {
            ddl = ddl + rs.getString("VIEW_DEFINITION");
            String table_schema = rs.getString("table_schema");
            ddl = ddl.replaceAll("`", "").replaceAll(table_schema + ".", "");
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      if (ddl != null) {
         ddl = ddl.toUpperCase();
      }

      return ddl;
   }

   public static String getViewDDLForOracle(Connection connection, String schema, String viewName) {
      String ddl = "create view " + viewName + " as ";
      String sql = "select * from dba_views t where t.view_name=? and t.owner=?";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = connection.prepareStatement(sql);
         ps.setString(1, viewName.toUpperCase());
         ps.setString(2, schema.toUpperCase());
         rs = ps.executeQuery();
         if (rs.next()) {
            ddl = ddl + rs.getString("TEXT");
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      if (ddl != null) {
         ddl = ddl.toUpperCase();
      }

      return ddl;
   }

   public static String getViewDDLForSybase(Connection connection, String schema, String viewName) {
      String ddl = "create view " + viewName + " as ";
      String sql = "SELECT * FROM syscomments comments WHERE comments.id=(SELECT id FROM sysobjects t WHERE t.name=? and t.loginame=?)";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = connection.prepareStatement(sql);
         ps.setString(1, viewName.toUpperCase());
         ps.setString(2, schema);
         rs = ps.executeQuery();
         if (rs.next()) {
            ddl = rs.getString("TEXT");
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      if (ddl != null) {
         ddl = ddl.toUpperCase();
      }

      return ddl;
   }

   public static String getViewDDLForMssqlserver(Connection connection, String schema, String viewName) {
      String ddl = "create view " + viewName + " as ";
      String sql = "select * from sys.all_sql_modules def where def.object_id=(SELECT id FROM sysobjects t where t.name=?)";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = connection.prepareStatement(sql);
         ps.setString(1, viewName.toUpperCase());
         rs = ps.executeQuery();
         if (rs.next()) {
            ddl = rs.getString("definition");
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      if (ddl != null) {
         ddl = ddl.toUpperCase();
      }

      return ddl;
   }

   public static boolean copyView(Connection sourceConnection, String sourceSchema, String sourceViewName, Connection targetConnection, String targetSchema) {
      EdbType source = DbInfo.getEdbTypeByConnection(sourceConnection);
      EdbType target = DbInfo.getEdbTypeByConnection(targetConnection);
      if (!source.getDbcode().equals(target.getDbcode())) {
         return false;
      } else {
         String ddl = getViewDDL(sourceConnection, sourceSchema, sourceViewName);
         boolean result = false;

         try {
            targetConnection.prepareStatement(ddl).executeUpdate();
            result = true;
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return result;
      }
   }

   public static List<String> getDataBaseForMySql(Connection cnn) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " show databases ";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<String> getDataBaseForOB(Connection cnn) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = " select username from sys.dba_users ";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e1) {
            e1.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<String> getDataBaseForSqlServer(Connection conn) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = "select name from master.sys.databases";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getObject("name").toString());
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         try {
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<String> getDbSchemas(Connection cnn) {
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         if (cnn.toString().indexOf(EdbType.OCEANBASE.getDbcode().toLowerCase()) >= 0) {
            return getDataBaseForOB(cnn);
         } else {
            DatabaseMetaData dbMetaData = null;
            List<String> list = new ArrayList();
            ResultSet rs = null;

            try {
               dbMetaData = cnn.getMetaData();
               rs = dbMetaData.getSchemas();

               while(rs.next()) {
                  list.add(rs.getObject("TABLE_SCHEM").toString());
               }
            } catch (SQLException e) {
               e.printStackTrace();
            } finally {
               try {
                  if (rs != null) {
                     Statement s = rs.getStatement();
                     rs.close();
                     if (s != null) {
                        s.close();
                     }
                  }
               } catch (SQLException e) {
                  e.printStackTrace();
               }

            }

            List<String> nullArr = new ArrayList();
            nullArr.add(null);
            list.removeAll(nullArr);
            return list;
         }
      } else {
         return getDataBaseForMySql(cnn);
      }
   }

   public static List<String> getTableName(Connection cnn, String schema, String tableNamePattern) {
      List<String> tables = new ArrayList();
      DatabaseMetaData dbMetaData = null;
      String[] types = new String[]{"TABLE"};
      ResultSet rs = null;

      try {
         dbMetaData = cnn.getMetaData();
         if (null != tableNamePattern) {
            tableNamePattern = "%" + tableNamePattern + "%";
         }

         rs = dbMetaData.getTables(cnn.getCatalog(), schema, tableNamePattern, types);

         while(rs.next()) {
            tables.add(rs.getObject("TABLE_NAME").toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               Statement s = rs.getStatement();
               rs.close();
               if (s != null) {
                  s.close();
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return tables;
   }

   public static List<String> getAllTableNameForMySql(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select table_name from information_schema.tables where table_schema='" + database + "' and table_type='BASE TABLE';");
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForInformix(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select tabname from systables where tabtype = 'T'");
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString("tabname"));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForOracle(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select TABLE_NAME from all_tab_comments where TABLE_TYPE='TABLE' and OWNER='" + database + "'");
         rs = ps.executeQuery();

         while(rs.next()) {
            if (rs.getString("TABLE_NAME").indexOf("$") == -1) {
               list.add(rs.getString("TABLE_NAME"));
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForMSSqlServer(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select o.name from sys.objects o join sys.schemas s on o.schema_id = s.schema_id where s.name = '" + database + "' and o.type = 'U'");
         rs = ps.executeQuery();

         while(rs.next()) {
            if (rs.getString("name").indexOf("$") == -1) {
               list.add(rs.getString("name"));
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForKingbase(Connection conn, String database) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("select table_name from information_schema.tables where table_schema = '" + database + "'");
         rs = ps.executeQuery();

         while(rs.next()) {
            if (rs.getString("table_name").indexOf("$") == -1) {
               list.add(rs.getString("table_name"));
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForMySqlLike(Connection conn, String database, String tableNamePattern) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement("use " + database);
         ps.execute();
         if (tableNamePattern == null || tableNamePattern.equals("null")) {
            tableNamePattern = "";
         }

         ps = conn.prepareStatement("SHOW TABLES LIKE '%" + tableNamePattern + "%'");
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString(1));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableNameForOracle(Connection conn, String database, String tableNamePattern) {
      List<String> list = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = "select TABLE_NAME from all_tab_comments where TABLE_TYPE='TABLE' and OWNER='" + database + "'";
         if (tableNamePattern != null && !tableNamePattern.equals("")) {
            sql = sql + " and TABLE_NAME LIKE '%" + tableNamePattern + "%'";
         }

         sql = sql + "order by TABLE_NAME";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString("TABLE_NAME"));
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public static List<String> getAllTableName(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         if (dbtype.equals(EdbType.INFORMIX.getDbcode())) {
            return getAllTableNameForInformix(cnn, schema);
         } else if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllTableNameForOracle(cnn, schema);
         } else if (dbtype.equals(EdbType.MSSQLSERVER.getDbcode())) {
            return getAllTableNameForMSSqlServer(cnn, schema);
         } else if (dbtype.equals(EdbType.KINGBASE.getDbcode())) {
            return getAllTableNameForKingbase(cnn, schema);
         } else {
            List<String> tables = getTableName(cnn, schema, (String)null);
            return tables;
         }
      } else {
         return getAllTableNameForMySql(cnn, schema);
      }
   }

   public static List<String> getAllViewName(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);
      List<String> Views = new ArrayList();

      try {
         if (dbtype.equals(EdbType.MYSQL.getDbcode()) || dbtype.equals(EdbType.RAPIDSDB.getDbcode()) || dbtype.equals(EdbType.POSTGRESQL.getDbcode())) {
            return getAllViewNameForMySql(cnn, schema);
         }

         if (dbtype.equals(EdbType.HIVE.getDbcode())) {
            return getAllViewNameForHive(cnn, schema);
         }

         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllViewNameForOracle(cnn, schema);
         }

         Views = getViewName(cnn, schema, null);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return Views;
   }

   private static List<String> getViewName(Connection cnn, String schema, Object o) throws SQLException {
      List<String> views = new ArrayList();
      String[] types = new String[]{"VIEW"};
      DatabaseMetaData dbMetaData = cnn.getMetaData();
      ResultSet rs = dbMetaData.getTables(cnn.getCatalog(), schema, (String)null, types);

      while(rs.next()) {
         views.add(rs.getObject("TABLE_NAME").toString());
      }

      return views;
   }

   public static List<String> getAllSynonymName(Connection cnn, String schema) {
      String dbtype = getDataBaseType(cnn);

      try {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            return getAllSynonymNameForOracle(cnn, schema);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return new ArrayList();
   }

   private static List<String> getAllSynonymNameForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> synonyms = new ArrayList();
      String sql = "SELECT SYNONYM_NAME , TABLE_NAME FROM DBA_SYNONYMS WHERE TABLE_OWNER = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String SYNONYM_NAME = resultSet.getString("SYNONYM_NAME");
         synonyms.add(SYNONYM_NAME);
      }

      return synonyms;
   }

   private static List<String> getAllViewNameForMySql(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> views = new ArrayList();
      String sql = "select TABLE_NAME,VIEW_DEFINITION from information_schema.VIEWS where TABLE_SCHEMA = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String table_name = resultSet.getString("TABLE_NAME");
         views.add(table_name);
      }

      return views;
   }

   private static List<String> getAllViewNameForHive(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> tables = new ArrayList();
      String sql = "show tables";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String tableName = resultSet.getString("TAB_NAME");
         String result = "";
         sql = "desc formatted " + tableName;
         ResultSet rs = statement.executeQuery(sql);

         while(rs.next()) {
            String col_name = rs.getString("COL_NAME").trim();
            if (col_name.equalsIgnoreCase("Table Type:")) {
               result = rs.getString("DATA_TYPE").trim();
               break;
            }
         }

         if ("VIRTUAL_VIEW".equalsIgnoreCase(result)) {
            tables.add(tableName);
         }
      }

      return tables;
   }

   private static List<String> getAllViewNameForOracle(Connection cnn, String schema) throws SQLException {
      Statement statement = cnn.createStatement();
      List<String> views = new ArrayList();
      String sql = "select VIEW_NAME ,TEXT from DBA_VIEWS where OWNER = '" + schema + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String table_name = resultSet.getString("VIEW_NAME");
         views.add(table_name);
      }

      return views;
   }

   public static String getTableComment(Connection cnn, String schema, String tablename) {
      String dbtype = getDataBaseType(cnn);
      String comment = "";
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            comment = getOracleTableComment(cnn, schema, tablename);
         } else {
            comment = "";
         }
      } else {
         comment = getMysqlTableComment(cnn, schema, tablename);
      }

      return comment;
   }

   private static String getOracleTableComment(Connection cnn, String schema, String tablename) {
      String comment = "";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = "select COMMENTS from all_tab_comments where TABLE_TYPE='TABLE' and OWNER='" + schema + "' and TABLE_NAME='" + tablename + "'";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();
         if (rs.next()) {
            comment = rs.getString("COMMENTS");
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return comment;
   }

   private static String getMysqlTableComment(Connection cnn, String schema, String tablename) {
      String comment = "";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         String sql = "select TABLE_COMMENT from information_schema.TABLES where TABLE_TYPE='BASE TABLE' and TABLE_SCHEMA='" + schema + "' and TABLE_NAME='" + tablename + "'";
         ps = cnn.prepareStatement(sql);
         rs = ps.executeQuery();
         if (rs.next()) {
            comment = rs.getString("TABLE_COMMENT");
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return comment;
   }

   public static List<String> getAllTableNameLike(Connection cnn, String schema, String tableNamePattern) {
      String dbtype = getDataBaseType(cnn);
      List<String> tablelist = null;
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         if (dbtype.equals(EdbType.ORACLE.getDbcode())) {
            tablelist = getAllTableNameForOracle(cnn, schema, tableNamePattern);
         } else {
            tablelist = getTableName(cnn, schema, tableNamePattern);
         }
      } else {
         tablelist = getAllTableNameForMySqlLike(cnn, schema, tableNamePattern);
      }

      List<String> reTablelist = new ArrayList();
      if (null != tablelist) {
         for(int i = 0; i < tablelist.size(); ++i) {
            String tableName = (String)tablelist.get(i);
            if (null != tableName && tableName.indexOf("$") == -1) {
               reTablelist.add(tableName);
            }
         }
      }

      return reTablelist;
   }

   public static List<ColumnInfo> getAllColumnInfo(Connection cnn, String schema, String tablename) {
      getColumnInfoInstance();
      List<ColumnInfo> list = ColumnInfo.getColumnInfoByConnection(cnn, schema, tablename, (String)null);
      return list;
   }

   public static List<TableJoinsInfo> getTableJoinsInfo(Connection cnn, String schema, List<String> tablenamelist, String taskid) {
      List<TableJoinsInfo> list = getTjDDL(cnn, schema, tablenamelist, taskid);
      return list;
   }

   public static List<TableJoinsInfo> getTjDDL(Connection cnn, String schema, List<String> tablenamelist, String taskid) {
      List<TableJoinsInfo> list = new ArrayList();
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      String inparstr = "";

      for(int i = 0; i < tablenamelist.size(); ++i) {
         inparstr = inparstr + "?,";
      }

      inparstr = inparstr.substring(0, inparstr.length() - 1);
      String sql = "select pk_table pkTableName, pk_col pkClounmName, fk_table fkTableName, fk_col fkCloumName, pk_con constraintName, pk_owner pkOwner from (select a.constraint_name pk_con, a.table_name pk_table,b.column_name pk_col, a.owner pk_owner from dba_constraints a,user_cons_columns b where (a.constraint_type='P' or a.constraint_type='U') and a.constraint_name=b.constraint_name and a.owner=b.owner) pk, (select c.constraint_name fk_con, c.table_name fk_table, c.delete_rule del_rule, d.column_name fk_col, c.R_OWNER r_pk_owner, c.R_CONSTRAINT_NAME r_pk_con, c.owner fk_owner from dba_constraints c,user_cons_columns d where c.constraint_type='R' and c.constraint_name=d.constraint_name and c.owner=d.owner) fk where pk.pk_owner=fk.r_pk_owner and pk.pk_con=fk.r_pk_con and pk_table in(" + inparstr + ") and  fk_table in(" + inparstr + ") and pk_owner=? order by pk.pk_con";

      try {
         int i = 0;
         pstmt = cnn.prepareStatement(sql);

         for(i = 0; i < tablenamelist.size(); ++i) {
            pstmt.setString(i + 1, (String)tablenamelist.get(i));
         }

         for(int j = 0; j < tablenamelist.size(); ++j) {
            pstmt.setString(i + 1, (String)tablenamelist.get(j));
            ++i;
         }

         pstmt.setString(i + 1, schema);
         rs = pstmt.executeQuery();

         while(rs.next()) {
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<TableJoinsInfo> getTablePFk(Connection cnn, String schema, List<String> tablenamelist, String taskid) {
      List<TableJoinsInfo> list = getTjDDL(cnn, schema, tablenamelist, taskid);
      return list;
   }

   public static List<String> getAllColumnName(Connection cnn, String schema, String tablename) {
      List<ColumnInfo> list = getAllColumnInfo(cnn, schema, tablename);
      List<String> namelist = new ArrayList();

      for(ColumnInfo columnInfo : list) {
         namelist.add(columnInfo.getColumnname());
      }

      return namelist;
   }

   public static List<String> getPrimaryKeyListForMySql(Connection cnn, String schema, String tablename) {
      List<String> keylist = new ArrayList();
      String sql = "desc " + schema + "." + tablename;

      try {
         PreparedStatement prepareStatement = cnn.prepareStatement(sql);
         ResultSet rs = prepareStatement.executeQuery();

         while(rs.next()) {
            String key = rs.getString("Key");
            if (key.equals("PRI")) {
               keylist.add(rs.getString("Field"));
            }
         }

         prepareStatement.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return keylist;
   }

   public static List<String> getPrimaryKeyList(Connection cnn, String schema, String tablename) {
      EdbType dbtype = DbInfo.getEdbTypeByConnection(cnn);
      if (dbtype.getDbcode().equals(EdbType.MYSQL.getDbcode())) {
         return getPrimaryKeyListForMySql(cnn, schema, tablename);
      } else {
         List<ColumnInfo> list = getAllColumnInfo(cnn, schema, tablename);
         List<String> keylist = new ArrayList();

         for(ColumnInfo columnInfo : list) {
            if ("1".equals(columnInfo.getPrimarykey())) {
               keylist.add(columnInfo.getColumnname());
            }
         }

         return keylist;
      }
   }

   public static boolean isTableExisted(Connection conn, String table) {
      try {
         DatabaseMetaData metaData = conn.getMetaData();
         ResultSet rs = metaData.getTables((String)null, (String)null, table, new String[]{"TABLE"});
         if (rs.next()) {
            return true;
         }
      } catch (SQLException var4) {
      }

      return false;
   }

   public static boolean isFieldExisted(Connection conn, String table, String field) {
      try {
         DatabaseMetaData metaData = conn.getMetaData();
         ResultSet rs = metaData.getColumns((String)null, (String)null, table, field);
         if (rs.next()) {
            return true;
         }
      } catch (SQLException var5) {
      }

      return false;
   }

   public static String getTableDDL(Connection conn, String schema, String tableName) {
      EdbType dbtype = DbInfo.getEdbTypeByConnection(conn);
      if (dbtype == null) {
         return null;
      } else if (dbtype.getDbcode().equals(EdbType.ORACLE.getDbcode())) {
         return getTableDDLForOracle(conn, schema, tableName);
      } else {
         if (!dbtype.getDbcode().equals(EdbType.DB2.getDbcode())) {
            if (dbtype.getDbcode().equals(EdbType.MYSQL.getDbcode())) {
               return getTableDDLForMysql(conn, tableName);
            }

            if (!dbtype.getDbcode().equals(EdbType.MSSQLSERVER.getDbcode()) && dbtype.getDbcode().equals(EdbType.SYBASE.getDbcode())) {
            }
         }

         return null;
      }
   }

   public static String getTableDDLForOracle(Connection conn, String schema, String tableName) {
      String dll = null;
      String sql = " SELECT DBMS_METADATA.GET_DDL(?,?,?) FROM DUAL ";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement(sql);
         ps.setString(1, "TABLE");
         ps.setString(2, tableName);
         ps.setString(3, schema);

         for(ResultSet var10 = ps.executeQuery(); var10.next(); dll = var10.getString(1)) {
         }

         ps.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return dll;
   }

   public static String getTableDDLForMysql(Connection conn, String tableName) {
      String dll = null;
      String sql = " show create table ? ";
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement(sql);
         ps.setString(1, tableName);

         for(ResultSet var9 = ps.executeQuery(); var9.next(); dll = var9.getString(2)) {
         }

         ps.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return dll;
   }

   public static void executeSql(Connection conn, String sql) {
      Statement stmt = null;

      try {
         stmt = conn.createStatement();
         stmt.executeUpdate(sql);
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            stmt.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

   }

   public static int getTableDataCount(Connection conn, String schema, String tableName) {
      int count = 0;
      String sql = "select count(*) cnt from " + schema + "." + tableName;
      if (schema == null || "".equals(schema)) {
         sql = "select count(*) cnt from " + tableName;
      }

      PreparedStatement pstmt = null;
      ResultSet r = null;

      try {
         pstmt = conn.prepareStatement(sql);

         for(r = pstmt.executeQuery(); r.next(); count = r.getInt("cnt")) {
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (r != null) {
               r.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return count;
   }

   public static String queryOracletbspace(Connection conn, String schema, String table) {
      PreparedStatement pstm = null;
      ResultSet rs = null;
      String sql = "SELECT owner as tt ,TABLE_NAME ,TABLESPACE_NAME FROM DBA_TABLES where owner = '" + schema + "' and table_name='" + table + "'";
      String owner = "";

      try {
         Statement stmt = conn.createStatement();
         rs = stmt.executeQuery(sql);
         rs.next();
         owner = rs.getString("TABLESPACE_NAME");
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstm != null) {
               pstm.close();
            }
         } catch (Exception var15) {
         }

      }

      return owner;
   }

   public static String queryInformixtbspace(Connection conn, String schema, String table) {
      PreparedStatement pstm = null;
      ResultSet rs = null;
      String sql = "select  st.dbsname databasename ,st.tabname tabname ,sd.name name from sysmaster:systabnames st, sysmaster:sysdbspaces sd where sd.dbsnum = trunc(st.partnum/(1024*1024))  and st.tabname='" + table + "'";
      String name = "";

      try {
         Statement stmt = conn.createStatement();
         rs = stmt.executeQuery(sql);
         rs.next();
         name = rs.getString("name");
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstm != null) {
               pstm.close();
            }
         } catch (Exception var15) {
         }

      }

      return name;
   }

   public static int queryTableDataCountBySql(Connection conn, String sql) {
      PreparedStatement pstm = null;
      ResultSet rs = null;
      int count = 0;

      try {
         pstm = conn.prepareStatement(sql.toString());
         rs = pstm.executeQuery();
         rs.next();
         count = rs.getInt("count");
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstm != null) {
               pstm.close();
            }
         } catch (Exception var13) {
         }

      }

      return count;
   }

   public static String getDataBaseType(Connection conn) {
      EdbType dbtype = DbInfo.getEdbTypeByConnection(conn);
      return dbtype != null ? dbtype.getDbcode() : null;
   }

   public static String getQueryStringByConnection(Connection conn, String sql, int offset, int limit) {
      String sql_page = null;
      String dbtype = getDataBaseType(conn);
      if (EdbType.DB2.getDbcode().equals(dbtype)) {
         DB2Dialect db2Dialect = new DB2Dialect();
         sql_page = db2Dialect.getLimitString(sql, offset, limit);
      } else if (EdbType.MSSQLSERVER.getDbcode().equals(dbtype)) {
         SQLServerDialect sqlServerDialect = new SQLServerDialect();
         sql_page = sqlServerDialect.getLimitString(sql, offset, limit);
      } else if (EdbType.MYSQL.getDbcode().equals(dbtype)) {
         MySQLDialect mysqlDialect = new MySQLDialect();
         sql_page = mysqlDialect.getLimitString(sql, offset, limit);
      } else if (EdbType.ORACLE.getDbcode().equals(dbtype)) {
         OracleDialect oracleDialect = new OracleDialect();
         sql_page = oracleDialect.getLimitString(sql, offset, limit);
      } else if (EdbType.SYBASE.getDbcode().equals(dbtype)) {
         SybaseDialect sybaseDialect = new SybaseDialect();
         sql_page = sybaseDialect.getLimitString(sql, offset, limit);
      }

      return sql_page;
   }

   public static String queryTableNote(Connection conn, String schema, String table) {
      String note = null;
      String dbtype = getDataBaseType(conn);
      if (dbtype == null) {
         return null;
      } else {
         if ("ORACLE".equals(dbtype)) {
            note = queryTableNoteForOracle(conn, schema, table);
         } else if ("DB2".equals(dbtype)) {
            note = queryTableNoteForDB2(conn, schema, table);
         } else if ("MYSQL".equals(dbtype)) {
            note = queryTableNoteForMysql(conn, schema, table);
         }

         return note;
      }
   }

   public static String queryTableNoteForOracle(Connection conn, String schema, String table) {
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      String sql = XmlTool.getSql("jdbc", "queryTableNoteForORACLE");
      new ArrayList();
      String note = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.setString(1, table);
         pstmt.setString(2, schema);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            note = rs.getString("note");
            if (note != null) {
               break;
            }
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return note;
   }

   public static String queryTableNoteForDB2(Connection conn, String schema, String table) {
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      String sql = XmlTool.getSql("jdbc", "queryTableNoteForDB2");
      new ArrayList();
      String note = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.setString(1, schema);
         pstmt.setString(2, table);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            note = rs.getString("note");
            if (note != null) {
               break;
            }
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return note;
   }

   public static String queryTableNoteForMysql(Connection conn, String schema, String table) {
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      String sql = XmlTool.getSql("jdbc", "queryTableNoteForMYSQL");
      String note = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.setString(1, schema);
         pstmt.setString(2, table);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            note = rs.getString("note");
            if (note != null) {
               break;
            }
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return note;
   }

   public static List<ForeignKeyInfo> queryForeignKey(Connection conn, String schema) {
      return ForeignKeyInfo.getForeignKeyInfoByConnection(conn, schema);
   }

   public static ResultVO testConnect(String url, String driver, String username, String password) {
      boolean result = false;
      ResultVO resultvo = new ResultVO();
      Connection conn = null;

      ResultVO ss;
      try {
         Class.forName(driver);
         String DBname = url.substring(url.indexOf(":") + 1);
         int ssNew = DBname.indexOf(":");
         String typename = DBname.substring(0, ssNew);
         if (typename.equals("mysql")) {
            if (DBname.substring(ssNew + 3).contains("/")) {
               conn = DriverManager.getConnection(url, username, password);
            } else {
               conn = DriverManager.getConnection(url, username, (String)null);
            }
         } else {
            conn = DriverManager.getConnection(url, username, password);
         }

         DatabaseMetaData dmd = conn.getMetaData();
         if (url.startsWith("jdbc:db2")) {
            checkDbVersion(url, resultvo, executeQuerySql(conn));
         } else if (url.startsWith("jdbc:kingbase")) {
            checkDbVersion(url, resultvo, dmd.getDriverVersion());
         } else {
            checkDbVersion(url, resultvo, dmd.getDatabaseProductVersion());
         }

         if (conn != null) {
            result = true;
         }

         return resultvo;
      } catch (Exception e) {
         e.printStackTrace();
         resultvo.setMessage("连接异常，检测失败！");
         ss = resultvo;
      } finally {
         resultvo.setResult(result);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (Exception e) {
            e.printStackTrace();
            resultvo.setMessage("连接异常，检测失败！");
            resultvo.setResult(false);
         }

      }

      return ss;
   }

   private static void checkDbVersion(String url, ResultVO resultvo, String productVersion) {
      if (org.apache.commons.lang3.StringUtils.isNotBlank(productVersion)) {
         if (productVersion.startsWith("Oracle Database")) {
            resultvo.setVersion(productVersion.substring(16, 19));
            System.out.println(productVersion.substring(16, 19));
         } else {
            resultvo.setVersion(productVersion.substring(0, 3));
            System.out.println(productVersion.substring(0, 3));
         }
      }

      if (url.indexOf("jdbc:oracle") >= 0) {
         resultvo.setVersion(productVersion.substring(16, 19));
      } else if (url.indexOf("jdbc:mysql") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 3));
      } else if (url.indexOf("jdbc:sqlserver") >= 0) {
         resultvo.setVersion(productVersion);
      } else if (url.indexOf("jdbc:db2") >= 0) {
         resultvo.setVersion(productVersion.substring(5, 9));
      } else if (url.indexOf("jdbc:hive2") >= 0) {
         resultvo.setVersion(productVersion.split("-")[0]);
      } else if (url.indexOf("jdbc:postgresql") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 3));
      } else if (url.indexOf("jdbc:dm") >= 0) {
         resultvo.setVersion(productVersion.substring(0, 3));
      } else if (url.indexOf("jdbc:kingbase") >= 0) {
         resultvo.setVersion(productVersion);
      }

   }

   public static String getExceptionSrintStackTrace(Exception e) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      return sw.toString();
   }

   public static Throwable getExceptionType(Exception e) {
      return e;
   }

   public static String getExceptionMessage(Exception e) {
      return e.getMessage();
   }

   public static Connection getKerberosConn(String url, String drivername, String loginprincipal, String xmlpath) {
      Configuration conf = new Configuration();
      Connection conn = null;
      conf.set("hadoop.security.authentication", "Kerberos");

      try {
         UserGroupInformation.setConfiguration(conf);
         UserGroupInformation.loginUserFromKeytab(loginprincipal, xmlpath + "/hive.keytab");
         Class.forName(drivername);
         conn = DriverManager.getConnection(url);
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return conn;
   }

   public static Connection getKerberosConnOfTDH(String url, String driver, TCoreDatasystem datasource) {
      Configuration conf = new Configuration();
      Connection conn = null;
      conf.set("hadoop.security.authentication", "Kerberos");

      try {
         String jdbcURL = url + ";authentication=kerberos;kuser=" + datasource.getLoginprincipal() + ";keytab=" + datasource.getKeytab() + ";krb5conf=" + datasource.getKrb5conf();

         try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
         } catch (ClassNotFoundException e) {
            e.printStackTrace();
         }

         conn = DriverManager.getConnection(jdbcURL);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return conn;
   }

   public static Connection getKerberosConnect(String url, String drivername, String loginprincipal, String xmlpath) throws IOException, ClassNotFoundException, SQLException {
      Configuration conf = new Configuration();
      Connection conn = null;
      conf.set("hadoop.security.authentication", "Kerberos");
      UserGroupInformation.setConfiguration(conf);
      UserGroupInformation.loginUserFromKeytab(loginprincipal, xmlpath + "/hive.keytab");
      Class.forName(drivername);
      conn = DriverManager.getConnection(url);
      return conn;
   }

   public static Connection getKerberosConnlog(String url, String drivername, String loginprincipal, String xmlpath) throws SQLException, ClassNotFoundException, IOException {
      Configuration conf = new Configuration();
      Connection conn = null;
      conf.set("hadoop.security.authentication", "Kerberos");
      UserGroupInformation.setConfiguration(conf);
      UserGroupInformation.loginUserFromKeytab(loginprincipal, xmlpath + "/hive.keytab");
      Class.forName(drivername);
      conn = DriverManager.getConnection(url);
      return conn;
   }

   public static List<Column> getAllColumn(Connection cnn, String schema, String tablename) {
      List<Column> columnList = new ArrayList();
      Map<String, Column> primaryColumnMap = new HashMap();
      List<String> primaryKeys = null;
      DatabaseMetaData dbMetaData = null;
      ResultSet columns = null;

      try {
         dbMetaData = cnn.getMetaData();
         columns = dbMetaData.getColumns(cnn.getCatalog(), schema, tablename, (String)null);
         primaryKeys = getPrimaryKeyList(cnn, schema, tablename);
         if (null == primaryKeys) {
            primaryKeys = new ArrayList();
         }

         System.out.println("*********************************************主键" + primaryKeys);

         while(columns.next()) {
            Column col = new Column();
            col.setName(columns.getObject("COLUMN_NAME").toString());
            col.setType(columns.getObject("DATA_TYPE").toString());
            col.setLength(getColumnSize(columns));
            if (primaryKeys.contains(col.getName())) {
               col.setPrimarykey(true);
               primaryColumnMap.put(col.getName(), col);
            } else {
               columnList.add(col);
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (columns != null) {
               columns.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      for(String primaryKey : primaryKeys) {
         columnList.add(primaryColumnMap.get(primaryKey));
      }

      return columnList;
   }

   public static List<Column> getAllColumnIn(Connection cnn, String schema, String tablename) {
      List<Column> columnList = new ArrayList();
      new HashMap();
      List<String> primaryKeys = null;
      DatabaseMetaData dbMetaData = null;
      ResultSet columns = null;

      try {
         dbMetaData = cnn.getMetaData();
         columns = dbMetaData.getColumns(cnn.getCatalog(), schema, tablename, (String)null);

         while(columns.next()) {
            Column col = new Column();
            col.setName(columns.getObject("COLUMN_NAME").toString());
            col.setType(columns.getObject("DATA_TYPE").toString());
            col.setLength(getColumnSize(columns));
            columnList.add(col);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (columns != null) {
               columns.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return columnList;
   }

   public static String getColumnSize(ResultSet resultSet) {
      String result = null;

      try {
         String columnSize = resultSet.getString("COLUMN_SIZE");
         if (columnSize != null && !columnSize.equals("0")) {
            String decimalDigits = resultSet.getString("DECIMAL_DIGITS");
            if (decimalDigits != null && !decimalDigits.equals("0")) {
               decimalDigits = "," + decimalDigits;
            } else {
               decimalDigits = "";
            }

            result = columnSize + decimalDigits;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public static List<TypeInfo> getTypeInfoListByConnection(Connection conn) {
      List<TypeInfo> list = null;
      if (conn == null) {
         return null;
      } else {
         DatabaseMetaData dbmd = null;
         ResultSet rs = null;

         try {
            dbmd = conn.getMetaData();

            TypeInfo typeinfo;
            for(rs = dbmd.getTypeInfo(); rs.next(); list.add(typeinfo)) {
               String typename = rs.getString("TYPE_NAME");
               Integer datatype = rs.getInt("DATA_TYPE");
               Integer precision = rs.getInt("PRECISION");
               String literalprefix = rs.getString("LITERAL_PREFIX");
               String literalsuffix = rs.getString("LITERAL_SUFFIX");
               String createparams = rs.getString("CREATE_PARAMS");
               Short nullable = rs.getShort("NULLABLE");
               Boolean casesensitive = rs.getBoolean("CASE_SENSITIVE");
               Short searchable = rs.getShort("SEARCHABLE");
               Boolean unsignedattribute = rs.getBoolean("UNSIGNED_ATTRIBUTE");
               Boolean fixedprecscale = rs.getBoolean("FIXED_PREC_SCALE");
               Boolean autoincrement = rs.getBoolean("AUTO_INCREMENT");
               String localtypename = rs.getString("LOCAL_TYPE_NAME");
               Short minimumscale = rs.getShort("MINIMUM_SCALE");
               Short maximunscale = rs.getShort("MAXIMUM_SCALE");
               Integer sqldatatype = rs.getInt("SQL_DATA_TYPE");
               Integer sqldatatimesub = rs.getInt("SQL_DATETIME_SUB");
               Integer numprecradix = rs.getInt("NUM_PREC_RADIX");
               typeinfo = new TypeInfo(typename, datatype, precision, literalprefix, literalsuffix, createparams, nullable, casesensitive, searchable, unsignedattribute, fixedprecscale, autoincrement, localtypename, minimumscale, maximunscale, sqldatatype, sqldatatimesub, numprecradix);
               if (list == null) {
                  list = new ArrayList();
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               if (rs != null) {
                  rs.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return list;
      }
   }

   /** @deprecated */
   @Deprecated
   public static boolean copyTable(String sourceSchema, String sourceTableName, Connection sourceConnection, String targetDBType, String targetSchema, String targetTableName, Connection targetConnection) {
      Table table = getTable(sourceConnection, sourceSchema, sourceTableName);
      List<ColumnInfo> columnInfo = ColumnInfo.getColumnInfoByConnection(sourceConnection, sourceSchema, sourceTableName, (String)null);
      List<TypeInfo> targettype = getTypeInfoListByConnection(targetConnection);
      List<String> notnull = new ArrayList();

      for(ColumnInfo item : columnInfo) {
         if ("0".equals(item.getNullable())) {
            notnull.add(item.getColumnname());
         }
      }

      List<ColumnInfo> source_column = getAllColumnInfo(sourceConnection, sourceSchema, sourceTableName);
      String sourcedbtype = getDataBaseType(sourceConnection);
      String sql = table.generateCreateDLL(source_column, sourcedbtype, targetDBType, targetSchema, targetTableName, notnull, targettype);
      boolean result = false;

      try {
         PreparedStatement prepareStatement = targetConnection.prepareStatement(sql);
         prepareStatement.execute();
         result = true;
         prepareStatement.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return result;
   }

   public static Table getTable(Connection sourceConnection, String sourceSchema, String sourceTableName) {
      List<Column> columns = getAllColumn(sourceConnection, sourceSchema, sourceTableName);
      System.out.println("++++++++++++++++++++++++++表的列数：" + columns.size());
      List<TCoreTablestructure> columnList = new ArrayList();
      if (columns != null) {
         for(Column column : columns) {
            TCoreTablestructure t = new TCoreTablestructure();
            t.setTableorcolumnname(column.getName());
            t.setJavacolumntype(column.getType());
            t.setColumnlength(column.getLength());
            t.setIsprimarykey(column.isPrimarykey() ? "1" : "0");
            columnList.add(t);
         }
      }

      Table table = new Table();
      table.setColumns(columnList);
      table.setTableorcolumnname(sourceTableName);
      return table;
   }

   public static boolean dropTable(Connection conn, String schema, String tableName) {
      String sql = "drop TABLE " + schema + "." + tableName;
      PreparedStatement pstmt = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.executeUpdate();
         pstmt.close();
         return true;
      } catch (SQLException e1) {
         e1.printStackTrace();
         return false;
      }
   }

   public static boolean delTable(Connection conn, String schema, String tableName) {
      String sql = "TRUNCATE TABLE " + schema + "." + tableName;
      PreparedStatement pstmt = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.executeUpdate();
         pstmt.close();
         return true;
      } catch (SQLException e1) {
         e1.printStackTrace();
         return false;
      }
   }

   public static boolean dropTable(String dbtype, Connection conn, String schema, String tableName, TCoreConfig tcoreConfig) throws SQLException {
      String tableSurroundCharacterLeft = XmlTool.getFileValue(dbtype + "/db-tableSurroundCharacterLeft");
      String tableSurroundCharacterRight = XmlTool.getFileValue(dbtype + "/db-tableSurroundCharacterRight");
      if ("MYSQL".equals(dbtype) || "RAPIDSDB".equals(dbtype)) {
         String s = "SELECT TABLE_NAME ,CONSTRAINT_NAME, CONSTRAINT_TYPE FROM information_schema.`TABLE_CONSTRAINTS` where TABLE_SCHEMA='" + schema + "'";
         PreparedStatement ps = null;
         ResultSet rs = null;
         ps = conn.prepareStatement(s);
         rs = ps.executeQuery();

         while(rs.next()) {
            String table_name = rs.getString("TABLE_NAME");
            String constraint_type = rs.getString("CONSTRAINT_TYPE");
            String constraint_name = rs.getString("CONSTRAINT_NAME");
            if ("FOREIGN KEY".equals(constraint_type)) {
               String ss = "ALTER TABLE " + table_name + " DROP FOREIGN KEY " + constraint_name + "";
               ps = conn.prepareStatement(ss);
               ps.executeUpdate();
            }
         }

         ps.close();
         rs.close();
      }

      if ("ORACLE".equals(dbtype)) {
         String s = "select TABLE_NAME ,CONSTRAINT_NAME, CONSTRAINT_TYPE FROM all_constraints WHERE OWNER ='" + schema + "'";
         PreparedStatement ps = null;
         ResultSet rs = null;
         ps = conn.prepareStatement(s);
         rs = ps.executeQuery();

         while(rs.next()) {
            String table_name = rs.getString("TABLE_NAME");
            String constraint_type = rs.getString("CONSTRAINT_TYPE");
            String constraint_name = rs.getString("CONSTRAINT_NAME");
            if ("R".equals(constraint_type)) {
               String ss = "ALTER TABLE " + schema + "." + table_name + " DROP CONSTRAINT  " + constraint_name + "";
               ps = conn.prepareStatement(ss);
               ps.executeUpdate();
            }
         }

         ps.close();
         rs.close();
      }

      if ("MSSQLSERVER".equals(dbtype)) {
         String s = "select oSub.name TABLE_NAME,fk.name CONSTRAINT_NAME from sys.foreign_keys fk JOIN sys.all_objects oSub ON (fk.parent_object_id = oSub.object_id)JOIN sys.all_objects oMain ON (fk.referenced_object_id = oMain.object_id)JOIN sys.foreign_key_columns fkCols ON (fk.object_id = fkCols.constraint_object_id)JOIN sys.columns SubCol ON (oSub.object_id = SubCol.object_id AND fkCols.parent_column_id = SubCol.column_id) JOIN sys.columns MainCol ON (oMain.object_id = MainCol.object_id AND fkCols.referenced_column_id = MainCol.column_id)";
         PreparedStatement ps = null;
         ResultSet rs = null;
         ps = conn.prepareStatement(s);
         rs = ps.executeQuery();

         while(rs.next()) {
            String table_name = rs.getString("TABLE_NAME");
            String constraint_name = rs.getString("CONSTRAINT_NAME");
            String ss = "ALTER TABLE " + schema + "." + table_name + " DROP CONSTRAINT  " + constraint_name + "";
            ps = conn.prepareStatement(ss);
            ps.executeUpdate();
         }

         ps.close();
         rs.close();
      }

      String sql = "drop TABLE " + tableSurroundCharacterLeft + schema + tableSurroundCharacterRight + "." + tableSurroundCharacterLeft + tableName + tableSurroundCharacterRight;
      if (dbtype.equals(EdbType.INFORMIX.getDbcode())) {
         sql = "drop TABLE " + tableSurroundCharacterLeft + tableName + tableSurroundCharacterRight;
      }

      PreparedStatement pstmt = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.executeUpdate();
         pstmt.close();
         return true;
      } catch (SQLException e1) {
         e1.printStackTrace();
         return false;
      }
   }

   public static boolean truncateTable(Connection conn, String schema, String tableName) {
      EdbType source = DbInfo.getEdbTypeByConnection(conn);
      String dataType = source.getDbcode();
      System.out.println(">>>>>>truncate TABLE " + schema + "." + tableName);
      String sql = "truncate TABLE " + schema + "." + tableName;
      if ("DB2".equals(dataType)) {
         sql = sql + " IMMEDIATE";
      }

      PreparedStatement pstmt = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.executeUpdate();
         pstmt.close();
         return true;
      } catch (SQLException e1) {
         e1.printStackTrace();
         return false;
      }
   }

   public static String getSelectSqlForSqlServer(Connection conn, String schema, String table) {
      StringBuffer sb = new StringBuffer();
      sb.append("select ");
      List<ColumnInfo> columnlist = getAllColumnInfo(conn, schema, table);

      for(int i = 0; i < columnlist.size(); ++i) {
         ColumnInfo temp = (ColumnInfo)columnlist.get(i);
         if (i > 0) {
            sb.append(",");
         }

         temp.setColumnname("\"" + temp.getColumnname() + "\"");
         if (temp.getTypename().equalsIgnoreCase("sql_variant")) {
            sb.append("convert(varchar(100), SERVERPROPERTY('" + temp.getColumnname() + "')) as " + temp.getColumnname());
         } else {
            sb.append(temp.getColumnname());
         }
      }

      sb.append(" from " + schema + "." + table);
      return sb.toString();
   }

   /** @deprecated */
   @Deprecated
   public static boolean createTableByStructure(Connection conn, String tablename, List<Map<String, String>> list) {
      StringBuilder sb = new StringBuilder();
      sb.append("create table ").append(tablename).append(" ( ");

      for(int i = 0; i < list.size(); ++i) {
         sb.append((String)((Map)list.get(i)).get("columnname")).append(" ").append((String)((Map)list.get(i)).get("columntype"));
         if (((Map)list.get(i)).get("columnaccuracy") != null && ((Map)list.get(i)).get("columnaccuracy") != "") {
            sb.append("(").append((String)((Map)list.get(i)).get("columnaccuracy"));
            if (((Map)list.get(i)).get("columndecimal") != null && ((Map)list.get(i)).get("columndecimal") != "") {
               sb.append(",").append((String)((Map)list.get(i)).get("columndecimal")).append(")");
            } else {
               sb.append(")");
            }
         }

         if (((String)((Map)list.get(i)).get("columnnotnull")).equals("YES")) {
            sb.append(" ").append("NOT NULL");
         }

         if (((String)((Map)list.get(i)).get("keytype")).equals("YES")) {
            sb.append(" ").append("PRIMARY KEY");
         }

         if (i != list.size() - 1) {
            sb.append(", ");
         }
      }

      sb.append(" )");
      String sql = sb.toString();

      try {
         conn.createStatement().execute(sql);
         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   public static String getCreateTableSqlForOracle(Connection conn, String schema, String tablename) {
      String sql = "SELECT DBMS_METADATA.GET_DDL('TABLE',?,?) FROM DUAL ";
      String ddl = null;
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement(sql);
         ps.setString(1, tablename);
         ps.setString(2, schema);

         for(rs = ps.executeQuery(); rs.next(); ddl = rs.getString(1)) {
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return ddl.replaceAll("\"", " ");
   }

   public static String getCreateTableSqlForMySql(Connection conn, String schema, String tablename) {
      String sql = "SHOW CREATE TABLE " + schema + "." + tablename;
      String ddl = null;
      PreparedStatement ps = null;
      ResultSet rs = null;

      try {
         ps = conn.prepareStatement(sql);

         for(rs = ps.executeQuery(); rs.next(); ddl = rs.getString(2)) {
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            rs.close();
            ps.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return ddl;
   }

   public static void synchronizePrimaryKeyAndIndex(Connection srcconn, String srcschema, String srctable, Connection tarconn, String tarschema, String tartable) {
      synchronizePrimaryKey(srcconn, srcschema, srctable, tarconn, tarschema, tartable);
      synchronizeIndex(srcconn, srcschema, srctable, tarconn, tarschema, tartable);
   }

   public static void delPrimaryForeignKeyAndIndex(Connection tarconn, String tarschema, String tartable) {
      delPrimaryKey(tarconn, tarschema, tartable);
      delForeignKey(tarconn, tarschema, tartable);
   }

   public static void synchronizePrimaryKey(Connection srcconn, String srcschema, String srctable, Connection tarconn, String tarschema, String tartable) {
      List<String> primarykey = PrimaryKeyInfo.getPrimaryKeyList(srcconn, srcschema, srctable);
      String pk = "";
      if (null != primarykey) {
         for(int i = 0; i < primarykey.size(); ++i) {
            pk = pk + (String)primarykey.get(i);
            if (i < primarykey.size() - 1) {
               pk = pk + ",";
            }
         }

         String sql = null;
         EdbType target_type = DbInfo.getEdbTypeByConnection(tarconn);
         if (EdbType.OCEANBASE.getDbcode().equalsIgnoreCase(target_type.getDbcode())) {
            sql = "ALTER TABLE " + tarschema + "." + tartable + " ADD CONSTRAINT un_" + pk + " unique(" + pk + ")";
         } else if (target_type.getDbcode().equalsIgnoreCase(EdbType.INFORMIX.getDbcode())) {
            sql = "ALTER TABLE " + tarschema + "." + tartable + " ADD CONSTRAINT primary key(" + pk + ")CONSTRAINT pk_" + System.currentTimeMillis();
         } else {
            sql = "ALTER TABLE " + tarschema + "." + tartable + " ADD CONSTRAINT pk_" + System.currentTimeMillis() + " PRIMARY KEY(" + pk + ")";
         }

         System.out.println("create primary key sql:" + sql);
         System.out.println("create primary key" + pk);
         long s = System.currentTimeMillis();
         System.out.println(">>>>>>>>>>>>>>>>同步目标表主键执行开始");
         System.out.println("同步目标表主键SQL语句：" + sql);
         executeSql(tarconn, sql);
         System.out.println(">>>>>>>>>>>>>>>>同步目标表主键执行完毕！");
         long e = System.currentTimeMillis();
         long t = (e - s) / 1000L;
         System.out.println("create primary key take time(second)" + t);
      }

   }

   public static void delPrimaryKey(Connection tarconn, String tarschema, String tartable) {
      List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(tarconn, tarschema, tartable);
      String pk = "";
      if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
         for(int i = 0; i < primarykeyInfo.size(); ++i) {
            pk = pk + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname();
            if (i < primarykeyInfo.size() - 1) {
               pk = pk + ",";
            }
         }

         String sql = null;
         EdbType target_type = DbInfo.getEdbTypeByConnection(tarconn);
         if (EdbType.OCEANBASE.getDbcode().equalsIgnoreCase(target_type.getDbcode())) {
            sql = " DROP  index un_" + pk + "";
         } else if (target_type.getDbcode().equalsIgnoreCase(EdbType.INFORMIX.getDbcode())) {
            sql = "ALTER TABLE " + tarschema + "." + tartable + " DROP CONSTRAINT primary key(" + pk + ")";
         } else if (target_type.getDbcode().equalsIgnoreCase(EdbType.MYSQL.getDbcode())) {
            sql = "ALTER TABLE " + tarschema + "." + tartable + " DROP  primary key";
         } else {
            sql = "ALTER TABLE " + tarschema + "." + tartable + " DROP  Constraint " + pk + "";
         }

         System.out.println(">>>>>>>>>>>>>>>>删除目标表主键执行开始");
         System.out.println("删除目标表主键SQL语句：" + sql);
         executeSql(tarconn, sql);
         System.out.println(">>>>>>>>>>>>>>>>删除目标表主键执行完毕！");
      }

   }

   public static List<Map<String, String>> getForeignKeys(Connection conn, String schema, String tableName) {
      List<Map<String, String>> list = new ArrayList();
      ResultSet rs = null;

      try {
         DatabaseMetaData databaseMetaData = conn.getMetaData();
         String dbtype = getDataBaseType(conn);
         if (EdbType.MYSQL.getDbcode().equalsIgnoreCase(dbtype)) {
            rs = databaseMetaData.getImportedKeys(schema, (String)null, tableName);
         } else {
            rs = databaseMetaData.getImportedKeys((String)null, schema, tableName);
         }

         while(rs.next()) {
            Map<String, String> map = new HashMap();
            map.put("FKTABLE_NAME", rs.getString("FKTABLE_NAME"));
            map.put("FKCOLUMN_NAME", rs.getString("FKCOLUMN_NAME"));
            map.put("FK_NAME", rs.getString("FK_NAME"));
            map.put("PKTABLE_NAME", rs.getString("PKTABLE_NAME"));
            map.put("PKCOLUMN_NAME", rs.getString("PKCOLUMN_NAME"));
            list.add(map);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static void synchronizeForeignKey(Connection srcconn, String srcschema, String srctable, Connection tarconn, String tarschema, String tartable, Map<String, String> pktableMap) {
      List<Map<String, String>> fkeyLst = null;
      fkeyLst = getForeignKeys(srcconn, srcschema, srctable);
      if (null != fkeyLst && fkeyLst.size() > 0) {
         for(int i = 0; i < fkeyLst.size(); ++i) {
            Map<String, String> fkeyInfo = (Map)fkeyLst.get(i);
            String fktableName = (String)fkeyInfo.get("FKTABLE_NAME");
            String fkcolumnName = (String)fkeyInfo.get("FKCOLUMN_NAME");
            String fkName = (String)fkeyInfo.get("FK_NAME");
            String pktableName = (String)fkeyInfo.get("PKTABLE_NAME");
            String pkcolumnName = (String)fkeyInfo.get("PKCOLUMN_NAME");
            String sql = null;
            sql = "ALTER TABLE " + tarschema + "." + tartable + " ADD CONSTRAINT fk_" + System.currentTimeMillis() + " FOREIGN KEY (" + fkcolumnName + ") REFERENCES " + tarschema + "." + (String)pktableMap.get(pktableName) + "(" + pkcolumnName + ")";
            System.out.println(">>>>>>>>>>>>>>>>同步外键执行开始");
            System.out.println("同步外键SQL语句：" + sql);
            executeSql(tarconn, sql);
            System.out.println(">>>>>>>>>>>>>>>>同步外键执行完毕！");
         }
      }

   }

   public static void synchronizeForeignKey(Connection srcconn, String srcschema, String srctable, Connection tarconn, String tarschema, String tartable) {
      List<Map<String, String>> fkeyLst = null;
      fkeyLst = getForeignKeys(srcconn, srcschema, srctable);
      if (null != fkeyLst && fkeyLst.size() > 0) {
         for(int i = 0; i < fkeyLst.size(); ++i) {
            Map<String, String> fkeyInfo = (Map)fkeyLst.get(i);
            String fktableName = (String)fkeyInfo.get("FKTABLE_NAME");
            String fkcolumnName = (String)fkeyInfo.get("FKCOLUMN_NAME");
            String fkName = (String)fkeyInfo.get("FK_NAME");
            String pktableName = (String)fkeyInfo.get("PKTABLE_NAME");
            String pkcolumnName = (String)fkeyInfo.get("PKCOLUMN_NAME");
            String sql = null;
            sql = "ALTER TABLE " + tarschema + "." + fktableName + " ADD CONSTRAINT fk_" + System.currentTimeMillis() + " FOREIGN KEY (" + fkcolumnName + ") REFERENCES " + tarschema + "." + pktableName + "(" + pkcolumnName + ")";
            System.out.println(">>>>>>>>>>>>>>>>同步外键执行开始");
            System.out.println("同步外键SQL语句：" + sql);
            executeSql(tarconn, sql);
            System.out.println(">>>>>>>>>>>>>>>>同步外键执行完毕！");
         }
      }

   }

   public static void delForeignKey(Connection tarconn, String tarschema, String tartable) {
      List<Map<String, String>> fkeyLst = null;
      fkeyLst = getForeignKeys(tarconn, tarschema, tartable);
      if (null != fkeyLst && fkeyLst.size() > 0) {
         for(int i = 0; i < fkeyLst.size(); ++i) {
            Map<String, String> fkeyInfo = (Map)fkeyLst.get(i);
            String fktableName = (String)fkeyInfo.get("FKTABLE_NAME");
            String fkcolumnName = (String)fkeyInfo.get("FKCOLUMN_NAME");
            String fkName = (String)fkeyInfo.get("FK_NAME");
            String pktableName = (String)fkeyInfo.get("PKTABLE_NAME");
            String pkcolumnName = (String)fkeyInfo.get("PKCOLUMN_NAME");
            String sql = null;
            EdbType target_type = DbInfo.getEdbTypeByConnection(tarconn);
            if (target_type.getDbcode().equalsIgnoreCase(EdbType.INFORMIX.getDbcode())) {
               sql = "ALTER TABLE " + tarschema + "." + fktableName + " DROP CONSTRAINT FOREIGN KEY(" + fkName + ")";
            } else if (target_type.getDbcode().equalsIgnoreCase(EdbType.MYSQL.getDbcode())) {
               sql = "ALTER TABLE " + tarschema + "." + fktableName + " DROP  FOREIGN KEY " + fkName + "";
            } else {
               sql = "ALTER TABLE " + tarschema + "." + fktableName + " DROP  Constraint " + fkName + "";
            }

            System.out.println(">>>>>>>>>>>>>>>>删除外键执行开始！");
            System.out.println("删除外键SQL语句：" + sql);
            executeSql(tarconn, sql);
            System.out.println(">>>>>>>>>>>>>>>>删除外键执行完毕！");
         }
      }

   }

   public static void synchronizeIndex(Connection srcconn, String srcschema, String srctable, Connection tarconn, String tarschema, String tartable) {
      List<IndexInfo> indexInfo = IndexInfo.getIndexInfoByConnection(srcconn, srcschema, srctable);
      List<String> primarykey = PrimaryKeyInfo.getPrimaryKeyList(srcconn, srcschema, srctable);
      List<IndexInfo> newindexinfo = new ArrayList();
      Map<Integer, String> indexmap = new HashMap();
      String columnname1 = "";
      int a = 0;
      int b = 0;
      String d = "1";
      if (null != indexInfo) {
         for(int i = 0; i < indexInfo.size(); ++i) {
            String index = ((IndexInfo)indexInfo.get(i)).getIndexname();
            String columnname2 = ((IndexInfo)indexInfo.get(i)).getColumnname();
            if (index.equals(d)) {
               columnname1 = columnname1 + columnname2 + ",";
            } else {
               d = index;
               indexmap.put(b, columnname1);
               columnname1 = columnname2 + ",";
               if (a == 0) {
                  b = i;
                  ++a;
               }

               a = 0;
            }

            if (i == indexInfo.size() - 1) {
               indexmap.put(b, columnname1);
            }
         }

         for(Map.Entry<Integer, String> entry : indexmap.entrySet()) {
            int mapKey = (Integer)entry.getKey();
            String mapValue = (String)entry.getValue();
            ((IndexInfo)indexInfo.get(mapKey)).setColumnname(mapValue.substring(0, mapValue.length() - 1));
            newindexinfo.add(indexInfo.get(mapKey));
         }

         for(IndexInfo item : newindexinfo) {
            String index_name = String.valueOf(System.currentTimeMillis());
            EdbType target_type = DbInfo.getEdbTypeByConnection(tarconn);
            if (EdbType.OCEANBASE.getDbcode().equalsIgnoreCase(target_type.getDbcode())) {
               String idxname = item.getIndexname();
               if (org.apache.commons.lang3.StringUtils.isBlank(idxname)) {
                  idxname = "idx_" + item.getColumnname();
               }

               String sql = "create index " + idxname + " on " + tarschema + ".ASTUDENTS(" + item.getColumnname() + ") local;";
               long s = System.currentTimeMillis();
               executeSql(tarconn, sql);
               long e = System.currentTimeMillis();
               long t = (e - s) / 1000L;
               System.out.println("create index " + item.getColumnname() + " take time (second)" + t);
            } else if ((null == primarykey || !primarykey.contains(item.getColumnname())) && null != item.getColumnname()) {
               if (item.isNonunique()) {
                  String sql = "CREATE INDEX index_" + index_name + " ON " + tarschema + "." + tartable + " (" + item.getColumnname() + ")";
                  System.out.println(sql);
                  System.out.println("create index " + item.getColumnname());
                  long s = System.currentTimeMillis();
                  executeSql(tarconn, sql);
                  long e = System.currentTimeMillis();
                  long t = (e - s) / 1000L;
                  System.out.println("create index " + item.getColumnname() + " take time (second)" + t);
               } else {
                  String sql = "CREATE UNIQUE  INDEX index_" + index_name + " ON " + tarschema + "." + tartable + " (" + item.getColumnname() + ")";
                  System.out.println(sql);
                  System.out.println("create index " + item.getColumnname());
                  long s = System.currentTimeMillis();
                  executeSql(tarconn, sql);
                  long e = System.currentTimeMillis();
                  long t = (e - s) / 1000L;
                  System.out.println("create index " + item.getColumnname() + " take time (second)" + t);
               }
            }
         }
      }

   }

   public static void delIndex(Connection tarconn, String tarschema, String tartable) {
      List<IndexInfo> indexInfo = IndexInfo.getIndexInfoByConnection(tarconn, tarschema, tartable);
      List<String> primarykey = PrimaryKeyInfo.getPrimaryKeyList(tarconn, tarschema, tartable);
      EdbType target_type = DbInfo.getEdbTypeByConnection(tarconn);
      if (EdbType.OCEANBASE.getDbcode().equalsIgnoreCase(target_type.getDbcode())) {
         for(IndexInfo item : indexInfo) {
            if (!primarykey.contains(item.getColumnname()) && null != item.getColumnname()) {
               String sql = " DROP  index index_" + item.getColumnname() + "";
               executeSql(tarconn, sql);
            }
         }
      } else {
         for(IndexInfo item : indexInfo) {
            if (!primarykey.contains(item.getColumnname()) && null != item.getColumnname()) {
               String sql = "DROP INDEX index_" + String.valueOf(System.currentTimeMillis()) + " ON " + tarschema + "." + tartable + " (" + item.getColumnname() + ")";
               executeSql(tarconn, sql);
            }
         }
      }

   }

   public static String getGenerateDDL(String targetSchema, String tableName, List<ColumnInfoVO> sourceList, List<Map<String, String>> mappingInfo) {
      StringBuilder sb = new StringBuilder();
      sb.append("create table ");
      sb.append(targetSchema);
      sb.append(".");
      sb.append(tableName);
      sb.append(" ( ");

      for(int i = 0; i < sourceList.size(); ++i) {
         for(Map<String, String> map : mappingInfo) {
            if (((ColumnInfoVO)sourceList.get(i)).getTypename().equalsIgnoreCase((String)map.get("sourcefieldname"))) {
               sb.append(((ColumnInfoVO)sourceList.get(i)).getColumnname());
               sb.append(" ");
               if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("targetfieldname"))) {
                  sb.append((String)map.get("targetfieldname"));
               } else {
                  sb.append((String)map.get("sourcefieldname"));
               }

               if ("1".equals(map.get("flag"))) {
                  sb.append("(");
                  sb.append(((String)map.get("targetlength")).trim());
                  if (map.get("targetdecimal") != null && !((String)map.get("targetdecimal")).equals("")) {
                     sb.append(",");
                     sb.append(((String)map.get("targetdecimal")).trim());
                  }

                  sb.append(") ");
               } else if ("2".equals(map.get("flag"))) {
                  sb.append("(");
                  sb.append(((ColumnInfoVO)sourceList.get(i)).getColumnsize());
                  if (!((ColumnInfoVO)sourceList.get(i)).getDecimaldigits().equals("") && ((ColumnInfoVO)sourceList.get(i)).getDecimaldigits() != null) {
                     sb.append(",");
                     sb.append(((ColumnInfoVO)sourceList.get(i)).getDecimaldigits());
                  }

                  sb.append(") ");
               }

               if (((ColumnInfoVO)sourceList.get(i)).getIsnullable().equals("NO")) {
                  sb.append(" NOT NULL ");
               } else {
                  sb.append(" NULL ");
               }

               if (i != sourceList.size() - 1) {
                  sb.append(",");
               }
               break;
            }
         }
      }

      sb.append(" ) ");
      return sb.toString();
   }

   public static String getGenerateDDL_new(String targetSchema, String tableName, List<TCoreMaskingTaskTableInfo> sourceList, boolean isallownull, String dbtype, String getDbtype_s, boolean ischar, TCoreConfig tcoreConfig) {
      StringBuilder sb = new StringBuilder();
      String tableSurroundCharacterLeft = XmlTool.getFileValue(dbtype + "/db-tableSurroundCharacterLeft");
      String tableSurroundCharacterRight = XmlTool.getFileValue(dbtype + "/db-tableSurroundCharacterRight");
      String columnSurroundCharacterLeft = XmlTool.getFileValue(dbtype + "/db-columnSurroundCharacterLeft");
      String columnSurroundCharacterRight = XmlTool.getFileValue(dbtype + "/db-columnSurroundCharacterRight");
      sb.append("create table ");
      sb.append(tableSurroundCharacterLeft + targetSchema + tableSurroundCharacterRight);
      sb.append(".");
      sb.append(tableSurroundCharacterLeft + tableName + tableSurroundCharacterRight);
      sb.append(" ( ");
      if ("HIVE".equals(dbtype)) {
         for(int i = 0; i < sourceList.size(); ++i) {
            sb.append(columnSurroundCharacterLeft);
            sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnName());
            sb.append(columnSurroundCharacterRight);
            sb.append(" ");
            String targetType = ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetType();
            if ("VARCHAR".equalsIgnoreCase(targetType)) {
               sb.append("string");
            } else {
               sb.append(targetType);
            }

            if (i != sourceList.size() - 1) {
               sb.append(",");
            }
         }
      } else {
         for(int i = 0; i < sourceList.size(); ++i) {
            sb.append(columnSurroundCharacterLeft);
            sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnName());
            sb.append(columnSurroundCharacterRight);
            sb.append(" ");
            String sourceType = ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getSourceType();
            String targetType = ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetType();
            targetType = targetType.replace("identity", "");
            if ("ORACLE".equalsIgnoreCase(dbtype) && "ORACLE".equalsIgnoreCase(getDbtype_s) && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getSecretkeyName() != null) {
               sb.append("VARCHAR2");
            } else if ("GREENPLUM".equalsIgnoreCase(dbtype) && "GREENPLUM".equalsIgnoreCase(getDbtype_s)) {
               if ("bigserial".equalsIgnoreCase(targetType)) {
                  sb.append("int8");
               } else if ("serial".equalsIgnoreCase(targetType)) {
                  sb.append("int4");
               } else {
                  sb.append(targetType);
               }
            } else {
               sb.append(targetType);
            }

            if (!"0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getLengthruletype()) && (!"ORACLE".equalsIgnoreCase(dbtype) || !"OCEANBASE".equalsIgnoreCase(getDbtype_s) && !EdbType.INFORMIX.getDbname().equalsIgnoreCase(getDbtype_s) || !"NUMBER".equalsIgnoreCase(targetType))) {
               if ("MSSQLSERVER".equalsIgnoreCase(dbtype) && targetType.equalsIgnoreCase("float")) {
                  if (((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength().equals("") && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength().equals("")) {
                     int length = 0;
                     sb.append("(");
                     String precision = compareValue(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision(), ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision()) ? ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().trim() : ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision().trim();
                     if (org.apache.commons.lang3.StringUtils.isNotBlank(precision)) {
                        length = Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength()) + Integer.valueOf(precision);
                     } else {
                        length = Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                     }

                     sb.append(String.valueOf(length));
                     sb.append(")");
                  }
               } else if ("SYBASE".equalsIgnoreCase(dbtype) && targetType.equalsIgnoreCase("float")) {
                  if (((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength().equals("") && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength().equals("")) {
                     int length = 0;
                     sb.append("(");
                     String precision = compareValue(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision(), ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision()) ? ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().trim() : ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision().trim();
                     if (org.apache.commons.lang3.StringUtils.isNotBlank(precision)) {
                        length = Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength()) + Integer.valueOf(precision);
                     } else {
                        length = Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                     }

                     sb.append(String.valueOf(length));
                     sb.append(")");
                  }
               } else if (!EdbType.TERADATA.getDbname().equalsIgnoreCase(dbtype) || !targetType.equalsIgnoreCase("float") && !targetType.equalsIgnoreCase("decimal")) {
                  if (((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength().equals("") && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength().equals("")) {
                     sb.append("(");
                     if ("ORACLE".equalsIgnoreCase(dbtype) && "HIVE".equalsIgnoreCase(getDbtype_s) && "varchar2".equalsIgnoreCase(targetType) && "boolean".equalsIgnoreCase(sourceType)) {
                        sb.append("1");
                     } else if ("ORACLE".equalsIgnoreCase(dbtype) && "HIVE".equalsIgnoreCase(getDbtype_s) && "NUMBER".equalsIgnoreCase(targetType) && "FLOAT".equalsIgnoreCase(sourceType)) {
                        sb.append("38");
                     } else if ("ORACLE".equalsIgnoreCase(dbtype) && "ORACLE".equalsIgnoreCase(getDbtype_s) && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getSecretkeyName() != null) {
                        sb.append("255");
                     } else if ("ORACLE".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "NUMBER".equalsIgnoreCase(targetType) && "FLOAT".equalsIgnoreCase(sourceType)) {
                        sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision());
                     } else if ("ORACLE".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR2".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if (("MYSQL".equalsIgnoreCase(getDbtype_s) || "RAPIDSDB".equalsIgnoreCase(getDbtype_s)) && "OCEANBASE".equalsIgnoreCase(dbtype) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("OCEANBASE".equalsIgnoreCase(dbtype) && ("GREENPLUM".equalsIgnoreCase(getDbtype_s) || "MARIADB".equalsIgnoreCase(getDbtype_s) || "MYSQL".equalsIgnoreCase(getDbtype_s) || "RAPIDSDB".equalsIgnoreCase(getDbtype_s)) && "VARCHAR2".equalsIgnoreCase(targetType) && "BIT".equalsIgnoreCase(sourceType)) {
                        if ("1".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append("10");
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("OCEANBASE".equalsIgnoreCase(dbtype) && "GREENPLUM".equalsIgnoreCase(getDbtype_s) && "BOOL".equalsIgnoreCase(sourceType)) {
                        if ("1".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append("10");
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("DB2".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           if (!"INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType) && !"INTERVAL DAY(2) TO SECOND(6)".equalsIgnoreCase(sourceType)) {
                              sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                           } else {
                              sb.append("255");
                           }
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("MSSQLSERVER".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("TERADATA".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(compareValue(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength(), ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength()) ? ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength() : ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        }
                     } else if ("TERADATA".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "DECIMAL".equalsIgnoreCase(targetType) && "0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                        sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                     } else if ("INFORMIX".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("INFORMIX".equalsIgnoreCase(getDbtype_s) && "OCEANBASE".equalsIgnoreCase(dbtype) && "NUMBER".equalsIgnoreCase(targetType)) {
                        sb.append(String.valueOf(Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength()) + Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision())));
                     } else if ("MARIADB".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("OCEANBASE".equalsIgnoreCase(dbtype) && "MSSQLSERVER".equalsIgnoreCase(getDbtype_s) && "VARCHAR2".equalsIgnoreCase(targetType) && "bit".equalsIgnoreCase(sourceType)) {
                        if ("1".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append("255");
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        }
                     } else if ("GREENPLUM".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if (("SYBASE".equalsIgnoreCase(dbtype) || "SYBASE_IQ".equalsIgnoreCase(dbtype)) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "varchar".equalsIgnoreCase(targetType)) {
                        if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType)) {
                           sb.append("255");
                        } else if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("TERADATA".equalsIgnoreCase(dbtype) && "OCEANBASE".equalsIgnoreCase(getDbtype_s) && "decimal".equalsIgnoreCase(targetType)) {
                        if ("0".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                        } else if (38 < Integer.parseInt(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength())) {
                           sb.append("38");
                        } else {
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                        }
                     } else if ("OCEANBASE".equalsIgnoreCase(dbtype) && ("SYBASE".equalsIgnoreCase(getDbtype_s) || "SYBASE_IQ".equalsIgnoreCase(getDbtype_s)) && "VARCHAR2".equalsIgnoreCase(targetType) && "bit".equalsIgnoreCase(sourceType)) {
                        sb.append("255");
                     } else if ("OCEANBASE".equalsIgnoreCase(getDbtype_s) && "INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(sourceType) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        sb.append("255");
                     } else if ("SYBASE".equalsIgnoreCase(getDbtype_s) && "bit".equalsIgnoreCase(sourceType) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        sb.append("10");
                     } else if ("MARIADB".equalsIgnoreCase(getDbtype_s) && "bit".equalsIgnoreCase(sourceType) && "VARCHAR".equalsIgnoreCase(targetType)) {
                        sb.append("10");
                     } else if (EdbType.INFORMIX.getDbname().equalsIgnoreCase(getDbtype_s) && EdbType.MSSQLSERVER.getDbname().equalsIgnoreCase(dbtype) && "blob".equalsIgnoreCase(sourceType) && "binary".equalsIgnoreCase(targetType)) {
                        sb.append("4000");
                     } else {
                        sb.append(compareValue(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength(), ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength()) ? ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength() : ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength());
                     }

                     if ((targetType.equalsIgnoreCase("char") || targetType.equalsIgnoreCase("varchar2") || targetType.equalsIgnoreCase("varchar")) && ischar) {
                        sb.append(" CHAR");
                     }

                     if (((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().equals("") && !"varchar".equalsIgnoreCase(targetType) && !"univarchar".equalsIgnoreCase(targetType)) {
                        if ((!"ORACLE".equalsIgnoreCase(dbtype) || !"OCEANBASE".equalsIgnoreCase(getDbtype_s) || !"NUMBER".equalsIgnoreCase(targetType)) && (!"OCEANBASE".equalsIgnoreCase(dbtype) || !"HIVE".equalsIgnoreCase(getDbtype_s) || !"NUMBER".equalsIgnoreCase(targetType)) && (!"OCEANBASE".equalsIgnoreCase(dbtype) || !"MSSQLSERVER".equalsIgnoreCase(getDbtype_s) || !"NUMBER".equalsIgnoreCase(targetType)) && (!"OCEANBASE".equalsIgnoreCase(dbtype) || !"GREENPLUM".equalsIgnoreCase(getDbtype_s) || !"NUMBER".equalsIgnoreCase(targetType)) && (!"ORACLE".equalsIgnoreCase(dbtype) || !"GREENPLUM".equalsIgnoreCase(getDbtype_s) || !"NUMBER".equalsIgnoreCase(targetType)) && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().equals("0") && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision().equals("0")) {
                           if ("RAPIDSDB".equals(dbtype)) {
                              if (!"INT".equals(targetType)) {
                                 sb.append(",");
                              }
                           } else {
                              sb.append(",");
                           }

                           if ("MSSQLSERVER".equalsIgnoreCase(dbtype) && "decimal".equalsIgnoreCase(targetType) && "FLOAT".equalsIgnoreCase(sourceType)) {
                              sb.append("0");
                           } else if ("ORACLE".equalsIgnoreCase(dbtype) && "HIVE".equalsIgnoreCase(getDbtype_s) && "NUMBER".equalsIgnoreCase(targetType) && "DOUBLE".equalsIgnoreCase(sourceType)) {
                              sb.append("10");
                           } else {
                              sb.append(compareValue(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision(), ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision()) ? ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().trim() : ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision().trim());
                           }
                        }

                        if ("MSSQLSERVER".equalsIgnoreCase(dbtype) && "decimal".equalsIgnoreCase(targetType) && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().equals("0")) {
                           sb.append(",");
                           sb.append(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().trim());
                        }
                     }

                     sb.append(") ");
                  }
               } else if (((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength().equals("") && ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength() != null && !((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetLength().equals("")) {
                  int length = 0;
                  sb.append("(");
                  String precision = compareValue(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision(), ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision()) ? ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnPrecision().trim() : ((TCoreMaskingTaskTableInfo)sourceList.get(i)).getTargetPrecision().trim();
                  if (org.apache.commons.lang3.StringUtils.isNotBlank(precision)) {
                     length = Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength()) + Integer.valueOf(precision);
                  } else {
                     length = Integer.valueOf(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getColumnLength());
                  }

                  if (length > 38) {
                     length = 38;
                  }

                  sb.append(String.valueOf(length));
                  sb.append(")");
               }
            }

            if ("NO".equals(((TCoreMaskingTaskTableInfo)sourceList.get(i)).getIsnullable())) {
               sb.append(" NOT NULL ");
            } else if (isallownull) {
               sb.append(" NULL ");
            }

            if (i != sourceList.size() - 1) {
               sb.append(",");
            }
         }
      }

      sb.append(" )");
      if ("HIVE".equals(dbtype)) {
         sb.append(" ROW FORMAT DELIMITED FIELDS TERMINATED BY '$'LINES TERMINATED BY '\\n'STORED AS TEXTFILE;");
      }

      return sb.toString();
   }

   public static boolean compareValue(String source, String target) {
      boolean flag = true;

      try {
         int source1 = Integer.parseInt(source);
         int target1 = 0;

         try {
            target1 = Integer.parseInt(target);
         } catch (Exception var6) {
            target1 = 0;
         }

         if (source1 >= target1) {
            flag = false;
         }
      } catch (Exception var7) {
      }

      return flag;
   }

   public static boolean copyTable(Connection tconn, String targetSchema, String tableName, List<ColumnInfoVO> sourceList, List<Map<String, String>> mappingInfo) {
      boolean result = false;
      String sql = getGenerateDDL(targetSchema, tableName, sourceList, mappingInfo);
      System.out.println("create:" + sql);

      try {
         PreparedStatement prepareStatement = tconn.prepareStatement(sql);
         prepareStatement.execute();
         result = true;
         prepareStatement.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return result;
   }

   public static boolean createTable(Connection tconn, String sql) throws SQLException {
      boolean result = false;
      PreparedStatement stmt = tconn.prepareStatement(sql);
      stmt.execute();
      stmt.close();
      result = true;
      return result;
   }

   public static boolean exesql(Connection tconn, StringBuilder sql) {
      boolean result = false;

      try {
         PreparedStatement prepareStatement = tconn.prepareStatement(sql.toString());
         prepareStatement.execute();
         result = true;
         prepareStatement.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return result;
   }

   public static String copyTable_result_sql(Connection tconn, String targetSchema, String tableName, List<ColumnInfoVO> sourceList, List<Map<String, String>> mappingInfo) {
      String sql = getGenerateDDL(targetSchema, tableName, sourceList, mappingInfo);
      return sql;
   }

   public static ResultSet getPrimaryKeysForMySql(Connection conn, String database, String tableName) {
      ResultSet pkResultSet = null;

      try {
         pkResultSet = conn.getMetaData().getPrimaryKeys(database, (String)null, tableName);
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return pkResultSet;
   }

   public static ResultSet getPrimaryKeys(Connection cnn, String schema, String tableName) {
      ResultSet pkResultSet = null;
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         try {
            pkResultSet = cnn.getMetaData().getPrimaryKeys((String)null, schema, tableName);
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return pkResultSet;
      } else {
         return getPrimaryKeysForMySql(cnn, schema, tableName);
      }
   }

   public static ResultSet getColumnsForMySql(Connection conn, String database, String tableName) {
      ResultSet pkResultSet = null;

      try {
         pkResultSet = conn.getMetaData().getColumns(database, (String)null, tableName, "%");
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return pkResultSet;
   }

   public static ResultSet getColumns(Connection cnn, String schema, String tableName) {
      ResultSet pkResultSet = null;
      String dbtype = getDataBaseType(cnn);
      if (!dbtype.equals(EdbType.MYSQL.getDbcode()) && !dbtype.equals(EdbType.RAPIDSDB.getDbcode())) {
         try {
            pkResultSet = cnn.getMetaData().getColumns((String)null, schema, tableName, "%");
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return pkResultSet;
      } else {
         return getColumnsForMySql(cnn, schema, tableName);
      }
   }

   public static List<String> getFK(Connection conn, String dbname, String schema, String tableName) {
      List<String> list = new ArrayList();
      ResultSet rs = null;

      try {
         DatabaseMetaData databaseMetaData = conn.getMetaData();
         rs = databaseMetaData.getImportedKeys(dbname, schema, tableName);

         while(rs.next()) {
            list.add(rs.getString("FKCOLUMN_NAME"));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static List<String> getPK(Connection conn, String dbname, String schema, String tableName) {
      List<String> list = new ArrayList();
      ResultSet rs = null;

      try {
         DatabaseMetaData databaseMetaData = conn.getMetaData();
         rs = databaseMetaData.getPrimaryKeys(dbname, schema, tableName);

         while(rs.next()) {
            list.add(rs.getString("COLUMN_NAME"));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static ResultSet getOceanBaseColumns(Connection conn, String tableName) {
      ResultSet rs = null;
      PreparedStatement ps = null;

      try {
         try {
            String sql = "select * from user_tab_columns WHERE TABLE_NAME = '" + tableName + "'";
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return rs;
      } finally {
         ;
      }
   }

   public static List<String> getOceanBasePK(Connection conn, String dbname, String schema, String tableName) {
      List<String> list = new ArrayList();
      ResultSet rs = null;
      PreparedStatement ps = null;

      try {
         String sql = "select   *   from   user_cons_columns  where owner ='" + schema + "' and table_name='" + tableName + "'";
         ps = conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            list.add(rs.getString("COLUMN_NAME"));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
               ps.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static List<Map<String, String>> getPKs(Connection conn, String dbname, String schema, String tableName) {
      List<Map<String, String>> list = new ArrayList();
      ResultSet rs = null;

      try {
         DatabaseMetaData databaseMetaData = conn.getMetaData();
         rs = databaseMetaData.getPrimaryKeys(dbname, schema, tableName);

         while(rs.next()) {
            Map<String, String> map = new HashMap();
            map.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
            map.put("PK_NAME", rs.getString("PK_NAME"));
            list.add(map);
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return list;
   }

   public static List<ColumnInfoVO> getColumnInfoVO(Connection conn, String schemaPattern, String tableNamePattern) {
      List<ColumnInfoVO> columnList = new ArrayList();
      if (conn == null) {
         return columnList;
      } else {
         String dbtype = getDataBaseType(conn);
         DatabaseMetaData dbmd = null;
         ResultSet rs = null;

         try {
            Properties props = new Properties();

            try {
               props = PropertiesLoaderUtils.loadAllProperties("config.properties");
            } catch (IOException e) {
               e.printStackTrace();
            }

            Object varchar_size_extendedObj = props.getProperty("varchar_size_extended");
            float varchar_size_extended = 1.0F;
            if (null != varchar_size_extendedObj) {
               varchar_size_extended = new Float(props.getProperty("varchar_size_extended"));
            }

            new ArrayList();
            List<String> fkList = new ArrayList();
            dbmd = conn.getMetaData();
            List pkList;
            if (EdbType.MYSQL.getDbname().equals(dbtype)) {
               pkList = getPK(conn, schemaPattern, (String)null, tableNamePattern);
               fkList = getFK(conn, schemaPattern, (String)null, tableNamePattern);
               rs = dbmd.getColumns(schemaPattern, (String)null, tableNamePattern, (String)null);
            } else if (conn.toString().toLowerCase().indexOf("oceanbase") != -1) {
               pkList = getOceanBasePK(conn, (String)null, schemaPattern, tableNamePattern);
               rs = getOceanBaseColumns(conn, tableNamePattern);
            } else {
               pkList = getPK(conn, (String)null, schemaPattern, tableNamePattern);
               if (!dbtype.equals("RAPIDSDB")) {
                  fkList = getFK(conn, (String)null, schemaPattern, tableNamePattern);
               }

               rs = dbmd.getColumns((String)null, schemaPattern, tableNamePattern, (String)null);
            }

            ColumnInfoVO cv;
            if (conn.toString().toLowerCase().indexOf("oceanbase") == -1) {
               while(rs.next()) {
                  cv = new ColumnInfoVO();
                  cv.setTablecat(rs.getString("TABLE_CAT"));
                  cv.setTableschem(rs.getString("TABLE_SCHEM"));
                  cv.setTablename(rs.getString("TABLE_NAME"));
                  if (rs.getString("TABLE_NAME").toLowerCase(Locale.ROOT).equals(tableNamePattern.toLowerCase(Locale.ROOT))) {
                     cv.setColumnname(rs.getString("COLUMN_NAME"));
                     cv.setDatatype(rs.getString("DATA_TYPE"));
                     if (EdbType.DB2.getDbname().equals(dbtype) && "VARCHAR () FOR BIT DATA".equals(rs.getString("TYPE_NAME"))) {
                        cv.setTypename("VARBINARY");
                     } else if (EdbType.INFORMIX.getDbname().equals(dbtype) && "interval".equals(rs.getString("TYPE_NAME")) && "1538".equals(rs.getString("COLUMN_SIZE"))) {
                        cv.setTypename("interval year to month");
                     } else if (EdbType.INFORMIX.getDbname().equals(dbtype) && "interval".equals(rs.getString("TYPE_NAME")) && "2122".equals(rs.getString("COLUMN_SIZE"))) {
                        cv.setTypename("interval day to SECOND");
                     } else if (EdbType.INFORMIX.getDbname().equals(dbtype) && "datetime".equals(rs.getString("TYPE_NAME"))) {
                        cv.setTypename("datetime year to fraction");
                     } else if (EdbType.GREENPLUM.getDbname().equals(dbtype)) {
                        cv.setTypename(rs.getString("TYPE_NAME").toUpperCase(Locale.ROOT));
                     } else {
                        cv.setTypename(rs.getString("TYPE_NAME"));
                     }

                     String columnsize = rs.getString("COLUMN_SIZE");
                     if (columnsize == null) {
                        columnsize = columnsize == null ? "" : columnsize;
                     }

                     if ((EdbType.MYSQL.getDbname().equals(dbtype) || EdbType.RAPIDSDB.getDbname().equals(dbtype)) && "year".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                        columnsize = "4";
                     }

                     if ((EdbType.MYSQL.getDbname().equals(dbtype) || EdbType.RAPIDSDB.getDbname().equals(dbtype) || EdbType.GREENPLUM.getDbname().equals(dbtype) || EdbType.MSSQLSERVER.getDbname().equals(dbtype)) && ("VARCHAR".equalsIgnoreCase(rs.getString("TYPE_NAME")) || "CHAR".equalsIgnoreCase(rs.getString("TYPE_NAME"))) && org.apache.commons.lang3.StringUtils.isNotBlank(columnsize) && 1.0F != varchar_size_extended) {
                        int columnsizeInt = Integer.valueOf(columnsize);
                        columnsizeInt = (int)((float)columnsizeInt * varchar_size_extended);
                        columnsize = String.valueOf(columnsizeInt);
                     }

                     if (EdbType.HIVE.getDbname().equals(dbtype) && "boolean".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                        columnsize = "1";
                     }

                     if (EdbType.ORACLE.getDbname().equals(dbtype) && "INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                        columnsize = "6";
                     }

                     if (EdbType.ORACLE.getDbname().equals(dbtype) && "DATE".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                        columnsize = "19";
                     }

                     if (EdbType.ORACLE.getDbname().equals(dbtype) && "ROWID".equalsIgnoreCase(rs.getString("TYPE_NAME"))) {
                        columnsize = "255";
                     }

                     cv.setColumnsize(columnsize);
                     cv.setBufferlength(rs.getString("BUFFER_LENGTH"));
                     String decimaldigits = rs.getString("DECIMAL_DIGITS");
                     if (decimaldigits == null) {
                        decimaldigits = decimaldigits == null ? "" : decimaldigits;
                     }

                     cv.setDecimaldigits(decimaldigits);
                     cv.setNumprecpadix(rs.getString("NUM_PREC_RADIX"));
                     cv.setNullable(rs.getString("NULLABLE"));
                     String remarks = rs.getString("REMARKS");
                     if (remarks == null || remarks.equals("")) {
                        remarks = "";
                     }

                     cv.setRemarks(remarks);
                     cv.setColumndef(rs.getString("COLUMN_DEF"));
                     cv.setSqldatatype(rs.getString("SQL_DATA_TYPE"));
                     cv.setSqldatetimesub(rs.getString("SQL_DATETIME_SUB"));
                     cv.setCharoctetlength(rs.getString("CHAR_OCTET_LENGTH"));
                     cv.setOrdinalposition(rs.getString("ORDINAL_POSITION"));
                     cv.setIsnullable(rs.getString("IS_NULLABLE"));
                     cv.setPrimarykey("0");
                     cv.setForeignkey("0");
                     cv.setMaskingruleid("");
                     cv.setMaskingrulename("");
                     cv.setRegextype("");
                     if (pkList.contains(cv.getColumnname()) && !EdbType.HIVE.getDbname().equals(dbtype)) {
                        cv.setPrimarykey("1");
                     }

                     if (fkList.contains(cv.getColumnname())) {
                        cv.setForeignkey("1");
                     }

                     if (columnsize.equals("2147483647") && !EdbType.MYSQL.getDbname().equals(dbtype)) {
                        cv.setColumnsize("255");
                     }

                     if (cv.getDecimaldigits().equals("-127") && cv.getColumnsize().equals("0")) {
                        cv.setColumnsize("");
                        cv.setDecimaldigits("");
                     }

                     if (EdbType.INFORMIX.getDbname().equals(dbtype) && "decimal".equalsIgnoreCase(cv.getTypename()) && "255".equals(cv.getDecimaldigits())) {
                        cv.setDecimaldigits("0");
                     }

                     if (EdbType.GREENPLUM.getDbname().equals(dbtype)) {
                        if ("timetz".equalsIgnoreCase(cv.getTypename())) {
                           cv.setDecimaldigits("0");
                        }

                        if ("numeric".equalsIgnoreCase(cv.getTypename())) {
                           cv.setColumnsize("1023");
                        }
                     } else if (EdbType.DB2.getDbname().equals(dbtype)) {
                        if ("vargraphic".equalsIgnoreCase(cv.getTypename())) {
                           cv.setColumnsize(Integer.parseInt(cv.getColumnsize()) / 2 + "");
                        }

                        if ("graphic".equalsIgnoreCase(cv.getTypename())) {
                           cv.setColumnsize(Integer.parseInt(cv.getColumnsize()) / 2 + "");
                        }

                        if ("xml".equalsIgnoreCase(cv.getTypename())) {
                           cv.setColumnsize("8000");
                        }
                     } else if (EdbType.ORACLE.getDbname().equals(dbtype)) {
                        if (cv.getTypename().contains("INTERVAL DAY") || cv.getTypename().contains("interval day")) {
                           cv.setColumnsize("30");
                           cv.setDecimaldigits("0");
                        }

                        if (cv.getTypename().equalsIgnoreCase("LONG")) {
                           cv.setColumnsize("4000");
                        }

                        if (cv.getTypename().equalsIgnoreCase("JTF_PF_PARAMS_TABLE") || cv.getTypename().equalsIgnoreCase("JTF_PF_COOKIES_TABLE") || cv.getTypename().equalsIgnoreCase("OZF_OFFER_HEADER") || cv.getTypename().equalsIgnoreCase("WF_EVENT_T") || cv.getTypename().equalsIgnoreCase("SDO_ORDINATE_ARRAY") || cv.getTypename().equalsIgnoreCase("WF_PARAMETER_LIST_T") || cv.getTypename().equalsIgnoreCase("JTF_PF_PAGE_OBJECT") || cv.getTypename().equalsIgnoreCase("SDO_ELEM_INFO_ARRAY") || cv.getTypename().equalsIgnoreCase("JTF_PF_PRODPARAMS_TABLE") || cv.getTypename().equalsIgnoreCase("IH_BULK_TYPE") || cv.getTypename().equalsIgnoreCase("OZF_ACCOUNT_HEADER") || cv.getTypename().equalsIgnoreCase("AQ$_SIG_PROP") || cv.getTypename().equalsIgnoreCase("OZF_QUOTA_HEADER") || cv.getTypename().equalsIgnoreCase("XNP_MESSAGE_TYPE")) {
                           cv.setTypename("VARCHAR2");
                           cv.setDatatype("12");
                        }
                     }

                     cv.setCharoctetlength(cv.getColumnsize());
                     columnList.add(cv);
                  }
               }
            } else {
               for(; rs.next(); columnList.add(cv)) {
                  cv = new ColumnInfoVO();
                  cv.setColumnname(rs.getString("COLUMN_NAME"));
                  cv.setTablename(rs.getString("TABLE_NAME"));
                  cv.setTypename(rs.getString("DATA_TYPE"));
                  cv.setRemarks("");
                  if ("NUMBER".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     if (null == rs.getString("DATA_PRECISION")) {
                        cv.setColumnsize("");
                     } else {
                        cv.setColumnsize(rs.getString("DATA_PRECISION"));
                     }
                  } else if ("FLOAT".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     cv.setColumnsize(rs.getString("DATA_PRECISION"));
                  } else if ("0".equals(rs.getString("DATA_LENGTH")) && null == rs.getString("DATA_PRECISION") && null != rs.getString("DATA_SCALE")) {
                     cv.setColumnsize(rs.getString("DATA_SCALE"));
                  } else {
                     cv.setColumnsize(rs.getString("DATA_LENGTH"));
                  }

                  if (null == rs.getString("DATA_PRECISION")) {
                     cv.setDecimaldigits("");
                  } else if ("NUMBER".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     cv.setDecimaldigits(rs.getString("DATA_LENGTH"));
                  } else if ("FLOAT".equalsIgnoreCase(rs.getString("DATA_TYPE"))) {
                     cv.setDecimaldigits("");
                  } else {
                     cv.setDecimaldigits(rs.getString("DATA_PRECISION"));
                  }

                  if (pkList.contains(cv.getColumnname())) {
                     cv.setPrimarykey("1");
                  }
               }
            }

            if ("MSSQLSERVER".equals(dbtype)) {
               String sql = "SELECT\ncast (A.name as varchar(200)) AS table_name,\ncast (B.name as varchar(200)) AS column_name,\ncast (C.value as varchar(200)) AS column_description\nFROM sys.tables A\nINNER JOIN sys.columns B ON B.object_id = A.object_id\nLEFT JOIN sys.extended_properties C ON C.major_id = B.object_id AND C.minor_id = B.column_id\nWHERE A.name = '" + tableNamePattern + "'";
               PreparedStatement stm = conn.prepareStatement(sql);
               rs = stm.executeQuery();

               while(rs.next()) {
                  String cname = rs.getString("column_name");
                  Optional<ColumnInfoVO> optionalColumn = columnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst();
                  if (optionalColumn.isPresent()) {
                     ColumnInfoVO columnInfoVO = (ColumnInfoVO)optionalColumn.get();
                     columnInfoVO.setRemarks(rs.getString("column_description"));
                  }
               }
            }

            if ("HIVE".equals(dbtype)) {
               int version = 2;
               String sqlVersion = "select version()";
               PreparedStatement stmVersion = conn.prepareStatement(sqlVersion);

               String ver;
               for(ResultSet var35 = stmVersion.executeQuery(); var35.next(); version = Integer.parseInt(ver.substring(0, 1))) {
                  ver = var35.getString(1);
               }

               if (version < 3) {
                  ver = "desc formatted " + schemaPattern + "." + tableNamePattern;
                  PreparedStatement stm = conn.prepareStatement(ver);
                  rs = stm.executeQuery();

                  while(rs.next()) {
                     String category = rs.getString("category");
                     if (org.apache.commons.lang3.StringUtils.isNotBlank(category) && category.contains("Bucket Columns: ")) {
                        String bucketColumn = rs.getString("attribute");
                        String bucket = bucketColumn.replace("[", "").replace("]", "").trim();
                        Optional<ColumnInfoVO> optionalColumn = columnList.stream().filter((c) -> c.getColumnname().equals(bucket)).findFirst();
                        if (optionalColumn.isPresent()) {
                           ColumnInfoVO columnInfoVO = (ColumnInfoVO)optionalColumn.get();
                           columnInfoVO.setPrimarykey("1");
                           break;
                        }
                     }
                  }
               } else {
                  ver = "DESC EXTENDED " + schemaPattern + "." + tableNamePattern;
                  PreparedStatement stm = conn.prepareStatement(ver);
                  rs = stm.executeQuery();

                  while(rs.next()) {
                     String category = rs.getString("col_name");
                     if (org.apache.commons.lang3.StringUtils.isNotBlank(category) && category.contains("Constraints")) {
                        String bucketColumn = rs.getString("data_type");
                        String pk = getPk(bucketColumn);
                        if (!"".equals(pk)) {
                           Optional<ColumnInfoVO> optionalColumn = columnList.stream().filter((c) -> c.getColumnname().equals(pk)).findFirst();
                           if (optionalColumn.isPresent()) {
                              ColumnInfoVO columnInfoVO = (ColumnInfoVO)optionalColumn.get();
                              columnInfoVO.setPrimarykey("1");
                              break;
                           }
                        }
                     }
                  }
               }
            }

            if ("HIVE_TDH".equals(dbtype)) {
               String sql = "desc formatted " + schemaPattern + "." + tableNamePattern;
               PreparedStatement stm = conn.prepareStatement(sql);
               rs = stm.executeQuery();

               while(rs.next()) {
                  String category = rs.getString("category");
                  if (org.apache.commons.lang3.StringUtils.isNotBlank(category) && category.contains("Bucket Columns: ")) {
                     String bucketColumn = rs.getString("attribute");
                     String bucket = bucketColumn.replace("[", "").replace("]", "").trim();
                     Optional<ColumnInfoVO> optionalColumn = columnList.stream().filter((c) -> c.getColumnname().equals(bucket)).findFirst();
                     if (optionalColumn.isPresent()) {
                        ColumnInfoVO columnInfoVO = (ColumnInfoVO)optionalColumn.get();
                        columnInfoVO.setPrimarykey("1");
                        break;
                     }
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (rs != null) {
               try {
                  rs.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }

         return columnList;
      }
   }

   public static List<TCoreMaskingTaskTableInfo> getColumnInfoVO1(Connection conn, String schemaPattern, String tableNamePattern) {
      List<TCoreMaskingTaskTableInfo> columnList = new ArrayList();
      if (conn == null) {
         return columnList;
      } else {
         String dbtype = getDataBaseType(conn);
         DatabaseMetaData dbmd = null;
         ResultSet rs = null;

         try {
            new ArrayList();
            new ArrayList();
            dbmd = conn.getMetaData();
            List e;
            List fkList;
            if (EdbType.MYSQL.getDbname().equals(dbtype)) {
               e = getPK(conn, schemaPattern, (String)null, tableNamePattern);
               fkList = getFK(conn, schemaPattern, (String)null, tableNamePattern);
               rs = dbmd.getColumns(schemaPattern, (String)null, tableNamePattern, (String)null);
            } else {
               e = getPK(conn, (String)null, schemaPattern, tableNamePattern);
               fkList = getFK(conn, (String)null, schemaPattern, tableNamePattern);
               rs = dbmd.getColumns((String)null, schemaPattern, tableNamePattern, (String)null);
            }

            TCoreMaskingTaskTableInfo cv;
            for(; rs.next(); columnList.add(cv)) {
               cv = new TCoreMaskingTaskTableInfo();
               cv.setTableName(rs.getString("TABLE_NAME"));
               cv.setColumnName(rs.getString("COLUMN_NAME"));
               cv.setSourceType(rs.getString("TYPE_NAME"));
               String columnsize = rs.getString("COLUMN_SIZE");
               if (columnsize == null) {
                  columnsize = columnsize == null ? "" : columnsize;
               }

               cv.setColumnLength(columnsize);
               String decimaldigits = rs.getString("DECIMAL_DIGITS");
               if (decimaldigits == null) {
                  decimaldigits = decimaldigits == null ? "" : decimaldigits;
               }

               cv.setColumnPrecision(decimaldigits);
               String remarks = rs.getString("REMARKS");
               if (remarks == null || remarks.equals("")) {
                  remarks = "";
               }

               cv.setIsnullable(rs.getString("IS_NULLABLE"));
               cv.setIsPrimaryKey("0");
               cv.setIsForeignKey("0");
               cv.setSearchType("");
               cv.setSearchType("");
               cv.setSearchType("");
               if (e.contains(cv.getColumnName())) {
                  cv.setIsPrimaryKey("1");
               }

               if (fkList.contains(cv.getColumnName())) {
                  cv.setIsForeignKey("1");
               }

               if (columnsize.equals("2147483647")) {
                  cv.setColumnLength("255");
               }

               if (cv.getColumnPrecision().equals("-127") && cv.getColumnLength().equals("0")) {
                  cv.setColumnLength("38");
                  cv.setColumnPrecision("0");
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            if (rs != null) {
               try {
                  rs.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }

         return columnList;
      }
   }

   public static Boolean disConstraint(Connection conn, String schema, String tableName, String constraintName) {
      Boolean bool = false;
      String dbType = getDataBaseType(conn);
      String sql = null;
      if (dbType.equals(EdbType.ORACLE.getDbcode())) {
         sql = "alter table " + schema + "." + tableName + " disable constraint \"" + constraintName + "\"";
         PreparedStatement ps = null;

         try {
            ps = conn.prepareStatement(sql);
            ps.executeUpdate();
            Boolean e = !bool;
            return e;
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            if (ps != null) {
               try {
                  ps.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }

         return bool;
      } else {
         return bool;
      }
   }

   public static Boolean enConstraint(Connection conn, String schema, String tableName, String constraintName) {
      Boolean bool = false;
      String dbType = getDataBaseType(conn);
      String sql = null;
      if (dbType.equals(EdbType.ORACLE.getDbcode())) {
         sql = "alter table " + schema + "." + tableName + " enable constraint \"" + constraintName + "\"";
         PreparedStatement ps = null;

         try {
            ps = conn.prepareStatement(sql);
            ps.executeUpdate();
            Boolean e = !bool;
            return e;
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            if (ps != null) {
               try {
                  ps.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }

         return bool;
      } else {
         return bool;
      }
   }

   public static <E> String sql_insert_h(E entity, List<String> liststr) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      StringBuilder sb = new StringBuilder();
      DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      sb.append("(");
      if (liststr.size() != 0) {
         for(String string : liststr) {
            if (getGetMethod(entity.getClass(), string).invoke(entity) != null) {
               Object value = getGetMethod(entity.getClass(), string).invoke(entity);
               if (value instanceof Date) {
                  String getdate = df.format((Date)value);
                  if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                     sb.append("str_to_date('" + getdate + "','%Y-%m-%d %H:%i:%s')");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
                     sb.append("to_date('" + getdate + "','YYYY-MM-DD hh24:mi:ss')");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     sb.append("to_date('" + getdate + "','YYYY-MM-DD hh24:mi:ss')");
                  }
               } else {
                  if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                     sb.append("\"");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
                     sb.append("'");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     sb.append("'");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
                     sb.append("'");
                  }

                  sb.append(getGetMethod(entity.getClass(), string).invoke(entity));
                  if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                     sb.append("\"");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
                     sb.append("'");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     sb.append("'");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
                     sb.append("'");
                  }
               }
            } else {
               sb.append("null");
            }

            sb.append(",");
         }

         sb.deleteCharAt(sb.length() - 1);
      }

      sb.append(")");
      sb.append(",");
      return sb.toString();
   }

   public static <E> List<String> sql_insert_q(E e) {
      List<String> liststr = new ArrayList();
      Field[] fields = e.getClass().getDeclaredFields();

      for(Field field2 : fields) {
         Annotation[] arr = field2.getAnnotations();
         if (null == arr || arr.length <= 0 || !"@javax.persistence.Transient()".equalsIgnoreCase(String.valueOf(arr[0]))) {
            liststr.add(field2.getName());
         }
      }

      return liststr;
   }

   public static <E> String sql_insert_z(List<String> liststr, String tableName) {
      StringBuilder sb = new StringBuilder();
      sb.append("insert into " + tableName);
      sb.append("(");
      if (liststr.size() != 0) {
         for(String key : liststr) {
            if (key.equals("id")) {
               key = "id";
            }

            if (HibernateConfig.PEIZHIKUDBTYPE.equals("3") && key.equals("value")) {
               key = "`value`";
            }

            sb.append(key);
            sb.append(",");
         }

         sb.deleteCharAt(sb.length() - 1);
      }

      sb.append(") ");
      sb.append("values");
      return sb.toString();
   }

   public static <E> String sql_insert(List<String> liststr, String tableName) {
      StringBuilder sb = new StringBuilder();
      sb.append("insert into " + tableName);
      sb.append("(");
      if (liststr.size() != 0) {
         for(String key : liststr) {
            if (key.equals("id")) {
               key = "id";
            }

            sb.append(key);
            sb.append(",");
         }

         sb.deleteCharAt(sb.length() - 1);
      }

      return sb.toString();
   }

   public static Method getGetMethod(Class objectClass, String fieldName) {
      StringBuffer sb = new StringBuffer();
      sb.append("get");
      sb.append(fieldName.substring(0, 1).toUpperCase());
      sb.append(fieldName.substring(1));

      try {
         return objectClass.getMethod(sb.toString());
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public static String sqlServerTypeTran(String dbtype, String datacode) {
      if ("-155".equals(datacode) && !"datetimeoffset".equalsIgnoreCase(dbtype)) {
         dbtype = "datetimeoffset";
      } else if ("92".equals(datacode) & !"time".equalsIgnoreCase(dbtype)) {
         dbtype = "time";
      } else if ("-16".equals(datacode) && !"xml".equalsIgnoreCase(dbtype) && !"ntext".equalsIgnoreCase(dbtype)) {
         dbtype = "ntext";
      } else if ("1".equals(datacode) && !"uniqueidentifier".equalsIgnoreCase(dbtype) && !"char".equalsIgnoreCase(dbtype)) {
         dbtype = "char";
      } else if ("-9".equals(datacode) && !"nvarchar".equalsIgnoreCase(dbtype) && !"sysname".equalsIgnoreCase(dbtype)) {
         dbtype = "nvarchar";
      } else if ("-15".equals(datacode) && !"nchar".equalsIgnoreCase(dbtype)) {
         dbtype = "nchar";
      } else if ("-7".equals(datacode) && !"bit".equalsIgnoreCase(dbtype)) {
         dbtype = "bit";
      } else if ("-6".equals(datacode) && !"tinyint".equalsIgnoreCase(dbtype) && !"tinyint identity".equalsIgnoreCase(dbtype)) {
         dbtype = "tinyint";
      } else if ("-5".equals(datacode) && !"bigint".equalsIgnoreCase(dbtype) && !"bigint identity".equalsIgnoreCase(dbtype)) {
         dbtype = "bigint";
      } else if ("-4".equals(datacode) && !"image".equalsIgnoreCase(dbtype)) {
         dbtype = "image";
      } else if ("-3".equals(datacode) && !"varbinary".equalsIgnoreCase(dbtype)) {
         dbtype = "varbinary";
      } else if ("-2".equals(datacode) && !"binary".equalsIgnoreCase(dbtype)) {
         dbtype = "timestamp";
      } else if ("-1".equals(datacode) && !"text".equalsIgnoreCase(dbtype)) {
         dbtype = "text";
      } else if ("2".equals(datacode) && !"numeric".equalsIgnoreCase(dbtype) && !"numeric() identity".equalsIgnoreCase(dbtype)) {
         dbtype = "numeric";
      } else if ("3".equals(datacode) && !"decimal".equalsIgnoreCase(dbtype) && !"money".equalsIgnoreCase(dbtype) && !"smallmoney".equalsIgnoreCase(dbtype) && !"decimal() identity".equalsIgnoreCase(dbtype)) {
         dbtype = "decimal";
      } else if ("4".equals(datacode) && !"int".equalsIgnoreCase(dbtype) && !"int identity".equalsIgnoreCase(dbtype)) {
         dbtype = "int";
      } else if ("5".equals(datacode) && !"smallint".equalsIgnoreCase(dbtype) && !"smallint identity".equalsIgnoreCase(dbtype)) {
         dbtype = "smallint";
      } else if ("8".equals(datacode) && !"float".equalsIgnoreCase(dbtype)) {
         dbtype = "float";
      } else if ("7".equals(datacode) && !"real".equalsIgnoreCase(dbtype)) {
         dbtype = "real";
      } else if ("12".equals(datacode) && !"varchar".equalsIgnoreCase(dbtype)) {
         dbtype = "varchar";
      } else if ("91".equals(datacode) && !"date".equalsIgnoreCase(dbtype)) {
         dbtype = "date";
      } else if ("93".equals(datacode) && !"datetime2".equalsIgnoreCase(dbtype) && !"datetime".equalsIgnoreCase(dbtype) && !"smalldatetime".equalsIgnoreCase(dbtype)) {
         dbtype = "datetime";
      }

      return dbtype;
   }

   public static String returnTaskType(String taskType) throws Exception {
      String rtnType = "";
      String[] typeArr = taskType.split("to");
      if ("DB".equals(typeArr[0])) {
         if ("DB".equals(typeArr[1])) {
            rtnType = "DBtoDB";
         } else if ("HIVE".equals(typeArr[1])) {
            rtnType = "DBtoHIVE";
         } else if (EdbType.KAFKA.getDbname().equals(typeArr[1])) {
            rtnType = "DBtoKAFKA";
         } else {
            rtnType = "DBtoFILE";
         }
      } else if ("HIVE".equals(typeArr[0])) {
         if ("DB".equals(typeArr[1])) {
            rtnType = "HIVEtoDB";
         } else if ("HIVE".equals(typeArr[1])) {
            rtnType = "HIVEtoHIVE";
         } else {
            rtnType = "HIVEtoFILE";
         }
      } else if ("DB".equals(typeArr[1])) {
         rtnType = "FILEtoDB";
      } else if ("HIVE".equals(typeArr[1])) {
         rtnType = "FILEtoHIVE";
      } else {
         rtnType = "FILEtoFILE";
      }

      return rtnType;
   }

   public static String returnType(String readType, String writeType, String tasktype) {
      String rtnType = "";
      if (org.apache.commons.lang3.StringUtils.isNotBlank(tasktype)) {
         tasktype = tasktype.replace("KAFKA", "DB");
      }

      switch (tasktype) {
         case "DBtoDB":
            if (!"normal".equals(readType)) {
               readType = "batchread,";
            } else {
               readType = readType + ",";
            }

            if (!"normal".equals(writeType)) {
               writeType = "batchwrite";
            }

            rtnType = tasktype + "," + readType + writeType;
            break;
         case "DBtoFILE":
            if (!"normal".equals(readType)) {
               readType = "batchread";
            }

            rtnType = tasktype + "," + readType;
            break;
         case "DBtoFTP":
            if (!"normal".equals(readType)) {
               readType = "batchread";
            } else {
               readType = readType + "normal";
            }

            rtnType = "DBtoFILE," + readType;
            break;
         case "DBtoSFTP":
            if (!"normal".equals(readType)) {
               readType = "batchread";
            } else {
               readType = readType + "normal";
            }

            rtnType = "DBtoFILE," + readType;
            break;
         case "FILEtoDB":
            if (!"normal".equals(writeType)) {
               writeType = ",batchwrite";
            } else {
               writeType = ",normal";
            }

            rtnType = tasktype + writeType;
            break;
         case "FTPtoDB":
            if (!"normal".equals(writeType)) {
               writeType = ",batchwrite";
            } else {
               writeType = ",normal";
            }

            rtnType = "FILEtoDB" + writeType;
            break;
         case "SFTPtoDB":
            if (!"normal".equals(writeType)) {
               writeType = ",batchwrite";
            } else {
               writeType = ",normal";
            }

            rtnType = "FILEtoDB" + writeType;
            break;
         case "FILEtoFILE":
            rtnType = tasktype;
            break;
         case "FILEtoFTP":
            rtnType = "FILEtoFILE";
            break;
         case "FILEtoSFTP":
            rtnType = "FILEtoFILE";
            break;
         case "HIVEtoHIVE":
            if (!"normal".equals(readType)) {
               readType = "batchread,";
            } else {
               readType = readType + ",";
            }

            if (!"normal".equals(writeType)) {
               writeType = "batchwrite";
            }

            rtnType = tasktype + "," + readType + writeType;
      }

      return rtnType;
   }

   public static StringBuffer ClobToString(Clob sc) throws SQLException, IOException {
      Reader is = sc.getCharacterStream();
      BufferedReader br = new BufferedReader(is);
      String s = br.readLine();

      StringBuffer sb;
      for(sb = new StringBuffer(); s != null; s = br.readLine()) {
         sb.append(s);
         sb.append("\r\n");
      }

      return sb;
   }

   public static void performTime(List<Long> list) {
      long time = System.currentTimeMillis();
      list.add(time);

      for(int i = 1; i < list.size(); ++i) {
         System.out.println("第" + list.size() + "块代码，执行时间:" + ((Long)list.get(i) - (Long)list.get(i - 1)) + "ms");
      }

   }

   public static <E> String sql_insert_h_date(E entity, List<String> liststr) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      StringBuilder sb = new StringBuilder();
      String erro = "";
      Date currentTime = new Date();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      sb.append("(");
      if (liststr.size() != 0) {
         for(String string : liststr) {
            try {
               erro = entity.getClass().getDeclaredField(string).getGenericType().toString();
            } catch (Exception var9) {
               erro = "false";
            }

            if (getGetMethod(entity.getClass(), string).invoke(entity) != null) {
               if (!"false".equals(erro) && "class java.util.Date".equals(erro)) {
                  if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                     sb.append("str_to_date('" + formatter.format(currentTime) + "','%Y-%m-%d %H:%i:%s')");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
                     sb.append("to_date('" + formatter.format(currentTime) + "','YYYY-MM-DD hh24:mi:ss')");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     sb.append("to_date('" + formatter.format(currentTime) + "','YYYY-MM-DD hh24:mi:ss')");
                  }
               } else {
                  if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                     sb.append("\"");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
                     sb.append("'");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     sb.append("'");
                  }

                  sb.append(getGetMethod(entity.getClass(), string).invoke(entity));
                  if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                     sb.append("\"");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
                     sb.append("'");
                  } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     sb.append("'");
                  }
               }
            } else {
               sb.append("null");
            }

            sb.append(",");
         }

         sb.deleteCharAt(sb.length() - 1);
      }

      sb.append(")");
      sb.append(",");
      return sb.toString();
   }

   public static String executeQuerySql(Connection conn) {
      String version = "";
      String sql = "SELECT service_level, fixpack_num FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO";
      PreparedStatement pstmt = null;
      ResultSet r = null;

      try {
         pstmt = conn.prepareStatement(sql);

         for(r = pstmt.executeQuery(); r.next(); version = r.getString("SERVICE_LEVEL")) {
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (r != null) {
               r.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }

            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return version;
   }

   public static Set<String> getColumnMap(Connection connection, String schema, String tableName) {
      List<ColumnInfo> allColumnInfo = getAllColumnInfo(connection, schema, tableName);
      return (Set<String>)(allColumnInfo != null && allColumnInfo.size() != 0 ? (Set)allColumnInfo.stream().filter((x) -> x != null && x.getColumnname() != null && x.getColumnname().length() > 0).map((x) -> x.getColumnname()).collect(Collectors.toSet()) : new HashSet());
   }

   public static void rollbackReplaceColumn(Connection connection, String schema, String table, String srcColName, String copyName, String type, String size, String primaryKeyFlag, String primary_key_columns, String columnNameKey, TCoreDatasystem coreDataSystem) {
      Set<String> columnMap = getColumnMap(connection, schema, table);
      if (!columnMap.contains(srcColName.toLowerCase())) {
         try {
            replaceTableFieldName(connection, schema, table, copyName, srcColName, type, size, primaryKeyFlag, primary_key_columns, columnNameKey, coreDataSystem);
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public static void rollbackReplaceColumn(Connection connection, Set<String> columnMap, String schema, String table, String srcColName, String copyName, String type, String size, String primaryKeyFlag, String primary_key_columns, String columnNameKey, TCoreDatasystem coreDataSystem) {
      if (!columnMap.contains(srcColName.toLowerCase())) {
         try {
            replaceTableFieldName(connection, schema, table, copyName, srcColName, type, size, primaryKeyFlag, primary_key_columns, columnNameKey, coreDataSystem);
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   private static void replaceTableFieldName(Connection con, String schema, String tableName, String sourceFieldName, String targetFieldName, String columnType, String columnSize, String primaryKeyFlag, String primary_key_columns, String columnNameKey, TCoreDatasystem tCoreDatasystem) throws SQLException {
      String columnSizestr = "";
      if (StringUtils.isNotBlank(columnSize)) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            columnSizestr = "(" + columnSize + " BYTE)";
         } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !EdbType.GREENPLUM.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
            columnSizestr = "(" + columnSize + ")";
         } else {
            columnSizestr = "(" + columnSize + ")";
         }
      }

      if (null != columnType && columnType.toLowerCase().contains("text")) {
         columnSizestr = "";
      }

      String sql = "";
      if (tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         sql = "ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName;
      } else if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            sql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + sourceFieldName + "]', '" + targetFieldName + "', 'COLUMN'";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + sourceFieldName + "\" rename to \"" + targetFieldName + "\"";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            sql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + sourceFieldName + "\" TO \"" + targetFieldName + "\"";
         } else {
            sql = "alter table " + schema + "." + tableName + " change column " + sourceFieldName + " " + targetFieldName + " " + columnType + columnSizestr;
         }
      } else {
         sql = "ALTER TABLE " + schema + "." + tableName + "  RENAME COLUMN " + sourceFieldName + " TO " + targetFieldName;
      }

      PreparedStatement preStatement = con.prepareStatement(sql);
      preStatement.executeUpdate();
      if (preStatement != null) {
         try {
            preStatement.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

      if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
         String primaryKeysqlIndex = "";
         String primaryKeysql = "";
         String primaryKeysql1 = "";
         if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype()) && !tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            if (tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(con, schema, tableName);
               StringBuilder primaryKeysqlBuilder = new StringBuilder();
               if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                  for(int i = 0; i < primarykeyInfo.size(); ++i) {
                     primaryKeysql = "ALTER TABLE " + schema + "." + tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + " ";
                     primaryKeysqlBuilder.append(primaryKeysql);
                  }

                  primaryKeysql = primaryKeysqlBuilder.toString();
               }
            } else if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(con, schema, tableName);
               if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                  for(int i = 0; i < primarykeyInfo.size(); ++i) {
                     primaryKeysqlIndex = "create CLUSTER index \"" + schema + "_" + tableName + "_" + targetFieldName + "_index\" on \"" + schema + "\".\"" + tableName + "\"(\"" + targetFieldName + "\") ";
                     primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\"";
                     primaryKeysql1 = "drop index \"" + schema + "\".\"" + schema + "_" + tableName + "_" + sourceFieldName + "_index\"";
                     PreparedStatement preStatementKeyIndex = con.prepareStatement(primaryKeysqlIndex);
                     preStatementKeyIndex.executeUpdate();
                     preStatementKeyIndex.close();
                     PreparedStatement preStatementKey = con.prepareStatement(primaryKeysql);
                     preStatementKey.executeUpdate();
                     preStatementKey.close();
                     PreparedStatement preStatementKey1 = con.prepareStatement(primaryKeysql1);
                     preStatementKey1.executeUpdate();
                     preStatementKey1.close();
                  }
               }
            } else if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               primaryKeysql = "alter table " + schema + "." + tableName + "  drop primary key";
            } else {
               List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(con, schema, tableName);
               StringBuilder primaryKeysqlBuilder = new StringBuilder();
               if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                  for(int i = 0; i < primarykeyInfo.size(); ++i) {
                     primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\" ";
                     primaryKeysqlBuilder.append(primaryKeysql);
                  }

                  primaryKeysql = primaryKeysqlBuilder.toString();
               }
            }
         } else {
            String tableName1 = tableName.replace("\"", "");
            if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               primaryKeysql = "alter table " + schema + "." + tableName + "  DROP CONSTRAINT \"" + tableName1 + "_pkey\"";
            } else {
               primaryKeysql = "alter table " + schema + "." + tableName + "  DROP CONSTRAINT \"" + tableName1 + "_pkey\"";
            }
         }

         if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            PreparedStatement preStatementKey = con.prepareStatement(primaryKeysql);
            preStatementKey.executeUpdate();
            preStatementKey.close();
            if (EdbType.GAUSS.toString().equalsIgnoreCase(tCoreDatasystem.getDbtype())) {
               con.commit();
            }
         }
      }

   }

   public static String queryHdfsLocationForTDH(Connection conn, String schema, String table) {
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      String sql = "desc formatted `" + schema + "`." + table;
      String location = null;

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.setString(1, schema);
         pstmt.setString(2, table);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            if (rs.getString(1).startsWith("Location:")) {
               location = rs.getString(2);
               break;
            }
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return location;
   }

   public static Map<String, String> queryHdfsFileInfoForTDH(Connection conn, String schema, String table) {
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      String sql = "desc formatted `" + schema + "`." + table;
      Map<String, String> outputs = new HashMap();

      try {
         pstmt = conn.prepareStatement(sql);
         pstmt.setString(1, schema);
         pstmt.setString(2, table);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            if (rs.getString(1).startsWith("Location:")) {
               String location = rs.getString(2);
               outputs.put("location", location);
            } else if (rs.getString(1).startsWith("SerDe Library:")) {
               String serde = rs.getString(2);
               outputs.put("serde", serde);
            } else if (rs.getString(1).startsWith("field.delim:")) {
               String delim = rs.getString(2);
               outputs.put("field.delim", delim);
            } else if (rs.getString(1).startsWith("transactional")) {
               String transactional = rs.getString(2);
               outputs.put("transactional", transactional);
            } else if (rs.getString(1).startsWith("Owner")) {
               String owner = rs.getString(2);
               outputs.put("owner", owner);
            } else if (rs.getString(1).startsWith("Table Type")) {
               String tableType = rs.getString(2);
               outputs.put("table.type", tableType);
            } else if (rs.getString(1).startsWith("InputFormat:")) {
               String tableType = rs.getString(2);
               outputs.put("input.format", tableType);
            }
         }
      } catch (SQLException e1) {
         e1.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (pstmt != null) {
               pstmt.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return outputs;
   }

   private static String getPk(String str) {
      String pk = "";
      String getPk = "\\[(.*)\\]";
      Pattern pattern = Pattern.compile(getPk);
      Matcher matcher = pattern.matcher(str);

      try {
         while(matcher.find()) {
            pk = matcher.group(1);
         }

         return pk;
      } catch (Exception var6) {
         return "";
      }
   }

   static {
      noSizeList.add("BLOB");
      noSizeList.add("CLOB");
      noSizeList.add("DATE");
      noSizeList.add("DATETIME");
      noSizeList.add("LONGBLOB");
      noSizeList.add("LONGTEXT");
      noSizeList.add("IMAGE");
      noSizeList.add("TEXT");
      noSizeList.add("INTEGER");
      noSizeList.add("TIME");
   }
}
