package com.chenyang.nse.bussiness.tools.xml;

import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReadJsonTool {
   public static String charset(String path) {
      FileInputStream fis = null;
      BufferedInputStream bis = null;
      String charset = "GBK";
      byte[] first3Bytes = new byte[3];

      try {
         boolean checked = false;
         fis = new FileInputStream(path);
         bis = new BufferedInputStream(fis);
         bis.mark(0);
         int read = bis.read(first3Bytes, 0, 3);
         if (read == -1) {
            try {
               if (bis != null) {
                  bis.close();
               }

               if (fis != null) {
                  fis.close();
               }
            } catch (IOException e) {
               e.printStackTrace();
            }

            return charset;
         }

         if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
            charset = "UTF-16LE";
            checked = true;
         } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
            charset = "UTF-16BE";
            checked = true;
         } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
            charset = "UTF-8";
            checked = true;
         }

         bis.reset();
         if (!checked) {
            while((read = bis.read()) != -1 && read < 240 && (128 > read || read > 191)) {
               if (192 <= read && read <= 223) {
                  read = bis.read();
                  if (128 > read || read > 191) {
                     break;
                  }
               } else if (224 <= read && read <= 239) {
                  read = bis.read();
                  if (128 <= read && read <= 191) {
                     read = bis.read();
                     if (128 <= read && read <= 191) {
                        charset = "UTF-8";
                     }
                  }
                  break;
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      try {
         if (bis != null) {
            bis.close();
         }

         if (fis != null) {
            fis.close();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return charset;
   }

   public static String sftpCharset(InputStream bi) throws Exception {
      BufferedInputStream bis = new BufferedInputStream(bi);
      String charset = "GBK";
      byte[] first3Bytes = new byte[3];
      boolean checked = false;
      bis.mark(100);
      int read = bis.read(first3Bytes, 0, 3);
      if (read == -1) {
         if (bis != null) {
            bis.close();
         }

         if (bi != null) {
            bi.close();
         }

         return charset;
      } else {
         if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
            charset = "UTF-16LE";
            checked = true;
         } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
            charset = "UTF-16BE";
            checked = true;
         } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
            charset = "UTF-8";
            checked = true;
         }

         bis.reset();
         if (!checked) {
            while((read = bis.read()) != -1 && read < 240 && (128 > read || read > 191)) {
               if (192 <= read && read <= 223) {
                  read = bis.read();
                  if (128 > read || read > 191) {
                     break;
                  }
               } else if (224 <= read && read <= 239) {
                  read = bis.read();
                  if (128 <= read && read <= 191) {
                     read = bis.read();
                     if (128 <= read && read <= 191) {
                        charset = "UTF-8";
                     }
                  }
                  break;
               }
            }
         }

         if (bis != null) {
            bis.close();
         }

         if (bi != null) {
            bi.close();
         }

         return charset;
      }
   }

   public static String ReadFile(String path, String charset) {
      BufferedReader reader = null;
      String laststr = "";

      try {
         reader = new BufferedReader(new InputStreamReader(new FileInputStream(path), charset));
         String tempString = null;

         for(int line = 1; (tempString = reader.readLine()) != null; ++line) {
            laststr = laststr + tempString;
         }

         reader.close();
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         if (reader != null) {
            try {
               reader.close();
            } catch (IOException var13) {
            }
         }

      }

      return laststr;
   }

   public static Map<String, List<String>> iteraJsonOrArray(String source) {
      Object parse1 = JSONArray.parse(source);
      Object parse = JSONUtils.parse(parse1.toString());
      String resultStr = "";
      String jsonstring = parse.toString();
      if (jsonstring.contains("{")) {
         jsonstring = jsonstring.replaceAll("\\{", "");
      }

      if (jsonstring.contains("[")) {
         jsonstring = jsonstring.replaceAll("\\[", "");
      }

      if (jsonstring.contains("]")) {
         jsonstring = jsonstring.replaceAll("\\]", "");
      }

      if (jsonstring.contains("}")) {
         jsonstring = jsonstring.replaceAll("\\}", "");
      }

      Map<String, List<String>> map = new HashMap();
      if (jsonstring.contains(",")) {
         String[] split = jsonstring.split(",");

         for(String string : split) {
            List<String> list = new ArrayList();
            if (string.contains("=")) {
               String[] split2 = string.split("=");
               if (split2.length == 1) {
                  String keyone = split2[split2.length - 1].trim();
                  if (map.containsKey(keyone)) {
                     List<String> list2 = (List)map.get(keyone);
                     list2.add("");
                  } else {
                     list.add("");
                     map.put(keyone, list);
                  }
               } else {
                  String keytwo = split2[split2.length - 2].trim();
                  String valuetwo = split2[split2.length - 1].trim();
                  if (map.containsKey(keytwo)) {
                     List<String> list2 = (List)map.get(keytwo);
                     list2.add(valuetwo);
                  } else {
                     list.add(valuetwo);
                     map.put(keytwo, list);
                  }
               }
            }
         }
      }

      return map;
   }

   public static void parseJSON2Map(Map<String, List<String>> map, String json, String parentKey) throws Exception {
      if (isJsonObject(json)) {
         JSONObject jsonObject = JSONObject.parseObject(json);

         for(String key : jsonObject.keySet()) {
            Object obj = jsonObject.get(key);
            String currentKey = StringUtils.isBlank(parentKey) ? key : parentKey + "." + key;
            if (obj instanceof JSONArray) {
               parseJSON2Map(map, obj.toString(), currentKey);
            } else if (obj instanceof JSONObject) {
               parseJSON2Map(map, obj.toString(), currentKey);
            } else if (map.containsKey(currentKey)) {
               List<String> list = (List)map.get(currentKey);
               list.add(obj.toString());
               map.put(currentKey, list);
            } else {
               ArrayList<String> arrayList = new ArrayList();
               arrayList.add(obj.toString());
               map.put(currentKey, arrayList);
            }
         }
      } else {
         if (!isJsonArray(json)) {
            throw new Exception("不是json串");
         }

         for(Object obj : JSONArray.parseArray(json)) {
            if (obj instanceof JSONArray) {
               parseJSON2Map(map, obj.toString(), parentKey);
            } else if (obj instanceof JSONObject) {
               parseJSON2Map(map, obj.toString(), parentKey);
            } else if (map.containsKey(parentKey)) {
               List<String> list = (List)map.get(parentKey);
               list.add(obj.toString());
               map.put(parentKey, list);
            } else {
               ArrayList<String> arrayList = new ArrayList();
               arrayList.add(obj.toString());
               map.put(parentKey, arrayList);
            }
         }
      }

   }

   public static boolean isJsonObject(String content) {
      if (StringUtils.isBlank(content)) {
         return false;
      } else {
         try {
            JSONObject.parseObject(content);
            return true;
         } catch (Exception var2) {
            return false;
         }
      }
   }

   public static boolean isJsonArray(String content) {
      if (StringUtils.isBlank(content)) {
         return false;
      } else {
         StringUtils.isEmpty(content);

         try {
            JSONArray.parseArray(content);
            return true;
         } catch (Exception var2) {
            return false;
         }
      }
   }

   public static void main(String[] args) {
      String path = "D:\\data\\infa_file\\treegrid2_data.json";
      String charset = charset(path);
      String readFile = ReadFile(path, charset);
      new HashMap();
      Map<String, List<String>> iteraJsonOrArray = iteraJsonOrArray(readFile);
      System.out.println(iteraJsonOrArray);
   }
}
