package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleHelpDocument;
import com.chenyang.nse.bussiness.entity.vo.HelpDocumentVO;
import com.chenyang.nse.bussiness.service.console.TConsoleHelpDocumentService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/helpdocument"})
public class TConsoleHelpDocumentController {
   @Autowired
   private TConsoleHelpDocumentService tConsoleHelpDocumentService;

   @GetMapping({"/returnAnchor"})
   @ResponseBody
   public Response<String> returnAnchor() {
      return RespHelper.<String>successResp(UUID.randomUUID().toString());
   }

   @RequestMapping({"/saveHelpDocument"})
   @ResponseBody
   public Response addHelpDocument(@RequestBody HelpDocumentVO vo) {
      String id = vo.getId();
      if (!id.equals("") && id != null) {
         this.tConsoleHelpDocumentService.editHelpDocument(vo);
      } else {
         TConsoleHelpDocument help = new TConsoleHelpDocument();
         help.setContent(vo.getContent());
         help.setFa_id(vo.getFa_id());
         help.setCreatetime(new Date());
         help.setCreateuser(CommonUtils.loginUsername());
         help.setMenu_name(vo.getMenu_name());
         help.setId(UUID.randomUUID().toString());
         help.setAnchor(vo.getAnchor());
         this.tConsoleHelpDocumentService.addHelpDocument(help);
      }

      return RespHelper.successResp();
   }

   @RequestMapping({"/delHelpDocument"})
   @ResponseBody
   public Response delHelpDocument(@RequestBody HelpDocumentVO vo) {
      this.tConsoleHelpDocumentService.delHelpDocument(vo);
      return RespHelper.successResp();
   }

   @RequestMapping({"/queryHelpDocument"})
   @ResponseBody
   public Response<TConsoleHelpDocument> queryHelpDocument(@RequestBody HelpDocumentVO vo) {
      TConsoleHelpDocument help = this.tConsoleHelpDocumentService.queryHelpDocument(vo);
      return RespHelper.<TConsoleHelpDocument>successResp(help);
   }

   @RequestMapping({"/getDocumentsList"})
   @ResponseBody
   public Response<List<HelpDocumentVO>> getDocumentsList() {
      List<HelpDocumentVO> list = this.tConsoleHelpDocumentService.getDocumentsList();
      return RespHelper.<List<HelpDocumentVO>>successResp(list);
   }
}
