package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.notice.SysLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.MailInformation;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SnmpTrapInfomation;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SyslogInfomation;
import com.chenyang.nse.bussiness.service.core.MailService;
import com.chenyang.nse.bussiness.service.core.SnmpTrapService;
import com.chenyang.nse.bussiness.tools.syslog.MySyslogClient;
import com.chenyang.nse.bussiness.tools.thread.GenericAsyProcess;
import com.chenyang.nse.bussiness.tools.trapServer.SnmpTrapSender;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/dblog"})
public class DblogController {
   private static Logger logger = LoggerFactory.getLogger(DblogController.class);
   @Autowired
   private MailService mailService;
   @Autowired
   private SnmpTrapService snmpTrapService;
   @Autowired
   private SysLogDao sysLogDao;
   @Autowired
   private JavaMailSender jms;
   private static Properties props = new Properties();
   private static String mailSubject = "";
   private static String mailContent = "";
   private static String mailTo = "";

   @RequestMapping({"/sendAlertInfo"})
   @ResponseBody
   public Response sendAlertInfo(@RequestParam Map<String, String> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String alarmtype = (String)params.get("alarmtype");
      String alarmid = (String)params.get("alarmid");
      if (StringUtils.isNotBlank(alarmtype)) {
         if (alarmtype.equals("0")) {
            List<MailInformation> mailList = this.mailService.queryAll();
            if (StringUtils.isNotBlank(alarmid)) {
               mailList = (List)mailList.stream().filter((log) -> log.getId().equalsIgnoreCase(alarmid)).collect(Collectors.toList());
            }

            if (mailList.size() > 0) {
               MailInformation mail = (MailInformation)mailList.get(0);
               mail.setMailsubject(mail.getMailsubject() == null ? mailSubject : mail.getMailsubject());
               mail.setMailto(mailTo);
               mail.setMailbody(mail.getMailbody() == null ? mailContent : mail.getMailbody());
               GenericAsyProcess.asyCommitThreadPool("sendSimpleMail", this.mailService, mail);
            }
         } else if (alarmtype.equals("1")) {
            List<SnmpTrapInfomation> snmpList = this.snmpTrapService.queryAll();
            if (StringUtils.isNotBlank(alarmid)) {
               snmpList = (List)snmpList.stream().filter((log) -> log.getId().equalsIgnoreCase(alarmid)).collect(Collectors.toList());
            }

            if (snmpList.size() > 0) {
               SnmpTrapInfomation snmp = (SnmpTrapInfomation)snmpList.get(0);
               SnmpTrapSender snmpTrapSender = new SnmpTrapSender();
               GenericAsyProcess.asyCommitThreadPool("sendSnpm", snmpTrapSender, snmp.getSnmp_server_ip(), snmp.getPort());
            }
         } else if (alarmtype.equals("2")) {
            List<SyslogInfomation> syslogList = this.sysLogDao.queryAll();
            if (StringUtils.isNotBlank(alarmid)) {
               syslogList = (List)syslogList.stream().filter((log) -> log.getId().equalsIgnoreCase(alarmid)).collect(Collectors.toList());
            }

            if (syslogList.size() > 0) {
               SyslogInfomation syslog = (SyslogInfomation)syslogList.get(0);
               MySyslogClient syslogClient = new MySyslogClient();
               GenericAsyProcess.asyCommitThreadPool("sendSyslog", syslogClient, syslog.getHostname(), syslog.getPort().intValue());
            }
         }
      }

      return RespHelper.successResp();
   }

   static {
      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         mailSubject = props.getProperty("mailSubject");
         mailContent = props.getProperty("mailContent");
         mailTo = props.getProperty("mailTo");
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
