package com.chenyang.nse.bussiness.controller.core;

import cn.hutool.core.util.ObjectUtil;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreDesensitizationRule;
import com.chenyang.nse.bussiness.service.core.DesensitizationRuleService;
import com.chenyang.nse.bussiness.service.core.encryption.DesensitizationStrategyService;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/desensitizationrule"})
public class DesensitizationRuleController {
   @Autowired
   DesensitizationRuleService desensitizationRuleService;
   @Autowired
   DesensitizationStrategyService desensitizationStrategyService;

   @ResponseBody
   @RequestMapping({"/save"})
   public Response save(@RequestBody TCoreDesensitizationRule rule) {
      if (!ObjectUtil.isEmpty(rule.getExpression())) {
         String expression = rule.getExpression();
         String s = expression.replaceAll("\"", "'");
         rule.setExpression(s);
      }

      return RespHelper.successResp(this.desensitizationRuleService.save(rule));
   }

   @ResponseBody
   @RequestMapping({"/delete"})
   public Response delete(@RequestBody Map<String, String> map) {
      String ruleId = (String)map.get("ruleId");
      if (!ObjectUtils.isEmpty(ruleId) && this.desensitizationStrategyService.checkStrategy(ruleId)) {
         return RespHelper.createResp(false, "pop_00032", MesUtil.getMsg("pop_00032", new String[0]));
      } else {
         this.desensitizationRuleService.delete(ruleId);
         return RespHelper.successResp();
      }
   }

   @ResponseBody
   @RequestMapping({"/query"})
   public Response query(String dataarea) {
      List<TCoreDataArea> list = this.desensitizationRuleService.queryRuleList(dataarea);
      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/test"})
   public Response test(@RequestBody Map<String, String> map) {
      String param = (String)map.get("param");
      String expression = (String)map.get("expression");
      if (!"".equals(param.trim()) && !"".equals(expression.trim())) {
         String result = this.desensitizationRuleService.test(param, expression);
         return "表达式错误!".equals(result) ? RespHelper.paramErrResp() : RespHelper.successResp(result);
      } else {
         return RespHelper.paramErrResp();
      }
   }

   @ResponseBody
   @RequestMapping({"/setdefault"})
   public Response setdefault(@RequestBody Map<String, String> map) {
      String ruleId = (String)map.get("ruleId");
      this.desensitizationRuleService.setdefault(ruleId);
      return RespHelper.successResp();
   }
}
