package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.batchmanage.BatchManage;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataTargetfield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitorInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.EncryptionMasking;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingImgInfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.CompareInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DesensitizationMonitorService;
import com.chenyang.nse.bussiness.service.core.EncryptionMaskingService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.TCoreMaskingImgInfoService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.service.info.db.DatabaseTool;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.dmp.TableStructureInfo;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.io.PipeTool;
import com.chenyang.nse.bussiness.tools.io.SocketTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.system.SysUtils;
import com.chenyang.nse.bussiness.interfaces.IHiveRMI;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import transdbf.transdbf;

@EnableAsync
@Controller
@RequestMapping({"/core/encryptionmasking"})
public class EncryptionMaskingController {
   private static Logger logger = LoggerFactory.getLogger(EncryptionMaskingController.class);
   private static final String Link_character = "_";
   public static final String DB_pwc_FILE_batchwrite_DB = "DBtoDB,normal,batchwrite";
   public static final String DB_batchread_FILE_pwc_DB = "DBtoDB,batchread,normal";
   public static final String DB_batchread_FILE_pwc_FILE_batchwrite_DB = "DBtoDB,batchread,batchwrite";
   public static final String DB_pwc_DB = "DBtoDB,normal,normal";
   public static final String DB_pwc_FILE = "DBtoFILE,normal";
   public static final String DB_batchread_FILE_pwc_FILE = "DBtoFILE,batchread";
   public static final String FILE_pwc_FILE_batchwrite_DB = "FILEtoDB,batchwrite";
   public static final String FILE_pwc_DB = "FILEtoDB,normal";
   public static final String FILE_pwc_FILE = "FILEtoFILE";
   public static final String HIVE_batchread_FILE_pwc_FILE_batchwrite_HIVE = "HIVEtoHIVE,batchread,batchwrite";
   public static final String INIT_STATE = "0";
   public static final String CHOOSE_STATE = "1";
   public static final String UPDATE_STATE = "2";
   public static final String CHOOSE_UPDATE_STATE = "3";
   public static final String ALL_CHOOSE = "0";
   public static final String NO_SAVE = "1";
   public static final String YES_SAVE = "2";
   public static final String NO_CHOOSE = "3";
   public static final String YES_CHOOSE = "4";
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private EncryptionMaskingService encryptionMaskingService;
   @Autowired
   private InfoService infoService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   private TCoreMaskingImgInfoService tCoreMaskingImgInfoService;
   @Autowired
   private DesensitizationMonitorService desensitizationMonitorService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      String crud = request.getParameter("crud");
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      String projectid = (String)request.getSession().getAttribute("projectid");
      model.addAttribute("projectid", projectid);
      model.addAttribute("crud", crud);
      return "core/encryptionmasking/encryptionmasking_list";
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @RequestMapping({"/desensitizationImg"})
   public String desensitizationImg(HttpServletRequest request, HttpServletResponse response, Model model) {
      String ip = request.getHeader("x-forwarded-for");
      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("Proxy-Client-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("WL-Proxy-Client-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("X-Real-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getRemoteAddr();
      }

      model.addAttribute("ip", ip);
      return "core/encryptionmasking/encryptionmasking_img";
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<EncryptionMasking> querytask(String isstart, String engineid, String taskname, String projectid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<EncryptionMasking> list = this.encryptionMaskingService.queryTask(taskname, pageInfo);
      if (isstart != null) {
         for(EncryptionMasking encryptionMasking : list) {
            String tasknamereal = encryptionMasking.getTasknamereal();
            if (!encryptionMasking.getSave_state().equals("0")) {
               if (encryptionMasking.getSave_state().equals("1")) {
                  encryptionMasking.setCount_exe("");
               } else {
                  encryptionMasking.setCount_exe("100%");
                  String removePercent = (String)this.redisService.get("removePercent_" + tasknamereal);
                  if (removePercent != null) {
                     encryptionMasking.setRemovePercent(removePercent);
                  }
               }

               this.redisService.remove(tasknamereal + "_zcount");
               this.redisService.remove(tasknamereal + "_ncount");
            } else {
               String time_exe = (String)this.redisService.get(tasknamereal + "_ntime");
               String count_exe = (String)this.redisService.get(tasknamereal + "_zcount");
               String ncount_exe = (String)this.redisService.get(tasknamereal + "_ncount");
               long ncount_exe_num = 0L;
               long count_exe_num = 1L;

               try {
                  if (ncount_exe == null) {
                     ncount_exe = "0";
                  }

                  if (count_exe == null) {
                     count_exe = "1";
                  }

                  ncount_exe_num = new Long(ncount_exe);
                  count_exe_num = new Long(count_exe);
               } catch (Exception var24) {
               }

               NumberFormat numberFormat = NumberFormat.getInstance();
               numberFormat.setMaximumFractionDigits(2);
               String result = numberFormat.format((double)ncount_exe_num / (double)count_exe_num * (double)100.0F);
               encryptionMasking.setCount_exe(result + "%");
            }

            DesensitizationMonitor moniter = this.encryptionMaskingService.getMoniterBytaskid(encryptionMasking.getId());
            if (null == moniter) {
               encryptionMasking.setExecuteStatus("0");
            } else if ("1".equals(moniter.getFlag()) && moniter.getRunstatus() == 1) {
               encryptionMasking.setExecuteStatus("1");
            } else {
               encryptionMasking.setExecuteStatus("0");
            }
         }
      }

      DataGridVO<EncryptionMasking> vo = new DataGridVO<EncryptionMasking>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/getbatchmanage"})
   @ResponseBody
   public Map<String, String> getbatchmanage(String taskid, String tasknamereal, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      Map<String, String> parammap = new HashMap();
      String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
      String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
      String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
      parammap.put("batchmanage", batchmanage);
      parammap.put("tableprefix", tableprefix);
      parammap.put("tablesuffix", tablesuffix);
      return parammap;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String taskid, String step, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      map.put("tasknamereal", (String)this.request.getSession().getAttribute("tasknamereal"));
      if (step == null) {
         step = (String)this.request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         this.request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "encryptionmasking_one":
            this.encryptionmasking_one(map, model);
            break;
         case "encryptionmasking_two":
            this.encryptionmasking_two(map, model);
            break;
         case "encryptionmasking_four":
            this.encryptionmasking_four(map, model);
            break;
         case "encryptionmasking_five":
            this.request.getSession().setAttribute("page_five", map.get("pageparam"));
      }

      return "core/encryptionmasking/" + step;
   }

   @RequestMapping({"/exportway"})
   @ResponseBody
   public String exportway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ExportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/importway"})
   @ResponseBody
   public String importway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ImportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/targetparam"})
   @ResponseBody
   public Map<String, String> targetparam(String database, String execution_type, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      Map<String, String> targetparam = new HashMap();
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         if (execution_type.equals("normal")) {
            targetparam = base.TargetParameter_normalEM();
         } else {
            targetparam = base.TargetParameter_notNormal();
         }
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return targetparam;
   }

   public void encryptionmasking_one(Map<String, String> map, Model model) {
      String newtask = (String)map.get("newtask");
      String way = (String)map.get("way");
      String tasknamereal = (String)map.get("tasknamereal");
      String masking_engine_type = "";

      try {
         masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
      } catch (IOException e) {
         e.printStackTrace();
      }

      model.addAttribute("maskingenginetype", masking_engine_type);
      if (newtask != null) {
         model.addAttribute("state", "checked");
      } else if ("prev".equals(way)) {
         EncryptionMasking encryptionmasking = new EncryptionMasking();
         encryptionmasking = (EncryptionMasking)this.redisService.get(tasknamereal + "_" + encryptionmasking.getClass().getSimpleName());
         if (encryptionmasking != null) {
            model.addAttribute("taskname", encryptionmasking.getTaskname());
            model.addAttribute("folder", encryptionmasking.getFoldername());
            model.addAttribute("tasknote", encryptionmasking.getRemark());
            model.addAttribute("isrecover", encryptionmasking.getIsrecover());
            model.addAttribute("state", encryptionmasking.getFastexecution() != null && encryptionmasking.getFastexecution().equals("1") ? "checked" : "");
         }
      }

   }

   public void encryptionmasking_two(Map<String, String> map, Model model) {
      EncryptionMasking encryptionmasking = new EncryptionMasking();
      if (((String)map.get("way")).equals("prev")) {
         String tasknamereal = (String)map.get("tasknamereal");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         if (desensitizationsource != null) {
            model.addAttribute("dataschema", desensitizationsource.getDataschema());
            model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
            model.addAttribute("execution_type", desensitizationsource.getExecution_type());
         }

         String hadoop = (String)this.request.getSession().getAttribute("hadoop_s");
         if ("1".equals(hadoop)) {
            model.addAttribute("hadoop", "1");
         } else {
            model.addAttribute("hadoop", "0");
         }

         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            model.addAttribute("isdmpfile", "1");
            model.addAttribute("dmptype", desensitizationsource.getDmptype());
            model.addAttribute("multiDempFile", desensitizationsource.getMultiDempFile());
            model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
         }

         encryptionmasking.setTasknamereal(tasknamereal);
      } else if (((String)map.get("way")).equals("next")) {
         encryptionmasking.setIsrecover(map.get("isrecover") == null ? "0" : (String)map.get("isrecover"));
         encryptionmasking.setFastexecution((String)map.get("isfast"));
         encryptionmasking.setFoldername((String)map.get("folder"));
         encryptionmasking.setTaskname((String)map.get("taskname"));
         encryptionmasking.setUserid((String)map.get("userid"));
         encryptionmasking.setUsername((String)map.get("username"));
         String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
         encryptionmasking.setRemark((String)map.get("tasknote"));
         encryptionmasking.setStamp(stamp);
         encryptionmasking.setTasknamereal(stamp + "_" + StringTool.hanziToPinyinFirst((String)map.get("taskname")));
         this.redisService.set(encryptionmasking.getTasknamereal() + "_" + encryptionmasking.getClass().getSimpleName(), encryptionmasking);
         this.request.getSession().setAttribute("isrecoverState", map.get("isrecover") == null ? "0" : map.get("isrecover"));
         this.request.getSession().setAttribute("tasknamereal", encryptionmasking.getTasknamereal());
      } else if ("1".equals(map.get("hadoop"))) {
         model.addAttribute("hadoop", map.get("hadoop"));
         this.request.getSession().setAttribute("hadoop_s", "1");
      } else {
         model.addAttribute("hadoop", "0");
         this.request.getSession().setAttribute("hadoop_s", "0");
      }

   }

   public void encryptionmasking_three(Map<String, String> map, Model model) {
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget != null) {
            model.addAttribute("dataschema", desensitizationtarget.getDataschema());
            model.addAttribute("datasourceid", desensitizationtarget.getDatasourceid());
            model.addAttribute("execution_type", desensitizationtarget.getExecution_type());
            model.addAttribute("inserttype", desensitizationtarget.getInserttype());
            model.addAttribute("isclear", desensitizationtarget.getIsclear());
            model.addAttribute("isindex", desensitizationtarget.getIsindex());
            model.addAttribute("isprimary", desensitizationtarget.getIsprimary());
            model.addAttribute("isrebuild", desensitizationtarget.getIsrebuild());
            model.addAttribute("istrigger", desensitizationtarget.getIstrigger());
            model.addAttribute("isfunction", desensitizationtarget.getIsfunction());
            model.addAttribute("loadscripttype", desensitizationtarget.getLoadscripttype());
            model.addAttribute("s_dbtype", map.get("s_dbtype"));
            model.addAttribute("tCoreDatasystem", map.get("tCoreDatasystem"));
            model.addAttribute("isassignspace", desensitizationtarget.getIsassignspace());
            model.addAttribute("isview", desensitizationtarget.getIsview());
            model.addAttribute("ispartition", desensitizationtarget.getIspartition());
            model.addAttribute("isconstraint", desensitizationtarget.getIsconstraint());
         }

         String hadoop = (String)this.request.getSession().getAttribute("hadoop_t");
         if ("1".equals(hadoop)) {
            model.addAttribute("hadoop", "1");
         } else {
            model.addAttribute("dmpexport", map.get("dmpexport"));
            model.addAttribute("hadoop", "0");
         }

         if ("1".equals(desensitizationtarget.getDmpimport())) {
            model.addAttribute("dmpimport", "1");
            model.addAttribute("targetfiledir", desensitizationtarget.getTargetfiledir());
         }
      } else if (((String)map.get("way")).equals("next")) {
         if (map.get("s-systemtype") != null) {
            if ("1".equals(map.get("s-systemtype"))) {
               if ("1".equals(map.get("filetype"))) {
                  if ("0".equals(map.get("multiDempFile"))) {
                     Desensitizationsource desensitizationsource = new Desensitizationsource();
                     desensitizationsource.setIsdmpfile((String)map.get("filetype"));
                     desensitizationsource.setDmptype((String)map.get("dmptype"));
                     String filename = (String)map.get("dmpfile");
                     filename = filename.substring(0, filename.lastIndexOf(","));
                     desensitizationsource.setSourcefiledir((String)map.get("sourcefiledir") + "/" + filename);
                     desensitizationsource.setExecution_type((String)map.get("execution_type"));
                     desensitizationsource.setMultiDempFile((String)map.get("multiDempFile"));
                     desensitizationsource.setFilelist(filename);
                     this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
                  } else {
                     Desensitizationsource desensitizationsource = new Desensitizationsource();
                     desensitizationsource.setIsdmpfile((String)map.get("filetype"));
                     desensitizationsource.setDmptype((String)map.get("dmptype"));
                     desensitizationsource.setExecution_type((String)map.get("execution_type"));
                     desensitizationsource.setMultiDempFile((String)map.get("multiDempFile"));
                     desensitizationsource.setSourcefiledir((String)map.get("sourcefiledir"));
                     desensitizationsource.setFilelist((String)map.get("dmpfile"));
                     System.out.println((String)map.get("filelist"));
                     this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
                  }
               } else {
                  Desensitizationsource desensitizationsource = new Desensitizationsource();
                  desensitizationsource.setDataschema((String)map.get("filesystemid"));
                  desensitizationsource.setDatasourceid((String)map.get("filesource"));
                  model.addAttribute("isrebuild", "isrebuild");
                  model.addAttribute("isclear", "isclear");
                  desensitizationsource.setExecution_type("normal");
                  desensitizationsource.setSourcefiledir((String)map.get("sourcefiledir"));
                  this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
               }

               model.addAttribute("dmpexport", map.get("dmpexport"));
            } else {
               Desensitizationsource desensitizationsource = new Desensitizationsource();
               desensitizationsource.setDataschema((String)map.get("dataschema"));
               desensitizationsource.setDatasourceid((String)map.get("datasourceid"));
               desensitizationsource.setExecution_type((String)map.get("execution_type"));
               this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
               TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
               model.addAttribute("s_dbtype", map.get("s_dbtype"));
               model.addAttribute("isclear", "isclear");
               if ("ORACLE".equals(tCoreDatasystem.getDbtype())) {
                  model.addAttribute("tCoreDatasystem", tCoreDatasystem.getUsername());
               } else {
                  model.addAttribute("tCoreDatasystem", tCoreDatasystem.getDbservername());
               }
            }

            this.redisService.set("systype", map.get("s-systemtype"));
            this.redisService.set("ftype", map.get("s-file-type"));
            this.redisService.set("dbtype", map.get("s_dbtype"));
         } else {
            Desensitizationsource desensitizationsource = new Desensitizationsource();
            desensitizationsource.setDataschema((String)map.get("dataschema"));
            desensitizationsource.setDatasourceid((String)map.get("datasourceid"));
            desensitizationsource.setExecution_type((String)map.get("execution_type"));
            this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
            TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            model.addAttribute("s_dbtype", map.get("s_dbtype"));
            model.addAttribute("isrebuild", "isrebuild");
            model.addAttribute("isclear", "isclear");
            model.addAttribute("tCoreDatasystem", tCoreDatasystem.getDbservername());
            this.redisService.set("s_dbtype", map.get("s_dbtype"));
         }

         if ("HIVE".equals(map.get("s_dbtype"))) {
            this.request.getSession().setAttribute("hadoop_s", "1");
         } else {
            this.request.getSession().setAttribute("hadoop_s", "0");
         }
      } else {
         model.addAttribute("isrebuild", "isrebuild");
         model.addAttribute("isclear", "isclear");
         if ("1".equals(map.get("hadoop"))) {
            model.addAttribute("hadoop", map.get("hadoop"));
            this.request.getSession().setAttribute("hadoop_t", "1");
         } else {
            model.addAttribute("hadoop", "0");
            this.request.getSession().setAttribute("hadoop_t", "0");
         }
      }

   }

   public void encryptionmasking_four(Map<String, String> map, Model model) {
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         model.addAttribute("way", "prev");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         if (desensitizationsource != null) {
            model.addAttribute("group", desensitizationsource.getDataschema());
         }

         Desensitizationtarget desensitizationtarget2 = new Desensitizationtarget();
         desensitizationtarget2 = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget2.getClass().getSimpleName());
         if (desensitizationtarget2 != null) {
            model.addAttribute("group", desensitizationtarget2.getDataschema());
         }

         if (desensitizationsource.getDatasourceid() != null && !desensitizationsource.getDatasourceid().equals("")) {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = null;
            if (desensitizationtarget2.getDatasourceid() != null) {
               tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget2.getDatasourceid());
            }

            if (null != tCoreDatasystemSource && null != tCoreDatasystemTarget) {
               if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
                  model.addAttribute("mappingEditFlag", "dbsystem_diff");
               } else {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               }
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         String version = (String)this.redisService.get(tasknamereal + "_" + "version");
         model.addAttribute("version", version);
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            this.redisService.set(tasknamereal + "_" + BatchManage.class.getSimpleName(), "");
            model.addAttribute("batchmanage", batchmanage);
         }

         if (tableprefix != null) {
            this.redisService.set(tasknamereal + "_" + "tableprefix", "");
            model.addAttribute("tableprefix", tableprefix);
         }

         if (tablesuffix != null) {
            this.redisService.set(tasknamereal + "_" + "tablesuffix", "");
            model.addAttribute("tablesuffix", tablesuffix);
         }

         model.addAttribute("isshow", "1");
      } else if (((String)map.get("way")).equals("next")) {
         Map<String, String> filterMap = new HashMap();
         this.request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", filterMap);
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource.setDataschema((String)map.get("dataschema"));
         desensitizationsource.setDatasourceid((String)map.get("datasourceid"));
         desensitizationsource.setExecution_type((String)map.get("execution_type"));
         this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
         if ((desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) & map.keySet().contains("filetype_t") && this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid()).getDbtype().equals("ORACLE") && ((String)map.get("filetype_t")).equals(".dmp")) {
            this.redisService.set(tasknamereal + "ghcaotd", "ghcaotd");
            map.put("datasourceid", desensitizationsource.getDatasourceid());
         }

         boolean s_isdmp = "1".equals(desensitizationsource.getIsdmpfile());
         if (((String)map.get("s-systemtype")).equals("0") || s_isdmp) {
            List<Map<String, String>> tableList = new ArrayList();
            if (desensitizationsource.getDatasourceid() != null && !this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid()).getFlag().equals("2")) {
               for(DBTableVO dbTableVO : this.dataSystemService.queryTablename(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getTablename());
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }

               this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            } else if (!s_isdmp) {
               for(TCoreFileStructure dbTableVO : this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getFilestructurename());
                  tableMap.put("structureid", dbTableVO.getId());
                  tableMap.put("filedir", desensitizationsource.getSourcefiledir());
                  tableMap.put("filename", dbTableVO.getFilestructurename());
                  tableMap.put("extension", ".txt");
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }

               this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            }

            Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDataschema((String)map.get("dataschema"));
            desensitizationtarget.setDatasourceid((String)map.get("datasourceid"));
            desensitizationtarget.setExecution_type((String)map.get("execution_type"));
            desensitizationtarget.setInserttype((String)map.get("inserttype"));
            desensitizationtarget.setIsclear((String)map.get("isclear"));
            desensitizationtarget.setIsindex((String)map.get("isindex"));
            desensitizationtarget.setIsprimary((String)map.get("isprimary"));
            desensitizationtarget.setIsrebuild((String)map.get("isrebuild"));
            desensitizationtarget.setIsassignspace((String)map.get("isassignspace"));
            desensitizationtarget.setIstrigger((String)map.get("istrigger"));
            desensitizationtarget.setIsview((String)map.get("isview"));
            desensitizationtarget.setIsconstraint((String)map.get("isconstraint"));
            desensitizationtarget.setIspartition((String)map.get("ispartition"));
            desensitizationtarget.setIsfunction((String)map.get("isfunction"));
            desensitizationtarget.setLoadscripttype((String)map.get("loadscripttype"));
            desensitizationtarget.setTargetfiledir((String)map.get("sourcefiledir"));
            desensitizationtarget.setDmpimport(".dmp".equals(map.get("filetype_t")) ? "1" : "0");
            if (this.redisService.get(tasknamereal + "ghcaotd") != null && this.redisService.get(tasknamereal + "ghcaotd").equals("ghcaotd")) {
               desensitizationtarget.setTargetfiledir((String)map.get("todmptargetfiledir"));
            }

            this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
            if (s_isdmp) {
               if ("1".equals(desensitizationtarget.getDmpimport())) {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               } else {
                  String sourceid = (String)map.get("datasourceid");
                  if (sourceid == null) {
                     sourceid = (String)map.get("filesource");
                  }

                  TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(sourceid);
                  if ("ORACLE".equals(tCoreDatasystemTarget.getDbtype())) {
                     model.addAttribute("mappingEditFlag", "dbsystem");
                  } else {
                     model.addAttribute("mappingEditFlag", "dbsystem_diff");
                  }
               }

               model.addAttribute("isdmpfile", desensitizationsource.getIsdmpfile());
               model.addAttribute("dmptype", desensitizationsource.getDmptype());
               model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
            } else {
               TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
               TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("datasourceid"));
               if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
                  model.addAttribute("mappingEditFlag", "dbsystem_diff");
               } else {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               }

               model.addAttribute("s_dbtype", tCoreDatasystemSource.getDbtype());
               model.addAttribute("tCoreDatasystem", map.get("tCoreDatasystem"));
            }

            model.addAttribute("dmpexport", map.get("dmpexport"));
         }

         if (((String)map.get("s-systemtype")).equals("1")) {
            if ("1".equals(desensitizationsource.getIsdmpfile())) {
               if (".dmp".equals(map.get("filetype_t"))) {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               } else {
                  TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("filesource"));
                  if ("ORACLE".equals(tCoreDatasystemTarget.getDbtype())) {
                     model.addAttribute("mappingEditFlag", "dbsystem");
                  } else {
                     model.addAttribute("mappingEditFlag", "dbsystem_diff");
                  }
               }
            }

            model.addAttribute("isdmpfile", desensitizationsource.getIsdmpfile());
            model.addAttribute("dmptype", desensitizationsource.getDmptype());
            model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
            model.addAttribute("dmpexport", map.get("dmpexport"));
            String filesystemlocation = (String)map.get("filesystemlocation");
            String datasourceid = "";
            datasourceid = (String)map.get("filesource");
            String filesystempath = (String)map.get("filesystempath");
            String sourcefiledir = (String)map.get("sourcefiledir");
            String filetype_t = (String)map.get("filetype_t");
            String filesystemextension = (String)map.get("filesystemextension");
            String filesystemcodepage = (String)map.get("filesystemcodepage");
            String filesystemcolumnformat = (String)map.get("filesystemcolumnformat");
            String delimiters = (String)map.get("delimiters");
            String divisionType = (String)map.get("divisionType");
            String repeatEmptyCharacter = (String)map.get("repeatEmptyCharacter");
            if ("other".equals(delimiters)) {
               delimiters = (String)map.get("order_delimiters");
            }

            String quotecharacter = (String)map.get("quotecharacter");
            Properties props = new Properties();

            try {
               props = PropertiesLoaderUtils.loadAllProperties("config.properties");
            } catch (IOException e) {
               e.printStackTrace();
            }

            if (".xls".equals(filetype_t)) {
               delimiters = props.getProperty("desensitization_delimiter");
            }

            DesensitizationFile desensitizationfile = new DesensitizationFile();
            if (filesystemlocation == null) {
               filesystemlocation = "0";
            }

            desensitizationfile.setFiletype(Integer.parseInt(filesystemlocation));
            if (datasourceid != null && !"".equals(datasourceid)) {
               TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
               desensitizationfile.setIp(tCoreDatasystem.getDbip());
               desensitizationfile.setPort(tCoreDatasystem.getDbport());
               desensitizationfile.setUsername(tCoreDatasystem.getUsername());
               desensitizationfile.setUserpassword(tCoreDatasystem.getPassword());
            }

            desensitizationfile.setDivisionType(divisionType);
            desensitizationfile.setRepeatEmptyCharacter(repeatEmptyCharacter);
            desensitizationfile.setFiledir(filesystempath == null ? sourcefiledir : filesystempath);
            desensitizationfile.setCodepage(filesystemcodepage);
            desensitizationfile.setSuffix(filesystemextension);
            desensitizationfile.setDateformat(filesystemcolumnformat);
            desensitizationfile.setDelimiters(delimiters);
            desensitizationfile.setQuotecharacter(quotecharacter);
            this.redisService.set(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName(), desensitizationfile);
            Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDatasourceid(datasourceid);
            desensitizationtarget.setExecution_type("normal");
            desensitizationtarget.setDmpimport(".dmp".equals(filetype_t) ? "1" : "0");
            desensitizationtarget.setTargetfiledir((String)map.get("sourcefiledir"));
            this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
            List<Map<String, String>> tableList = new ArrayList();
            if (desensitizationsource.getDatasourceid() != null && !this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid()).getFlag().equals("2")) {
               for(DBTableVO dbTableVO : this.dataSystemService.queryTablename(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getTablename());
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }

               this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            } else if (!"1".equals(desensitizationsource.getIsdmpfile())) {
               for(TCoreFileStructure dbTableVO : this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getFilestructurename());
                  tableMap.put("structureid", dbTableVO.getId());
                  tableMap.put("filedir", desensitizationsource.getSourcefiledir());
                  tableMap.put("filename", dbTableVO.getFilestructurename());
                  tableMap.put("extension", ".txt");
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }

               this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            }

            model.addAttribute("mappingEditFlag", "dbsystem");
         } else if (((String)map.get("s-systemtype")).equals("2")) {
            List<Map<String, String>> tableList = new ArrayList();
            if (desensitizationsource.getDatasourceid() != null && !this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid()).getFlag().equals("2")) {
               for(DBTableVO dbTableVO : this.dataSystemService.queryTablename(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getTablename());
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }

               this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            } else if (!"1".equals(desensitizationsource.getIsdmpfile())) {
               for(TCoreFileStructure dbTableVO : this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "")) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", dbTableVO.getFilestructurename());
                  tableMap.put("structureid", dbTableVO.getId());
                  tableMap.put("filedir", "");
                  tableMap.put("filename", "");
                  tableMap.put("extension", "");
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }

               this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            }

            Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDataschema((String)map.get("dataschema"));
            desensitizationtarget.setDatasourceid((String)map.get("datasourceid"));
            desensitizationtarget.setExecution_type((String)map.get("execution_type"));
            desensitizationtarget.setInserttype((String)map.get("inserttype"));
            desensitizationtarget.setIsclear((String)map.get("isclear"));
            desensitizationtarget.setIsindex((String)map.get("isindex"));
            desensitizationtarget.setIsprimary((String)map.get("isprimary"));
            desensitizationtarget.setIsrebuild((String)map.get("isrebuild"));
            desensitizationtarget.setIstrigger((String)map.get("istrigger"));
            desensitizationtarget.setIsfunction((String)map.get("isfunction"));
            desensitizationtarget.setLoadscripttype((String)map.get("loadscripttype"));
            desensitizationtarget.setDmpimport(".dmp".equals(map.get("filetype_t")) ? "1" : "0");
            desensitizationtarget.setTargetfiledir((String)map.get("targetfiledir"));
            this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
            if ("1".equals(desensitizationsource.getIsdmpfile())) {
               if ("1".equals(desensitizationtarget.getDmpimport())) {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               } else {
                  TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("datasourceid"));
                  if ("ORACLE".equals(tCoreDatasystemTarget.getDbtype())) {
                     model.addAttribute("mappingEditFlag", "dbsystem");
                  } else {
                     model.addAttribute("mappingEditFlag", "dbsystem_diff");
                  }
               }

               model.addAttribute("isdmpfile", desensitizationsource.getIsdmpfile());
               model.addAttribute("dmptype", desensitizationsource.getDmptype());
               model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
            } else {
               TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
               TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("datasourceid"));
               if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
                  model.addAttribute("mappingEditFlag", "dbsystem_diff");
               } else {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               }

               model.addAttribute("s_dbtype", tCoreDatasystemSource.getDbtype());
               model.addAttribute("tCoreDatasystem", map.get("tCoreDatasystem"));
            }

            model.addAttribute("dmpexport", map.get("dmpexport"));
         }

         if ("HIVE".equals(map.get("t_dbtype"))) {
            this.request.getSession().setAttribute("hadoop_t", "1");
         } else {
            this.request.getSession().setAttribute("hadoop_t", "0");
         }

         model.addAttribute("isshow", "0");
      }

   }

   @RequestMapping({"/querytasktype"})
   @ResponseBody
   public List<ComboboxVO> querytasktype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();

      for(EmaskingTaskType e : EmaskingTaskType.values()) {
         ComboboxVO c = new ComboboxVO(e.getFlag(), e.getMaskingtype());
         list.add(c);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryfolder"})
   public List<Map<String, String>> queryfolder(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> folder = this.infoService.queryFolderList(engineid);
      List<Map<String, String>> list = new ArrayList();

      for(String item : folder) {
         Map<String, String> map = new HashMap();
         map.put("id", item);
         map.put("text", item);
         map.put("iconCls", "icon-folder");
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroups"})
   public List<ComboboxVO> querysensitivegroups(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.searchRegexService.querySensitiveGroups();
   }

   @RequestMapping({"/executepubtask"})
   public String executepubtask(String taskid, String engineid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      if ("1".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorrun";
      } else if ("2".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorimptask";
      } else if ("3".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorsubtask";
      } else {
         return "";
      }
   }

   @ResponseBody
   @RequestMapping({"/savetask"})
   public Map<String, String> savetask(HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectId = (String)request.getSession().getAttribute("projectid");
      Map<String, String> map = new HashMap();
      if (tasknamereal == null) {
         map.put("state", "1");
      } else {
         String taskid = this.encryptionMaskingService.gettaskBytasknamereal(tasknamereal, projectId);
         map.put("state", taskid);
      }

      return map;
   }

   @RequestMapping({"/savetask_info"})
   public String savetask_info(String state, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectid = (String)request.getSession().getAttribute("projectid");
      Map<String, Object> map = new HashMap();
      Object obj = request.getSession().getAttribute("loginUser");
      Map<String, String> map_table_filterConditions = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
      map.put("state", state);
      map.put("loginUser", obj);
      map.put("map_table_filterConditions", map_table_filterConditions);
      map.put("tableList", request.getSession().getAttribute("tableList_" + tasknamereal));
      map.put("projectid", projectid);

      try {
         if (this.redisService.get(tasknamereal + "ghcaotd") != null && this.redisService.get(tasknamereal + "ghcaotd").equals("ghcaotd")) {
            List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
            for(Map<String, String> map2 : listNew) {
               this.querymasktable("", "", (String)map2.get("tableName"), request);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (!state.equals("1")) {
         this.encryptionMaskingService.savetask_info(tasknamereal, map);
      }

      request.getSession().removeAttribute("tableList_" + tasknamereal);
      request.getSession().removeAttribute("tasknamereal");
      model.addAttribute("toPageCurr", 1);
      return "core/encryptionmasking/encryptionmasking_list";
   }

   @ResponseBody
   @RequestMapping({"/querytaskdetail"})
   public Map<String, Object> querytaskdetail(String taskid, String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Map<String, Object> map = new HashMap();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      EncryptionMasking encryptionmasking = new EncryptionMasking();
      EncryptionMasking encryptionmasking_replace = new EncryptionMasking();
      encryptionmasking = (EncryptionMasking)this.redisService.get(tasknamereal + "_" + encryptionmasking.getClass().getSimpleName());
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (!"1".equals(type) && !"2".equals(type)) {
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            encryptionmasking_replace.setBatchnumber(batchmanage);
         }

         if (tableprefix != null && !"".equals(tableprefix)) {
            encryptionmasking_replace.setTableprefix(tableprefix);
         } else {
            encryptionmasking_replace.setTableprefix("无");
         }

         if (tablesuffix != null && !"".equals(tablesuffix)) {
            encryptionmasking_replace.setTablesuffix(tablesuffix);
         } else {
            encryptionmasking_replace.setTablesuffix("无");
         }
      } else {
         encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
         desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         desensitizationtarget = this.encryptionMaskingService.queryTargetById(taskid);
         encryptionmasking_replace.setBatchnumber(encryptionmasking.getBatchnumber());
         encryptionmasking_replace.setTableprefix(!"".equals(encryptionmasking.getTableprefix()) && encryptionmasking.getTableprefix() != null ? encryptionmasking.getTableprefix() : "无");
         encryptionmasking_replace.setTablesuffix(!"".equals(encryptionmasking.getTablesuffix()) && encryptionmasking.getTablesuffix() != null ? encryptionmasking.getTablesuffix() : "无");
         if ("2".equals(type)) {
            String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            if (batchmanage != null) {
               encryptionmasking_replace.setBatchnumber(batchmanage);
            }

            if (tableprefix != null && !"".equals(tableprefix)) {
               encryptionmasking_replace.setTableprefix(tableprefix);
            } else {
               encryptionmasking_replace.setTableprefix("无");
            }

            if (tablesuffix != null && !"".equals(tablesuffix)) {
               encryptionmasking_replace.setTablesuffix(tablesuffix);
            } else {
               encryptionmasking_replace.setTablesuffix("无");
            }
         }
      }

      encryptionmasking_replace.setTaskname(encryptionmasking.getTaskname());
      encryptionmasking_replace.setFoldername(encryptionmasking.getFoldername());
      encryptionmasking_replace.setFastexecution(encryptionmasking.getFastexecution());
      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         desensitizationsource.setDataschema("");
         desensitizationtarget.setInserttype("");
      }

      map.put("desensitizationtask", encryptionmasking_replace);
      map.put("desensitizationsource", desensitizationsource);
      map.put("desensitizationtarget", desensitizationtarget);
      TCoreDatasystem tCoreDatasystem_source = null;
      TCoreDatasystem tCoreDatasystem_target = null;
      if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
         tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         map.put("tCoreDatasystem_source", tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
         tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      }

      if (!"".equals(desensitizationsource.getDatasourceid()) && desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid()) && desensitizationtarget.getDatasourceid() != null && !tCoreDatasystem_source.getDbtype().equals(tCoreDatasystem_target.getDbtype())) {
         map.put("isSameDb", "1");
      } else {
         map.put("isSameDb", "0");
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else if (dbtype.equals("LOCALFILE")) {
            sourcetype = "1";
         } else {
            sourcetype = "0";
         }
      }

      map.put("sourcetype", sourcetype);
      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else if (dbtype.equals("LOCALFILE")) {
            targettype = "1";
         } else {
            targettype = "0";
         }
      }

      if (!sourcetype.equals("0") || !targettype.equals("0")) {
         map.put("isSameDb", "0");
      }

      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         String dmpImportFlg = desensitizationtarget.getDmpimport();
         if ("1".equals(dmpImportFlg)) {
            tCoreDatasystem_target = new TCoreDatasystem();
            tCoreDatasystem_target.setSysname("DMP系统");
            desensitizationtarget.setDataschema("无");
            map.put("tCoreDatasystem_target", tCoreDatasystem_target);
            targettype = "0";
         }
      }

      map.put("targettype", targettype);
      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         } else {
            desensitizationfile = this.encryptionMaskingService.queryDesensitizationfileBytaskid(taskid);
         }

         map.put("desensitizationfile", desensitizationfile);
      }

      new ArrayList();
      List<Map<String, String>> var39;
      if ("1".equals(type)) {
         var39 = new ArrayList();

         for(DesensitizationTable desensitizationTable : this.encryptionMaskingService.queryTableList(taskid)) {
            Map<String, String> desensitizationTablemap = new HashMap();
            desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
            ((List)var39).add(desensitizationTablemap);
         }
      } else {
         var39 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if (var39 != null) {
            var39 = (var39).stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
         }
      }

      map.put("tCoreMaskingTaskTableList", var39);
      if (!map.keySet().contains("tCoreDatasystem_target")) {
         tCoreDatasystem_target = new TCoreDatasystem();
         tCoreDatasystem_target.setSysname("DMP系统");
         map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      }

      return map;
   }

   @RequestMapping({"/inittasktable"})
   @ResponseBody
   public DataGridVO<DBTableVO> inittabledg(HttpServletRequest request, String tableNamePattern, Model model, String status) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();
      List<Map<String, String>> tableList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      long a = System.currentTimeMillis();
      if ("0".equals(status)) {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            list.add(dbTableVO);
         }

         long b = System.currentTimeMillis();
         System.out.println(b - a);
      } else {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            if (!status.equals("1") || !"0".equals(map.get("status")) && !"1".equals(map.get("status"))) {
               if (!status.equals("2") || !"2".equals(map.get("status")) && !"3".equals(map.get("status"))) {
                  if (!status.equals("3") || !"0".equals(map.get("status")) && !"2".equals(map.get("status"))) {
                     if (status.equals("4") && ("1".equals(map.get("status")) || "3".equals(map.get("status")))) {
                        dbTableVO.setTablename((String)map.get("tableName"));
                        dbTableVO.setStatus((String)map.get("status"));
                        list.add(dbTableVO);
                     }
                  } else {
                     dbTableVO.setTablename((String)map.get("tableName"));
                     dbTableVO.setStatus((String)map.get("status"));
                     list.add(dbTableVO);
                  }
               } else {
                  dbTableVO.setTablename((String)map.get("tableName"));
                  dbTableVO.setStatus((String)map.get("status"));
                  list.add(dbTableVO);
               }
            } else {
               dbTableVO.setTablename((String)map.get("tableName"));
               dbTableVO.setStatus((String)map.get("status"));
               list.add(dbTableVO);
            }
         }
      }

      String[] table_List = tableNamePattern.trim().split("\\,");
      if (table_List.length < 2) {
         if (!"".equals(tableNamePattern.trim())) {
            List<DBTableVO> tableSearchList = new ArrayList();

            for(DBTableVO dbTableVO : list) {
               if (dbTableVO.getTablename().toLowerCase().indexOf(tableNamePattern.toLowerCase()) != -1) {
                  tableSearchList.add(dbTableVO);
               }
            }

            return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
         } else {
            long b = System.currentTimeMillis();
            System.out.println("结束：" + (b - a));
            return new DataGridVO<DBTableVO>((long)list.size(), list);
         }
      } else {
         List<DBTableVO> tableSearchList = new ArrayList();
         List<String> table_List_name = new ArrayList();

         for(String string : table_List) {
            table_List_name.add(string.toLowerCase());
         }

         if (!"".equals(tableNamePattern.trim())) {
            tableSearchList = (List)list.parallelStream().filter((item) -> table_List_name.contains(item.getTablename().toLowerCase())).collect(Collectors.toList());
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      }
   }

   @RequestMapping({"/inputtable"})
   public String inputmulti(String flag, String title, String multivalue, String version, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tableName = title;
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectid = (String)request.getSession().getAttribute("projectid");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
         desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
      }

      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
         desensitizationtarget = this.encryptionMaskingService.queryTargetById(taskid);
      }

      String filedir = desensitizationsource.getSourcefiledir();
      String filename = title;
      String extension = ".txt";
      String t_tableName = title;

      List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         if (tableName.equals(map.get("tableName"))) {
            if (((String)map.get("status")).equals("2") || ((String)map.get("status")).equals("3")) {
               filedir = (String)map.get("filedir");
               filename = (String)map.get("filename");
               extension = (String)map.get("extension");
            }

            t_tableName = map.get("t_tableName") != null && !"".equals(map.get("t_tableName")) ? (String)map.get("t_tableName") : title;
            break;
         }
      }

      Map<String, String> fileNameR = (Map)this.redisService.get("fileNameRR");
      model.addAttribute("title", title);
      model.addAttribute("multivalue", multivalue);
      model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
      model.addAttribute("isfile", desensitizationsource.getDatasourceid() == null);
      model.addAttribute("dataschema", desensitizationsource.getDataschema());
      model.addAttribute("isdmpfile", desensitizationsource.getIsdmpfile());
      model.addAttribute("dmptype", desensitizationsource.getDmptype());
      model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
      model.addAttribute("filedir", filedir);
      if (!"".equals(fileNameR) && fileNameR != null && t_tableName.equals(fileNameR.get("tableName"))) {
         model.addAttribute("filename", fileNameR.get("filename"));
      } else {
         model.addAttribute("filename", filename);
      }

      model.addAttribute("extension", extension);
      model.addAttribute("t_tableName", t_tableName);
      model.addAttribute("targettitle", desensitizationtarget.getDataschema() != null ? "目标表名:" : "目标文件名:");
      model.addAttribute("projectid", projectid);
      model.addAttribute("version", version);
      String sqlFilter = "";
      Map map = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
      if (map != null) {
         if (!"".equals((String)map.get(multivalue)) && (String)map.get(multivalue) != null) {
            sqlFilter = ((String)map.get(multivalue)).replaceAll("'", "\\\\'");
         } else {
            sqlFilter = (String)map.get(multivalue);
         }
      }

      model.addAttribute("sqlFilter", sqlFilter);
      return "core/encryptionmasking/" + flag;
   }

   @ResponseBody
   @RequestMapping({"/checkWhereStatement"})
   public ResultVO checkWhereStatement(String dataSystemId, String schema, String whereStatements, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(dataSystemId);
      this.iskeberos(datasystem);
      Connection conn = JdbcTool.getConnection(datasystem);
      String[] tempArr = whereStatements.split(":");
      if (tempArr.length != 2) {
         return new ResultVO("过滤条件格式不正确！", false);
      } else {
         String sql = MessageFormat.format("select * from {0}.{1} where {2}", schema, tempArr[0], tempArr[1]);

         try {
            PreparedStatement statement = conn.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            resultSet.close();
            statement.close();
         } catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return new ResultVO(tempArr[0] + ": " + e.getMessage(), false);
         }

         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return new ResultVO((String)null, true);
      }
   }

   @RequestMapping({"/querycolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/querydmpcolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querydmpcolumninfo(String tablename, String sourcefiledir, String dmptype, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if ("0".equals(desensitizationsource.getMultiDempFile())) {
         if ("0".equals(dmptype)) {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmpdp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         } else {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         }
      } else {
         String sourcefiles = desensitizationsource.getFilelist();
         String sourcepath = desensitizationsource.getSourcefiledir();
         String[] sourcefile = sourcefiles.split(",");
         List<String> sourcefilelist = new ArrayList();

         for(String string : sourcefile) {
            sourcefilelist.add(sourcepath + "/" + string);
         }

         if ("0".equals(dmptype)) {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmpdp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         } else {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         }
      }
   }

   public List<ColumnInfoVO> querydmpcolumninfo(String tablename, String dmptype) {
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if ("0".equals(desensitizationsource.getMultiDempFile())) {
         if ("0".equals(dmptype)) {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmpdp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         } else {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         }
      } else {
         String sourcefiles = desensitizationsource.getFilelist();
         String sourcepath = desensitizationsource.getSourcefiledir();
         String[] sourcefile = sourcefiles.split(",");
         List<String> sourcefilelist = new ArrayList();

         for(String string : sourcefile) {
            sourcefilelist.add(sourcepath + "/" + string);
         }

         if ("0".equals(dmptype)) {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmpdp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         } else {
            List<ColumnInfoVO> reColumnInfoList = null;
            Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmp_tableInfoMap_masking");
            List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
            Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               if (tablename.equals(tableStructureInfo.getTablename())) {
                  reColumnInfoList = tableStructureInfo.getColInfoLst();
               }

               columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            return reColumnInfoList;
         }
      }
   }

   @RequestMapping({"/querycolumninfodiff1"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfodiff1(String tablename, String dmptype, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         return null;
      } else {
         TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         String dbSourceFlag = EdataMappingType.getFlagByName("ORACLE");
         String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
         List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
         List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
         List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
         Map<String, String> targetFieldNameMap = new HashMap();

         for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
            String targetName = "";
            String fieldname = desensitizationDataTargetfield.getFieldname();

            for(Map<String, String> map : map_t) {
               if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
                  targetName = ((String)map.get("sourcefieldname")).toLowerCase();
                  break;
               }
            }

            targetFieldNameMap.put(fieldname, targetName);
         }

         List<ColumnInfoVO> list = this.querydmpcolumninfo(tablename, dmptype);
         if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
            new ArrayList();
            List<TCoreMaskingTaskTableInfo> var23 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
            if (var23 != null) {
               for(ColumnInfoVO civ : list) {
                  for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var23) {
                     if (this.delparentheses(civ.getColumnname()).equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                        civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                        break;
                     }
                  }
               }
            }
         } else {
            for(ColumnInfoVO civ : list) {
               for(Map<String, String> map : map_s) {
                  if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                     civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                     break;
                  }
               }
            }
         }

         return list;
      }
   }

   @RequestMapping({"/querycolumninfodiff"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfodiff(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         return null;
      } else {
         String datasystemid = id.replace(tablename, "");
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(datasystemid);
         if (tCoreDatasystemSource == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            Map<String, String> targetFieldNameMap = new HashMap();

            for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
               String targetName = "";
               String fieldname = desensitizationDataTargetfield.getFieldname();

               for(Map<String, String> map : map_t) {
                  if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
                     targetName = ((String)map.get("sourcefieldname")).toLowerCase();
                     break;
                  }
               }

               targetFieldNameMap.put(fieldname, targetName);
            }

            Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
            List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tablename);
            List<ColumnInfoVO> list1 = new ArrayList();
            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               for(ColumnInfoVO civ : list) {
                  if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                     civ.setDecimaldigits("");
                  }

                  list1.add(civ);
               }

               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
                  new ArrayList();
                  List<TCoreMaskingTaskTableInfo> var32 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
                  if (var32 != null) {
                     for(ColumnInfoVO civ : list1) {
                        for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var32) {
                           if (civ.getColumnname().equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                              civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                              break;
                           }
                        }
                     }
                  }
               } else {
                  for(ColumnInfoVO civ : list1) {
                     for(Map<String, String> map : map_s) {
                        if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                           civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                           break;
                        }
                     }
                  }
               }
            } else if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
               new ArrayList();
               List<TCoreMaskingTaskTableInfo> var34 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
               if (var34 != null) {
                  for(ColumnInfoVO civ : list) {
                     for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var34) {
                        if (this.delparentheses(civ.getColumnname()).equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                           civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                           break;
                        }
                     }
                  }
               }
            } else {
               for(ColumnInfoVO civ : list) {
                  for(Map<String, String> map : map_s) {
                     if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                        civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                        break;
                     }
                  }
               }
            }

            try {
               if (conn != null) {
                  conn.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               this.redisService.remove("dbsystemdata");
               this.redisService.set("dbsystemdata", list1);
               return list1;
            } else {
               this.redisService.remove("dbsystemdata");
               this.redisService.set("dbsystemdata", list);
               return list;
            }
         }
      }
   }

   @RequestMapping({"/querycolumntypediff2"})
   @ResponseBody
   public List<ComboboxVO> querycolumntype2(HttpServletRequest request, HttpServletResponse response, Model model, String sourceColumnType) {
      List<ComboboxVO> list = new ArrayList();
      sourceColumnType = this.delparentheses(sourceColumnType);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return null;
      } else {
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName("ORACLE");
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            String fieldName = "";

            for(Map<String, String> map : map_s) {
               if (sourceColumnType.toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                  fieldName = (String)map.get("targetfieldname");
               }
            }

            List<String> targetFieldNameList = new ArrayList();

            for(Map<String, String> map : map_t) {
               if (fieldName.equals(map.get("targetfieldname"))) {
                  targetFieldNameList.add(((String)map.get("sourcefieldname")).toLowerCase());
               }
            }

            for(String string : targetFieldNameList) {
               ComboboxVO c = new ComboboxVO(string);
               list.add(c);
            }

            return list;
         }
      }
   }

   @RequestMapping({"/querycolumntypediff"})
   @ResponseBody
   public List<ComboboxVO> querycolumntype(HttpServletRequest request, HttpServletResponse response, Model model, String sourceColumnType) {
      List<ComboboxVO> list = new ArrayList();
      sourceColumnType = this.delparentheses(sourceColumnType);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return null;
      } else {
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            String fieldName = "";

            for(Map<String, String> map : map_s) {
               if (sourceColumnType.toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                  fieldName = (String)map.get("targetfieldname");
               }
            }

            List<String> targetFieldNameList = new ArrayList();

            for(Map<String, String> map : map_t) {
               if (fieldName.equals(map.get("targetfieldname"))) {
                  targetFieldNameList.add(((String)map.get("sourcefieldname")).toLowerCase());
               }
            }

            for(String string : targetFieldNameList) {
               ComboboxVO c = new ComboboxVO(string);
               list.add(c);
            }

            return list;
         }
      }
   }

   @RequestMapping({"/querycolumnfileinfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumnfileinfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/queryfilecolumnbyid"})
   @ResponseBody
   public List<TCoreFileStructurecolumnVO> queryfilecolumnbyid(String structureid) {
      List<TCoreFileStructurecolumn> list = this.fileSystemService.queryFileStructureColumn(structureid);
      List<TCoreFileStructurecolumnVO> volist = null;

      try {
         volist = ObjectTool.listConvert(list, TCoreFileStructurecolumnVO.class);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return volist;
   }

   @RequestMapping({"/savetableinfo"})
   @ResponseBody
   public boolean savetableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap, String filterConditions) {
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String t_tableName = (String)tableInfoMap.get("tableInfoMap[t_tableName]");
      String version = (String)tableInfoMap.get("version");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      this.redisService.set(tasknamereal + "_" + "version", version);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      filterConditions = null == filterConditions ? "" : filterConditions;
      if (request.getSession().getAttribute(tasknamereal + "_" + "filterConditions") == null) {
         Map<String, String> map = new HashMap();
         map.put(tableName, filterConditions);
         request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", map);
      } else {
         ((Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions")).put(tableName, filterConditions);
      }

      if (desensitizationsource == null) {
         return false;
      } else {
         List<ColumnInfoVO> queryColumnInfo = null;
         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            String multiDempFile = desensitizationsource.getMultiDempFile();
            if ("0".equals(multiDempFile)) {
               if ("0".equals(desensitizationsource.getDmptype())) {
                  List<ColumnInfoVO> reColumnInfoList = null;
                  Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmpdp_tableInfoMap_masking");
                  List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
                  Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                     if (tableName.equals(tableStructureInfo.getTablename())) {
                        reColumnInfoList = tableStructureInfo.getColInfoLst();
                     }

                     columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                  }

                  queryColumnInfo = reColumnInfoList;
               } else {
                  List<ColumnInfoVO> reColumnInfoList = null;
                  Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmp_tableInfoMap_masking");
                  List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
                  Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                     if (tableName.equals(tableStructureInfo.getTablename())) {
                        reColumnInfoList = tableStructureInfo.getColInfoLst();
                     }

                     columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                  }

                  queryColumnInfo = reColumnInfoList;
               }
            } else {
               String sourcefiledir = desensitizationsource.getFilelist();
               String sourcepath = desensitizationsource.getSourcefiledir();
               String[] sourcefile = sourcefiledir.split(",");
               List<String> sourcefilelist = new ArrayList();

               for(String string : sourcefile) {
                  sourcefilelist.add(sourcepath + "/" + string);
               }

               if ("0".equals(desensitizationsource.getDmptype())) {
                  List<ColumnInfoVO> reColumnInfoList = null;
                  Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmpdp_tableInfoMap_masking");
                  List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
                  Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                     if (tableName.equals(tableStructureInfo.getTablename())) {
                        reColumnInfoList = tableStructureInfo.getColInfoLst();
                     }

                     columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                  }

                  queryColumnInfo = reColumnInfoList;
               } else {
                  List<ColumnInfoVO> reColumnInfoList = null;
                  Map<String, Object> dmpTableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmp_tableInfoMap_masking");
                  List<TableStructureInfo> tableStructureInfoList = (List)dmpTableInfoMap.get("tableStructureInfoList");
                  Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                     if (tableName.equals(tableStructureInfo.getTablename())) {
                        reColumnInfoList = tableStructureInfo.getColInfoLst();
                     }

                     columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                  }

                  queryColumnInfo = reColumnInfoList;
               }
            }
         } else {
            queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), tableName);
         }

         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            String string = (String)tableInfoMap.get("tableInfoMap[rows][" + j + "][canshuname]");
            Map<String, String> parameterlist = new HashMap();
            if (string != null) {
               String[] split = string.split(",");

               for(String s : split) {
                  parameterlist.put(s, tableInfoMap.get("tableInfoMap[rows][" + j + "][" + s + "]"));
               }
            }

            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][primarykey]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][typename]"));
            tCoreMaskingTaskTableInfo.setTargetType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][targettypename]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnsize]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][decimaldigits]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setParameterlist(parameterlist);
            tCoreMaskingTaskTableInfo.setSecretkeyId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][secretkeyId]"));
            tCoreMaskingTaskTableInfo.setSecretkeyName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][secretkeyName]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         List<Map<String, String>> tableList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         this.redisService.set(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]"), tCoreMaskingTaskTableInfoList);

         for(Map<String, String> map : tableList) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("t_tableName", t_tableName);
               if (((String)map.get("status")).equals("0")) {
                  map.put("status", "2");
               } else if (((String)map.get("status")).equals("1")) {
                  map.put("status", "3");
               }
            }
         }

         int RuleResult = 0;
         return true;
      }
   }

   public List<ColumnInfoVO> queryColumnInfo(String structureid) {
      List<TCoreFileStructurecolumn> listFile = this.fileSystemService.queryFileStructureColumn(structureid);
      List<ColumnInfoVO> list = new ArrayList();

      for(TCoreFileStructurecolumn tCoreFileStructurecolumn : listFile) {
         ColumnInfoVO columnInfoVO = new ColumnInfoVO();
         columnInfoVO.setColumnname(tCoreFileStructurecolumn.getColumnname());
         columnInfoVO.setColumnsize(tCoreFileStructurecolumn.getColumnaccuracy());
         columnInfoVO.setTargettypename(tCoreFileStructurecolumn.getColumntype());
         columnInfoVO.setTypename(tCoreFileStructurecolumn.getColumntype());
         columnInfoVO.setDecimaldigits(tCoreFileStructurecolumn.getColumndecimal());
         list.add(columnInfoVO);
      }

      return list;
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   @RequestMapping({"/savefiletableinfo"})
   @ResponseBody
   public boolean savefiletableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      String structureid = (String)tableInfoMap.get("tableInfoMap[structureid]");
      String filedir = (String)tableInfoMap.get("tableInfoMap[filedir]");
      String filename = (String)tableInfoMap.get("tableInfoMap[filename]");
      String extension = (String)tableInfoMap.get("tableInfoMap[extension]");
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return false;
      } else {
         List<TCoreFileStructurecolumn> queryColumnInfo = this.fileSystemService.queryFileStructureColumn(structureid);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][keytype]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columntype]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnaccuracy]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columndecimal]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setColumnformat((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnformat]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         this.redisService.set(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]"), tCoreMaskingTaskTableInfoList);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("filedir", filedir);
               map.put("filename", filename);
               map.put("extension", extension);
               map.put("status", "1");
               if (((String)map.get("status")).equals("0")) {
                  map.put("status", "2");
               } else if (((String)map.get("status")).equals("1")) {
                  map.put("status", "3");
               }

               this.redisService.set("fileNameRR", map);
            }
         }

         return true;
      }
   }

   @RequestMapping({"/savechoosetable"})
   @ResponseBody
   public boolean saveChooseTable(String tableName, String chooseType, HttpServletRequest request) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         new ArrayList();
         List<Map<String, String>> list = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if ("onCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "3");
               } else if (tableName.equals(map.get("tableName")) && !this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "1");
               }
            }
         } else if ("onUnCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "2");
               } else if (tableName.equals(map.get("tableName")) && !this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "0");
               }
            }
         } else if ("onCheckAll".equals(chooseType)) {
            if (!"".equals(tableName) && tableName != null) {
               String[] tableNameArr = tableName.split(",");
               if (tableNameArr.length > 0) {
                  for(Map<String, String> map : list) {
                     if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")) && Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                        map.put("status", "3");
                     } else if (!this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")) && Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                        map.put("status", "1");
                     }
                  }
               }
            }
         } else if ("onUnCheckAll".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "2");
               } else if (!this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "0");
               }
            }
         }

         request.getSession().setAttribute("tableList_" + tasknamereal, list);
         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/getTableColumnSensitiveRule"},
      method = {RequestMethod.GET}
   )
   public void getSensitiveByIdBySchema(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      PrintWriter writer = null;
      String schema = (String)parameter.get("schema");
      String table = (String)parameter.get("table");
      String version = (String)parameter.get("version");
      String structureid = (String)parameter.get("structureid");
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table)) {
         new ArrayList();
         List<TCoreMaskingTaskTableInfo> e = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table);
         if (e != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : e) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               tcoreDiscoverySensitivecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexRuleName());
               tcoreDiscoverySensitivecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
               tcoreDiscoverySensitivecolumn.setSecretkeyId(tCoreMaskingTaskTableInfo.getSecretkeyId());
               tcoreDiscoverySensitivecolumn.setSecretkeyName(tCoreMaskingTaskTableInfo.getSecretkeyName());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      } else if (version != null && !"".equals(version)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         String ver = version.split("/")[0];
         if ("AllVersion".equals(ver)) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if ("ProjectVersion".equals(ver)) {
            File file = new File(props.getProperty("ProjectVersion") + version.split("/")[1]);
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("ProjectVersion") + version.split("/")[1] + File.separator + file.listFiles()[0].getName();
            }
         } else if ("TaskVersion".equals(ver)) {
            filepath = props.getProperty("TaskVersion") + version.split("/")[1] + "/" + version.split("/")[2];
         }

         System.out.println("filepath:" + filepath + "," + version);
         String sourceid = desensitizationsource.getDatasourceid();
         new ArrayList();
         if (sourceid != null) {
            TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(sourceid);
            List columnlist;
            if (!"1".equals(tCoreDatasystem.getFlag()) && !"3".equals(tCoreDatasystem.getFlag())) {
               columnlist = this.queryColumnInfo(structureid);
            } else {
               columnlist = this.queryColumnInfo(desensitizationsource.getDatasourceid(), schema, table);
            }

            list = this.versionList(filepath, columnlist, desensitizationsource.getDataschema(), table);
         } else {
            List<ColumnInfoVO> var35 = this.querydmpcolumninfo(table, desensitizationsource.getMultiDempFile());
            if ("0".equals(desensitizationsource.getMultiDempFile())) {
               String sourcefiledir = desensitizationsource.getSourcefiledir();
               String dmpFileName = sourcefiledir.substring(sourcefiledir.lastIndexOf("/") + 1);
               schema = dmpFileName.substring(0, dmpFileName.lastIndexOf("."));
            } else {
               String sourcefiledir = desensitizationsource.getFilelist();
               String sourcepath = desensitizationsource.getSourcefiledir();
               String[] sourcefiledirs = sourcefiledir.split(",");

               for(String filePathStr : sourcefiledirs) {
                  filePathStr = filePathStr.trim();
                  String dmpFileName = filePathStr.substring(filePathStr.lastIndexOf("/") + 1);
                  dmpFileName = dmpFileName.substring(0, dmpFileName.lastIndexOf("."));
                  schema = dmpFileName;
               }
            }

            list = this.versionList(filepath, var35, schema, table);
         }
      }

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public List<TcoreDiscoverySensitivecolumn> versionList(String filepath, List<ColumnInfoVO> columnlist, String schema, String table) {
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      if (!FileTool.isFileExit(filepath)) {
         return list;
      } else {
         InputStreamReader newRead = null;

         try {
            newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
         } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
         } catch (FileNotFoundException e1) {
            e1.printStackTrace();
         }

         BufferedReader newBufferedReader = new BufferedReader(newRead);
         String newInformationLine = "";
         String[] str = null;

         try {
            while((newInformationLine = newBufferedReader.readLine()) != null) {
               str = newInformationLine.split(",", -1);
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               if (schema.equals(str[0]) && table.equals(str[1])) {
                  for(int i = 0; i < columnlist.size(); ++i) {
                     if (((ColumnInfoVO)columnlist.get(i)).getColumnname().equals(str[2])) {
                        tcoreDiscoverySensitivecolumn.setColumnname(str[2]);
                        tcoreDiscoverySensitivecolumn.setRegextype(str[6]);
                        tcoreDiscoverySensitivecolumn.setRuleid(str[5]);
                     } else {
                        tcoreDiscoverySensitivecolumn.setColumnname(str[2]);
                     }

                     list.add(tcoreDiscoverySensitivecolumn);
                  }
               }
            }
         } catch (IOException e) {
            e.printStackTrace();
         } finally {
            a(newBufferedReader, newRead);
         }

         return list;
      }
   }

   private static void a(Closeable... closeables) {
      if (closeables != null) {
         try {
            for(Closeable closeable : closeables) {
               if (closeable != null) {
                  closeable.close();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   public HashMap<String, String> versionMap(String filepath, List<ColumnInfoVO> columnlist, String schema, String table) {
      HashMap<String, String> map = new HashMap();
      if (!FileTool.isFileExit(filepath)) {
         return map;
      } else {
         InputStreamReader newRead = null;

         try {
            newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
         } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
         } catch (FileNotFoundException e1) {
            e1.printStackTrace();
         }

         BufferedReader newBufferedReader = new BufferedReader(newRead);
         String newInformationLine = "";
         String[] str = null;

         try {
            while((newInformationLine = newBufferedReader.readLine()) != null) {
               str = newInformationLine.split(",", -1);
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               if (schema.equals(str[0]) && table.equals(str[1])) {
                  for(int i = 0; i < columnlist.size(); ++i) {
                     if (((ColumnInfoVO)columnlist.get(i)).getColumnname().equals(str[2])) {
                        tcoreDiscoverySensitivecolumn.setColumnname(str[2]);
                        tcoreDiscoverySensitivecolumn.setRegextype(str[6]);
                        tcoreDiscoverySensitivecolumn.setRuleid(str[5]);
                        map.put(str[2], str[6]);
                     }
                  }
               }
            }
         } catch (IOException e) {
            e.printStackTrace();
         } finally {
            a(newBufferedReader, newRead);
         }

         return map;
      }
   }

   @ResponseBody
   @RequestMapping({"/resetTableInfo"})
   public boolean resetTableInfo(HttpServletRequest request, String tableName) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         this.redisService.remove(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tableName);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               if (((String)map.get("status")).equals("2")) {
                  map.put("status", "0");
               } else if (((String)map.get("status")).equals("3")) {
                  map.put("status", "1");
               }
            }
         }

         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @ResponseBody
   @RequestMapping({"/resetTableInfoAll"})
   public boolean resetTableInfoAll(HttpServletRequest request, String tableName) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         this.redisService.removePattern(tasknamereal + "_TCoreMaskingTaskTableInfo_*");

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("status", "0");
            }
         }

         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @RequestMapping({"/editEncryptionMasking"})
   public String editEncryptionMasking(HttpServletRequest request, Model model, String taskid, Integer pageCurr, String edit) {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
      String tasktype = encryptionmasking.getTasktype();
      String sourcetype = tasktype.split("to")[0];
      String tasknamereal = encryptionmasking.getTasknamereal();
      String path = "";
      model.addAttribute("tasknamereal", tasknamereal);
      request.getSession().setAttribute("tasknamereal", tasknamereal);
      request.getSession().setAttribute(encryptionmasking.getTasknamereal() + "_taskid", taskid);
      Desensitizationsource desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
      Desensitizationtarget desensitizationtarget = this.encryptionMaskingService.queryTargetInfo(taskid);
      this.redisService.set(encryptionmasking.getTasknamereal() + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
      List<Map<String, String>> tableList = new ArrayList();
      if (!"DB".equals(sourcetype) && !"HIVE".equals(sourcetype)) {
         if ("LOCALFILE".equals(sourcetype) || "FILE".equals(sourcetype) || "FTP".equals(sourcetype) || "SFTP".equals(sourcetype)) {
            List<TCoreFileStructure> list = this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "");
            List<DesensitizationTable> desensitizationTablelist = this.encryptionMaskingService.queryTableList(taskid);
            Map<String, DesensitizationTable> maptable = new HashMap();

            for(DesensitizationTable desensitizationTable : desensitizationTablelist) {
               maptable.put(desensitizationTable.getTablename(), desensitizationTable);
            }

            for(TCoreFileStructure dbTableVO : list) {
               Map<String, String> tableMap = new HashMap();
               tableMap.put("tableName", dbTableVO.getFilestructurename());
               tableMap.put("structureid", dbTableVO.getId());
               tableMap.put("filedir", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilepath());
               tableMap.put("filename", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilename().split("\\.")[0]);
               tableMap.put("extension", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : "." + ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilename().split("\\.")[1]);
               tableMap.put("status", maptable.get(dbTableVO.getFilestructurename()) == null ? "0" : "1");
               tableList.add(tableMap);
            }

            request.getSession().setAttribute("tableList_" + encryptionmasking.getTasknamereal(), tableList);
            model.addAttribute("isshow", "1");
            model.addAttribute("taskid", taskid);
            model.addAttribute("tasknamereal", encryptionmasking.getTasknamereal());
            String version = (String)this.redisService.get(tasknamereal + "_" + "version");
            String batchnumber = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            if (edit == null) {
               if (version == null) {
                  version = encryptionmasking.getVersion();
               }

               batchnumber = encryptionmasking.getBatchnumber();
               tablesuffix = encryptionmasking.getTablesuffix();
               tableprefix = encryptionmasking.getTableprefix();
            }

            this.redisService.set(encryptionmasking.getTasknamereal() + "_" + BatchManage.class.getSimpleName(), batchnumber);
            this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "tableprefix", tableprefix);
            this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "tablesuffix", tablesuffix);
            model.addAttribute("version", version);
            path = "core/encryptionmasking/taskedit/encryptionmasking_edit_file";
         }
      } else {
         Map<String, String> allTable = new HashMap();
         if (!"1".equals(desensitizationsource.getIsdmpfile())) {
            allTable = this.dataSystemService.queryTableName(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "");
         } else {
            List<String> list = new ArrayList();
            String multiDempFile = desensitizationsource.getMultiDempFile();
            if ("0".equals(multiDempFile)) {
               if ("0".equals(desensitizationsource.getDmptype())) {
                  Map<String, Object> tableInfoMap = DmpDpTool.getAllTableinfo(desensitizationsource.getSourcefiledir());
                  this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "Dmpdp_tableInfoMap_masking", tableInfoMap);
                  List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
                  }
               } else {
                  Map<String, Object> tableInfoMap = DmpTool.getAllTableinfo(desensitizationsource.getSourcefiledir());
                  this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "Dmp_tableInfoMap_masking", tableInfoMap);
                  List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
                  }
               }
            } else {
               List<String> fileslist = new ArrayList();
               String sourcefiledir = desensitizationsource.getFilelist();
               String sourcepath = desensitizationsource.getSourcefiledir();
               String[] sourcefiledirs = sourcefiledir.split(",");

               for(String string : sourcefiledirs) {
                  fileslist.add(sourcepath + "/" + string);
               }

               if ("0".equals(desensitizationsource.getDmptype())) {
                  Map<String, Object> tableInfoMap = MultipleDmpDpTool.getAllTableinfo(fileslist);
                  this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "multiDmpdp_tableInfoMap_masking", tableInfoMap);
                  List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                  list = new ArrayList();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
                  }
               } else {
                  Map<String, Object> tableInfoMap = MultipleDmpTool.getAllTableinfo(fileslist);
                  this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "MultipleDmp_tableInfoMap_masking", tableInfoMap);
                  List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
                  }
               }
            }

            for(String str : list) {
               allTable.put(str, "0");
            }
         }

         List<DesensitizationTable> desensitizationTableList = this.encryptionMaskingService.queryTableList(taskid);
         Map<String, String> sqlFiterMap = new HashMap();
         Map<String, String> t_tableNameMap = new HashMap();

         for(DesensitizationTable desensitizationTable : desensitizationTableList) {
            allTable.put(desensitizationTable.getTablename(), desensitizationTable.getStatus());
            sqlFiterMap.put(desensitizationTable.getTablename(), desensitizationTable.getSqlFilter());
            t_tableNameMap.put(desensitizationTable.getTablename(), desensitizationTable.getT_tablename());
         }

         List<DBTableVO> list = new ArrayList();

         for(String key : allTable.keySet()) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename(key);
            dbTableVO.setStatus((String)allTable.get(key));
            list.add(dbTableVO);
         }

         Collections.sort(list);

         for(DBTableVO dbTableVO : list) {
            Map<String, String> map = new HashMap();
            map.put("tableName", dbTableVO.getTablename());
            map.put("status", dbTableVO.getStatus());
            map.put("t_tableName", t_tableNameMap.get(dbTableVO.getTablename()));
            tableList.add(map);
         }

         request.getSession().setAttribute(encryptionmasking.getTasknamereal() + "_" + "filterConditions", sqlFiterMap);
         request.getSession().setAttribute(encryptionmasking.getTasknamereal() + "_" + "filterConditions", sqlFiterMap);
         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            model.addAttribute("mappingEditFlag", "dbsystem");
         } else {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            if (tCoreDatasystemTarget != null && !tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype())) {
               model.addAttribute("mappingEditFlag", "dbsystem_diff");
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         }

         request.getSession().setAttribute("tableList_" + encryptionmasking.getTasknamereal(), tableList);
         String version = (String)this.redisService.get(tasknamereal + "_" + "version");
         String batchnumber = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         if (edit == null) {
            if (version == null) {
               version = encryptionmasking.getVersion();
            }

            batchnumber = encryptionmasking.getBatchnumber();
            tablesuffix = encryptionmasking.getTablesuffix();
            tableprefix = encryptionmasking.getTableprefix();
         }

         this.redisService.set(encryptionmasking.getTasknamereal() + "_" + BatchManage.class.getSimpleName(), batchnumber);
         this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "tableprefix", tableprefix);
         this.redisService.set(encryptionmasking.getTasknamereal() + "_" + "tablesuffix", tablesuffix);
         model.addAttribute("version", version);
         path = "core/encryptionmasking/taskedit/encryptionmasking_edit";
      }

      return path;
   }

   @RequestMapping({"/showEncryptionMasking"})
   public String showEncryptionMasking(HttpServletRequest request, Model model, String taskid, Integer pageCurr) {
      model.addAttribute("pageCurr", pageCurr);
      model.addAttribute("taskid", taskid);
      return "core/encryptionmasking/taskedit/encryptionmasking_show";
   }

   @RequestMapping({"/querymultitable"})
   @ResponseBody
   public List<ColumnInfoVO> querymultitable(String structureid, String taskid, String type, String table, HttpServletRequest request) {
      String dmpschema = "";
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String version = (String)this.redisService.get(tasknamereal + "_" + "version");
      List<ColumnInfoVO> queryColumnInfo = new ArrayList();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      if (!"1".equals(type) && !"2".equals(type)) {
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      } else {
         desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
      }

      new ArrayList();
      List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + table);
      HashMap<String, String> map = new HashMap();
      if ("1".equals(type)) {
         for(DesensitizationTablecolumn desensitizationTablecolumn : this.encryptionMaskingService.queryColumInfo(taskid, table)) {
            ColumnInfoVO columnInfo = new ColumnInfoVO();
            columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
            columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
            columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
            columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
            columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRulename()) ? "无" : desensitizationTablecolumn.getRulename());
            columnInfo.setSecretkeyName(desensitizationTablecolumn.getSecretkeyName());
            queryColumnInfo.add(columnInfo);
         }
      } else {
         if (tCoreMaskingTaskTableInfoList != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
            }
         } else {
            if ("1".equals(desensitizationsource.getIsdmpfile())) {
               if ("0".equals(desensitizationsource.getMultiDempFile())) {
                  if ("0".equals(desensitizationsource.getDmptype())) {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmpdp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  } else {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  }

                  String dmpFilePath = desensitizationsource.getSourcefiledir();
                  String dmpFileName = dmpFilePath.substring(dmpFilePath.lastIndexOf("/") + 1);
                  dmpschema = dmpFileName.substring(0, dmpFileName.lastIndexOf("."));
               } else {
                  List<String> sourcefilelist = new ArrayList();
                  String filelist = desensitizationsource.getFilelist();
                  String[] sourcefiledirlist = filelist.split(",");

                  for(String string : sourcefiledirlist) {
                     sourcefilelist.add(string);
                     String dmpFileName = string.substring(string.lastIndexOf("/") + 1);
                     dmpschema = dmpFileName.substring(0, dmpFileName.lastIndexOf("."));
                  }

                  if ("0".equals(desensitizationsource.getDmptype())) {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmpdp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  } else {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  }
               }
            } else {
               String sourceid = desensitizationsource.getDatasourceid();
               if (sourceid != null) {
                  TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(sourceid);
                  String soucreType = tCoreDatasystem.getFlag();
                  if (soucreType.equals("2")) {
                     queryColumnInfo = this.queryColumnInfo(structureid);
                  } else {
                     queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
                  }
               }
            }

            if (version != null && !"".equals(version)) {
               Properties props = new Properties();

               try {
                  props = PropertiesLoaderUtils.loadAllProperties("config.properties");
               } catch (IOException e) {
                  e.printStackTrace();
               }

               String filepath = "";
               String ver = version.split("/")[0];
               if ("AllVersion".equals(ver)) {
                  File file = new File(props.getProperty("AllVersion"));
                  if (file.listFiles() != null && file.listFiles().length > 0) {
                     filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
                  }
               } else if ("ProjectVersion".equals(ver)) {
                  File file = new File(props.getProperty("ProjectVersion") + version.split("/")[1]);
                  if (file.listFiles() != null && file.listFiles().length > 0) {
                     filepath = props.getProperty("ProjectVersion") + version.split("/")[1] + File.separator + file.listFiles()[0].getName();
                  }
               } else if ("TaskVersion".equals(ver)) {
                  filepath = props.getProperty("TaskVersion") + version.split("/")[1] + "/" + version.split("/")[2];
               }

               System.out.println("filepath:" + filepath + "," + version);
               String sourceid = desensitizationsource.getDatasourceid();
               new ArrayList();
               if (sourceid != null) {
                  map = this.versionMap(filepath, queryColumnInfo, desensitizationsource.getDataschema(), table);
               } else {
                  map = this.versionMap(filepath, queryColumnInfo, dmpschema, table);
               }
            }
         }

         if (tCoreMaskingTaskTableInfoList != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
               columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
               columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
               columnInfo.setSecretkeyName(tCoreMaskingTaskTableInfo.getSecretkeyName());
               queryColumnInfo.add(columnInfo);
            }
         }

         for(ColumnInfoVO columnInfo : queryColumnInfo) {
            columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");
         }
      }

      return queryColumnInfo;
   }

   @RequestMapping({"/querymultitablediff"})
   @ResponseBody
   public List<ColumnInfoVO> querymultitablediff(String structureid, String taskid, String type, String table, HttpServletRequest request) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String version = (String)this.redisService.get(tasknamereal + "_" + "version");
      List<ColumnInfoVO> queryColumnInfo = new ArrayList();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      if (!"1".equals(type) && !"2".equals(type)) {
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      } else {
         desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         desensitizationtarget = this.encryptionMaskingService.queryTargetInfo(taskid);
      }

      TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
      String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
      String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
      List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
      List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
      List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
      Map<String, String> targetFieldNameMap = new HashMap();

      for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
         String targetName = "";
         String fieldname = desensitizationDataTargetfield.getFieldname();

         for(Map<String, String> map : map_t) {
            if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
               targetName = ((String)map.get("sourcefieldname")).toLowerCase();
               break;
            }
         }

         targetFieldNameMap.put(fieldname, targetName);
      }

      new ArrayList();
      List<TCoreMaskingTaskTableInfo> var32 = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + table);
      HashMap<String, String> map = new HashMap();
      if ("1".equals(type)) {
         for(DesensitizationTablecolumn desensitizationTablecolumn : this.encryptionMaskingService.queryColumInfo(taskid, table)) {
            ColumnInfoVO columnInfo = new ColumnInfoVO();
            columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
            columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
            columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
            columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
            columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRulename()) ? "无" : desensitizationTablecolumn.getRulename());
            columnInfo.setTargettypename(desensitizationTablecolumn.getColumntartype());
            queryColumnInfo.add(columnInfo);
         }
      } else {
         if (var32 != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var32) {
               map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
            }
         } else {
            String sourceid = desensitizationsource.getDatasourceid();
            if (sourceid != null) {
               TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(sourceid);
               String soucreType = tCoreDatasystem.getFlag();
               if (soucreType.equals("2")) {
                  queryColumnInfo = this.queryColumnInfo(structureid);
               } else {
                  queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
               }
            }

            if (version != null && !"".equals(version)) {
               Properties props = new Properties();

               try {
                  props = PropertiesLoaderUtils.loadAllProperties("config.properties");
               } catch (IOException e) {
                  e.printStackTrace();
               }

               String filepath = "";
               String ver = version.split("/")[0];
               if ("AllVersion".equals(ver)) {
                  File file = new File(props.getProperty("AllVersion"));
                  if (file.listFiles() != null && file.listFiles().length > 0) {
                     filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
                  }
               } else if ("ProjectVersion".equals(ver)) {
                  File file = new File(props.getProperty("ProjectVersion") + version.split("/")[1]);
                  if (file.listFiles() != null && file.listFiles().length > 0) {
                     filepath = props.getProperty("ProjectVersion") + version.split("/")[1] + File.separator + file.listFiles()[0].getName();
                  }
               } else if ("TaskVersion".equals(ver)) {
                  filepath = props.getProperty("TaskVersion") + version.split("/")[1] + "/" + version.split("/")[2];
               }

               System.out.println("filepath:" + filepath + "," + version);
               new ArrayList();
               if (sourceid != null) {
                  TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(sourceid);
                  String soucreType = tCoreDatasystem.getFlag();
                  if (!soucreType.equals("2")) {
                     List<ColumnInfoVO> columnlist = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
                     queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
                     map = this.versionMap(filepath, columnlist, desensitizationsource.getDataschema(), table);
                  }
               }
            }
         }

         if (var32 != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var32) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
               columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
               columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
               if ("HIVE".equals(tCoreDatasystemSource.getDbtype())) {
                  for(Map<String, String> map1 : map_s) {
                     if (this.delparentheses(columnInfo.getTypename().toLowerCase()).equals(((String)map1.get("sourcefieldname")).toLowerCase()) && "1".equals(map1.get("sourcedefault"))) {
                        columnInfo.setTargettypename((String)targetFieldNameMap.get(map1.get("targetfieldname")));
                        break;
                     }
                  }
               } else {
                  columnInfo.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
               }

               columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");
               queryColumnInfo.add(columnInfo);
            }
         } else {
            for(ColumnInfoVO columnInfo : queryColumnInfo) {
               columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");

               for(Map<String, String> map1 : map_s) {
                  if (this.delparentheses(columnInfo.getTypename().toLowerCase()).equals(((String)map1.get("sourcefieldname")).toLowerCase()) && "1".equals(map1.get("sourcedefault"))) {
                     columnInfo.setTargettypename((String)targetFieldNameMap.get(map1.get("targetfieldname")));
                     break;
                  }
               }
            }
         }
      }

      return queryColumnInfo;
   }

   @ResponseBody
   @RequestMapping({"/querysqlFilter"})
   public Map<String, Object> querysqlFilter(String taskid, String type, String table, HttpServletRequest request) {
      String sqlFilter = "";
      String t_tablename = "";
      Map<String, Object> map = new HashMap();
      EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
      if ("1".equals(type)) {
         DesensitizationTable desensitizationTable = this.encryptionMaskingService.queryTableByTableName(taskid, table);
         sqlFilter = desensitizationTable.getSqlFilter() == null ? "" : desensitizationTable.getSqlFilter();
         map.put("filename", desensitizationTable.getFilename() == null ? "" : desensitizationTable.getFilename());
         map.put("filepath", desensitizationTable.getFilepath() == null ? "" : desensitizationTable.getFilepath());
         t_tablename = encryptionmasking.getTableprefix() != null ? encryptionmasking.getTableprefix() : "";
         t_tablename = t_tablename + (desensitizationTable.getT_tablename() != null ? desensitizationTable.getT_tablename() : desensitizationTable.getTablename());
         t_tablename = t_tablename + (encryptionmasking.getTablesuffix() != null ? encryptionmasking.getTablesuffix() : "");
      } else {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         Map filterMap = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
         if (filterMap != null) {
            if (!"".equals((String)filterMap.get(table)) && (String)filterMap.get(table) != null) {
               sqlFilter = ((String)filterMap.get(table)).replaceAll("'", "\\\\'");
            } else {
               sqlFilter = (String)filterMap.get(table);
            }
         }

         new ArrayList();
         List<Map<String, String>> tCoreMaskingTaskTablemapList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         tCoreMaskingTaskTablemapList = (List)tCoreMaskingTaskTablemapList.stream().filter((s) -> table.equals(s.get("tableName"))).collect(Collectors.toList());
         System.out.println(tCoreMaskingTaskTablemapList.size());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         if (tableprefix == null) {
            tableprefix = "";
         }

         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (tablesuffix == null) {
            tablesuffix = "";
         }

         if (tCoreMaskingTaskTablemapList != null && tCoreMaskingTaskTablemapList.size() > 0) {
            Map<String, String> maptable = (Map)tCoreMaskingTaskTablemapList.get(0);
            t_tablename = tableprefix + (maptable.get("t_tableName") != null ? (String)maptable.get("t_tableName") : table);
            t_tablename = t_tablename + tablesuffix;
         } else {
            t_tablename = "";
         }
      }

      map.put("t_tableName", t_tablename);
      map.put("sqlFilter", sqlFilter);
      return map;
   }

   @RequestMapping(
      value = {"/removetask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public void removetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
      encryptionmasking.setTaskstatus("2");
      this.redisService.set("removePercent_" + encryptionmasking.getTasknamereal(), "0", new Long(86400L));
      this.encryptionMaskingService.updateTask(encryptionmasking);
      this.encryptionMaskingService.removeTask(taskid);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("数据脱敏");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setLogmessage("删除数据脱敏任务");
      this.operationService.add(record);

      try {
         Properties loadAllProperties = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String datacomparedir = (String)loadAllProperties.get("datacomparedir");
         String tasknamereal = encryptionmasking.getTasknamereal();
         delFolder(datacomparedir + "/" + tasknamereal);
      } catch (IOException e) {
         e.printStackTrace();
      }

   }

   public static boolean delAllFile(String path) {
      boolean flag = false;
      File file = new File(path);
      if (!file.exists()) {
         return flag;
      } else if (!file.isDirectory()) {
         return flag;
      } else {
         String[] tempList = file.list();
         File temp = null;

         for(int i = 0; i < tempList.length; ++i) {
            if (path.endsWith(File.separator)) {
               temp = new File(path + tempList[i]);
            } else {
               temp = new File(path + File.separator + tempList[i]);
            }

            if (temp.isFile()) {
               temp.delete();
            }

            if (temp.isDirectory()) {
               delAllFile(path + "/" + tempList[i]);
               delFolder(path + "/" + tempList[i]);
               flag = true;
            }
         }

         return flag;
      }
   }

   public static void delFolder(String folderPath) {
      try {
         delAllFile(folderPath);
         String e = folderPath.toString();
         File myFilePath = new File(e);
         myFilePath.delete();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @RequestMapping({"/executeEncryptionMasking"})
   public String executeEncryptionMasking(HttpServletRequest request, Model model, String taskid, Integer pageCurr) {
      String returnUrl = "/core/encryptionmasking/monitorrun";
      String masking_engine_type = "";

      try {
         Desensitizationsource desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.encryptionMaskingService.queryTargetById(taskid);
         EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
         DesensitizationFile desensitizationFile = this.encryptionMaskingService.queryDesensitizationfileBytaskid(taskid);
         boolean isOracleTodmp = false;
         if (desensitizationsource.getDatasourceid() != null && "".equals(desensitizationsource.getDatasourceid()) && "ORACLE".equals(this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid()).getDbtype()) && "oracledmp".equals(desensitizationtarget.getExecution_type())) {
            isOracleTodmp = true;
         }

         masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
         TCoreDatasystem tCoreDatasystemSource = new TCoreDatasystem();
         TCoreDatasystem tCoreDatasystemTarget = new TCoreDatasystem();
         if (null != desensitizationsource && desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid()) && !isOracleTodmp) {
            tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         } else if (null == desensitizationsource || !"1".equals(desensitizationsource.getIsdmpfile()) && !isOracleTodmp) {
            tCoreDatasystemSource.setDbtype("FILE");
         } else {
            tCoreDatasystemSource.setDbtype("ORACLE");
         }

         if (null != desensitizationtarget && desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
            tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         } else if (null != desensitizationtarget && "1".equals(desensitizationtarget.getDmpimport())) {
            tCoreDatasystemTarget.setDbtype("ORACLE");
         } else {
            tCoreDatasystemTarget.setDbtype("FILE");
         }

         String type = JdbcTool.returnType(desensitizationsource.getExecution_type(), desensitizationtarget.getExecution_type(), encryptionmasking.getTasktype().replace("FTP", "FILE").replace("SFTP", "FILE").replace("LOCALFILE", "FILE"));
         InfoProperty infoProperty = this.encryptionMaskingService.getInfoProperty();
         long groupId = (new Date()).getTime();
         ExecuteParam executeParam = new ExecuteParam();
         executeParam.setSourceDataSystem(tCoreDatasystemSource);
         executeParam.setTargetDataSystem(tCoreDatasystemTarget);
         executeParam.setInfoProperty(infoProperty);
         executeParam.setDataSourceId(desensitizationsource.getDatasourceid());
         executeParam.setDataTargetId(desensitizationtarget.getDatasourceid());
         executeParam.setFolderName(encryptionmasking.getFoldername());
         executeParam.setSourceSchemaName(desensitizationsource.getDataschema());
         executeParam.setTargetSchemaName(desensitizationtarget.getDataschema());
         executeParam.setIsPrimary(desensitizationtarget.getIsprimary());
         executeParam.setIsIndex(desensitizationtarget.getIsindex());
         executeParam.setTaskid(taskid);
         executeParam.setSourceFileDir(desensitizationsource.getSourcefiledir());
         executeParam.setTragetFileDir(desensitizationtarget.getTargetfiledir());
         executeParam.setTaskNameReal(encryptionmasking.getTasknamereal());
         executeParam.setSourcetype(desensitizationsource.getExecution_type());
         executeParam.setTargettype(desensitizationtarget.getExecution_type());
         executeParam.setLoadscripttype(desensitizationtarget.getLoadscripttype());
         executeParam.setTableprefix(encryptionmasking.getTableprefix());
         executeParam.setTablesuffix(encryptionmasking.getTablesuffix());
         executeParam.setDesensitizationtarget(desensitizationtarget);
         executeParam.setSourceDbType(tCoreDatasystemSource.getDbtype());
         executeParam.setTargetDbType(tCoreDatasystemTarget.getDbtype());
         executeParam.setDesensitizationFile(desensitizationFile);
         if (isOracleTodmp) {
            executeParam.setDataSourceId((String)null);
            executeParam.setSourceSchemaName((String)null);
         }

         String taskType = JdbcTool.returnTaskType(encryptionmasking.getTasktype());
         List<DesensitizationTable> tableList = this.encryptionMaskingService.queryTableList(taskid);
         Map<String, String> tableMap = new HashMap();
         StringBuilder batchInserSql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationMonitor());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "desensitization_monitor");
         batchInserSql.append(sqlBase);

         for(DesensitizationTable desensitizationTable : tableList) {
            String id = UUID.randomUUID().toString();
            tableMap.put(desensitizationTable.getTablename(), id);
            DesensitizationMonitor desensitizationMonitor = new DesensitizationMonitor();
            desensitizationMonitor.setId(id);
            desensitizationMonitor.setSourcename(desensitizationTable.getTablename());
            desensitizationMonitor.setTargetname((encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix()));
            desensitizationMonitor.setRunstatus(0);
            desensitizationMonitor.setGroupid(new BigInteger(String.valueOf(groupId)));
            desensitizationMonitor.setTaskid(taskid);
            desensitizationMonitor.setTasktype(taskType);
            desensitizationMonitor.setIsimport("0");
            batchInserSql.append(JdbcTool.sql_insert_h(desensitizationMonitor, list_table));
         }

         executeParam.setTableMap(tableMap);
         executeParam.setGroupId(groupId);
         this.encryptionMaskingService.saveDesensitizationMonitor(batchInserSql.deleteCharAt(batchInserSql.length() - 1));
         new Properties();
         Properties var30 = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String engineType = var30.getProperty("masking_engine_type");
         this.encryptionMaskingService.updateTask_isengine(executeParam, engineType);
         switch (type) {
            case "DBtoDB,normal,batchwrite":
               this.encryptionMaskingService.executeDB_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "FILEtoDB,batchwrite":
               this.encryptionMaskingService.executeFILE_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "DBtoDB,batchread,batchwrite":
               this.encryptionMaskingService.executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "DBtoFILE,batchread":
               this.encryptionMaskingService.executeDB_batchread_FILE_pwc_FILE(executeParam);
               break;
            case "DBtoDB,batchread,normal":
               this.encryptionMaskingService.executeDB_batchread_FILE_pwc_DB(executeParam);
               break;
            default:
               if (encryptionmasking.getTasktype().contains("HIVE")) {
                  if ("oracledmp".equals(executeParam.getSourcetype())) {
                     this.encryptionMaskingService.executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(executeParam);
                  } else {
                     this.encryptionMaskingService.executeTask(executeParam);
                  }
               } else if ("oracledmp".equals(executeParam.getSourcetype())) {
                  this.encryptionMaskingService.executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(executeParam);
               } else {
                  this.encryptionMaskingService.executeTaskNormal(executeParam);
               }
         }

         model.addAttribute("taskid", taskid);
         model.addAttribute("pageCurr", pageCurr);
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (masking_engine_type.equals("1")) {
         returnUrl = "/core/encryptionmasking/monitorrunlog";
      }

      return returnUrl;
   }

   @RequestMapping({"/monitortaskEM"})
   public String monitortaskEM(HttpServletRequest request, Model model, String taskid) {
      String returnUrl = "/core/encryptionmasking/monitorrun";
      String masking_engine_type = "";

      try {
         EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
         masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
         long groupId = (new Date()).getTime();
         String res = String.valueOf(groupId);
         this.desensitizationMonitorService.queryTaskLogMonitorEM(res);
         String taskType = JdbcTool.returnTaskType(encryptionmasking.getTasktype());
         this.encryptionMaskingService.queryTableList(taskid);
         new HashMap();
         StringBuilder batchInserSql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationMonitor());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "desensitization_monitor");
         batchInserSql.append(sqlBase);
         model.addAttribute("taskid", taskid);
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (masking_engine_type.equals("1")) {
         returnUrl = "/core/encryptionmasking/monitorrunlog";
      }

      return returnUrl;
   }

   @RequestMapping({"/redirectRunMonitor"})
   public String redirectRunMonitor(String taskid, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);

      try {
         String masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
         if ("1".equals(masking_engine_type)) {
            return "/core/desensitizationmonitor/monitorrunlog";
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return "/core/desensitizationmonitor/monitorrun";
   }

   @RequestMapping({"/resultStatistical"})
   public String resultStatistical(String taskid, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      return "/core/desensitizationresultstatistical/resultstatistical";
   }

   @RequestMapping({"/queryStatistical"})
   public String queryStatistical(String taskid, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      return "/core/desensitizationresultstatistical/resultstatistical";
   }

   @RequestMapping({"/detail"})
   public String detail(String tasknamereal, String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) throws SQLException {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      request.getSession().setAttribute("tasknamereal", tasknamereal);
      return "core/encryptionmasking/encryptionmasking_details";
   }

   @RequestMapping({"/isrun"})
   @ResponseBody
   public boolean isrun(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      long num_exeing = this.encryptionMaskingService.getExeTaskNum();
      long num_table = this.encryptionMaskingService.getTableNum(taskid);
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      long num_thread = new Long(props.getProperty("threadPool.queueCapacity"));
      return num_exeing + num_table < num_thread;
   }

   @RequestMapping({"/checksystem"})
   @ResponseBody
   public Map<String, Object> checksystem(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      Map<String, Object> map = new HashMap();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      Float sys_Alert_Threshold = new Float(props.getProperty("Sys_Alert_Threshold"));
      sys_Alert_Threshold = sys_Alert_Threshold * 100.0F;
      map.put("flag", false);

      try {
         if (!((double)sys_Alert_Threshold <= SysUtils.cpuUsage()) && !((double)sys_Alert_Threshold <= SysUtils.memoryUsage()) && !((double)sys_Alert_Threshold <= SysUtils.getDiskUsage())) {
            map.put("flag", false);
         } else {
            System.out.println("CPU利用率：" + SysUtils.cpuUsage());
            System.out.println("内存占用率：" + SysUtils.memoryUsage());
            System.out.println("磁盘空间占用率：" + SysUtils.getDiskUsage());
            map.put("disk", SysUtils.getDiskUsage());
            map.put("cpu", SysUtils.cpuUsage());
            map.put("memory", SysUtils.memoryUsage());
            map.put("flag", true);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return map;
   }

   public String source_type(Map<String, String> map) {
      String sourceType = "";
      String tasknamereal = (String)map.get("tasknamereal");
      new Desensitizationsource();
      Desensitizationsource desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
      if (desensitizationsource != null) {
         String datasourceid = desensitizationsource.getDatasourceid();
         if (datasourceid != null && !"".equals(datasourceid)) {
            TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
            String dbtype = tCoreDatasystem.getDbtype();
            if (!dbtype.equals("FTP") && !dbtype.equals("SFTP") && !dbtype.equals("LOCALFILE")) {
               sourceType = "db";
            } else {
               sourceType = "file";
            }
         } else if ("1".equals(desensitizationsource.getIsdmpfile())) {
            sourceType = "dmp";
         } else {
            sourceType = "file";
         }
      }

      return sourceType;
   }

   @RequestMapping({"/structure/querystructurebygroup"})
   @ResponseBody
   public DataGridVO<DBTableVO> querystructurebygroup(String groupname, String tableNamePattern) {
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();

      List<Map<String, String>> listNew = (List)this.request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         DBTableVO dbTableVO = new DBTableVO();
         dbTableVO.setTablename((String)map.get("tableName"));
         dbTableVO.setStatus((String)map.get("status"));
         dbTableVO.setDatasystemid((String)map.get("structureid"));
         list.add(dbTableVO);
      }

      if (!"".equals(tableNamePattern.trim())) {
         List<DBTableVO> tableSearchList = new ArrayList();

         for(DBTableVO dbTableVO : list) {
            if (dbTableVO.getTablename().indexOf(tableNamePattern) != -1) {
               tableSearchList.add(dbTableVO);
            }
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      } else {
         return new DataGridVO<DBTableVO>((long)list.size(), list);
      }
   }

   @RequestMapping({"/getFileContent"})
   @ResponseBody
   public Map<String, Object> getFileContent(@RequestParam("file") MultipartFile file, String charset) {
      System.out.println("开始");
      String path = "D:\\";
      String uuid = UUID.randomUUID().toString();
      File dbffile = new File(path + uuid + ".dbf");

      try {
         dbffile.createNewFile();
         file.transferTo(dbffile);
      } catch (Exception e) {
         e.printStackTrace();
      }

      Map<String, String> map = transdbf.selectdbf(charset, dbffile, ",");
      Map<String, Object> map_list = new HashMap();
      String content = (String)map.get("content");
      String[] a = content.split("\\\n");
      List<String> list = new ArrayList();

      for(String string : a) {
         list.add(string);
      }

      map_list.put("list", list);
      map_list.put("title", map.get("fieldtitle"));
      return map_list;
   }

   @RequestMapping({"/source_isnull"})
   @ResponseBody
   public boolean source_isnull(String taskid, String tableNamePattern) {
      boolean isnull = true;
      boolean sourceisnull = true;
      boolean targetisnull = true;
      Desensitizationsource desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
      Desensitizationtarget desensitizationtarget = this.encryptionMaskingService.queryTargetInfo(taskid);
      if (desensitizationsource != null && desensitizationsource.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         if (tCoreDatasystemSource == null) {
            sourceisnull = false;
            if (desensitizationsource.getExecution_type().equals("oracledmp")) {
               sourceisnull = true;
            }
         } else {
            sourceisnull = this.testConnect(tCoreDatasystemSource);
         }
      }

      if (desensitizationtarget != null && desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
         TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         if (tCoreDatasystemTarget == null) {
            targetisnull = false;
            if (desensitizationtarget.getExecution_type().equals("oracledmp")) {
               targetisnull = true;
            }
         } else {
            targetisnull = this.testConnect(tCoreDatasystemTarget);
         }
      }

      if (sourceisnull && targetisnull) {
         isnull = true;
      } else {
         isnull = false;
      }

      return isnull;
   }

   @RequestMapping({"/isrepeatname"})
   @ResponseBody
   public boolean isrepeatname(String taskname) {
      if (taskname != null && !"".equals(taskname)) {
         String projectid = (String)this.request.getSession().getAttribute("projectid");
         EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskByName(taskname, projectid);
         return encryptionmasking == null;
      } else {
         return true;
      }
   }

   @RequestMapping({"/saveparamvalue"})
   @ResponseBody
   public void saveparamvalue(String paramvalue, String tasknamereal, String tableprefix, String tablesuffix, String version) {
      this.redisService.set(tasknamereal + "_" + "tableprefix", tableprefix == null ? "" : tableprefix);
      this.redisService.set(tasknamereal + "_" + "tablesuffix", tablesuffix == null ? "" : tablesuffix);
      this.redisService.set(tasknamereal + "_" + BatchManage.class.getSimpleName(), paramvalue);
      this.redisService.set(tasknamereal + "_" + "version", version);
   }

   public boolean testConnect(TCoreDatasystem datasource) {
      boolean isnull = true;
      String url = "";
      if ("LOCALFILE".equals(datasource.getDbtype())) {
         return true;
      } else if ("SFTP".equals(datasource.getDbtype())) {
         SFTPUtil sftp = new SFTPUtil(datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.valueOf(datasource.getDbport()));
         ResultVO resultvo = SFTPUtil.login();
         boolean b = resultvo.getResult();
         sftp.logout();
         return b;
      } else if ("FTP".equals(datasource.getDbtype())) {
         ResultVO resultvo = FtpTool.ftpConnect(datasource.getDbip(), Integer.valueOf(datasource.getDbport()), datasource.getUsername(), datasource.getPassword());
         boolean b = resultvo.getResult();
         return b;
      } else {
         String driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
         switch (datasource.getDbtype()) {
            case "INFORMIX":
               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername(), datasource.getServername());
               break;
            case "AS400":
               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbservername(), datasource.getServername());
               break;
            default:
               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
         }

         if ("HIVE".equals(datasource.getDbtype()) && "on".equals(datasource.getIskerberos())) {
            System.setProperty("java.security.krb5.conf", datasource.getXmlpath() + "/krb5.conf");
            Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasource.getPrincipal(), driver, datasource.getLoginprincipal(), datasource.getXmlpath());
            if (conn != null) {
               try {
                  conn.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }

               return true;
            } else {
               return false;
            }
         } else {
            ResultVO resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), "1".equals(datasource.getFlag()) ? AesTool.decrypt(datasource.getPassword(), "ghca") : datasource.getPassword());
            isnull = resultvo.getResult();
            return isnull;
         }
      }
   }

   public String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   @RequestMapping({"/querydatasystem"})
   @ResponseBody
   public List<TCoreDatasystem> querydatasystem(String istargetdb, String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      String flag = "";
      if (type != null && !"".equals(type)) {
         flag = type;
      } else {
         flag = "1";
      }

      new ArrayList();
      List<TCoreDatasystem> list = this.dataSystemService.queryDataSystemEM(flag, istargetdb);
      return list;
   }

   @RequestMapping({"/querymonitorinfo"})
   @ResponseBody
   public List<DesensitizationMonitorInfo> querymonitorinfo(String taskid, HttpServletRequest request) {
      return this.encryptionMaskingService.queryMonitorInfo(taskid);
   }

   @RequestMapping({"/isFilePathExist"})
   @ResponseBody
   public boolean isFilePathExist(String filepath) {
      boolean rebln = true;
      File file = new File(filepath);
      if (file.exists()) {
         rebln = true;
      } else {
         rebln = false;
      }

      return rebln;
   }

   @RequestMapping({"/isFilePath"})
   @ResponseBody
   public boolean isFilePath(String mutifile, String filepath, String dmptype) {
      try {
         List<String> list2 = this.dataSystemService.getAllTableNameLists(mutifile, filepath, dmptype);
         return list2.size() != 0;
      } catch (Exception var5) {
         return false;
      }
   }

   @RequestMapping({"/isMultiFileDir"})
   @ResponseBody
   public boolean isMultiFileDir(String filepath) {
      boolean directory = true;
      File subFiles = new File(filepath);
      if (subFiles.isDirectory()) {
         directory = true;
      } else {
         directory = false;
      }

      return directory;
   }

   @RequestMapping({"/querydmpfilename"})
   @ResponseBody
   public List<Map<String, String>> querydmpfilename(String fileName, String filepath, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> listre = new ArrayList();
      File subFiles = new File(filepath);
      if (subFiles.isDirectory()) {
         String[] strSubfiles = subFiles.list();
         strSubfiles = StringTool.arraySort(strSubfiles);
         if (fileName != null && fileName != "") {
            for(String string : strSubfiles) {
               if (string.toUpperCase().endsWith(".DMP")) {
                  int i = string.toUpperCase().lastIndexOf(fileName.toUpperCase());
                  if (i >= 0) {
                     Map<String, String> map = new HashMap();
                     map.put("filename", string);
                     listre.add(map);
                  }
               }
            }
         } else {
            for(String string : strSubfiles) {
               if (string.toUpperCase().endsWith(".DMP")) {
                  Map<String, String> map = new HashMap();
                  map.put("filename", string);
                  listre.add(map);
               }
            }
         }
      }

      return listre;
   }

   @RequestMapping({"/querytaskbyid"})
   @ResponseBody
   public DataGridVO<EncryptionMasking> queryTaskById(PageInfo pageInfo, String taskid, HttpServletRequest request) {
      EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
      List<EncryptionMasking> list = new ArrayList();
      list.add(encryptionmasking);
      DataGridVO<EncryptionMasking> vo = new DataGridVO<EncryptionMasking>();
      vo.setRows(list);
      return vo;
   }

   @RequestMapping({"/querytaskbyid1"})
   @ResponseBody
   public EncryptionMasking queryTaskById1(String taskid, HttpServletRequest request) {
      return this.encryptionMaskingService.queryTaskById(taskid);
   }

   @RequestMapping({"/querytaskall"})
   @ResponseBody
   public List<EncryptionMasking> queryTask(HttpServletRequest request) {
      return this.encryptionMaskingService.queryTaskAll();
   }

   @ResponseBody
   @RequestMapping({"/queryversion"})
   public List<ComboboxVO> queryversion(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      File projectfile = new File(props.getProperty("ProjectVersion"));
      File allfile = new File(props.getProperty("AllVersion"));
      if (taskfile.listFiles() != null && taskfile.listFiles().length > 0) {
         ComboboxVO taskbox = new ComboboxVO();
         taskbox.setText("任务版本");
         list.add(taskbox);
      }

      if (projectfile.listFiles() != null && projectfile.listFiles().length > 0) {
         ComboboxVO probox = new ComboboxVO();
         probox.setText("项目版本");
         list.add(probox);
      }

      if (allfile.listFiles() != null && allfile.listFiles().length > 0) {
         ComboboxVO allbox = new ComboboxVO();
         allbox.setText("全局版本");
         list.add(allbox);
      }

      ComboboxVO allbox = new ComboboxVO();
      allbox.setText("无版本");
      list.add(allbox);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryProVersion"})
   public List<ComboboxVO> queryProVersion(HttpServletRequest request, HttpServletResponse response, Model model) {
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File projectfile = new File(props.getProperty("ProjectVersion"));
      StringBuffer str = new StringBuffer();
      File[] f = projectfile.listFiles();

      for(int i = 0; i < f.length; ++i) {
         str.append("'" + f[i].getName() + "'" + ',');
      }

      List<ComboboxVO> list = this.tdataProjectService.queryProjectList(str.substring(0, str.length() - 1));
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryTask"})
   public List<ComboboxVO> queryTask(String projectid, HttpServletRequest request, HttpServletResponse response, Model model) {
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      StringBuffer str = new StringBuffer();
      File[] f = taskfile.listFiles();

      for(int i = 0; i < f.length; ++i) {
         str.append("'" + f[i].getName() + "'" + ',');
      }

      List<ComboboxVO> list = this.tdataProjectService.queryTaskList(str.substring(0, str.length() - 1), projectid);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersion"})
   public List<HashMap<String, String>> queryTaskVersion(HttpServletRequest request, HttpServletResponse response, Model model, String taskid) {
      List<HashMap<String, String>> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion") + taskid);
      File[] f = taskfile.listFiles();

      for(int i = 0; i < f.length; ++i) {
         HashMap<String, String> map = new HashMap();
         map.put("value", f[i].getName());
         String text = f[i].getName().split("\\_")[0];
         String sd = this.TimeStamp2Date(text, (String)null);
         map.put("text", sd);
         list.add(map);
      }

      return list;
   }

   public String TimeStamp2Date(String timestampString, String formats) {
      if (TextUtils.isEmpty(formats)) {
         formats = "yyyy-MM-dd HH:mm:ss";
      }

      Long timestamp = Long.parseLong(timestampString) * 1000L;
      String date = (new SimpleDateFormat(formats, Locale.CHINA)).format(new Date(timestamp));
      return date;
   }

   @ResponseBody
   @RequestMapping({"/queryLogByTaskId"})
   public String queryLogByTaskId(String tasknamereal, HttpServletRequest request, HttpServletResponse response, Model model, String taskid) {
      List<TConsoleLog> tConsoleLog = this.operationService.getTConsoleLogBylogno(tasknamereal);
      StringBuffer errlog = new StringBuffer("暂无信息");
      if (tConsoleLog != null) {
         errlog.setLength(0);

         for(TConsoleLog tConsoleLog2 : tConsoleLog) {
            errlog.append(tConsoleLog2.getNote());
         }
      }

      return errlog.toString();
   }

   @RequestMapping({"/compare"})
   public String compare(String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) throws SQLException {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      return "core/encryptionmasking/encryptionmasking_resultcompare";
   }

   @ResponseBody
   @RequestMapping({"/compareMaskingResult"})
   public Map<String, Object> compareMaskingResult(String tablename, String taskid, String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Map<String, Object> map = new HashMap();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      EncryptionMasking encryptionmasking = new EncryptionMasking();
      EncryptionMasking encryptionmasking_replace = new EncryptionMasking();
      encryptionmasking = (EncryptionMasking)this.redisService.get(tasknamereal + "_" + encryptionmasking.getClass().getSimpleName());
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (!"1".equals(type) && !"2".equals(type)) {
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            encryptionmasking_replace.setBatchnumber(batchmanage);
         }

         if (tableprefix != null && !"".equals(tableprefix)) {
            encryptionmasking_replace.setTableprefix(tableprefix);
         } else {
            encryptionmasking_replace.setTableprefix("无");
         }

         if (tablesuffix != null && !"".equals(tablesuffix)) {
            encryptionmasking_replace.setTablesuffix(tablesuffix);
         } else {
            encryptionmasking_replace.setTablesuffix("无");
         }
      } else {
         encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
         desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         desensitizationtarget = this.encryptionMaskingService.queryTargetById(taskid);
         encryptionmasking_replace.setBatchnumber(encryptionmasking.getBatchnumber());
         encryptionmasking_replace.setTableprefix(!"".equals(encryptionmasking.getTableprefix()) && encryptionmasking.getTableprefix() != null ? encryptionmasking.getTableprefix() : "无");
         encryptionmasking_replace.setTablesuffix(!"".equals(encryptionmasking.getTablesuffix()) && encryptionmasking.getTablesuffix() != null ? encryptionmasking.getTablesuffix() : "无");
         if ("2".equals(type)) {
            String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            if (batchmanage != null) {
               encryptionmasking_replace.setBatchnumber(batchmanage);
            }

            if (tableprefix != null && !"".equals(tableprefix)) {
               encryptionmasking_replace.setTableprefix(tableprefix);
            } else {
               encryptionmasking_replace.setTableprefix("无");
            }

            if (tablesuffix != null && !"".equals(tablesuffix)) {
               encryptionmasking_replace.setTablesuffix(tablesuffix);
            } else {
               encryptionmasking_replace.setTablesuffix("无");
            }
         }
      }

      encryptionmasking_replace.setTaskname(encryptionmasking.getTaskname());
      encryptionmasking_replace.setFoldername(encryptionmasking.getFoldername());
      encryptionmasking_replace.setFastexecution(encryptionmasking.getFastexecution());
      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         desensitizationsource.setDataschema("");
         desensitizationtarget.setInserttype("");
      }

      map.put("encryptionmasking", encryptionmasking_replace);
      map.put("desensitizationsource", desensitizationsource);
      map.put("desensitizationtarget", desensitizationtarget);
      TCoreDatasystem tCoreDatasystem_source = null;
      TCoreDatasystem tCoreDatasystem_target = null;
      if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
         tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         map.put("tCoreDatasystem_source", tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
         tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      }

      if (!"".equals(desensitizationsource.getDatasourceid()) && desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid()) && desensitizationtarget.getDatasourceid() != null && !tCoreDatasystem_source.getDbtype().equals(tCoreDatasystem_target.getDbtype())) {
         map.put("isSameDb", "1");
      } else {
         map.put("isSameDb", "0");
      }

      if ("".equals(desensitizationsource.getDatasourceid()) || desensitizationsource.getDatasourceid() == null || "".equals(desensitizationtarget.getDatasourceid()) || desensitizationtarget.getDatasourceid() == null) {
         map.put("isSameDb", "0");
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      map.put("sourcetype", sourcetype);
      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else {
            targettype = "0";
         }
      }

      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         String dmpImportFlg = desensitizationtarget.getDmpimport();
         if ("1".equals(dmpImportFlg)) {
            tCoreDatasystem_target = new TCoreDatasystem();
            tCoreDatasystem_target.setSysname("DMP系统");
            desensitizationtarget.setDataschema("无");
            map.put("tCoreDatasystem_target", tCoreDatasystem_target);
            targettype = "0";
         }
      }

      map.put("targettype", targettype);
      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         } else {
            desensitizationfile = this.encryptionMaskingService.queryDesensitizationfileBytaskid(taskid);
         }

         map.put("desensitizationfile", desensitizationfile);
      }

      new ArrayList();
      List<Map<String, String>> var39;
      if ("1".equals(type)) {
         if (!"".equals(tablename) && tablename != null) {
            var39 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.encryptionMaskingService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               if (desensitizationTable.getTablename().toUpperCase().contains(tablename.toUpperCase())) {
                  ((List)var39).add(desensitizationTablemap);
               }
            }
         } else {
            var39 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.encryptionMaskingService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               ((List)var39).add(desensitizationTablemap);
            }
         }
      } else {
         var39 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if (var39 != null) {
            var39 = (List)(var39).stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
         }
      }

      map.put("tCoreMaskingTaskTableList", var39);
      return map;
   }

   @RequestMapping({"/queryMaskingDataCompare"})
   @ResponseBody
   public List<CompareInfoVO> queryMaskingDataCompare(String taskid, String type, int curPage, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<CompareInfoVO> compareDataList = null;
      if (tablename != null && !"".equals(tablename)) {
         if (curPage > 10) {
            curPage = 10;
         }

         Integer total = 10;
         new HashMap();
         List sourceValueList = new ArrayList();
         List targetValueList = new ArrayList();
         List couumnname = new ArrayList();
         List regex = new ArrayList();
         new ArrayList();
         Desensitizationsource desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.encryptionMaskingService.queryTargetInfo(taskid);
         String schemasource = desensitizationsource.getDataschema();
         String schematarget = desensitizationtarget.getDataschema();
         this.queryConnInfo(taskid, type, tablename, request, response, model);
         String structureid = "";
         List<ColumnInfoVO> columnInfo = this.querymultitable(structureid, taskid, type, tablename, request);
         int cnt = 0;

         for(int i = 0; i < columnInfo.size(); ++i) {
            couumnname.add(((ColumnInfoVO)columnInfo.get(i)).getColumnname());
            regex.add(((ColumnInfoVO)columnInfo.get(i)).getRegextype() != null && !"".equals(((ColumnInfoVO)columnInfo.get(i)).getRegextype()) ? ((ColumnInfoVO)columnInfo.get(i)).getRegextype() : "无");
         }

         String datacomparedir = null;

         try {
            datacomparedir = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("datacomparedir");
         } catch (IOException e1) {
            e1.printStackTrace();
         }

         String tasknamereal = this.encryptionMaskingService.getTasknamereal(taskid);
         String soupath = datacomparedir + tasknamereal + "/source/";
         String tarpath = datacomparedir + tasknamereal + "/target/";
         File soufile = new File(soupath + tablename + ".txt");
         File tarfile = new File(tarpath + tablename + ".txt");
         if (soufile.isFile() && soufile.exists()) {
            BufferedReader br = null;

            try {
               InputStreamReader isr = new InputStreamReader(new FileInputStream(soufile), "UTF-8");
               br = new BufferedReader(isr);
               String lineTxt = null;
               cnt = 0;

               while((lineTxt = br.readLine()) != null) {
                  ++cnt;
                  String[] sourcedata = lineTxt.split("~!~");
                  if (cnt == curPage) {
                     for(int j = 0; j < sourcedata.length; ++j) {
                        String onesourcedata = sourcedata[j];
                        sourceValueList.add(onesourcedata);
                     }
                     break;
                  }
               }

               br.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            System.out.println("文件不存在!");
         }

         if (tarfile.isFile() && tarfile.exists()) {
            BufferedReader br = null;

            try {
               InputStreamReader isr = new InputStreamReader(new FileInputStream(tarfile), "UTF-8");
               br = new BufferedReader(isr);
               String lineTxt = null;
               cnt = 0;

               while((lineTxt = br.readLine()) != null) {
                  ++cnt;
                  if (cnt == curPage) {
                     String[] targetdata = lineTxt.split("~!~");

                     for(int j = 0; j < targetdata.length; ++j) {
                        String onetargetdata = targetdata[j];
                        targetValueList.add(onetargetdata);
                     }
                  }
               }

               if (cnt < total) {
                  total = cnt;
               }

               br.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            System.out.println("文件不存在!");
         }

         CompareInfoVO compareInfoVO = null;
         if (cnt == 0) {
            compareDataList = new ArrayList();
         } else {
            compareDataList = new ArrayList();

            for(int i = 0; i < couumnname.size(); ++i) {
               compareInfoVO = new CompareInfoVO();
               compareInfoVO.setColumnname(couumnname.get(i));
               compareInfoVO.setMaskingrulename(regex.get(i));
               compareInfoVO.setSourcedata(sourceValueList.get(i));
               compareInfoVO.setTargetdata(targetValueList.get(i));
               compareInfoVO.setTotal((long)total);
               compareDataList.add(compareInfoVO);
            }
         }

         return compareDataList;
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/queryConnInfo"})
   public List<TCoreDatasystem> queryConnInfo(String taskid, String type, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> connInfo = new ArrayList();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      EncryptionMasking encryptionmasking = new EncryptionMasking();
      EncryptionMasking encryptionmasking_replace = new EncryptionMasking();
      encryptionmasking = (EncryptionMasking)this.redisService.get(tasknamereal + "_" + encryptionmasking.getClass().getSimpleName());
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (!"1".equals(type) && !"2".equals(type)) {
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            encryptionmasking_replace.setBatchnumber(batchmanage);
         }

         if (tableprefix != null && !"".equals(tableprefix)) {
            encryptionmasking_replace.setTableprefix(tableprefix);
         } else {
            encryptionmasking_replace.setTableprefix("无");
         }

         if (tablesuffix != null && !"".equals(tablesuffix)) {
            encryptionmasking_replace.setTablesuffix(tablesuffix);
         } else {
            encryptionmasking_replace.setTablesuffix("无");
         }
      } else {
         encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
         desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         desensitizationtarget = this.encryptionMaskingService.queryTargetById(taskid);
         encryptionmasking_replace.setBatchnumber(encryptionmasking.getBatchnumber());
         encryptionmasking_replace.setTableprefix(!"".equals(encryptionmasking.getTableprefix()) && encryptionmasking.getTableprefix() != null ? encryptionmasking.getTableprefix() : "无");
         encryptionmasking_replace.setTablesuffix(!"".equals(encryptionmasking.getTablesuffix()) && encryptionmasking.getTablesuffix() != null ? encryptionmasking.getTablesuffix() : "无");
         if ("2".equals(type)) {
            String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            if (batchmanage != null) {
               encryptionmasking_replace.setBatchnumber(batchmanage);
            }

            if (tableprefix != null && !"".equals(tableprefix)) {
               encryptionmasking_replace.setTableprefix(tableprefix);
            } else {
               encryptionmasking_replace.setTableprefix("无");
            }

            if (tablesuffix != null && !"".equals(tablesuffix)) {
               encryptionmasking_replace.setTablesuffix(tablesuffix);
            } else {
               encryptionmasking_replace.setTablesuffix("无");
            }
         }
      }

      encryptionmasking_replace.setTaskname(encryptionmasking.getTaskname());
      encryptionmasking_replace.setFoldername(encryptionmasking.getFoldername());
      encryptionmasking_replace.setFastexecution(encryptionmasking.getFastexecution());
      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         desensitizationsource.setDataschema("");
         desensitizationtarget.setInserttype("");
      }

      TCoreDatasystem tCoreDatasystem_source = null;
      TCoreDatasystem tCoreDatasystem_target = null;
      if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
         tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         connInfo.add(tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
         tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         connInfo.add(tCoreDatasystem_target);
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else {
            targettype = "0";
         }
      }

      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         String dmpImportFlg = desensitizationtarget.getDmpimport();
         if ("1".equals(dmpImportFlg)) {
            tCoreDatasystem_target = new TCoreDatasystem();
            tCoreDatasystem_target.setSysname("DMP系统");
            desensitizationtarget.setDataschema("无");
            targettype = "0";
         }
      }

      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         } else {
            this.encryptionMaskingService.queryDesensitizationfileBytaskid(taskid);
         }
      }

      new ArrayList();
      if ("1".equals(type)) {
         if (!"".equals(tablename) && tablename != null) {
            List<Map<String, String>> var45 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.encryptionMaskingService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               if (desensitizationTable.getTablename().toUpperCase().contains(tablename.toUpperCase())) {
                  var45.add(desensitizationTablemap);
               }
            }
         } else {
            List<Map<String, String>> var44 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.encryptionMaskingService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               var44.add(desensitizationTablemap);
            }
         }
      } else {
         List<Map<String, String>> var46 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if (var46 != null) {
            var46 = (List)var46.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
         }
      }

      return connInfo;
   }

   @RequestMapping({"/querymasktable"})
   @ResponseBody
   public List<ColumnInfoVO> querymasktable(String taskid, String type, String table, HttpServletRequest request) {
      if (table != null && !"".equals(table)) {
         String dmpschema = "";
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         List<ColumnInfoVO> queryColumnInfo = new ArrayList();
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         } else {
            desensitizationsource = this.encryptionMaskingService.querySourceInfo(taskid);
         }

         new ArrayList();
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + table);
         HashMap<String, String> map = new HashMap();
         if ("1".equals(type)) {
            for(DesensitizationTablecolumn desensitizationTablecolumn : this.encryptionMaskingService.queryColumInfo(taskid, table)) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
               columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
               columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
               columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
               columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRulename()) ? "无" : desensitizationTablecolumn.getRulename());
               queryColumnInfo.add(columnInfo);
            }
         } else {
            if (tCoreMaskingTaskTableInfoList != null) {
               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
                  map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
               }
            } else if (!"1".equals(desensitizationsource.getIsdmpfile())) {
               queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
               if (this.redisService.exists(table + "+" + desensitizationsource.getDataschema())) {
                  new ArrayList();
                  List<TCoreFieldSensitiveMemory> var26 = (List)this.redisService.get(table + "+" + desensitizationsource.getDataschema());
                  if (var26 != null) {
                     for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : var26) {
                        map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory.getRuie());
                     }
                  }
               }
            } else {
               if ("0".equals(desensitizationsource.getMultiDempFile())) {
                  if ("0".equals(desensitizationsource.getDmptype())) {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmpdp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  } else {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "Dmp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  }

                  String dmpFilePath = desensitizationsource.getSourcefiledir();
                  String dmpFileName = dmpFilePath.substring(dmpFilePath.lastIndexOf("/") + 1);
                  dmpschema = dmpFileName.substring(0, dmpFileName.lastIndexOf("."));
               } else {
                  List<String> sourcefilelist = new ArrayList();
                  String filelist = desensitizationsource.getFilelist();
                  String[] sourcefiledirlist = filelist.split(",");

                  for(String string : sourcefiledirlist) {
                     sourcefilelist.add(string);
                     String dmpFileName = string.substring(string.lastIndexOf("/") + 1);
                     dmpschema = dmpFileName.substring(0, dmpFileName.lastIndexOf("."));
                  }

                  if ("0".equals(desensitizationsource.getDmptype())) {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmpdp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  } else {
                     List<ColumnInfoVO> reColumnInfoList = null;
                     Map<String, Object> tableInfoMap = (Map)this.redisService.get(tasknamereal + "_" + "multiDmp_tableInfoMap_masking");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     Map<String, List<ColumnInfoVO>> columnameVoListMap = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        if (table.equals(tableStructureInfo.getTablename())) {
                           reColumnInfoList = tableStructureInfo.getColInfoLst();
                        }

                        columnameVoListMap.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     queryColumnInfo = reColumnInfoList;
                  }
               }

               if (this.redisService.exists(table + "+" + dmpschema)) {
                  new ArrayList();
                  List<TCoreFieldSensitiveMemory> var25 = (List)this.redisService.get(table + "+" + dmpschema);
                  if (var25 != null) {
                     for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : var25) {
                        map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory.getRuie());
                     }
                  }
               }
            }

            if (tCoreMaskingTaskTableInfoList != null) {
               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
                  ColumnInfoVO columnInfo = new ColumnInfoVO();
                  columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
                  columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
                  columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
                  columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
                  queryColumnInfo.add(columnInfo);
               }
            }

            for(ColumnInfoVO columnInfo : queryColumnInfo) {
               columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");
            }
         }

         return queryColumnInfo;
      } else {
         return null;
      }
   }

   @RequestMapping({"/checkdmp"})
   @ResponseBody
   public Map checkdmp(String tasknamereal, HttpServletRequest request) {
      tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<Map<String, String>> tableList = new ArrayList();
      Map<String, String> checkdmp = new HashMap();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      String multiDempFile2 = desensitizationsource.getSourcefiledir();
      String multiDempFile = desensitizationsource.getMultiDempFile();

      try {
         if (!"1".equals(desensitizationsource.getIsdmpfile())) {
            checkdmp.put("flag", "success");
         } else {
            if ("0".equals(multiDempFile)) {
               for(String tablename : this.dataSystemService.getAllTableNameList(multiDempFile, desensitizationsource.getSourcefiledir(), desensitizationsource.getDmptype(), tasknamereal)) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", tablename);
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }
            } else {
               String filelist = desensitizationsource.getFilelist();
               String path = "";
               String[] mutidmpFilePath = filelist.split(",");

               for(String string : mutidmpFilePath) {
                  path = path + multiDempFile2 + "/" + string + ",";
               }

               path = path.substring(0, path.lastIndexOf(","));

               for(String tablename : this.dataSystemService.getAllTableNameList(multiDempFile, path, desensitizationsource.getDmptype(), tasknamereal)) {
                  Map<String, String> tableMap = new HashMap();
                  tableMap.put("tableName", tablename);
                  tableMap.put("status", "0");
                  tableList.add(tableMap);
               }
            }

            checkdmp.put("flag", "success");
            if (tableList.size() == 0) {
               checkdmp.put("flag", "error");
            }
         }

         request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
      } catch (Exception e) {
         e.printStackTrace();
         checkdmp.put("flag", "error");
      }

      return checkdmp;
   }

   @ResponseBody
   @RequestMapping({"/uploadImg"})
   public String uploadPicture(@RequestParam(value = "file",required = false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
      new HashMap();
      File targetFile = null;
      String url = "";
      String fileName = file.getOriginalFilename();
      if (fileName != null && fileName != "") {
         String returnUrl = "/data/infa_work_report/image_masking_source";
         String fileF = fileName.substring(fileName.lastIndexOf("."), fileName.length());
         fileName = (new Date()).getTime() + "_" + (new Random()).nextInt(1000) + fileF;
         File file1 = new File(returnUrl);
         if (!file1.exists() && !file1.isDirectory()) {
            file1.mkdir();
         }

         targetFile = new File(file1, fileName);

         try {
            file.transferTo(targetFile);
            url = fileName;
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return url;
   }

   @ResponseBody
   @RequestMapping({"/readimg"})
   public void readimg(@RequestParam("path") String fileName, @RequestParam("flag") String flag, HttpServletRequest request, HttpServletResponse response) {
      String path = "";
      if ("0".equals(flag)) {
         path = "/data/infa_work_report/image_masking_source/" + fileName;
      } else {
         path = "/data/infa_work_report/image_masking_target/" + fileName;
      }

      File filePic = new File(path);
      if (filePic.exists()) {
         try {
            FileInputStream is = new FileInputStream(filePic);
            int i = is.available();
            byte[] data = new byte[i];
            is.read(data);
            is.close();
            response.setContentType("image/*");
            OutputStream toClient = response.getOutputStream();
            toClient.write(data);
            is.close();
            toClient.close();
            toClient.flush();
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   @ResponseBody
   @RequestMapping({"/mosaic"})
   public String mosaic(@RequestParam("path") String fileName, @RequestParam("ip") String ip, @RequestParam("logincount") int logincount, @RequestParam("maskingcontentflag") String maskingcontentflag, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_source/" + fileName;
      TCoreMaskingImgInfo tCoreMaskingImgInfo = null;
      if (!"0:0:0:0:0:0:0:1".equals(ip) && !"127.0.0.1".equals(ip)) {
         if (logincount == 0) {
            tCoreMaskingImgInfo = new TCoreMaskingImgInfo();
            tCoreMaskingImgInfo.setIp(ip);
            tCoreMaskingImgInfo.setLogincount(1);
            tCoreMaskingImgInfo.setCreatedate(new Date());
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         } else {
            tCoreMaskingImgInfo = this.tCoreMaskingImgInfoService.querynumByip(ip);
            tCoreMaskingImgInfo.setLogincount(logincount);
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         }

         this.tCoreMaskingImgInfoService.saveOrUpdate(tCoreMaskingImgInfo);
      }

      if ("1".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " " + fileName + "  mask";
         CommandTool.commandRtn(commandlf);
      } else if ("2".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  mask";
         CommandTool.commandRtn(commandlf);
      } else if (maskingcontentflag.indexOf("1") != -1 && maskingcontentflag.indexOf("2") != -1) {
         String commandlf1 = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " 1_" + fileName + "  mask";
         CommandTool.commandRtn(commandlf1);
         path = "/data/infa_work_report/image_masking_target/1_" + fileName;
         String commandlf2 = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  mask";
         CommandTool.commandRtn(commandlf2);

         try {
            File filePic = new File(path);
            if (filePic.exists()) {
               filePic.delete();
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return "success";
   }

   @ResponseBody
   @RequestMapping({"/coverblack"})
   public String coverblack(@RequestParam("path") String fileName, @RequestParam("ip") String ip, @RequestParam("logincount") int logincount, @RequestParam("maskingcontentflag") String maskingcontentflag, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_source/" + fileName;
      TCoreMaskingImgInfo tCoreMaskingImgInfo = null;
      if (!"0:0:0:0:0:0:0:1".equals(ip) && !"127.0.0.1".equals(ip)) {
         if (logincount == 0) {
            tCoreMaskingImgInfo = new TCoreMaskingImgInfo();
            tCoreMaskingImgInfo.setIp(ip);
            tCoreMaskingImgInfo.setLogincount(1);
            tCoreMaskingImgInfo.setCreatedate(new Date());
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         } else {
            tCoreMaskingImgInfo = this.tCoreMaskingImgInfoService.querynumByip(ip);
            tCoreMaskingImgInfo.setLogincount(logincount);
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         }

         this.tCoreMaskingImgInfoService.saveOrUpdate(tCoreMaskingImgInfo);
      }

      if ("1".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " " + fileName + "  black";
         CommandTool.commandRtn(commandlf);
      } else if ("2".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  black";
         CommandTool.commandRtn(commandlf);
      } else if (maskingcontentflag.indexOf("1") != -1 && maskingcontentflag.indexOf("2") != -1) {
         String commandlf1 = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " 2_" + fileName + "  black";
         CommandTool.commandRtn(commandlf1);
         path = "/data/infa_work_report/image_masking_target/2_" + fileName;
         String commandlf2 = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  black";
         CommandTool.commandRtn(commandlf2);

         try {
            File filePic = new File(path);
            if (filePic.exists()) {
               filePic.delete();
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return "success";
   }

   @ResponseBody
   @RequestMapping({"/maskingfileexist"})
   public String maskingfileexist(@RequestParam("path") String fileName, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_target/" + fileName;

      try {
         File filePic = new File(path);
         return filePic.exists() ? "1" : "0";
      } catch (Exception var6) {
         return "0";
      }
   }

   @ResponseBody
   @RequestMapping({"/checkipnum"})
   public int checkipnum(String ip, HttpServletRequest request, HttpServletResponse response) {
      TCoreMaskingImgInfo querynumByip = this.tCoreMaskingImgInfoService.querynumByip(ip);
      if (querynumByip == null) {
         return 0;
      } else {
         int logincount = querynumByip.getLogincount();
         return logincount;
      }
   }

   @ResponseBody
   @RequestMapping({"/delimg"})
   public String delimg(@RequestParam("path") String fileName, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_target/" + fileName;

      try {
         File filePic = new File(path);
         if (filePic.exists()) {
            filePic.delete();
         }

         return "success";
      } catch (Exception var6) {
         return "fail";
      }
   }

   @ResponseBody
   @RequestMapping({"/taskCallBack"})
   public void taskCallBack(HttpServletRequest request, HttpServletResponse response) {
      StringBuilder result = new StringBuilder();

      try {
         BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
         String jsonStr = null;

         while((jsonStr = reader.readLine()) != null) {
            result.append(jsonStr);
         }

         reader.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

      JSONObject param = JSONObject.parseObject(result.toString());
      this.encryptionMaskingService.callBackAll(param);
   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }

   @ResponseBody
   @RequestMapping({"/selectData"})
   public void selectData(String taskid, String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> list = new ArrayList();

      try {
         new Desensitizationsource();
         Desensitizationsource e = this.encryptionMaskingService.querySourceInfo(taskid);
         String systemid = e.getDatasourceid();
         Connection con = this.dataSystemService.getConnectionByDataSystemId(systemid);
         TCoreDatasystem sourceCoreDatasystem = this.dataSystemService.queryDataSystemById(systemid);
         PipeTool p = new PipeTool(con, "", "", "", "");
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e1) {
            e1.printStackTrace();
         }

         String hdfs_path = props.getProperty("hdfs_path");
         EncryptionMasking encryptionmasking = this.encryptionMaskingService.queryTaskById(taskid);
         Process process = null;
         int port = SocketTool.getPort();
         process = SocketTool.start(process, port, taskid);

         try {
            IHiveRMI iRmi = (IHiveRMI)Naming.lookup("rmi://127.0.0.1:" + port + "/My_RMI");
            String xmlPath = sourceCoreDatasystem.getXmlpath();
            String user = sourceCoreDatasystem.getLoginprincipal();
            user = "hive";
            String pathStr = hdfs_path + "/tmp/ghca/" + encryptionmasking.getTasknamereal() + "/";
            iRmi.addHdfs(xmlPath, user, pathStr);
         } catch (NotBoundException e1) {
            e1.printStackTrace();
         }

         process.destroy();
         String dataschema = e.getDataschema();
         if ("1".equals(type)) {
            for(DesensitizationTable desensitizationTable : this.encryptionMaskingService.queryTableList(taskid)) {
               String tableName = desensitizationTable.getTablename();
               this.queryColumnInfo(e.getDatasourceid(), e.getDataschema(), tableName);
               StringBuffer sb = new StringBuffer("insert overwrite directory '/tmp/ghca/" + encryptionmasking.getTasknamereal() + "/" + tableName + "'  row format delimited FIELDS TERMINATED BY ',' COLLECTION ITEMS TERMINATED BY ',' MAP KEYS TERMINATED BY ':'   ");
               sb.append("select * ");
               sb.append(" from " + dataschema + "." + tableName);
               System.out.println(sb.toString());
               list.add(sb.toString());
            }

            p.selectDataList(list);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/selectSecretkey"})
   public List<TCoreSecretkey> selectSecretkey(HttpServletRequest request, HttpServletResponse response) {
      List<TCoreSecretkey> tCoreSecretkeylist = this.encryptionMaskingService.selectSecretkey();
      return tCoreSecretkeylist;
   }
}
