package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubset;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsetcolumns;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsettask;
import com.chenyang.nse.bussiness.service.core.SubsetService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/subdatamanager"})
public class SubsetDataManagerController {
   private static Logger logger = LoggerFactory.getLogger(SubsetDataManagerController.class);
   @Autowired
   private SubsetService subsetService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/subsetdatamanager/subdatamanager";
   }

   @ResponseBody
   @RequestMapping({"/queryAllSubset"})
   public List<TCoreSubset> queryAllSubset(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.subsetService.queryAllSubset();
   }

   @ResponseBody
   @RequestMapping({"/delete"})
   public boolean delete(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.subsetService.delete(id);
      return true;
   }

   @ResponseBody
   @RequestMapping({"/modify"})
   public boolean modify(TCoreSubset subset, HttpServletRequest request, HttpServletResponse response, Model model) {
      request.getSession().setAttribute("lastSelectSubsetName", subset.getTname());
      return true;
   }

   @ResponseBody
   @RequestMapping({"/add"})
   public boolean add(HttpServletRequest request, HttpServletResponse response, Model model) {
      request.getSession().setAttribute("lastSelectSubsetName", null);
      return true;
   }

   @ResponseBody
   @RequestMapping({"/querySubsetColumns"})
   public List<TCoreSubsetcolumns> querySubsetColumns(String subsetid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreSubsetcolumns> list = this.subsetService.querySubsetColumns(subsetid);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryTaskBySubsetId"})
   public List<TCoreSubsettask> queryTaskBySubsetId(String subsetId, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.subsetService.queryTaskBySubsetId(subsetId);
   }

   @RequestMapping({"/setModifiedSubsetId"})
   public void setModifiedSubsetId(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      request.getSession().setAttribute("modifiedSubsetId", id);
   }
}
