package com.chenyang.nse.bussiness.controller.core.dataproject;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.batchmanage.BatchManage;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.subset.NewsubsetService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@EnableAsync
@Controller
@RequestMapping({"/core/datasubsettask"})
public class TdataSubsetTaskController {
   private static Logger logger = LoggerFactory.getLogger(TdataSubsetTaskController.class);
   private static final String Link_character = "_";
   public static final String DB_pwc_FILE_batchwrite_DB = "DBtoDB,normal,batchwrite";
   public static final String DB_batchread_FILE_pwc_DB = "DBtoDB,batchread,normal";
   public static final String DB_batchread_FILE_pwc_FILE_batchwrite_DB = "DBtoDB,batchread,batchwrite";
   public static final String DB_pwc_DB = "DBtoDB,normal,normal";
   public static final String DB_pwc_FILE = "DBtoFILE,normal";
   public static final String DB_batchread_FILE_pwc_FILE = "DBtoFILE,batchread";
   public static final String FILE_pwc_FILE_batchwrite_DB = "FILEtoDB,batchwrite";
   public static final String FILE_pwc_DB = "FILEtoDB,normal";
   public static final String FILE_pwc_FILE = "FILEtoFILE";
   public static final String HIVE_batchread_FILE_pwc_FILE_batchwrite_HIVE = "HIVEtoHIVE,batchread,batchwrite";
   public static final String INIT_STATE = "0";
   public static final String CHOOSE_STATE = "1";
   public static final String UPDATE_STATE = "2";
   public static final String CHOOSE_UPDATE_STATE = "3";
   public static final String ALL_CHOOSE = "0";
   public static final String NO_SAVE = "1";
   public static final String YES_SAVE = "2";
   public static final String NO_CHOOSE = "3";
   public static final String YES_CHOOSE = "4";
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private DesensitizationtaskService desensitizationtaskService;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private RedisService redisService;
   @Autowired
   private NewsubsetService subsetService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      return "core/dataproject/datasetsubtask/subsettask_list";
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @RequestMapping({"/desensitizationImg"})
   public String desensitizationImg(HttpServletRequest request, HttpServletResponse response, Model model) {
      String ip = request.getHeader("x-forwarded-for");
      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("Proxy-Client-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("WL-Proxy-Client-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("X-Real-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getRemoteAddr();
      }

      model.addAttribute("ip", ip);
      return "core/dataproject/desensitizationtask/desensitizationtask_img";
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<Desensitizationtask> querytask(String isstart, String engineid, String taskname, String projectid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Desensitizationtask> list = this.desensitizationtaskService.queryTask(projectid, taskname, pageInfo);
      if (isstart != null) {
         for(Desensitizationtask desensitizationtask : list) {
            String tasknamereal = desensitizationtask.getTasknamereal();
            if (!desensitizationtask.getSave_state().equals("0")) {
               if (desensitizationtask.getSave_state().equals("1")) {
                  desensitizationtask.setCount_exe("");
               } else {
                  desensitizationtask.setCount_exe("100%");
                  String removePercent = (String)this.redisService.get("removePercent_" + tasknamereal);
                  if (removePercent != null) {
                     desensitizationtask.setRemovePercent(removePercent);
                  }
               }

               this.redisService.remove(tasknamereal + "_zcount");
               this.redisService.remove(tasknamereal + "_ncount");
            } else {
               String time_exe = (String)this.redisService.get(tasknamereal + "_ntime");
               String count_exe = (String)this.redisService.get(tasknamereal + "_zcount");
               String ncount_exe = (String)this.redisService.get(tasknamereal + "_ncount");
               long ncount_exe_num = 0L;
               long count_exe_num = 1L;

               try {
                  if (ncount_exe == null) {
                     ncount_exe = "0";
                  }

                  if (count_exe == null) {
                     count_exe = "1";
                  }

                  ncount_exe_num = new Long(ncount_exe);
                  count_exe_num = new Long(count_exe);
               } catch (Exception var24) {
               }

               NumberFormat numberFormat = NumberFormat.getInstance();
               numberFormat.setMaximumFractionDigits(2);
               String result = numberFormat.format((double)ncount_exe_num / (double)count_exe_num * (double)100.0F);
               desensitizationtask.setCount_exe(result + "%");
            }

            DesensitizationMonitor moniter = this.desensitizationtaskService.getMoniterBytaskid(desensitizationtask.getId());
            if (null == moniter) {
               desensitizationtask.setExecuteStatus("0");
            } else if ("1".equals(moniter.getFlag()) && moniter.getRunstatus() == 1) {
               desensitizationtask.setExecuteStatus("1");
            } else {
               desensitizationtask.setExecuteStatus("0");
            }
         }
      }

      DataGridVO<Desensitizationtask> vo = new DataGridVO<Desensitizationtask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/getbatchmanage"})
   @ResponseBody
   public Map<String, String> getbatchmanage(String taskid, String tasknamereal, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      Map<String, String> parammap = new HashMap();
      String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
      String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
      String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
      parammap.put("batchmanage", batchmanage);
      parammap.put("tableprefix", tableprefix);
      parammap.put("tablesuffix", tablesuffix);
      return parammap;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String taskid, String step, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      map.put("tasknamereal", (String)this.request.getSession().getAttribute("tasknamereal"));
      if (step == null) {
         step = (String)this.request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         this.request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "subsettask_one":
            this.subset_one(map, model);
            break;
         case "subsettask_two":
            this.subset_two(map, model);
            break;
         case "subsettask_three":
            this.subset_three(map, model);
            break;
         case "subsettask_four":
            this.subset_four(map, model);
            break;
         case "subsettask_five":
            this.request.getSession().setAttribute("page_five", map.get("pageparam"));
      }

      return "core/dataproject/datasetsubtask/" + step;
   }

   public void subset_one(Map<String, String> map, Model model) {
      String newtask = (String)map.get("newtask");
      String way = (String)map.get("way");
      String tasknamereal = (String)map.get("tasknamereal");
      String masking_engine_type = "";

      try {
         masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
      } catch (IOException e) {
         e.printStackTrace();
      }

      model.addAttribute("maskingenginetype", masking_engine_type);
      if (newtask != null) {
         model.addAttribute("state", "checked");
      } else if ("prev".equals(way)) {
         Desensitizationtask desensitizationtask = new Desensitizationtask();
         desensitizationtask = (Desensitizationtask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
         if (desensitizationtask != null) {
            model.addAttribute("taskname", desensitizationtask.getTaskname());
            model.addAttribute("folder", desensitizationtask.getFoldername());
            model.addAttribute("tasknote", desensitizationtask.getRemark());
            model.addAttribute("isrecover", desensitizationtask.getIsrecover());
            model.addAttribute("state", desensitizationtask.getFastexecution() != null && desensitizationtask.getFastexecution().equals("1") ? "checked" : "");
         }
      }

   }

   public void subset_two(Map<String, String> map, Model model) {
      model.addAttribute("subsettaskname", map.get("subsettaskname"));
   }

   public void subset_three(Map<String, String> map, Model model) {
      model.addAttribute("subsettaskname", map.get("subsettaskname"));
      model.addAttribute("subsetname", map.get("subsetname"));
   }

   public void subset_four(Map<String, String> map, Model model) {
      model.addAttribute("subsettaskname", map.get("subsettaskname"));
      model.addAttribute("subsetname", map.get("subsetname"));
      model.addAttribute("t_dbtype", map.get("t_dbtype"));
      model.addAttribute("datasourceid", map.get("datasourceid"));
      model.addAttribute("dataschema", map.get("dataschema"));
      model.addAttribute("execution_type", map.get("execution_type"));
      model.addAttribute("isclear", map.get("isclear"));
   }

   @ResponseBody
   @RequestMapping({"/savetask"})
   public Map<String, String> savetask(HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectId = (String)request.getSession().getAttribute("projectid");
      Map<String, String> map = new HashMap();
      if (tasknamereal == null) {
         map.put("state", "1");
      } else {
         String taskid = this.desensitizationtaskService.gettaskBytasknamereal(tasknamereal, projectId);
         map.put("state", taskid);
      }

      return map;
   }

   @ResponseBody
   @RequestMapping({"/getSubsetName"})
   public List<ComboboxVO> getSubsetName() {
      List<ComboboxVO> subsetName = this.subsetService.getSubsetName();
      return subsetName;
   }

   @ResponseBody
   @RequestMapping({"/getTableNames"})
   public List<ComboboxVO> getTableNames(String subsetnameid) {
      List<ComboboxVO> tableNames = this.subsetService.getTableNames(subsetnameid);
      return tableNames;
   }

   @RequestMapping({"/inputtable"})
   public String inputmulti(String datasourceid, String dataschema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("datasourceid", datasourceid);
      model.addAttribute("dataschema", dataschema);
      model.addAttribute("tablename", tablename);
      return "core/dataproject/datasetsubtask/dbsystem";
   }
}
