package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseButton;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseButtonDao extends BaseDao<TBaseButton, String> {
   public List<String> getDistinctMenuId() {
      String sql = XmlTool.getSql("button", "getDistinctMenuid");
      return this.getSession().createNativeQuery(sql).getResultList();
   }

   public List<TBaseButton> queryButtonCRUDByRoleids(List<String> roleid) {
      String sql = "select b.* from t_base_button b,t_base_rolemenu rm where b.id = rm.menuid and roleid in :roleid";
      List<TBaseButton> buttom_list = this.getSession().createNativeQuery(sql, TBaseButton.class).setParameter("roleid", roleid).getResultList();
      return buttom_list;
   }

   public List<TBaseButton> queryButtonNotCRUDByRoleids(List<String> roleid) {
      String sql = "select * from t_base_button b left join t_base_rolemenu rm on b.id = rm.menuid and rm.roleid in :roleid where rm.id is null";
      List<TBaseButton> buttom_list = this.getSession().createNativeQuery(sql, TBaseButton.class).setParameter("roleid", roleid).getResultList();
      return buttom_list;
   }
}
