package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.vo.MenuGridVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseMenuDao extends BaseDao<TBaseMenu, String> {
   public List<TBaseMenu> qeuryMenusByRoleId(List<String> roles, List<String> menuidlist) {
      String sql = XmlTool.getSql("menu", "qeuryMenusByRoleId");
      List<TBaseMenu> menu_list = this.getSession().createNativeQuery(sql, TBaseMenu.class).setParameter("roleid", roles).getResultList();
      menu_list = (List)menu_list.stream().distinct().collect(Collectors.toList());

      for(TBaseMenu tBaseMenu : menu_list) {
         Criterion criterion = Restrictions.eq("parentid", tBaseMenu.getId());
         tBaseMenu.setSubmenu(this.queryAll(Order.asc("sortstring"), new Criterion[]{criterion}));
      }

      return menu_list;
   }

   public List<TBaseMenu> qeuryAllMenus() {
      String sql = XmlTool.getSql("menu", "qeuryAllMenus");
      List<TBaseMenu> menu_list = this.getSession().createNativeQuery(sql, TBaseMenu.class).getResultList();

      for(TBaseMenu tBaseMenu : menu_list) {
         Criterion criterion = Restrictions.eq("parentid", tBaseMenu.getId());
         tBaseMenu.setSubmenu(this.queryAll(Order.asc("sortstring"), new Criterion[]{criterion}));
      }

      return menu_list;
   }

   public List<TBaseMenu> queryMenus() {
      String sql = XmlTool.getSql("menu", "queryMenus");
      List<TBaseMenu> menu_list = this.getSession().createNativeQuery(sql, TBaseMenu.class).getResultList();
      return menu_list;
   }

   public List<TBaseMenu> qeuryMenusByRoleId(String roleid) {
      String sql = XmlTool.getSql("menu", "qeuryMenusByRoleId");
      List<TBaseMenu> menu_list = this.getSession().createNativeQuery(sql, TBaseMenu.class).setParameter("roleid", roleid).getResultList();

      for(TBaseMenu tBaseMenu : menu_list) {
         Criterion criterion = Restrictions.eq("parentid", tBaseMenu.getId());
         tBaseMenu.setSubmenu(this.queryAll(Order.asc("sortstring"), new Criterion[]{criterion, Restrictions.not(Restrictions.in("menuname", new Object[]{"资源管理", "特殊权限", "字段对应关系管理", "用户组管理"}))}));
      }

      return menu_list;
   }

   public List<MenuGridVO> queryMenuGrid(List<String> menuidlist) {
      List<MenuGridVO> list = null;
      String sql = XmlTool.getSql("menu", "queryMenuGrid");
      if (menuidlist != null && menuidlist.size() > 0) {
         sql = sql + XmlTool.getSql("menu", "queryMenuGrid", "idlist");
         list = this.getSession().createNativeQuery(sql).setParameter("t1idlist", menuidlist).setParameter("t2idlist", menuidlist).setResultTransformer(Transformers.aliasToBean(MenuGridVO.class)).getResultList();
      } else {
         list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(MenuGridVO.class)).getResultList();
      }

      return list;
   }

   public TBaseMenu queryMenusBySubName(String submenuname) {
      TBaseMenu remenu = null;
      String sql = XmlTool.getSql("menu", "queryMenusByMenuName");
      List<TBaseMenu> submenu_list = this.getSession().createNativeQuery(sql, TBaseMenu.class).setParameter("menuname", submenuname).getResultList();
      if (null != submenu_list && submenu_list.size() > 0) {
         Criterion criterion = Restrictions.eq("id", ((TBaseMenu)submenu_list.get(0)).getParentid());
         List<TBaseMenu> parentMenus = this.queryAll(Order.asc("sortstring"), new Criterion[]{criterion});
         if (null != parentMenus && parentMenus.size() > 0) {
            remenu = (TBaseMenu)parentMenus.get(0);
            remenu.setSubmenu(submenu_list);
         }
      }

      return remenu;
   }

   public List<TBaseMenu> queryMenusByUserId(String userId) {
      String sql = "select u.id as id ,u.menuname from  t_base_menu u left join t_base_usermenu r on u.id = r.menuid where r.userid = :userId order by u.createtime desc ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select u.id as \"id\" ,u.menuname as \"menuname\" from  t_base_menu u left join t_base_usermenu r on u.id = r.menuid where r.userid = :userId order by u.createtime desc ";
      }

      return this.getSession().createNativeQuery(sql).setParameter("userId", userId).setResultTransformer(Transformers.aliasToBean(TBaseMenu.class)).getResultList();
   }
}
