package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.vo.UserVO;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseUserDao extends BaseDao<TBaseUser, String> {
   public TBaseUser login(TBaseUser user) {
      Criterion cusername = Restrictions.eq("username", user.getUsername());
      Criterion cpassword = Restrictions.eq("password", user.getPassword());
      return (TBaseUser)this.queryUnique(new Criterion[]{cusername, cpassword});
   }

   public List<UserVO> queryuservo(PageInfo pageInfo) {
      pageInfo.setCount(this.count());
      String sql = "SELECT u.id as id,u.editpasswordtime, u.username, u.password, u.createtime, u.note, u.isenable, u.limitnum, g.id AS groupid, g.groupname AS groupname, ur.roleid AS \"roleid\", u.realname AS \"realname\", u.remark AS \"remark\" FROM t_base_user u LEFT JOIN t_base_usergroup ug ON u.id=ug.userid LEFT JOIN t_base_group g ON ug.groupid= g.id LEFT JOIN t_base_userrole ur ON u.id=ur.userid where u.id!=1 order by g.createtime desc,u.createtime desc";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(UserVO.class)).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).getResultList();
   }

   public List<UserVO> queryuservobyid(String id) {
      String sql = "SELECT u.id as id,u.editpasswordtime, u.username, u.password, u.createtime, u.note, u.isenable, u.limitnum, u.plaintext, u.desensitize, g.id AS groupid, g.groupname AS groupname, ur.roleid AS roleid, u.realname AS realname, u.remark AS remark ,u.email AS email FROM t_base_user u LEFT JOIN t_base_usergroup ug ON u.id=ug.userid LEFT JOIN t_base_group g ON ug.groupid= g.id LEFT JOIN t_base_userrole ur ON u.id=ur.userid where u.id = :id";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT u.id as \"id\",u.editpasswordtime as \"editpasswordtime\", u.username as \"username\", u.password as \"password\", u.createtime as \"createtime\", u.note as \"note\", u.isenable as \"isenable\",u.limitnum as \"limitnum\", u.plaintext as \"plaintext\", u.desensitize as \"desensitize\", g.id AS \"groupid\", g.groupname AS \"groupname\", ur.roleid AS \"roleid\", u.realname AS \"realname\", u.remark AS \"remark\" ,u.email AS \"email\" FROM t_base_user u LEFT JOIN t_base_usergroup ug ON u.id=ug.userid LEFT JOIN t_base_group g ON ug.groupid= g.id LEFT JOIN t_base_userrole ur ON u.id=ur.userid where u.id = :id";
      }

      return this.getSession().createNativeQuery(sql).setParameter("id", id).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public List<UserVO> querynoprojectuser(String proid) {
      String sql = "SELECT u.id as id,u.editpasswordtime, u.username, u.password, u.createtime, u.note, u.isenable, u.limitnum, '' as updateuserid,u.realname from t_base_user u where u.id not in (select p.userid from t_base_userproject p where p.proid = :proid ) AND u.id != '1'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT u.id as \"id\",u.editpasswordtime as \"editpasswordtime\", u.username as \"username\", u.password as \"password\", u.createtime as \"createtime\", u.note as \"note\", u.isenable as \"isenable\", u.limitnum as \"limitnum\", '' as \"updateuserid\",u.realname as \"realname\" from t_base_user u where u.id not in (select p.userid from t_base_userproject p where p.proid = :proid ) AND u.id != '1'";
      }

      return this.getSession().createNativeQuery(sql).setParameter("proid", proid).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public List<UserVO> queryselfgivecruduser(String proid, String userid) {
      String sql = "SELECT u.id as id,u.editpasswordtime, u.username, u.password, u.createtime, u.note, u.isenable, u.limitnum, :userid as updateuserid,u.realname from t_base_user u where u.id in (select p.userid from t_base_userproject p where p.proid = :proid AND p.updateuserid = :userid AND p.userid != :userid ) AND u.id != '1'";
      return this.getSession().createNativeQuery(sql).setParameter("proid", proid).setParameter("userid", userid).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public List<UserVO> queryprojectuser(String proid) {
      String sql = "SELECT u.id AS id,p1.id as tid, u.editpasswordtime, u.username, u. password, u.createtime, u.note, u.isenable, u.limitnum, p1.updateuserid, p1.crud,u.realname FROM t_base_user u LEFT JOIN t_base_userproject p1 ON u.id = p1.userid WHERE p1.proid = :proid";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT u.id AS \"id\",p1.id as \"tid\", u.editpasswordtime as \"editpasswordtime\", u.username as \"username\", u.password as \"password\", u.createtime as \"createtime\", u.note as \"note\", u.isenable as \"isenable\", u.limitnum as \"limitnum\", p1.updateuserid as \"updateuserid\", p1.crud as \"crud\",u.realname as \"realname\" FROM t_base_user u LEFT JOIN t_base_userproject p1 ON u.id = p1.userid WHERE p1.proid = :proid";
      }

      return this.getSession().createNativeQuery(sql).setParameter("proid", proid).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public List<UserVO> querynosysuser(String sysid) {
      String sql = "SELECT u.id as id,u.editpasswordtime, u.username, u.password, u.createtime, u.note, u.isenable, u.limitnum, '' as updateuserid from t_base_user u where u.id not in (select bu.userid from t_base_usersys bu where bu.sysid = :sysid ) AND u.id != '1'";
      return this.getSession().createNativeQuery(sql).setParameter("sysid", sysid).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public List<UserVO> querysysselfgivecruduser(String sysid, String userid) {
      String sql = "SELECT u.id as id,u.editpasswordtime, u.username, u.password, u.createtime, u.note, u.isenable, u.limitnum, :userid as updateuserid from t_base_user u where u.id in (select bu.userid from t_base_usersys bu where bu.sysid = :sysid AND bu.updateuserid = :userid AND bu.userid != :userid ) AND u.id != '1'";
      return this.getSession().createNativeQuery(sql).setParameter("sysid", sysid).setParameter("userid", userid).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public List<UserVO> querysysuser(String sysid) {
      String sql = "SELECT u.id AS id, u.editpasswordtime, u.username, u. password, u.createtime, u.note, u.isenable, u.limitnum, bu.updateuserid, bu.crud FROM t_base_user u LEFT JOIN t_base_usersys bu ON u.id = bu.userid WHERE bu.sysid = :sysid AND u.id != '1'";
      return this.getSession().createNativeQuery(sql).setParameter("sysid", sysid).setResultTransformer(Transformers.aliasToBean(UserVO.class)).getResultList();
   }

   public TBaseUser queryByusername(String username) {
      Criterion cusername = Restrictions.eq("username", username);
      return (TBaseUser)this.queryUnique(new Criterion[]{cusername});
   }

   public String queryUserIdByName(String username) {
      String sql = "SELECT id FROM t_base_user WHERE username = :username";
      return this.getSession().createNativeQuery(sql).setParameter("username", username).uniqueResult().toString();
   }
}
