package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiverelation;
import com.chenyang.nse.bussiness.entity.vo.SenstiveColumnRelationVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSensitivecolumnDao extends BaseDao<TCoreSensitivecolumn, String> {
   public List<TCoreSensitivecolumn> queryAllSensitiveColumns() {
      String sql = XmlTool.getSql("sensitivecolumn", "queryAllSensitiveColumns");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> queryAllSensitiveColumns(String groupid, String time) {
      String sql = XmlTool.getSql("sensitivecolumn", "querySensitiveColumnsByTimeBygroup");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupid).setParameter("createtime", time).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> queryAllSensitiveColumns(PageInfo pageInfo) {
      String sql = XmlTool.getSql("sensitivecolumn", "queryAllSensitiveColumnsCount");
      long count = (long)((BigInteger)this.getSession().createNativeQuery(sql).getSingleResult()).intValue();
      pageInfo.setCount(count);
      sql = XmlTool.getSql("sensitivecolumn", "queryAllSensitiveColumns");
      return this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> queryValidSensitiveColumns(PageInfo pageInfo) {
      pageInfo.setCount(this.count(new Criterion[]{Restrictions.isNotNull("regextype"), Restrictions.eq("flag", "1")}));
      String sql = XmlTool.getSql("sensitivecolumn", "queryValidSensitiveColumns");
      return this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> queryCheckedSensitiveColumns(String groupId) {
      String sql = XmlTool.getSql("sensitivecolumn", "queryCheckedSensitiveColumns");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<SenstiveColumnRelationVO> querySensitiveColumns(String groupId, String sensitiveColumnId, String regexType) {
      String sql = XmlTool.getSql("sensitivecolumn", "querySensitiveColumns");
      return this.getSession().createNativeQuery(sql).setParameter("GROUPID", groupId).setParameter("SSENSITIVECOLUMNID", sensitiveColumnId).setParameter("REGEXTYPE", regexType).setResultTransformer(Transformers.aliasToBean(SenstiveColumnRelationVO.class)).getResultList();
   }

   public List<TCoreSensitiverelation> querySensitiveColumnRelations(String groupId) {
      String sql = XmlTool.getSql("sensitivecolumn", "querySensitiveColumnRelations");
      return this.getSession().createNativeQuery(sql).setParameter("GROUPID", groupId).setResultTransformer(Transformers.aliasToBean(TCoreSensitiverelation.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId) {
      String sql = XmlTool.getSql("sensitivecolumn", "querySensitiveColumnsByGroupId");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId, Date createtime) {
      String sql = XmlTool.getSql("sensitivecolumn", "querySensitiveColumnsByGroupIdAndCreatetime");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setParameter("createtime", createtime).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public int updateflag(String groupid) {
      String sql = XmlTool.getSql("sensitivecolumn", "updateflag");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupid).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).executeUpdate();
   }

   public List<TCoreSensitivecolumn> getSensitiveColumnsTime(String groupId) {
      String sql = XmlTool.getSql("sensitivecolumn", "getsensitivecolumnstime");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public int removeBygroupid(String groupId) {
      String sql = XmlTool.getSql("sensitivecolumn", "delsensitivecolumnstimebygroupid");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).executeUpdate();
   }

   public int removeBygroupidByTime(String groupId, String time) {
      String sql = XmlTool.getSql("sensitivecolumn", "delsensitivecolumnstimebytime");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setParameter("createtime", time).executeUpdate();
   }

   public List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, Date createtime, String schema) {
      String sql = XmlTool.getSql("sensitivecolumn", "getSensitiveByIdBySchema");
      return this.getSession().createNativeQuery(sql).setParameter("datasourceid", datasystemid).setParameter("createtime", createtime).setParameter("tschema", schema).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, Date createtime) {
      String sql = XmlTool.getSql("sensitivecolumn", "getSensitiveByIdBySchemamysql");
      return this.getSession().createNativeQuery(sql).setParameter("datasourceid", datasystemid).setParameter("createtime", createtime).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, Date createtime, String schema, String table) {
      String sql = XmlTool.getSql("sensitivecolumn", "getSensitiveByIdBySchemaByTable");
      return this.getSession().createNativeQuery(sql).setParameter("datasourceid", datasystemid).setParameter("createtime", createtime).setParameter("tschema", schema).setParameter("tablename", table).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> getSensitiveByIdBySchemamysql(String datasystemid, Date createtime, String table) {
      String sql = XmlTool.getSql("sensitivecolumn", "getSensitiveByIdBySchemaByTable");
      return this.getSession().createNativeQuery(sql).setParameter("datasourceid", datasystemid).setParameter("createtime", createtime).setParameter("tablename", table).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public List<TCoreSensitivecolumn> getSensitiveByStructureId(String note) {
      String sql = XmlTool.getSql("sensitivecolumn", "getSensitiveByStructureId");
      return this.getSession().createNativeQuery(sql).setParameter("note", note).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }

   public Date getMaxDate(String datasystemid, String tablename, String schema) {
      new Date();
      Date date;
      if (tablename == null && schema == null) {
         date = (Date)this.getSession().createCriteria(TCoreSensitivecolumn.class).add(Restrictions.eq("datasourceid", datasystemid)).setProjection(Projections.projectionList().add(Projections.max("createtime"))).uniqueResult();
      } else if (schema == null) {
         date = (Date)this.getSession().createCriteria(TCoreSensitivecolumn.class).add(Restrictions.eq("datasourceid", datasystemid)).add(Restrictions.eq("tablename", tablename)).setProjection(Projections.projectionList().add(Projections.max("createtime"))).uniqueResult();
      } else if (tablename == null) {
         date = (Date)this.getSession().createCriteria(TCoreSensitivecolumn.class).add(Restrictions.eq("datasourceid", datasystemid)).add(Restrictions.eq("schema", schema)).setProjection(Projections.projectionList().add(Projections.max("createtime"))).uniqueResult();
      } else {
         date = (Date)this.getSession().createCriteria(TCoreSensitivecolumn.class).add(Restrictions.eq("datasourceid", datasystemid)).add(Restrictions.eq("schema", schema)).add(Restrictions.eq("tablename", tablename)).setProjection(Projections.projectionList().add(Projections.max("createtime"))).uniqueResult();
      }

      return date;
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdNew(String groupId) {
      String sql = XmlTool.getSql("sensitivecolumn", "getSensitiveByIdByGroupIdNew");
      return this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setResultTransformer(Transformers.aliasToBean(TCoreSensitivecolumn.class)).getResultList();
   }
}
