package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryMonitorVO;
import com.chenyang.nse.bussiness.entity.vo.DiscoverytaskVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDiscoveryTaskVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDiscoverytaskDao extends BaseDao<TcoreDiscoveryTask, String> {
   public List<DiscoverytaskVO> queryAllDiscoverytask(PageInfo pageInfo, HashMap<String, String> hash) {
      String searchTaskName = "";
      if (StringUtils.isNotBlank((CharSequence)hash.get("tname"))) {
         searchTaskName = (String)hash.get("tname");
      }

      String sqls = XmlTool.getSql("discovery", "queryAllDiscoverytasktotnamecount");
      BigInteger i = (BigInteger)this.getSession().createNativeQuery(sqls).setParameter("tname", searchTaskName + "%").uniqueResult();
      pageInfo.setCount(i.longValue());
      String sql = XmlTool.getSql("discovery", "queryAllDiscoverytasktotname");
      return this.getSession().createNativeQuery(sql).setParameter("tname", searchTaskName + "%").setResultTransformer(Transformers.aliasToBean(DiscoverytaskVO.class)).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).getResultList();
   }

   public int createDiscoveryTask(TcoreDiscoveryTask task) {
      String sql = XmlTool.getSql("discovery", "addtask");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", task.getId()).setParameter("createtime", task.getCreatetime()).setParameter("updatetime", task.getUpdatetime()).setParameter("tname", task.getTname()).setParameter("isdmpflag", task.getIsdmpflag()).setParameter("discoverytype", task.getDiscoverytype()).setParameter("cyfs", task.getCyfs()).setParameter("cys", task.getCys()).setParameter("ppl", task.getPpl()).setParameter("dbtype", task.getDbtype()).setParameter("username", task.getUsername()).setParameter("projectid", task.getProjectid()).setParameter("datasystemid", task.getDatasystemid()).setParameter("resultid", task.getResultid()).setParameter("note", task.getNote()).setParameter("flag", task.getFlag()).setParameter("alltableschema", task.getAlltableschema()).executeUpdate();
      return i;
   }

   public int editDiscoveryTask(TcoreDiscoveryTask task) {
      String sql = XmlTool.getSql("discovery", "edittask");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", task.getId()).setParameter("tname", task.getTname()).setParameter("isdmpflag", task.getIsdmpflag()).setParameter("discoverytype", task.getDiscoverytype()).setParameter("cyfs", task.getCyfs()).setParameter("cys", task.getCys()).setParameter("ppl", task.getPpl()).setParameter("dbtype", task.getDbtype()).setParameter("username", task.getUsername()).setParameter("note", task.getNote()).setParameter("flag", task.getFlag()).setParameter("updatetime", task.getUpdatetime()).setParameter("alltableschema", task.getAlltableschema()).executeUpdate();
      return i;
   }

   public long getExeTaskNum(String taskid) {
      String sql = "select  count(*) from t_core_discovery_task where taskstatus = 1 and id='" + taskid + "'";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public void updateTaskstatus(String taskid, String status, String version) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String sql = "update t_core_discovery_task set taskstatus= '" + status + "',curversion='" + version + "' ,updatetime='" + formatter.format(new Date()) + "' where id='" + taskid + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void updateAutofindResultid(String taskid, String resultid) {
      String sql = "update t_core_discovery_task set autofindresultid= '" + resultid + "' where id='" + taskid + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void createsqlstr(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<ComboboxVO> queryTaskList(String ids, String projectid) {
      String sql = "select id as value,tname as text from t_core_discovery_task where id in (" + ids + ") and projectid ='" + projectid + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select id as \"value\",tname as \"text\" from t_core_discovery_task where id in (" + ids + ") and projectid ='" + projectid + "'";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select id as \"value\",tname as \"text\" from t_core_discovery_task where id in (" + ids + ") and projectid ='" + projectid + "'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ComboboxVO.class)).getResultList();
   }

   public List<DiscoverytaskVO> discoveryTaskList(String datasourceid) {
      String sql = XmlTool.getSql("discovery", "queryAllDatasourceTask");
      List<DiscoverytaskVO> list = this.getSession().createNativeQuery(sql).setParameter("datasourceid", datasourceid).setResultTransformer(Transformers.aliasToBean(DiscoverytaskVO.class)).getResultList();
      return list;
   }

   public List<Map<String, Object>> selectFindCount(String id) {
      String sql = "SELECT count(1) as s FROM t_core_discovery_task where projectid ='" + id + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<DiscoveryMonitorVO> selectTaskByProjectid(String projectid) {
      List<DiscoveryMonitorVO> list;
      if (projectid != null && !"".equals(projectid)) {
         String sql = "SELECT a.id as id,a.tname as taskname,a.discoverytype,a.isdmpflag,b.id as projectid,b.project as projectname,a.createtime FROM t_core_discovery_task a left outer join t_core_data_project b on a.projectid=b.id where a.projectid='" + projectid + "' and a.taskstatus is not null order by a.createtime desc";
         list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(DiscoveryMonitorVO.class)).getResultList();
      } else {
         String sql = "SELECT a.id as id,a.tname as taskname,a.discoverytype,a.isdmpflag,b.id as projectid,b.project as projectname,a.createtime FROM t_core_discovery_task a left outer join t_core_data_project b on a.projectid=b.id where a.taskstatus is not null order by a.createtime desc";
         list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(DiscoveryMonitorVO.class)).getResultList();
      }

      return list;
   }

   public List<TCoreDiscoveryTaskVO> selectDiscoveryTaskforDB(String taskid) {
      new ArrayList();
      String sql = XmlTool.getSql("discovery", "queryDiscoveryTaskforDB");
      List<TCoreDiscoveryTaskVO> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setResultTransformer(Transformers.aliasToBean(TCoreDiscoveryTaskVO.class)).getResultList();
      return list;
   }

   public List<TCoreDiscoveryTaskVO> selectDiscoveryTaskforTxt(String taskid) {
      new ArrayList();
      String sql = XmlTool.getSql("discovery", "queryDiscoveryTaskDetailforTxt");
      List<TCoreDiscoveryTaskVO> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setResultTransformer(Transformers.aliasToBean(TCoreDiscoveryTaskVO.class)).getResultList();
      return list;
   }

   public List<TCoreDiscoveryTaskVO> selectDiscoveryTaskforDmp(String taskid) {
      new ArrayList();
      String sql = XmlTool.getSql("discovery", "queryDiscoveryTaskDetailforDmp");
      List<TCoreDiscoveryTaskVO> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setResultTransformer(Transformers.aliasToBean(TCoreDiscoveryTaskVO.class)).getResultList();
      return list;
   }

   public List<Map<String, Object>> selectIsSureFieldcount(String tablename) {
      String sql = "select count(tfields) as count from " + tablename + " where issure = '1' ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select count(tfields) as \"count\" from " + tablename + " where issure = '1' ";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select count(tfields) as \"count\" from " + tablename + " where issure = '1' ";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, Object>> selectFieldcount(String taskid) {
      String sql = "select fieldcount as count from t_core_discovery_data_result where taskid  = '" + taskid + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select fieldcount as \"count\" from t_core_discovery_data_result where taskid  = '" + taskid + "'";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select fieldcount as \"count\" from t_core_discovery_data_result where taskid  = '" + taskid + "'";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }
}
