package com.chenyang.nse.bussiness.dao.table.core.desensitizationtask;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDatamapping;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class DesensitizationDatamappingDao extends BaseDao<DesensitizationDatamapping, String> {
   public List<Map<String, String>> getDatamappingInfo(String sourcesystemtype, String targetsystemtype) {
      String sql = XmlTool.getSql("desensitizationdatamapping", "getDatamappingInfo");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("sourcesystemtype", sourcesystemtype).setParameter("targetsystemtype", targetsystemtype).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> getDatamappingInfo1(PageInfo pageinfo, String sourcesystemtype, String targetsystemtype) {
      String sql = XmlTool.getSql("desensitizationdatamapping", "getDatamappingInfo1");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("sourcesystemtype", sourcesystemtype).setParameter("targetsystemtype", targetsystemtype).setParameter("startno", (pageinfo.getPageno() - 1) * pageinfo.getPagesize()).setParameter("pagesize", pageinfo.getPagesize()).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public BigInteger getDatamappingCount(String sourcesystemtype, String targetsystemtype) {
      String sql = XmlTool.getSql("desensitizationdatamapping", "getDatamappingCount");
      List<Map<String, BigInteger>> list = this.getSession().createNativeQuery(sql).setParameter("sourcesystemtype", sourcesystemtype).setParameter("targetsystemtype", targetsystemtype).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return (BigInteger)((Map)list.get(0)).get("count");
   }

   public void updateIsdefault(String sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, String>> getPwctypeBySourceType(String sourcesystemtype, String targetsystemtype, String sourcefieldname) {
      String sql = XmlTool.getSql("desensitizationdatamapping", "getPwctypeBySourceType");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("sourcesystemtype", sourcesystemtype).setParameter("targetsystemtype", targetsystemtype).setParameter("sourcefieldname", sourcefieldname).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> getPwctypeList(String sourcesystemtype, String targetsystemtype) {
      String sql = XmlTool.getSql("desensitizationdatamapping", "getPwctypeList");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("sourcesystemtype", sourcesystemtype).setParameter("targetsystemtype", targetsystemtype).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }
}
