package com.chenyang.nse.bussiness.dao.table.core.encryption;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.service.webApi.business.SecretKeyCache;
import com.chenyang.nse.bussiness.tools.DataSourceTools;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreEncryptionTypeFieldDao extends BaseDao<TCoreEncryptionTypeField, String> {
   public void saveTCoreEncryptionTypeField(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
      SecretKeyCache.instance().invalidate();
   }

   public List<TCoreEncryptionTypeField> getTCoreEncryptionTypeField(String table_name, String schema, String datasystem_id) {
      String sql = "select table_field_id,encryption_secretkey_id,combination_id,updatetime,flag,islike,describe_info,keepfirst,encdigit FROM t_core_encryption_field WHERE names='" + table_name + "'and tschemas='" + schema + "'and datasystem_id ='" + datasystem_id + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select table_field_id as \"table_field_id\",encryption_secretkey_id as \"encryption_secretkey_id\",combination_id as \"combination_id\",updatetime as \"updatetime\",flag as \"flag\",islike as \"islike\",describe_info as \"describe_info\",keepfirst as \"keepfirst\",encdigit as \"encdigit\" FROM t_core_encryption_field WHERE names='" + table_name + "'and tschemas='" + schema + "'and datasystem_id ='" + datasystem_id + "'";
      }

      List<TCoreEncryptionTypeField> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
      return vo;
   }

   public List<TCoreEncryptionTypeField> getExcel(String projectid) {
      String sql = "select f.id as id,f.createtime ,f.createuser, f.flag, f.note,f.updatetime,f.updateuser,f.column_size,f.combination_id,f.dataareaid,f.datasystem_id,f.describe_info,f.encryption_secretkey_id,f.names,f.projectid,f.table_field_id,f.tschemas,f.dataareaname,f.state,f.column_type, f.datasystemname,e.encryption_name as encryptiontypename,s.secret_key_name as secretkeyname,f.islike, f.keepfirst, f.encdigit, f.realitycolumnsize, f.twoindex from t_core_encryption_field f join t_core_secretkey s on f.encryption_secretkey_id = s.id  join t_core_encryption e on e.id = s.encryption_id  where projectid = '" + projectid + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select f.id as \"id\",f.createtime as \"createtime\",f.createuser as \"createuser\", f.flag as \"flag\", f.note as \"note\",f.updatetime as \"updatetime\",f.updateuser as \"updateuser\",f.column_size as \"column_size\",f.combination_id as \"combination_id\",f.dataareaid as \"dataareaid\",f.datasystem_id as \"datasystem_id\",f.describe_info as \"describe_info\",f.encryption_secretkey_id as \"encryption_secretkey_id\",f.names as \"names\",f.projectid as \"projectid\",f.table_field_id as \"table_field_id\",f.tschemas as \"tschemas\",f.dataareaname as \"dataareaname\",f.state as \"state\",f.column_type as \"column_type\", f.datasystemname as \"datasystemname\",e.encryption_name as \"encryptiontypename\",s.secret_key_name as \"secretkeyname\",f.islike as \"islike\", f.keepfirst as \"keepfirst\", f.encdigit as \"encdigit\", f.realitycolumnsize as \"realitycolumnsize\", f.twoindex as \"twoindex\" from t_core_encryption_field f join t_core_secretkey s on f.encryption_secretkey_id = s.id  join t_core_encryption e on e.id = s.encryption_id  where projectid = '" + projectid + "'";
      }

      List<TCoreEncryptionTypeField> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
      return vo;
   }

   public Object queryEncryptionTableNum(String projectId, String dataSystemId) {
      String sql = null;
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "select sum(tabelnum) from(select count(DISTINCT `names`) tabelnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND flag in ('5','6')\nGROUP BY projectid,datasystem_id,tschemas) a";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "select sum(tabelnum) from(select count(DISTINCT \"names\") tabelnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND flag in ('5','6')\nGROUP BY projectid,datasystem_id,tschemas) a";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select sum(tabelnum) from(select count(DISTINCT \"names\") tabelnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND flag in ('5','6')\nGROUP BY projectid,datasystem_id,tschemas) a";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT\n\t\tCASE when sum(tabelnum) IS NULL THEN 0 ELSE sum(TABELNUM) end \nFROM\n\t(\n\tSELECT count(*) AS tabelnum FROM  (\n\t\tSELECT DISTINCT projectid,datasystem_id,tschemas,names\n\t\tFROM t_core_encryption_field\n\t\tWHERE 1 = 1 AND flag IN ('5', '6')  and projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND flag in ('5','6')\n\t) t GROUP BY projectid,datasystem_id,tschemas\n) a";
      }

      sql = DataSourceTools.dealSqlFormat(sql);
      return this.getSession().createNativeQuery(sql).uniqueResult();
   }

   public Object queryEncryptionColumnNum(String projectId, String dataSystemId) {
      String sql = "select sum(columnnum) from(select count(DISTINCT table_field_id) columnnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND flag in ('5','6')\nGROUP BY projectid,datasystem_id,tschemas,names) a";
      sql = DataSourceTools.dealSqlFormat(sql);
      return this.getSession().createNativeQuery(sql).uniqueResult();
   }

   public Object queryEncryptionColumnNum(String projectId, String dataSystemId, String schema, String tableName) {
      String sql = null;
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "select count(DISTINCT table_field_id) columnnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND tschemas ='" + schema + "' AND `names`='" + tableName + "' AND flag in (5,6)\nGROUP BY projectid,datasystem_id,tschemas,names";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "select count(DISTINCT table_field_id) columnnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND tschemas ='" + schema + "' AND \"names\"='" + tableName + "' AND flag in (5,6)\nGROUP BY projectid,datasystem_id,tschemas,names";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select count(DISTINCT table_field_id) columnnum FROM t_core_encryption_field\nwhere projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND tschemas ='" + schema + "' AND \"names\"='" + tableName + "' AND flag in (5,6)\nGROUP BY projectid,datasystem_id,tschemas,names";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT\n\t\tCASE when sum(columnnum) IS NULL THEN 0 ELSE sum(columnnum) end \nFROM\n\t(\n\tSELECT count(*) AS columnnum FROM  (\n\t\tSELECT DISTINCT projectid,datasystem_id,tschemas,names,table_field_id\n\t\tFROM t_core_encryption_field\n\t\tWHERE 1 = 1 AND flag IN ('5', '6')\n and projectid = '" + projectId + "' AND datasystem_id ='" + dataSystemId + "' AND tschemas ='" + schema + "' AND names='" + tableName + "'\t) t GROUP BY projectid,datasystem_id,tschemas,names\n) a";
      }

      return this.getSession().createNativeQuery(sql).uniqueResult();
   }

   public Object queryTotalEncrypTableCount(String projectid) {
      String sql = "";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         if (projectid.equals("")) {
            sql = "select sum(tabelnum) from (select count(DISTINCT `names`) tabelnum FROM t_core_encryption_field where 1=1 AND flag in ('5','6') GROUP BY datasystem_id,tschemas) a";
         } else {
            sql = "select sum(tabelnum) from (select count(DISTINCT `names`) tabelnum FROM t_core_encryption_field where projectid in (" + projectid + ") AND flag in ('5','6') GROUP BY datasystem_id,tschemas) a";
         }
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         if (projectid.equals("")) {
            sql = "select sum(tabelnum) from (select count(DISTINCT \"names\") tabelnum FROM t_core_encryption_field where 1=1 AND flag in ('5','6') GROUP BY datasystem_id,tschemas) a";
         } else {
            sql = "select sum(tabelnum) from (select count(DISTINCT \"names\") tabelnum FROM t_core_encryption_field where projectid in (" + projectid + ") AND flag in ('5','6') GROUP BY datasystem_id,tschemas) a";
         }
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         if (projectid.equals("")) {
            sql = "select sum(tabelnum) from (select count(DISTINCT \"names\") tabelnum FROM encryption.t_core_encryption_field where 1=1 AND flag in ('5','6') GROUP BY datasystem_id,tschemas) a";
         } else {
            sql = "select sum(tabelnum) from (select count(DISTINCT \"names\") tabelnum FROM encryption.t_core_encryption_field where projectid in (" + projectid + ") AND flag in ('5','6') GROUP BY datasystem_id,tschemas) a";
         }
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         if (projectid.equals("")) {
            sql = "SELECT\n\t\tCASE when sum(tabelnum) IS NULL THEN 0 ELSE sum(TABELNUM) end \nFROM\n\t(\n\tSELECT count(*) AS tabelnum FROM  (\n\t\tSELECT DISTINCT datasystem_id,tschemas,names\n\t\tFROM t_core_encryption_field\n\t\tWHERE 1 = 1 AND flag IN ('5', '6')\n\t) t GROUP BY datasystem_id,tschemas\n) a";
         } else {
            sql = "SELECT\n\t\tCASE when sum(tabelnum) IS NULL THEN 0 ELSE sum(TABELNUM) end \nFROM\n\t(\n\tSELECT count(*) AS tabelnum FROM  (\n\t\tSELECT DISTINCT datasystem_id,tschemas,names\n\t\tFROM t_core_encryption_field\n\t\tWHERE 1 = 1 AND flag IN ('5', '6') AND  projectid in (" + projectid + ") \n\t) t GROUP BY datasystem_id,tschemas\n) a";
         }
      }

      return this.getSession().createNativeQuery(sql).uniqueResult();
   }

   public Object queryTotalEncrypColumnCount(String projectid) {
      String sql = "";
      if (projectid.equals("")) {
         sql = "select sum(columnnum) from(select count(DISTINCT table_field_id) columnnum FROM t_core_encryption_field where 1=1 AND flag in ('5','6') GROUP BY datasystem_id,tschemas,names) a";
      } else {
         sql = "select sum(columnnum) from(select count(DISTINCT table_field_id) columnnum FROM t_core_encryption_field where projectid in (" + projectid + ") AND flag in ('5','6') GROUP BY datasystem_id,tschemas,names) a";
      }

      return this.getSession().createNativeQuery(sql).uniqueResult();
   }

   public List<TCoreEncryptionTypeField> queryTCorTypeFieldList(String dataSystemId, String projectId, String schema, String tableName, String flag) {
      String sql = "SELECT id as id,table_field_id,encryption_secretkey_id,describe_info,names,tschemas,datasystem_id,column_type,column_size,islike, keepfirst, encdigit, realitycolumnsize, twoindex FROM t_core_encryption_field WHERE datasystem_id = '" + dataSystemId + "' and projectid = '" + projectId + "' and tschemas='" + schema + "' and names='" + tableName + "' and flag='" + flag + "' and state='0'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT id as \"id\",table_field_id as \"table_field_id\",encryption_secretkey_id as \"encryption_secretkey_id\",describe_info as \"describe_info\",names as \"names\",tschemas as \"tschemas\",datasystem_id as \"datasystem_id\",column_type as \"column_type\",column_size as \"column_size\",islike as \"islike\", keepfirst as \"keepfirst\", encdigit as \"encdigit\", realitycolumnsize as \"realitycolumnsize\", twoindex as \"twoindex\" FROM t_core_encryption_field WHERE datasystem_id = '" + dataSystemId + "' and projectid = '" + projectId + "' and tschemas='" + schema + "' and names='" + tableName + "' and flag='" + flag + "' and state='0'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }

   public List<TCoreEncryptionTypeField> queryTCorTypeFieldListTable(String dataSystemId, String schema, String tableName, String flag) {
      String sql = "SELECT id as id,table_field_id,encryption_secretkey_id,describe_info,names,flag,tschemas,datasystem_id,column_type,column_size FROM t_core_encryption_field WHERE datasystem_id = '" + dataSystemId + "' and tschemas='" + schema + "' and names='" + tableName + "' and flag='" + flag + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }

   public List<TCoreEncryptionTypeField> queryTCorTypeFieldProjectList(String dataSystemId, String projectId, String schema, String flag) {
      String sql = "SELECT id as id,table_field_id,encryption_secretkey_id,describe_info,names,flag,tschemas,datasystem_id,column_type,column_size FROM t_core_encryption_field WHERE datasystem_id = '" + dataSystemId + "' and projectid = '" + projectId + "' and tschemas='" + schema + "' and flag='" + flag + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }

   public List<TCoreEncryptionTypeField> queryTotalTasks(String dataSystemId, String projectId, String schema, String tableName) {
      String sql = "SELECT id as id,encryption_secretkey_id,flag FROM t_core_encryption_field WHERE datasystem_id = '" + dataSystemId + "' and projectid = '" + projectId + "' and tschemas='" + schema + "' and names='" + tableName + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }

   public List<TCoreEncryptionTypeField> queryProjectCorTyFieldList(String projectId, String flag) {
      String sql = "SELECT id as id,table_field_id,encryption_secretkey_id,describe_info,names,tschemas,datasystem_id,column_type,column_size,realitycolumnsize FROM t_core_encryption_field WHERE encryption_secretKey_id IS NOT NUll AND encryption_secretKey_id <> '' AND projectid = '" + projectId + "' and flag='" + flag + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT id as \"id\",table_field_id as \"table_field_id\",encryption_secretkey_id as \"encryption_secretkey_id\",describe_info as \"describe_info\",names as \"names\",tschemas as \"tschemas\",datasystem_id as \"datasystem_id\",column_type as \"column_type\",column_size as \"column_size\",realitycolumnsize as \"realitycolumnsize\" FROM t_core_encryption_field WHERE encryption_secretKey_id IS NOT NUll AND encryption_secretKey_id <> '' AND projectid = '" + projectId + "' and flag='" + flag + "'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }

   public List<TCoreEncryptionTypeField> queryCompletedTasks(String projectId) {
      String sql = "SELECT id as id,encryption_secretkey_id,flag FROM t_core_encryption_field WHERE projectid = '" + projectId + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }

   public List<TCoreEncryptionTypeField> queryFields(String projectId) {
      String sql = "SELECT id as id,encryption_secretkey_id,flag,state FROM t_core_encryption_field WHERE projectid = '" + projectId + "' and (state = '1' or state is null)";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT id as \"id\",encryption_secretkey_id as \"encryption_secretkey_id\",flag as \"flag\",state as \"state\" FROM t_core_encryption_field WHERE projectid = '" + projectId + "' and (state = '1' or state is null)";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryptionTypeField.class)).getResultList();
   }
}
