package com.chenyang.nse.bussiness.entity.orm.table.core.masking;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_MASKING_RULEINFO"
)
public class TCoreMaskingRuleinfo extends TBaseEntity {
   private String subjectarea;
   private String mappletname;
   private String engineid;
   private String ruleid;
   private String ruledemo;
   private String name;
   private String dataarea_id;
   private String defaulttype;

   public TCoreMaskingRuleinfo() {
   }

   public TCoreMaskingRuleinfo(String subjectarea, String mappletname, String engineid, String ruleid) {
      this.subjectarea = subjectarea;
      this.mappletname = mappletname;
      this.engineid = engineid;
      this.ruleid = ruleid;
   }

   public String getSubjectarea() {
      return this.subjectarea;
   }

   public void setSubjectarea(String subjectarea) {
      this.subjectarea = subjectarea;
   }

   public String getMappletname() {
      return this.mappletname;
   }

   public void setMappletname(String mappletname) {
      this.mappletname = mappletname;
   }

   public String getEngineid() {
      return this.engineid;
   }

   public void setEngineid(String engineid) {
      this.engineid = engineid;
   }

   public String getRuleid() {
      return this.ruleid;
   }

   public void setRuleid(String ruleid) {
      this.ruleid = ruleid;
   }

   public String getRuledemo() {
      return this.ruledemo;
   }

   public void setRuledemo(String ruledemo) {
      this.ruledemo = ruledemo;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getDataarea_id() {
      return this.dataarea_id;
   }

   public void setDataarea_id(String dataarea_id) {
      this.dataarea_id = dataarea_id;
   }

   public String getDefaulttype() {
      return this.defaulttype;
   }

   public void setDefaulttype(String defaulttype) {
      this.defaulttype = defaulttype;
   }

   public String toString() {
      return "TCoreMaskingRuleinfo [subjectarea=" + this.subjectarea + ", mappletname=" + this.mappletname + ", engineid=" + this.engineid + ", ruleid=" + this.ruleid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.engineid == null ? 0 : this.engineid.hashCode());
      result = 31 * result + (this.mappletname == null ? 0 : this.mappletname.hashCode());
      result = 31 * result + (this.ruleid == null ? 0 : this.ruleid.hashCode());
      result = 31 * result + (this.subjectarea == null ? 0 : this.subjectarea.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreMaskingRuleinfo other = (TCoreMaskingRuleinfo)obj;
         if (this.engineid == null) {
            if (other.engineid != null) {
               return false;
            }
         } else if (!this.engineid.equals(other.engineid)) {
            return false;
         }

         if (this.mappletname == null) {
            if (other.mappletname != null) {
               return false;
            }
         } else if (!this.mappletname.equals(other.mappletname)) {
            return false;
         }

         if (this.ruleid == null) {
            if (other.ruleid != null) {
               return false;
            }
         } else if (!this.ruleid.equals(other.ruleid)) {
            return false;
         }

         if (this.subjectarea == null) {
            if (other.subjectarea != null) {
               return false;
            }
         } else if (!this.subjectarea.equals(other.subjectarea)) {
            return false;
         }

         return true;
      }
   }
}
