package com.chenyang.nse.bussiness.rmbackupfield.controller;

import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.rmbackupfield.service.RmBackupFieldService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RmBackupFieldController {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected RmBackupFieldService rmBackupFieldService;

   @RequestMapping({"rmbackupfield"})
   public Response<String> rmbackupfield(@RequestBody Map<String, String> map) {
      this.logger.info(map != null ? map.toString() : "");
      String projectId = (String)map.get("projectId");
      if (!StringUtils.hasText(projectId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "projectId is required");
      } else {
         String datasystem_id = (String)map.get("datasystem_id");
         if (!StringUtils.hasText(datasystem_id)) {
            return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "datasystem_id is required");
         } else {
            String schema = (String)map.get("schema");
            if (!StringUtils.hasText(schema)) {
               return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "schema is required");
            } else {
               String tablename = (String)map.get("tablename");
               if (!StringUtils.hasText(tablename)) {
                  return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "tablename is required");
               } else {
                  String columnname = (String)map.get("columnname");
                  if (!StringUtils.hasText(columnname)) {
                     return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "columnname is required");
                  } else {
                     try {
                        this.rmBackupFieldService.rmBackupField(projectId, datasystem_id, schema, tablename, columnname);
                        return RespHelper.<String>successResp();
                     } catch (Exception e) {
                        this.logger.error(e.getMessage(), e);
                        return RespHelper.<String>createResp(ErrCode.BUSINESS_ERROR.getCode(), String.format("[%s]%s", e.getClass().getName(), e.getMessage()));
                     }
                  }
               }
            }
         }
      }
   }
}
