package com.chenyang.nse.bussiness.service.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.vo.RegexTypeColorVO;
import java.util.List;
import java.util.Map;

public interface DictionaryService {
   List<TConsoleDictionarytype> getDictinaryTypesbytypename(String typename);

   List<TConsoleDictionary> getDictinaryByname(String typename);

   List<String> querySingleFirstName();

   List<String> queryDoubleFirstName();

   List<String> queryFirstTwoNumOfIdentifyNo();

   List<String> queryProvinceAndCity();

   List<String> queryDictionaryValues(String typeCode);

   List<TConsoleDictionary> queryRuleType();

   void save(String regexTypeName, String regexTypeColor);

   String queryRegexTypeColor(String regexTypeName);

   List<RegexTypeColorVO> queryAllRegexTypeColor();

   List<String> queryAllRegexTypes();

   void delete(String regexTypeName);

   List<TConsoleDictionary> query(String fuzzySearch, String typecode, String value, PageInfo pageInfo);

   List<TConsoleDictionary> query(String typecode, String value, PageInfo pageInfo);

   List<TConsoleDictionarytype> getDictinaryTypes();

   void removeSum(List<String> idlist);

   void remove(String rowid);

   TConsoleDictionary initEditRude(String rowid, String typecode);

   void save(TConsoleDictionary dictionary);

   void addDictionaryType(TConsoleDictionarytype dictionaryType);

   long queryDictionaryTypeCount(String typename);

   List<TConsoleDictionary> querySensitiveTypes();

   List<String> querySensitiveTypeNames();

   void sortSensitiveTypes(List<String> ids);

   List<TcoreDiscoverySensitivecolumn> queryTcoreDiscoverySensitivecolumn(String groupid, String taskversion);

   void tcoreDiscoverySensitivecolumnSave(TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn);

   List<TConsoleDictionary> queryAll(PageInfo pageInfo);

   List<TConsoleDictionarytype> queryBycode(String code);

   void removetype(String typecode);

   void removeDictionaryType(List<String> idlist);

   List<TConsoleDictionary> queryDictionaryByTypeCode(String typecode, PageInfo pageInfo, Map<String, Object> params);

   TConsoleDictionary initEditDictionary(String id);

   TConsoleDictionarytype initEditDictionaryType(String id);
}
