package com.chenyang.nse.bussiness.service.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseAppUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsersys;
import com.chenyang.nse.bussiness.entity.vo.AppUserVO;
import com.chenyang.nse.bussiness.entity.vo.DutyPersonVO;
import com.chenyang.nse.bussiness.entity.vo.UserVO;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public interface UserService {
   int delDutyPersonById(DutyPersonVO vo);

   int saveDutyPerson(DutyPersonVO vo);

   List<DutyPersonVO> isExistPerson(DutyPersonVO vo);

   int updateDutyPerson(DutyPersonVO vo);

   List<DutyPersonVO> selectDutyPerson(DutyPersonVO vo);

   TBaseUser login(TBaseUser user);

   List<TBaseUser> query(PageInfo pageInfo);

   List<TBaseUser> queryAll();

   void remove(List<String> idlist);

   void removeuser(String userid);

   boolean checkNameExit(String username);

   void save(TBaseUser user);

   void saveUserRole(TBaseUserrole userRole);

   void saveUserSys(TBaseUsersys userSys);

   void saveUserPro(TBaseUserproject userProject);

   void deleteUserRoleByUserId(String userid);

   void deleteUserSysByUserId(String userid);

   List<TBaseUserrole> queryuserrolebyuserid(String userid);

   List<TBaseUsersys> queryusersysbyuserid(String userid);

   List<UserVO> queryuservo(PageInfo pageInfo, Map<String, String> params);

   List<AppUserVO> queryappuservo(PageInfo pageInfo, Map<String, String> params);

   void removeUsersysBySysId(String sysid);

   void removeUsersysByUserId(String userid);

   void removeUsersystByUpdateuserid(String userid, String updateuserid);

   void removeUserprojectByUserId(String userid);

   void removeUserprojectByUpdateuserid(String proid, String updateuserid);

   void removeUserprojectByProjectid(String proid);

   void updateUser(String username, Integer isenable);

   UserVO queryByUserid(String userid);

   TBaseAppUser queryByAppUserid(String id);

   List<UserVO> queryNoProjectCrudUser(String proid);

   List<UserVO> queryProjectCrudUser(String proid);

   void delProjectCrudUserById(String id);

   void addProjectCrudUser(TBaseUserproject vo);

   List<UserVO> querySelfGiveCrudUser(String proid, String userid);

   List<UserVO> querySysCrudUser(String sysid);

   List<UserVO> querySysSelfGiveCrudUser(String sysid, String userid);

   List<UserVO> querynoSysCrudUser(String sysid);

   List<String> queryGroupByusrid(String usreid);

   void saveUserSyscrud(TBaseUsersys userSys);

   UserVO initUser(String userId);

   void addUser(UserVO userVO, HttpServletRequest request);

   void addAppUser(AppUserVO appUserVO, HttpServletRequest request);

   void deleteUserRole(String userid);

   void deleteUserMenu(String userid);

   void deleteUserGroup(String userid);

   void deleteUserMenuByUserid(String id);

   void deleteUserRoleByUserid(String id);

   void deleteUserGroupByUserid(String id);

   void remove(String idlist);

   void removeAppUser(String id);

   TBaseAppUser queryByuseridentifier(String useridentifier);

   TBaseAppUser queryByappusername(String username);

   TBaseUser queryByusername(String username);

   void changeGlobalOriginalConfig(Integer status, String projectId);

   Integer getGlobalOriginalConfig(String projectId);

   Integer pullGlobalOriginalConfig(String projectId);

   TBaseAppUser queryByappuserid(String id);
}
