package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingInfoDao;
import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingTargetfieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.mapping.TConsoleDatamappingInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.mapping.TConsoleDatamappingTargetfield;
import com.chenyang.nse.bussiness.service.console.DataMappingService;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataMappingServiceImpl implements DataMappingService {
   @Autowired
   private TConsoleDatamappingInfoDao tConsoleDatamappingInfoDao;
   @Autowired
   private TConsoleDatamappingTargetfieldDao tConsoleDatamappingTargetfieldDao;

   public List<Map<String, String>> getDatamappingInfo(String sourcesystemtype, String targetsystemtype) {
      List<Map<String, String>> list = this.tConsoleDatamappingInfoDao.getDatamappingInfo(sourcesystemtype, targetsystemtype);
      return list;
   }

   public List<TConsoleDatamappingTargetfield> getTargetFieldByType(String datasystemtype) {
      List<TConsoleDatamappingTargetfield> list = this.tConsoleDatamappingTargetfieldDao.queryAll("fieldname", true, new Criterion[]{Restrictions.eq("datasystemtype", datasystemtype)});
      return list;
   }

   public void modifyDataInfo(Map<String, String> map) {
      String id = (String)map.get("id");
      String sourcefieldid = (String)map.get("sourcefieldid");
      String flag = (String)map.get("flag");
      String targetfieldid = (String)map.get("targetfieldid");
      String targetlength = (String)map.get("targetlength");
      String targetdecimal = (String)map.get("targetdecimal");
      String targetsystemtype = (String)map.get("targetsystemtype");
      String note = (String)map.get("note");
      TConsoleDatamappingInfo tConsoleDatamappingInfo = new TConsoleDatamappingInfo();
      if (id != "" && id != null) {
         tConsoleDatamappingInfo.setId(id);
      }

      tConsoleDatamappingInfo.setSourcefieldid(sourcefieldid);
      tConsoleDatamappingInfo.setFlag(flag);
      tConsoleDatamappingInfo.setTargetfieldid(targetfieldid);
      tConsoleDatamappingInfo.setTargetlength(flag.equals("1") ? targetlength : "");
      tConsoleDatamappingInfo.setTargetdecimal(flag.equals("1") ? targetdecimal : "");
      tConsoleDatamappingInfo.setTargetsystemtype(targetsystemtype);
      tConsoleDatamappingInfo.setNote(note);
      this.tConsoleDatamappingInfoDao.saveOrUpdate(tConsoleDatamappingInfo);
   }
}
