package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuresourceDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseResourceDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenuresource;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseResource;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.MenuGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResourcesVO;
import com.chenyang.nse.bussiness.service.console.ResourceService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ResourceServiceImpl implements ResourceService {
   @Autowired
   private TBaseResourceDao tBaseResourceDao;
   @Autowired
   private TBaseMenuresourceDao tBaseMenuresourceDao;

   public List<ResourcesVO> queryAll() {
      String sql = XmlTool.getSql("resource", "queryAll");
      List<ResourcesVO> list = this.tBaseResourceDao.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ResourcesVO.class)).getResultList();
      return list;
   }

   public List<MenuGridVO> queryMenuGrid() {
      String sql = XmlTool.getSql("resource", "queryMenuGrid");
      List<MenuGridVO> list = this.tBaseResourceDao.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(MenuGridVO.class)).getResultList();
      return list;
   }

   public List<MenuGridVO> queryMenuGridByFlag(String flag) {
      String sql = XmlTool.getSql("resource", "queryMenuGridByFlag");
      List<MenuGridVO> list = this.tBaseResourceDao.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(MenuGridVO.class)).setParameter("flag", flag).getResultList();
      return list;
   }

   public List<ComboboxVO> queryMenuNames() {
      String sql = XmlTool.getSql("resource", "queryMenuNames");
      List<ComboboxVO> list = this.tBaseResourceDao.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ComboboxVO.class)).getResultList();
      return list;
   }

   public void addResource(TBaseResource resources, String menuid) {
      if (resources.getId() != null) {
         this.tBaseResourceDao.saveOrUpdate(resources);
         Criterion cresourceid = Restrictions.eq("resourceid", resources.getId());
         List<TBaseMenuresource> list = this.tBaseMenuresourceDao.queryAll(new Criterion[]{cresourceid});
         this.tBaseMenuresourceDao.remove(list);
      } else {
         resources.setId(StringTool.getTablePrimaryKey());
         this.tBaseResourceDao.save(resources);
      }

      TBaseMenuresource menuResources = new TBaseMenuresource();
      menuResources.setMenuid(menuid);
      menuResources.setResourceid(resources.getId());
      this.tBaseMenuresourceDao.save(menuResources);
   }

   public List<ComboboxVO> querySubMenuNamesByParentId(String parentid) {
      String sql = XmlTool.getSql("resource", "querySubMenuNamesByParentId");
      List<ComboboxVO> list = this.tBaseResourceDao.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ComboboxVO.class)).setParameter("parentid", parentid).getResultList();
      return list;
   }

   public List<ComboboxVO> querySubMenuNames() {
      String sql = XmlTool.getSql("resource", "querySubMenuNames");
      List<ComboboxVO> list = this.tBaseResourceDao.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ComboboxVO.class)).getResultList();
      return list;
   }

   public void remove(List<String> idlist) {
      for(String id : idlist) {
         this.tBaseResourceDao.removeById(id);
         this.tBaseMenuresourceDao.remove(new Criterion[]{Restrictions.eq("resourceid", id)});
      }

   }
}
