package com.chenyang.nse.bussiness.service.core.encryption.impl;

import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.vo.AutoDetectVO;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.key.TCoreKeyTypeManagementVO;
import com.chenyang.nse.bussiness.kms.model.Kms;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.key.KeyManagerService;
import com.chenyang.nse.bussiness.thkms.model.ThKmsCert;
import com.chenyang.nse.bussiness.thkms.runner.ThKmsCertRunner;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Service;

@Service("TCoreEncryptionContext")
public class TCoreEncryptionContext implements TCoreEncryptionService {
   private static final String LOCAL_CODE = "1";
   private static final String SDK_CODE = "2";
   private static final String CLOUD_SDK_CODE = "3";
   private static final String C_CORE_SDF_CODE = "4";
   private static final String KMS_CODE = "5";
   private static final String TH_KMS_CODE = "6";
   private static final String DE_AN_CODE = "7";
   private static final String SAN_WEI_CODE = "8";
   private static final String QUANTUM_CODE = "9";
   @Autowired
   Map<String, TCoreEncryptionService> tCoreEncryptionMap;
   @Autowired
   KeyManagerService keyManagerService;

   public TCoreEncryptionService getTCoreEncryptionService() {
      TCoreKeyTypeManagementVO tCoreKeyTypeManagementVO = this.keyManagerService.queryTCoreKeyTypeManageUsed();
      String typeId = tCoreKeyTypeManagementVO.getTypeid();
      if (Objects.isNull(typeId)) {
         return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceImpl");
      } else {
         switch (typeId) {
            case "2":
            case "3":
               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceSdkImpl");
            case "4":
               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceCCoreSDFImpl");
            case "5":
               Kms.MasterKey instance = Kms.MasterKey.getInstance();
               if (StringUtils.isEmpty(instance.getKeyid())) {
                  Map<String, String> map = this.keyManagerService.showKeyParams("5");
                  Kms.Credential.init((String)map.get("credtid"), (String)map.get("credaccesskey"), (String)map.get("credsecretkey"), (String)map.get("crediv"), (String)map.get("credprotocol"), (String)map.get("credhost"), Integer.parseInt((String)map.get("credport")));
                  Kms.MasterKey.init((String)map.get("keyid"), (String)map.get("keyspec"), (String)map.get("keyusage"), (String)map.get("origin"), (String)map.get("protectionlevel"));
               }

               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceKmsImpl");
            case "6":
               try {
                  ThKmsCert thKmsCert = ThKmsCert.getInstance();
                  if (StringUtils.isEmpty(thKmsCert.getCertB64())) {
                     ((ThKmsCertRunner)SpringUtil.getBean(ThKmsCertRunner.class)).run((ApplicationArguments)null);
                  }
               } catch (Exception e) {
                  e.printStackTrace();
                  return null;
               }

               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceThKmsImpl");
            case "7":
               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceDeAnImpl");
            case "8":
               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceSanWeiImpl");
            case "9":
               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceQuantumImpl");
            default:
               return (TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceImpl");
         }
      }
   }

   public void save(TCoreEncryption encryption) {
      this.getTCoreEncryptionService().save(encryption);
   }

   public List<ComboboxVO> initEncryptionTypeList() {
      return this.getTCoreEncryptionService().initEncryptionTypeList();
   }

   public List<TCoreEncryptionTypeField> deleteEncryption(String encryptionId) {
      return this.getTCoreEncryptionService().deleteEncryption(encryptionId);
   }

   public String getRandomValue(String type) {
      return this.getTCoreEncryptionService().getRandomValue(type);
   }

   public String testEncryption(String type, String param, String isLike, String secret_key, String keepfirst, String encdigit, String twoindex) {
      return this.getTCoreEncryptionService().testEncryption(type, param, isLike, secret_key, keepfirst, encdigit, twoindex);
   }

   public void saveSecretKey(TCoreSecretkey tCoreSecretKey) {
      this.getTCoreEncryptionService().saveSecretKey(tCoreSecretKey);
   }

   public List<TCoreEncryptionTypeField> delSecretKey(String keyId) {
      return this.getTCoreEncryptionService().delSecretKey(keyId);
   }

   public List<TCoreEncryption> queryEncryptionList(String encryption_name) {
      return this.getTCoreEncryptionService().queryEncryptionList(encryption_name);
   }

   public Map<String, String> queryEncryptionInfo(String secretKeyId) {
      return this.getTCoreEncryptionService().queryEncryptionInfo(secretKeyId);
   }

   public Map<String, String> queryEncryptionInfo(String keyName, String sKeyName) {
      return this.getTCoreEncryptionService().queryEncryptionInfo(keyName, sKeyName);
   }

   public AutoDetectVO autoDetect(AutoDetectVO autoDetectVO) throws SQLException {
      return this.getTCoreEncryptionService().autoDetect(autoDetectVO);
   }

   public String getProcesslog(String path) {
      return this.getTCoreEncryptionService().getProcesslog(path);
   }

   public void updateFlag(String projectId, String dataSystemId, String schema, String tableName, String columnName, String flag) {
      this.getTCoreEncryptionService().updateFlag(projectId, dataSystemId, schema, tableName, columnName, flag);
   }
}
